/*
 * Decompiled with CFR 0.152.
 */
package checkers.nullness;

import checkers.basetype.BaseTypeChecker;
import checkers.nullness.NullnessAnnotatedTypeFactory;
import checkers.nullness.quals.KeyFor;
import checkers.types.AnnotatedTypeMirror;
import checkers.types.GeneralAnnotatedTypeFactory;
import checkers.util.Heuristics;
import checkers.util.Resolver2;
import com.sun.source.tree.AssertTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.util.TreePath;
import java.util.List;
import javacutils.AnnotationUtils;
import javacutils.ElementUtils;
import javacutils.InternalUtils;
import javacutils.TreeUtils;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;

class MapGetHeuristics {
    private final ProcessingEnvironment processingEnv;
    private final NullnessAnnotatedTypeFactory atypeFactory;
    private final GeneralAnnotatedTypeFactory keyForFactory;
    private final Resolver2 resolver;
    private final ExecutableElement mapGet;
    private final ExecutableElement mapPut;
    private final ExecutableElement mapKeySet;
    private final ExecutableElement mapContains;

    public MapGetHeuristics(BaseTypeChecker checker, NullnessAnnotatedTypeFactory factory, GeneralAnnotatedTypeFactory keyForFactory) {
        this.processingEnv = checker.getProcessingEnvironment();
        this.atypeFactory = factory;
        this.keyForFactory = keyForFactory;
        this.resolver = new Resolver2(this.processingEnv);
        this.mapGet = TreeUtils.getMethod("java.util.Map", "get", 1, this.processingEnv);
        this.mapPut = TreeUtils.getMethod("java.util.Map", "put", 2, this.processingEnv);
        this.mapKeySet = TreeUtils.getMethod("java.util.Map", "keySet", 0, this.processingEnv);
        this.mapContains = TreeUtils.getMethod("java.util.Map", "containsKey", 1, this.processingEnv);
    }

    public void handle(TreePath path, AnnotatedTypeMirror.AnnotatedExecutableType method) {
        try {
            MethodInvocationTree tree = (MethodInvocationTree)path.getLeaf();
            if (TreeUtils.isMethodInvocation(tree, this.mapGet, this.processingEnv)) {
                AnnotatedTypeMirror type = method.getReturnType();
                if (this.mapGetReturnsNonNull(path)) {
                    type.replaceAnnotation(this.atypeFactory.NONNULL);
                } else {
                    type.replaceAnnotation(this.atypeFactory.NULLABLE);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private boolean mapGetReturnsNonNull(TreePath path) {
        MethodInvocationTree tree = (MethodInvocationTree)path.getLeaf();
        Element receiver = this.getReceiver(tree);
        if (receiver instanceof VariableElement) {
            VariableElement rvar = (VariableElement)receiver;
            ExpressionTree arg = tree.getArguments().get(0);
            if (arg instanceof IdentifierTree && this.isKeyInMap((IdentifierTree)arg, rvar)) {
                return true;
            }
            return this.keyForInMap(arg, receiver, path) || this.keyForInMap(arg, rvar.getSimpleName().toString()) || this.keyForInMap(arg, String.valueOf(TreeUtils.getReceiverTree(tree)));
        }
        return false;
    }

    private boolean keyForInMap(ExpressionTree key, String mapName) {
        AnnotatedTypeMirror keyForType = this.keyForFactory.getAnnotatedType(key);
        AnnotationMirror anno = keyForType.getAnnotation(KeyFor.class);
        if (anno == null) {
            return false;
        }
        List<String> maps = AnnotationUtils.getElementValueArray(anno, "value", String.class, false);
        return maps.contains(mapName);
    }

    private boolean keyForInMap(ExpressionTree key, Element mapElement, TreePath path) {
        AnnotatedTypeMirror keyForType = this.keyForFactory.getAnnotatedType(key);
        AnnotationMirror anno = keyForType.getAnnotation(KeyFor.class);
        if (anno == null) {
            return false;
        }
        List<String> maps = AnnotationUtils.getElementValueArray(anno, "value", String.class, false);
        for (String map : maps) {
            Element elt = this.resolver.findVariable(map, path);
            if (!elt.equals(mapElement) || this.isSiteRequired(TreeUtils.getReceiverTree((ExpressionTree)path.getLeaf()), elt)) continue;
            return true;
        }
        return false;
    }

    private boolean isSiteRequired(ExpressionTree node, Element elt) {
        boolean r = ElementUtils.isStatic(elt) || !elt.getKind().isField() || this.atypeFactory.isMostEnclosingThisDeref(node);
        return !r;
    }

    public Heuristics.Matcher inContains(final Element key, final VariableElement map) {
        return Heuristics.Matchers.or(Heuristics.Matchers.whenTrue(new Heuristics.Matcher(){

            @Override
            public Boolean visitMethodInvocation(MethodInvocationTree node, Void p) {
                return MapGetHeuristics.this.isInvocationOfContains(key, map, node);
            }
        }), Heuristics.Matchers.withIn(Heuristics.Matchers.ofKind(Tree.Kind.CONDITIONAL_EXPRESSION, new Heuristics.Matcher(){

            @Override
            public Boolean visitConditionalExpression(ConditionalExpressionTree tree, Void p) {
                return MapGetHeuristics.this.isInvocationOfContains(key, map, tree.getCondition());
            }
        })));
    }

    private Heuristics.Matcher inForEnhanced(final Element key, final VariableElement map) {
        return Heuristics.Matchers.withIn(Heuristics.Matchers.ofKind(Tree.Kind.ENHANCED_FOR_LOOP, new Heuristics.Matcher(){

            @Override
            public Boolean visitEnhancedForLoop(EnhancedForLoopTree tree, Void p) {
                if (key.equals(TreeUtils.elementFromDeclaration(tree.getVariable()))) {
                    return (Boolean)this.visit(tree.getExpression(), p);
                }
                return false;
            }

            @Override
            public Boolean visitMethodInvocation(MethodInvocationTree tree, Void p) {
                return TreeUtils.isMethodInvocation(tree, MapGetHeuristics.this.mapKeySet, MapGetHeuristics.this.processingEnv) && map.equals(MapGetHeuristics.this.getReceiver(tree));
            }
        }));
    }

    private Heuristics.Matcher preceededByAssert(final Element key, final VariableElement map) {
        return Heuristics.Matchers.preceededBy(Heuristics.Matchers.ofKind(Tree.Kind.ASSERT, new Heuristics.Matcher(){

            @Override
            public Boolean visitAssert(AssertTree tree, Void p) {
                return MapGetHeuristics.this.isInvocationOfContains(key, map, tree.getCondition()) || MapGetHeuristics.this.isCheckOfGet(key, map, tree.getCondition());
            }
        }));
    }

    private boolean isTerminating(StatementTree tree) {
        IfTree ifTree;
        StatementTree first = this.firstStatement(tree);
        if (first instanceof ThrowTree) {
            return true;
        }
        if (first instanceof ReturnTree) {
            return true;
        }
        return first instanceof IfTree && (ifTree = (IfTree)first).getElseStatement() != null && this.isTerminating(ifTree.getThenStatement()) && this.isTerminating(ifTree.getElseStatement());
    }

    private Heuristics.Matcher preceededByExplicitAssert(final Element key, final VariableElement map) {
        return Heuristics.Matchers.preceededBy(Heuristics.Matchers.ofKind(Tree.Kind.IF, new Heuristics.Matcher(){

            @Override
            public Boolean visitIf(IfTree tree, Void p) {
                return MapGetHeuristics.this.isNotContained(key, map, tree.getCondition()) && MapGetHeuristics.this.isTerminating(tree.getThenStatement());
            }
        }));
    }

    private Heuristics.Matcher preceededByIfThenPut(final Element key, final VariableElement map) {
        return Heuristics.Matchers.preceededBy(Heuristics.Matchers.ofKind(Tree.Kind.IF, new Heuristics.Matcher(){

            @Override
            public Boolean visitIf(IfTree tree, Void p) {
                StatementTree first;
                if (MapGetHeuristics.this.isNotContained(key, map, tree.getCondition()) && (first = MapGetHeuristics.this.firstStatement(tree.getThenStatement())) != null && first.getKind() == Tree.Kind.EXPRESSION_STATEMENT && MapGetHeuristics.this.isInvocationOfPut(key, map, ((ExpressionStatementTree)first).getExpression())) {
                    return true;
                }
                return false;
            }
        }));
    }

    private Heuristics.Matcher keyInMatcher(Element key, VariableElement map) {
        return Heuristics.Matchers.or(this.inContains(key, map), this.inForEnhanced(key, map), this.preceededByAssert(key, map), this.preceededByExplicitAssert(key, map), this.preceededByIfThenPut(key, map));
    }

    private boolean isKeyInMap(IdentifierTree keyTree, VariableElement map) {
        TreePath path = this.atypeFactory.getPath(keyTree);
        Element key = TreeUtils.elementFromUse(keyTree);
        return this.keyInMatcher(key, map).match(path);
    }

    private Element getReceiver(MethodInvocationTree tree) {
        Element element = InternalUtils.symbol(tree);
        assert (element != null) : "Unexpected null element for tree: " + tree;
        if (!ElementUtils.hasReceiver(element)) {
            return null;
        }
        ExpressionTree receiver = TreeUtils.getReceiverTree(tree);
        Element rcvelem = InternalUtils.symbol(receiver);
        return rcvelem;
    }

    private boolean isInvocationOf(ExecutableElement method, Element key, VariableElement map, ExpressionTree tree) {
        Element containsArgument;
        MethodInvocationTree invok;
        return TreeUtils.skipParens(tree) instanceof MethodInvocationTree && TreeUtils.isMethodInvocation(invok = (MethodInvocationTree)TreeUtils.skipParens(tree), method, this.processingEnv) && key.equals(containsArgument = InternalUtils.symbol(invok.getArguments().get(0))) && map.equals(this.getReceiver(invok));
    }

    private boolean isInvocationOfContains(Element key, VariableElement map, ExpressionTree tree) {
        return this.isInvocationOf(this.mapContains, key, map, tree);
    }

    private boolean isInvocationOfPut(Element key, VariableElement map, ExpressionTree tree) {
        return this.isInvocationOf(this.mapPut, key, map, tree);
    }

    private boolean isNotContained(Element key, VariableElement map, ExpressionTree tree) {
        return (tree = TreeUtils.skipParens(tree)).getKind() == Tree.Kind.LOGICAL_COMPLEMENT && this.isInvocationOfContains(key, map, ((UnaryTree)tree).getExpression());
    }

    private StatementTree firstStatement(StatementTree tree) {
        StatementTree first = tree;
        while (first.getKind() == Tree.Kind.BLOCK) {
            List<? extends StatementTree> trees = ((BlockTree)first).getStatements();
            if (trees.isEmpty()) {
                return null;
            }
            first = trees.iterator().next();
        }
        return first;
    }

    private boolean isCheckOfGet(Element key, VariableElement map, ExpressionTree tree) {
        Element containsArgument;
        MethodInvocationTree invok;
        if ((tree = TreeUtils.skipParens(tree)).getKind() != Tree.Kind.NOT_EQUAL_TO || ((BinaryTree)tree).getRightOperand().getKind() != Tree.Kind.NULL_LITERAL) {
            return false;
        }
        ExpressionTree right = TreeUtils.skipParens(((BinaryTree)tree).getLeftOperand());
        return right instanceof MethodInvocationTree && TreeUtils.isMethodInvocation(invok = (MethodInvocationTree)right, this.mapGet, this.processingEnv) && key.equals(containsArgument = InternalUtils.symbol(invok.getArguments().get(0))) && map.equals(this.getReceiver(invok));
    }
}

