/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.model.processor;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.InterpretationContext;
import ch.qos.logback.core.joran.util.beans.BeanDescriptionCache;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.processor.AllowAllModelFilter;
import ch.qos.logback.core.model.processor.DenyAllModelFilter;
import ch.qos.logback.core.model.processor.ModelFiler;
import ch.qos.logback.core.model.processor.ModelHandlerBase;
import ch.qos.logback.core.model.processor.ModelHandlerException;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.spi.FilterReply;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;

public class DefaultProcessor
extends ContextAwareBase {
    final InterpretationContext interpretationContext;
    final HashMap<Class<? extends Model>, Class<? extends ModelHandlerBase>> modelClassToHandlerMap = new HashMap();
    ModelFiler phaseOneFilter = new AllowAllModelFilter();
    ModelFiler phaseTwoFilter = new DenyAllModelFilter();
    ModelFiler phaseThreeFilter = new DenyAllModelFilter();

    public DefaultProcessor(Context context, InterpretationContext interpretationContext) {
        this.setContext(context);
        this.interpretationContext = interpretationContext;
    }

    public void addHandler(Class<? extends Model> modelClass, Class<? extends ModelHandlerBase> handlerClass) {
        this.modelClassToHandlerMap.put(modelClass, handlerClass);
    }

    private void traversalLoop(TraverseMethod traverseMethod, Model model, ModelFiler modelfFilter, String phaseName) {
        int handledModelCount;
        int LIMIT = 3;
        for (int i = 0; i < LIMIT && (handledModelCount = traverseMethod.traverse(model, modelfFilter)) != 0; ++i) {
        }
    }

    public void process(Model model) {
        if (model == null) {
            this.addError("Expecting non null model to process");
            return;
        }
        this.initialObjectPush();
        this.traversalLoop(this::traverse, model, this.getPhaseOneFilter(), "phase 1");
        this.traversalLoop(this::traverse, model, this.getPhaseTwoFilter(), "phase 2");
        this.traversalLoop(this::traverse, model, this.getPhaseThreeFilter(), "phase 3");
        this.addInfo("End of configuration.");
        this.finalObjectPop();
    }

    private void finalObjectPop() {
        this.interpretationContext.popObject();
    }

    private void initialObjectPush() {
        this.interpretationContext.pushObject(this.context);
    }

    public ModelFiler getPhaseOneFilter() {
        return this.phaseOneFilter;
    }

    public ModelFiler getPhaseTwoFilter() {
        return this.phaseTwoFilter;
    }

    public ModelFiler getPhaseThreeFilter() {
        return this.phaseThreeFilter;
    }

    public void setPhaseOneFilter(ModelFiler phaseOneFilter) {
        this.phaseOneFilter = phaseOneFilter;
    }

    public void setPhaseTwoFilter(ModelFiler phaseTwoFilter) {
        this.phaseTwoFilter = phaseTwoFilter;
    }

    public void setPhaseThreeFilter(ModelFiler phaseThreeFilter) {
        this.phaseThreeFilter = phaseThreeFilter;
    }

    protected int traverse(Model model, ModelFiler modelFiler) {
        FilterReply filterReply = modelFiler.decide(model);
        if (filterReply == FilterReply.DENY) {
            return 0;
        }
        Class<? extends ModelHandlerBase> handlerClass = this.modelClassToHandlerMap.get(model.getClass());
        if (handlerClass == null) {
            this.addError("Can't handle model of type " + model.getClass() + "  with tag: " + model.getTag() + " at line " + model.getLineNumber());
            return 0;
        }
        int count = 0;
        ModelHandlerBase handler = this.instantiateHandler(handlerClass);
        try {
            if (!handler.isSupportedModelType(model)) {
                this.addWarn("Skipping processing for model " + model.idString());
                return count;
            }
            boolean handledHere = false;
            if (model.isUnhandled()) {
                handler.handle(this.interpretationContext, model);
                handledHere = true;
                model.markAsHandled();
                ++count;
            }
            int len = model.getSubModels().size();
            for (int i = 0; i < len; ++i) {
                Model m3 = model.getSubModels().get(i);
                count += this.traverse(m3, modelFiler);
            }
            if (handledHere) {
                handler.postHandle(this.interpretationContext, model);
            }
        }
        catch (ModelHandlerException e) {
            this.addError("Failed to traverse model " + model.getTag(), e);
        }
        return count;
    }

    ModelHandlerBase instantiateHandler(Class<? extends ModelHandlerBase> handlerClass) {
        try {
            Constructor<? extends ModelHandlerBase> commonConstructor = this.getWithContextConstructor(handlerClass);
            if (commonConstructor != null) {
                return commonConstructor.newInstance(this.context);
            }
            Constructor<? extends ModelHandlerBase> constructorWithBDC = this.getWithContextAndBDCConstructor(handlerClass);
            if (constructorWithBDC != null) {
                return constructorWithBDC.newInstance(this.context, this.interpretationContext.getBeanDescriptionCache());
            }
            this.addError("Failed to find suitable constructor for class [" + handlerClass + "]");
            return null;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException e1) {
            this.addError("Failed to instantiate " + handlerClass);
            return null;
        }
    }

    private Constructor<? extends ModelHandlerBase> getWithContextConstructor(Class<? extends ModelHandlerBase> handlerClass) {
        try {
            Constructor<? extends ModelHandlerBase> constructor = handlerClass.getConstructor(Context.class);
            return constructor;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private Constructor<? extends ModelHandlerBase> getWithContextAndBDCConstructor(Class<? extends ModelHandlerBase> handlerClass) {
        try {
            Constructor<? extends ModelHandlerBase> constructor = handlerClass.getConstructor(Context.class, BeanDescriptionCache.class);
            return constructor;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    static interface TraverseMethod {
        public int traverse(Model var1, ModelFiler var2);
    }
}

