/*
 * Decompiled with CFR 0.152.
 */
package com.welie.blessed;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothDevice;
import com.welie.blessed.BondState;
import com.welie.blessed.WriteType;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@SuppressLint(value={"MissingPermission"})
public class BluetoothCentral {
    @NotNull
    protected final BluetoothDevice device;
    private int currentMtu = 23;

    BluetoothCentral(@NotNull BluetoothDevice device) {
        this.device = device;
    }

    @NotNull
    public String getAddress() {
        return this.device.getAddress();
    }

    @NotNull
    public String getName() {
        return this.device.getName() == null ? "" : this.device.getName();
    }

    public BondState getBondState() {
        return BondState.fromValue(this.device.getBondState());
    }

    protected void setCurrentMtu(int currentMtu) {
        this.currentMtu = currentMtu;
    }

    public int getCurrentMtu() {
        return this.currentMtu;
    }

    public boolean createBond() {
        return this.device.createBond();
    }

    public boolean setPairingConfirmation(Boolean confirm) {
        return this.device.setPairingConfirmation(confirm.booleanValue());
    }

    public int getMaximumWriteValueLength(@NotNull WriteType writeType) {
        Objects.requireNonNull(writeType, "writetype is null");
        switch (writeType) {
            case WITH_RESPONSE: {
                return 512;
            }
            case SIGNED: {
                return this.currentMtu - 15;
            }
        }
        return this.currentMtu - 3;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BluetoothCentral that = (BluetoothCentral)o;
        return this.device.getAddress().equals(that.device.getAddress());
    }

    public int hashCode() {
        return Objects.hash(this.device);
    }
}

