/*
 * Decompiled with CFR 0.152.
 */
package com.welie.blessed;

import com.welie.blessed.WriteType;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BluetoothCentral {
    @NotNull
    private final String address;
    @Nullable
    private final String name;
    private int currentMtu = 23;

    BluetoothCentral(@NotNull String address, @Nullable String name) {
        this.address = Objects.requireNonNull(address, "address is null");
        this.name = name;
    }

    @NotNull
    public String getAddress() {
        return this.address;
    }

    @NotNull
    public String getName() {
        return this.name == null ? "" : this.name;
    }

    protected void setCurrentMtu(int currentMtu) {
        this.currentMtu = currentMtu;
    }

    public int getCurrentMtu() {
        return this.currentMtu;
    }

    public int getMaximumWriteValueLength(@NotNull WriteType writeType) {
        Objects.requireNonNull(writeType, "writetype is null");
        switch (writeType) {
            case WITH_RESPONSE: {
                return 512;
            }
            case SIGNED: {
                return this.currentMtu - 15;
            }
        }
        return this.currentMtu - 3;
    }
}

