/*
 * Decompiled with CFR 0.152.
 */
package com.welie.blessed;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.le.BluetoothLeScanner;
import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanFilter;
import android.bluetooth.le.ScanResult;
import android.bluetooth.le.ScanSettings;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.ParcelUuid;
import com.welie.blessed.BluetoothCentralManagerCallback;
import com.welie.blessed.BluetoothPeripheral;
import com.welie.blessed.BluetoothPeripheralCallback;
import com.welie.blessed.HciStatus;
import com.welie.blessed.Logger;
import com.welie.blessed.PeripheralType;
import com.welie.blessed.ScanFailure;
import com.welie.blessed.ScanMode;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BluetoothCentralManager {
    private static final String TAG = BluetoothCentralManager.class.getSimpleName();
    private static final long SCAN_TIMEOUT = 180000L;
    private static final int SCAN_RESTART_DELAY = 1000;
    private static final int MAX_CONNECTION_RETRIES = 1;
    private static final String NO_PERIPHERAL_ADDRESS_PROVIDED = "no peripheral address provided";
    private static final String NO_VALID_PERIPHERAL_PROVIDED = "no valid peripheral provided";
    private static final String NO_VALID_PERIPHERAL_CALLBACK_SPECIFIED = "no valid peripheral callback specified";
    @NotNull
    private final Context context;
    @NotNull
    private final Handler callBackHandler;
    @NotNull
    private final BluetoothAdapter bluetoothAdapter;
    @Nullable
    private BluetoothLeScanner bluetoothScanner;
    @Nullable
    private BluetoothLeScanner autoConnectScanner;
    @NotNull
    private final BluetoothCentralManagerCallback bluetoothCentralManagerCallback;
    @NotNull
    private final Map<String, BluetoothPeripheral> connectedPeripherals = new ConcurrentHashMap<String, BluetoothPeripheral>();
    @NotNull
    private final Map<String, BluetoothPeripheral> unconnectedPeripherals = new ConcurrentHashMap<String, BluetoothPeripheral>();
    @NotNull
    private final Map<String, BluetoothPeripheral> scannedPeripherals = new ConcurrentHashMap<String, BluetoothPeripheral>();
    @NotNull
    private final List<String> reconnectPeripheralAddresses = new ArrayList<String>();
    @NotNull
    private final Map<String, BluetoothPeripheralCallback> reconnectCallbacks = new ConcurrentHashMap<String, BluetoothPeripheralCallback>();
    @NotNull
    private String[] scanPeripheralNames = new String[0];
    @NotNull
    private final Handler mainHandler = new Handler(Looper.getMainLooper());
    @Nullable
    private Runnable timeoutRunnable;
    @Nullable
    private Runnable autoConnectRunnable;
    @NotNull
    private final Object connectLock = new Object();
    @Nullable
    private ScanCallback currentCallback;
    @Nullable
    private List<ScanFilter> currentFilters;
    @NotNull
    private ScanSettings scanSettings;
    @NotNull
    private final ScanSettings autoConnectScanSettings;
    @NotNull
    private final Map<String, Integer> connectionRetries = new ConcurrentHashMap<String, Integer>();
    private boolean expectingBluetoothOffDisconnects = false;
    @Nullable
    private Runnable disconnectRunnable;
    @NotNull
    private final Map<String, String> pinCodes = new ConcurrentHashMap<String, String>();
    private final ScanCallback scanByNameCallback = new ScanCallback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onScanResult(int callbackType, ScanResult result) {
            1 var3_3 = this;
            synchronized (var3_3) {
                String deviceName = result.getDevice().getName();
                if (deviceName == null) {
                    return;
                }
                for (String name : BluetoothCentralManager.this.scanPeripheralNames) {
                    if (!deviceName.contains(name)) continue;
                    BluetoothCentralManager.this.sendScanResult(result);
                    return;
                }
            }
        }

        public void onScanFailed(int errorCode) {
            BluetoothCentralManager.this.sendScanFailed(ScanFailure.fromValue(errorCode));
        }
    };
    private final ScanCallback defaultScanCallback = new ScanCallback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onScanResult(int callbackType, ScanResult result) {
            2 var3_3 = this;
            synchronized (var3_3) {
                BluetoothCentralManager.this.sendScanResult(result);
            }
        }

        public void onScanFailed(int errorCode) {
            BluetoothCentralManager.this.sendScanFailed(ScanFailure.fromValue(errorCode));
        }
    };
    private final ScanCallback autoConnectScanCallback = new ScanCallback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onScanResult(int callbackType, ScanResult result) {
            5 var3_3 = this;
            synchronized (var3_3) {
                if (!BluetoothCentralManager.this.isAutoScanning()) {
                    return;
                }
                Logger.d(TAG, "peripheral with address '%s' found", result.getDevice().getAddress());
                BluetoothCentralManager.this.stopAutoconnectScan();
                String deviceAddress = result.getDevice().getAddress();
                BluetoothPeripheral peripheral = (BluetoothPeripheral)BluetoothCentralManager.this.unconnectedPeripherals.get(deviceAddress);
                BluetoothPeripheralCallback callback = (BluetoothPeripheralCallback)BluetoothCentralManager.this.reconnectCallbacks.get(deviceAddress);
                BluetoothCentralManager.this.reconnectPeripheralAddresses.remove(deviceAddress);
                BluetoothCentralManager.this.reconnectCallbacks.remove(deviceAddress);
                BluetoothCentralManager.this.unconnectedPeripherals.remove(deviceAddress);
                BluetoothCentralManager.this.scannedPeripherals.remove(deviceAddress);
                if (peripheral != null && callback != null) {
                    BluetoothCentralManager.this.connectPeripheral(peripheral, callback);
                }
                if (BluetoothCentralManager.this.reconnectPeripheralAddresses.size() > 0) {
                    BluetoothCentralManager.this.scanForAutoConnectPeripherals();
                }
            }
        }

        public void onScanFailed(int errorCode) {
            final ScanFailure scanFailure = ScanFailure.fromValue(errorCode);
            Logger.e(TAG, "autoConnect scan failed with error code %d (%s)", new Object[]{errorCode, scanFailure});
            BluetoothCentralManager.this.autoConnectScanner = null;
            BluetoothCentralManager.this.callBackHandler.post(new Runnable(){

                @Override
                public void run() {
                    BluetoothCentralManager.this.bluetoothCentralManagerCallback.onScanFailed(scanFailure);
                }
            });
        }
    };
    protected final BluetoothPeripheral.InternalCallback internalCallback = new BluetoothPeripheral.InternalCallback(){

        @Override
        public void connecting(final @NotNull BluetoothPeripheral peripheral) {
            BluetoothCentralManager.this.callBackHandler.post(new Runnable(){

                @Override
                public void run() {
                    BluetoothCentralManager.this.bluetoothCentralManagerCallback.onConnectingPeripheral(peripheral);
                }
            });
        }

        @Override
        public void connected(final @NotNull BluetoothPeripheral peripheral) {
            BluetoothCentralManager.this.connectionRetries.remove(peripheral.getAddress());
            BluetoothCentralManager.this.unconnectedPeripherals.remove(peripheral.getAddress());
            BluetoothCentralManager.this.scannedPeripherals.remove(peripheral.getAddress());
            BluetoothCentralManager.this.connectedPeripherals.put(peripheral.getAddress(), peripheral);
            BluetoothCentralManager.this.callBackHandler.post(new Runnable(){

                @Override
                public void run() {
                    BluetoothCentralManager.this.bluetoothCentralManagerCallback.onConnectedPeripheral(peripheral);
                }
            });
        }

        @Override
        public void connectFailed(final @NotNull BluetoothPeripheral peripheral, final @NotNull HciStatus status) {
            BluetoothCentralManager.this.unconnectedPeripherals.remove(peripheral.getAddress());
            BluetoothCentralManager.this.scannedPeripherals.remove(peripheral.getAddress());
            int nrRetries = 0;
            Integer retries = (Integer)BluetoothCentralManager.this.connectionRetries.get(peripheral.getAddress());
            if (retries != null) {
                nrRetries = retries;
            }
            if (nrRetries < 1 && status != HciStatus.CONNECTION_FAILED_ESTABLISHMENT) {
                Logger.i(TAG, "retrying connection to '%s' (%s)", peripheral.getName(), peripheral.getAddress());
                BluetoothCentralManager.this.connectionRetries.put(peripheral.getAddress(), ++nrRetries);
                BluetoothCentralManager.this.unconnectedPeripherals.put(peripheral.getAddress(), peripheral);
                peripheral.connect();
            } else {
                Logger.i(TAG, "connection to '%s' (%s) failed", peripheral.getName(), peripheral.getAddress());
                BluetoothCentralManager.this.connectionRetries.remove(peripheral.getAddress());
                BluetoothCentralManager.this.callBackHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        BluetoothCentralManager.this.bluetoothCentralManagerCallback.onConnectionFailed(peripheral, status);
                    }
                });
            }
        }

        @Override
        public void disconnecting(final @NotNull BluetoothPeripheral peripheral) {
            BluetoothCentralManager.this.callBackHandler.post(new Runnable(){

                @Override
                public void run() {
                    BluetoothCentralManager.this.bluetoothCentralManagerCallback.onDisconnectingPeripheral(peripheral);
                }
            });
        }

        @Override
        public void disconnected(final @NotNull BluetoothPeripheral peripheral, final @NotNull HciStatus status) {
            if (BluetoothCentralManager.this.expectingBluetoothOffDisconnects) {
                BluetoothCentralManager.this.cancelDisconnectionTimer();
                BluetoothCentralManager.this.expectingBluetoothOffDisconnects = false;
            }
            BluetoothCentralManager.this.connectedPeripherals.remove(peripheral.getAddress());
            BluetoothCentralManager.this.unconnectedPeripherals.remove(peripheral.getAddress());
            BluetoothCentralManager.this.scannedPeripherals.remove(peripheral.getAddress());
            BluetoothCentralManager.this.connectionRetries.remove(peripheral.getAddress());
            BluetoothCentralManager.this.callBackHandler.post(new Runnable(){

                @Override
                public void run() {
                    BluetoothCentralManager.this.bluetoothCentralManagerCallback.onDisconnectedPeripheral(peripheral, status);
                }
            });
        }

        @Override
        @Nullable
        public String getPincode(@NotNull BluetoothPeripheral peripheral) {
            return (String)BluetoothCentralManager.this.pinCodes.get(peripheral.getAddress());
        }
    };
    protected final BroadcastReceiver adapterStateReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (action == null) {
                return;
            }
            if (action.equals("android.bluetooth.adapter.action.STATE_CHANGED")) {
                final int state = intent.getIntExtra("android.bluetooth.adapter.extra.STATE", Integer.MIN_VALUE);
                BluetoothCentralManager.this.callBackHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        BluetoothCentralManager.this.bluetoothCentralManagerCallback.onBluetoothAdapterStateChanged(state);
                    }
                });
                BluetoothCentralManager.this.handleAdapterState(state);
            }
        }
    };

    private void sendScanResult(final @NotNull ScanResult result) {
        this.callBackHandler.post(new Runnable(){

            @Override
            public void run() {
                if (BluetoothCentralManager.this.isScanning()) {
                    BluetoothPeripheral peripheral = BluetoothCentralManager.this.getPeripheral(result.getDevice().getAddress());
                    peripheral.setDevice(result.getDevice());
                    BluetoothCentralManager.this.bluetoothCentralManagerCallback.onDiscoveredPeripheral(peripheral, result);
                }
            }
        });
    }

    private void sendScanFailed(final @NotNull ScanFailure scanFailure) {
        this.currentCallback = null;
        this.currentFilters = null;
        this.callBackHandler.post(new Runnable(){

            @Override
            public void run() {
                Logger.e(TAG, "scan failed with error code %d (%s)", new Object[]{scanFailure.value, scanFailure});
                BluetoothCentralManager.this.bluetoothCentralManagerCallback.onScanFailed(scanFailure);
            }
        });
    }

    public BluetoothCentralManager(@NotNull Context context, @NotNull BluetoothCentralManagerCallback bluetoothCentralManagerCallback, @NotNull Handler handler) {
        this.context = Objects.requireNonNull(context, "no valid context provided");
        this.bluetoothCentralManagerCallback = Objects.requireNonNull(bluetoothCentralManagerCallback, "no valid bluetoothCallback provided");
        this.callBackHandler = Objects.requireNonNull(handler, "no valid handler provided");
        this.bluetoothAdapter = Objects.requireNonNull(BluetoothAdapter.getDefaultAdapter(), "no bluetooth adapter found");
        this.autoConnectScanSettings = this.getScanSettings(ScanMode.LOW_POWER);
        this.scanSettings = this.getScanSettings(ScanMode.LOW_LATENCY);
        IntentFilter filter = new IntentFilter("android.bluetooth.adapter.action.STATE_CHANGED");
        context.registerReceiver(this.adapterStateReceiver, filter);
    }

    public void close() {
        this.unconnectedPeripherals.clear();
        this.connectedPeripherals.clear();
        this.reconnectCallbacks.clear();
        this.reconnectPeripheralAddresses.clear();
        this.scannedPeripherals.clear();
        this.context.unregisterReceiver(this.adapterStateReceiver);
    }

    public void enableLogging() {
        Logger.enabled = true;
    }

    public void disableLogging() {
        Logger.enabled = false;
    }

    private ScanSettings getScanSettings(@NotNull ScanMode scanMode) {
        Objects.requireNonNull(scanMode, "scanMode is null");
        if (Build.VERSION.SDK_INT >= 23) {
            return new ScanSettings.Builder().setScanMode(scanMode.value).setCallbackType(1).setMatchMode(1).setNumOfMatches(1).setReportDelay(0L).build();
        }
        return new ScanSettings.Builder().setScanMode(scanMode.value).setReportDelay(0L).build();
    }

    public void setScanMode(@NotNull ScanMode scanMode) {
        Objects.requireNonNull(scanMode);
        this.scanSettings = this.getScanSettings(scanMode);
    }

    private void startScan(@NotNull List<ScanFilter> filters, @NotNull ScanSettings scanSettings, @NotNull ScanCallback scanCallback) {
        if (this.bleNotReady()) {
            return;
        }
        if (this.isScanning()) {
            Logger.e(TAG, "other scan still active, stopping scan");
            this.stopScan();
        }
        if (this.bluetoothScanner == null) {
            this.bluetoothScanner = this.bluetoothAdapter.getBluetoothLeScanner();
        }
        if (this.bluetoothScanner != null) {
            this.setScanTimer();
            this.currentCallback = scanCallback;
            this.currentFilters = filters;
            this.bluetoothScanner.startScan(filters, scanSettings, scanCallback);
            Logger.i(TAG, "scan started");
        } else {
            Logger.e(TAG, "starting scan failed");
        }
    }

    public void scanForPeripheralsWithServices(@NotNull UUID[] serviceUUIDs) {
        Objects.requireNonNull(serviceUUIDs, "no service UUIDs supplied");
        if (serviceUUIDs.length == 0) {
            throw new IllegalArgumentException("at least one service UUID  must be supplied");
        }
        ArrayList<ScanFilter> filters = new ArrayList<ScanFilter>();
        for (UUID serviceUUID : serviceUUIDs) {
            ScanFilter filter = new ScanFilter.Builder().setServiceUuid(new ParcelUuid(serviceUUID)).build();
            filters.add(filter);
        }
        this.startScan(filters, this.scanSettings, this.defaultScanCallback);
    }

    public void scanForPeripheralsWithNames(@NotNull String[] peripheralNames) {
        Objects.requireNonNull(peripheralNames, "no peripheral names supplied");
        if (peripheralNames.length == 0) {
            throw new IllegalArgumentException("at least one peripheral name must be supplied");
        }
        this.scanPeripheralNames = peripheralNames;
        this.startScan(Collections.emptyList(), this.scanSettings, this.scanByNameCallback);
    }

    public void scanForPeripheralsWithAddresses(@NotNull String[] peripheralAddresses) {
        Objects.requireNonNull(peripheralAddresses, "no peripheral addresses supplied");
        if (peripheralAddresses.length == 0) {
            throw new IllegalArgumentException("at least one peripheral address must be supplied");
        }
        ArrayList<ScanFilter> filters = new ArrayList<ScanFilter>();
        for (String address : peripheralAddresses) {
            if (BluetoothAdapter.checkBluetoothAddress((String)address)) {
                ScanFilter filter = new ScanFilter.Builder().setDeviceAddress(address).build();
                filters.add(filter);
                continue;
            }
            Logger.e(TAG, "%s is not a valid address. Make sure all alphabetic characters are uppercase.", address);
        }
        this.startScan(filters, this.scanSettings, this.defaultScanCallback);
    }

    public void scanForPeripheralsUsingFilters(@NotNull List<ScanFilter> filters) {
        Objects.requireNonNull(filters, "no filters supplied");
        if (filters.isEmpty()) {
            throw new IllegalArgumentException("at least one scan filter must be supplied");
        }
        this.startScan(filters, this.scanSettings, this.defaultScanCallback);
    }

    public void scanForPeripherals() {
        this.startScan(Collections.emptyList(), this.scanSettings, this.defaultScanCallback);
    }

    private void scanForAutoConnectPeripherals() {
        if (this.bleNotReady()) {
            return;
        }
        if (this.autoConnectScanner != null) {
            this.stopAutoconnectScan();
        }
        this.autoConnectScanner = this.bluetoothAdapter.getBluetoothLeScanner();
        if (this.autoConnectScanner != null) {
            ArrayList<ScanFilter> filters = new ArrayList<ScanFilter>();
            for (String address : this.reconnectPeripheralAddresses) {
                ScanFilter filter = new ScanFilter.Builder().setDeviceAddress(address).build();
                filters.add(filter);
            }
            this.autoConnectScanner.startScan(filters, this.autoConnectScanSettings, this.autoConnectScanCallback);
            Logger.d(TAG, "started scanning to autoconnect peripherals (" + this.reconnectPeripheralAddresses.size() + ")");
            this.setAutoConnectTimer();
        } else {
            Logger.e(TAG, "starting autoconnect scan failed");
        }
    }

    private void stopAutoconnectScan() {
        this.cancelAutoConnectTimer();
        if (this.autoConnectScanner != null) {
            this.autoConnectScanner.stopScan(this.autoConnectScanCallback);
            this.autoConnectScanner = null;
            Logger.i(TAG, "autoscan stopped");
        }
    }

    private boolean isAutoScanning() {
        return this.autoConnectScanner != null;
    }

    public void stopScan() {
        this.cancelTimeoutTimer();
        if (this.isScanning()) {
            if (this.bluetoothScanner != null) {
                this.bluetoothScanner.stopScan(this.currentCallback);
                Logger.i(TAG, "scan stopped");
            }
        } else {
            Logger.i(TAG, "no scan to stop because no scan is running");
        }
        this.currentCallback = null;
        this.currentFilters = null;
        this.scannedPeripherals.clear();
    }

    public boolean isScanning() {
        return this.bluetoothScanner != null && this.currentCallback != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectPeripheral(@NotNull BluetoothPeripheral peripheral, @NotNull BluetoothPeripheralCallback peripheralCallback) {
        Object object = this.connectLock;
        synchronized (object) {
            Objects.requireNonNull(peripheral, NO_VALID_PERIPHERAL_PROVIDED);
            Objects.requireNonNull(peripheralCallback, NO_VALID_PERIPHERAL_CALLBACK_SPECIFIED);
            if (this.connectedPeripherals.containsKey(peripheral.getAddress())) {
                Logger.w(TAG, "already connected to %s'", peripheral.getAddress());
                return;
            }
            if (this.unconnectedPeripherals.containsKey(peripheral.getAddress())) {
                Logger.w(TAG, "already connecting to %s'", peripheral.getAddress());
                return;
            }
            if (peripheral.isUncached()) {
                Logger.w(TAG, "peripheral with address '%s' is not in the Bluetooth cache, hence connection may fail", peripheral.getAddress());
            }
            peripheral.setPeripheralCallback(peripheralCallback);
            this.scannedPeripherals.remove(peripheral.getAddress());
            this.unconnectedPeripherals.put(peripheral.getAddress(), peripheral);
            peripheral.connect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void autoConnectPeripheral(@NotNull BluetoothPeripheral peripheral, @NotNull BluetoothPeripheralCallback peripheralCallback) {
        Object object = this.connectLock;
        synchronized (object) {
            Objects.requireNonNull(peripheral, NO_VALID_PERIPHERAL_PROVIDED);
            Objects.requireNonNull(peripheralCallback, NO_VALID_PERIPHERAL_CALLBACK_SPECIFIED);
            if (this.connectedPeripherals.containsKey(peripheral.getAddress())) {
                Logger.w(TAG, "already connected to %s'", peripheral.getAddress());
                return;
            }
            if (this.unconnectedPeripherals.get(peripheral.getAddress()) != null) {
                Logger.w(TAG, "already issued autoconnect for '%s' ", peripheral.getAddress());
                return;
            }
            if (peripheral.isUncached()) {
                Logger.d(TAG, "peripheral with address '%s' not in Bluetooth cache, autoconnecting by scanning", peripheral.getAddress());
                this.scannedPeripherals.remove(peripheral.getAddress());
                this.unconnectedPeripherals.put(peripheral.getAddress(), peripheral);
                this.autoConnectPeripheralByScan(peripheral.getAddress(), peripheralCallback);
                return;
            }
            if (peripheral.getType() == PeripheralType.CLASSIC) {
                Logger.e(TAG, "peripheral does not support Bluetooth LE");
                return;
            }
            peripheral.setPeripheralCallback(peripheralCallback);
            this.scannedPeripherals.remove(peripheral.getAddress());
            this.unconnectedPeripherals.put(peripheral.getAddress(), peripheral);
            peripheral.autoConnect();
        }
    }

    private void autoConnectPeripheralByScan(String peripheralAddress, BluetoothPeripheralCallback peripheralCallback) {
        if (this.reconnectPeripheralAddresses.contains(peripheralAddress)) {
            Logger.w(TAG, "peripheral already on list for reconnection");
            return;
        }
        this.reconnectPeripheralAddresses.add(peripheralAddress);
        this.reconnectCallbacks.put(peripheralAddress, peripheralCallback);
        this.scanForAutoConnectPeripherals();
    }

    public void cancelConnection(final @NotNull BluetoothPeripheral peripheral) {
        Objects.requireNonNull(peripheral, NO_VALID_PERIPHERAL_PROVIDED);
        String peripheralAddress = peripheral.getAddress();
        if (this.reconnectPeripheralAddresses.contains(peripheralAddress)) {
            this.reconnectPeripheralAddresses.remove(peripheralAddress);
            this.reconnectCallbacks.remove(peripheralAddress);
            this.unconnectedPeripherals.remove(peripheralAddress);
            this.stopAutoconnectScan();
            Logger.d(TAG, "cancelling autoconnect for %s", peripheralAddress);
            this.callBackHandler.post(new Runnable(){

                @Override
                public void run() {
                    BluetoothCentralManager.this.bluetoothCentralManagerCallback.onDisconnectedPeripheral(peripheral, HciStatus.SUCCESS);
                }
            });
            if (this.reconnectPeripheralAddresses.size() > 0) {
                this.scanForAutoConnectPeripherals();
            }
            return;
        }
        if (this.unconnectedPeripherals.containsKey(peripheralAddress) || this.connectedPeripherals.containsKey(peripheralAddress)) {
            peripheral.cancelConnection();
        } else {
            Logger.e(TAG, "cannot cancel connection to unknown peripheral %s", peripheralAddress);
        }
    }

    public void autoConnectPeripheralsBatch(@NotNull Map<BluetoothPeripheral, BluetoothPeripheralCallback> batch) {
        Objects.requireNonNull(batch, "no valid batch provided");
        HashMap<BluetoothPeripheral, BluetoothPeripheralCallback> uncachedPeripherals = new HashMap<BluetoothPeripheral, BluetoothPeripheralCallback>();
        for (BluetoothPeripheral peripheral : batch.keySet()) {
            if (peripheral.isUncached()) {
                uncachedPeripherals.put(peripheral, batch.get(peripheral));
                continue;
            }
            this.autoConnectPeripheral(peripheral, batch.get(peripheral));
        }
        if (!uncachedPeripherals.isEmpty()) {
            for (BluetoothPeripheral peripheral : uncachedPeripherals.keySet()) {
                String peripheralAddress = peripheral.getAddress();
                this.reconnectPeripheralAddresses.add(peripheralAddress);
                this.reconnectCallbacks.put(peripheralAddress, (BluetoothPeripheralCallback)uncachedPeripherals.get(peripheral));
                this.unconnectedPeripherals.put(peripheralAddress, peripheral);
            }
            this.scanForAutoConnectPeripherals();
        }
    }

    @NotNull
    public BluetoothPeripheral getPeripheral(@NotNull String peripheralAddress) {
        Objects.requireNonNull(peripheralAddress, NO_PERIPHERAL_ADDRESS_PROVIDED);
        if (!BluetoothAdapter.checkBluetoothAddress((String)peripheralAddress)) {
            String message = String.format("%s is not a valid bluetooth address. Make sure all alphabetic characters are uppercase.", peripheralAddress);
            throw new IllegalArgumentException(message);
        }
        if (this.connectedPeripherals.containsKey(peripheralAddress)) {
            return Objects.requireNonNull(this.connectedPeripherals.get(peripheralAddress));
        }
        if (this.unconnectedPeripherals.containsKey(peripheralAddress)) {
            return Objects.requireNonNull(this.unconnectedPeripherals.get(peripheralAddress));
        }
        if (this.scannedPeripherals.containsKey(peripheralAddress)) {
            return Objects.requireNonNull(this.scannedPeripherals.get(peripheralAddress));
        }
        BluetoothPeripheral peripheral = new BluetoothPeripheral(this.context, this.bluetoothAdapter.getRemoteDevice(peripheralAddress), this.internalCallback, new BluetoothPeripheralCallback.NULL(), this.callBackHandler);
        this.scannedPeripherals.put(peripheralAddress, peripheral);
        return peripheral;
    }

    @NotNull
    public List<BluetoothPeripheral> getConnectedPeripherals() {
        return new ArrayList<BluetoothPeripheral>(this.connectedPeripherals.values());
    }

    private boolean bleNotReady() {
        if (this.isBleSupported() && this.isBluetoothEnabled()) {
            return !this.permissionsGranted();
        }
        return true;
    }

    private boolean isBleSupported() {
        if (this.context.getPackageManager().hasSystemFeature("android.hardware.bluetooth_le")) {
            return true;
        }
        Logger.e(TAG, "BLE not supported");
        return false;
    }

    public boolean isBluetoothEnabled() {
        if (this.bluetoothAdapter.isEnabled()) {
            return true;
        }
        Logger.e(TAG, "Bluetooth disabled");
        return false;
    }

    private boolean permissionsGranted() {
        int targetSdkVersion = this.context.getApplicationInfo().targetSdkVersion;
        if (Build.VERSION.SDK_INT >= 29 && targetSdkVersion >= 29) {
            if (this.context.checkSelfPermission("android.permission.ACCESS_FINE_LOCATION") != 0) {
                throw new SecurityException("app does not have ACCESS_FINE_LOCATION permission, cannot start scan");
            }
            return true;
        }
        if (Build.VERSION.SDK_INT >= 23) {
            if (this.context.checkSelfPermission("android.permission.ACCESS_COARSE_LOCATION") != 0) {
                throw new SecurityException("app does not have ACCESS_COARSE_LOCATION permission, cannot start scan");
            }
            return true;
        }
        return true;
    }

    private void setScanTimer() {
        this.cancelTimeoutTimer();
        this.timeoutRunnable = new Runnable(){

            @Override
            public void run() {
                Logger.d(TAG, "scanning timeout, restarting scan");
                final ScanCallback callback = BluetoothCentralManager.this.currentCallback;
                final List filters = BluetoothCentralManager.this.currentFilters;
                BluetoothCentralManager.this.stopScan();
                BluetoothCentralManager.this.callBackHandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        if (callback != null) {
                            BluetoothCentralManager.this.startScan(filters, BluetoothCentralManager.this.scanSettings, callback);
                        }
                    }
                }, 1000L);
            }
        };
        this.mainHandler.postDelayed(this.timeoutRunnable, 180000L);
    }

    private void cancelTimeoutTimer() {
        if (this.timeoutRunnable != null) {
            this.mainHandler.removeCallbacks(this.timeoutRunnable);
            this.timeoutRunnable = null;
        }
    }

    private void setAutoConnectTimer() {
        this.cancelAutoConnectTimer();
        this.autoConnectRunnable = new Runnable(){

            @Override
            public void run() {
                Logger.d(TAG, "autoconnect scan timeout, restarting scan");
                if (BluetoothCentralManager.this.autoConnectScanner != null) {
                    BluetoothCentralManager.this.autoConnectScanner.stopScan(BluetoothCentralManager.this.autoConnectScanCallback);
                    BluetoothCentralManager.this.autoConnectScanner = null;
                }
                BluetoothCentralManager.this.mainHandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        BluetoothCentralManager.this.scanForAutoConnectPeripherals();
                    }
                }, 1000L);
            }
        };
        this.mainHandler.postDelayed(this.autoConnectRunnable, 180000L);
    }

    private void cancelAutoConnectTimer() {
        if (this.autoConnectRunnable != null) {
            this.mainHandler.removeCallbacks(this.autoConnectRunnable);
            this.autoConnectRunnable = null;
        }
    }

    public boolean setPinCodeForPeripheral(@NotNull String peripheralAddress, @NotNull String pin) {
        Objects.requireNonNull(peripheralAddress, NO_PERIPHERAL_ADDRESS_PROVIDED);
        Objects.requireNonNull(pin, "no pin provided");
        if (!BluetoothAdapter.checkBluetoothAddress((String)peripheralAddress)) {
            Logger.e(TAG, "%s is not a valid address. Make sure all alphabetic characters are uppercase.", peripheralAddress);
            return false;
        }
        if (pin.length() != 6) {
            Logger.e(TAG, "%s is not 6 digits long", pin);
            return false;
        }
        this.pinCodes.put(peripheralAddress, pin);
        return true;
    }

    public boolean removeBond(@NotNull String peripheralAddress) {
        Objects.requireNonNull(peripheralAddress, NO_PERIPHERAL_ADDRESS_PROVIDED);
        Set bondedDevices = this.bluetoothAdapter.getBondedDevices();
        Object peripheralToUnBond = null;
        if (bondedDevices.size() > 0) {
            for (BluetoothDevice device : bondedDevices) {
                if (!device.getAddress().equals(peripheralAddress)) continue;
                peripheralToUnBond = device;
            }
        } else {
            return true;
        }
        if (peripheralToUnBond != null) {
            try {
                Method method = peripheralToUnBond.getClass().getMethod("removeBond", null);
                boolean result = (Boolean)method.invoke(peripheralToUnBond, (Object[])null);
                if (result) {
                    Logger.i(TAG, "Succesfully removed bond for '%s'", peripheralToUnBond.getName());
                }
                return result;
            }
            catch (Exception e) {
                Logger.i(TAG, "could not remove bond");
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    public void startPairingPopupHack() {
        String manufacturer = Build.MANUFACTURER;
        if (!manufacturer.equalsIgnoreCase("samsung")) {
            this.bluetoothAdapter.startDiscovery();
            this.callBackHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    Logger.d(TAG, "popup hack completed");
                    BluetoothCentralManager.this.bluetoothAdapter.cancelDiscovery();
                }
            }, 1000L);
        }
    }

    private void cancelAllConnectionsWhenBluetoothOff() {
        Logger.d(TAG, "disconnect all peripherals because bluetooth is off");
        for (BluetoothPeripheral peripheral : this.connectedPeripherals.values()) {
            peripheral.disconnectWhenBluetoothOff();
        }
        this.connectedPeripherals.clear();
        for (BluetoothPeripheral peripheral : this.unconnectedPeripherals.values()) {
            peripheral.disconnectWhenBluetoothOff();
        }
        this.unconnectedPeripherals.clear();
        this.reconnectPeripheralAddresses.clear();
        this.reconnectCallbacks.clear();
    }

    private void startDisconnectionTimer() {
        this.cancelDisconnectionTimer();
        this.disconnectRunnable = new Runnable(){

            @Override
            public void run() {
                Logger.e(TAG, "bluetooth turned off but no automatic disconnects happening, so doing it ourselves");
                BluetoothCentralManager.this.cancelAllConnectionsWhenBluetoothOff();
                BluetoothCentralManager.this.disconnectRunnable = null;
            }
        };
        this.mainHandler.postDelayed(this.disconnectRunnable, 1000L);
    }

    private void cancelDisconnectionTimer() {
        if (this.disconnectRunnable != null) {
            this.mainHandler.removeCallbacks(this.disconnectRunnable);
            this.disconnectRunnable = null;
        }
    }

    private void handleAdapterState(int state) {
        switch (state) {
            case 10: {
                if (this.connectedPeripherals.size() > 0 || this.unconnectedPeripherals.size() > 0) {
                    this.expectingBluetoothOffDisconnects = true;
                    this.startDisconnectionTimer();
                }
                Logger.d(TAG, "bluetooth turned off");
                break;
            }
            case 13: {
                this.expectingBluetoothOffDisconnects = true;
                this.cancelTimeoutTimer();
                this.cancelAutoConnectTimer();
                this.currentCallback = null;
                this.currentFilters = null;
                this.autoConnectScanner = null;
                Logger.d(TAG, "bluetooth turning off");
                break;
            }
            case 12: {
                this.expectingBluetoothOffDisconnects = false;
                Logger.d(TAG, "bluetooth turned on");
                break;
            }
            case 11: {
                this.expectingBluetoothOffDisconnects = false;
                Logger.d(TAG, "bluetooth turning on");
            }
        }
    }
}

