/*
 * Decompiled with CFR 0.152.
 */
package com.welie.blessed;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.le.BluetoothLeScanner;
import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanFilter;
import android.bluetooth.le.ScanResult;
import android.bluetooth.le.ScanSettings;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.ParcelUuid;
import com.welie.blessed.BluetoothCentralManagerCallback;
import com.welie.blessed.BluetoothPeripheral;
import com.welie.blessed.BluetoothPeripheralCallback;
import com.welie.blessed.HciStatus;
import com.welie.blessed.PeripheralType;
import com.welie.blessed.ScanFailure;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import timber.log.Timber;

public class BluetoothCentralManager {
    private static final long SCAN_TIMEOUT = 180000L;
    private static final int SCAN_RESTART_DELAY = 1000;
    private static final int MAX_CONNECTION_RETRIES = 1;
    private static final int MAX_CONNECTED_PERIPHERALS = 7;
    private static final String NO_PERIPHERAL_ADDRESS_PROVIDED = "no peripheral address provided";
    private static final String NO_VALID_PERIPHERAL_PROVIDED = "no valid peripheral provided";
    private static final String NO_VALID_PERIPHERAL_CALLBACK_SPECIFIED = "no valid peripheral callback specified";
    @NotNull
    private final Context context;
    @NotNull
    private final Handler callBackHandler;
    @NotNull
    private final BluetoothAdapter bluetoothAdapter;
    @Nullable
    private BluetoothLeScanner bluetoothScanner;
    @Nullable
    private BluetoothLeScanner autoConnectScanner;
    @NotNull
    private final BluetoothCentralManagerCallback bluetoothCentralManagerCallback;
    @NotNull
    private final Map<String, BluetoothPeripheral> connectedPeripherals = new ConcurrentHashMap<String, BluetoothPeripheral>();
    @NotNull
    private final Map<String, BluetoothPeripheral> unconnectedPeripherals = new ConcurrentHashMap<String, BluetoothPeripheral>();
    @NotNull
    private final Map<String, BluetoothPeripheral> scannedPeripherals = new ConcurrentHashMap<String, BluetoothPeripheral>();
    @NotNull
    private final List<String> reconnectPeripheralAddresses = new ArrayList<String>();
    @NotNull
    private final Map<String, BluetoothPeripheralCallback> reconnectCallbacks = new ConcurrentHashMap<String, BluetoothPeripheralCallback>();
    @NotNull
    private String[] scanPeripheralNames = new String[0];
    @NotNull
    private final Handler mainHandler = new Handler(Looper.getMainLooper());
    @Nullable
    private Runnable timeoutRunnable;
    @Nullable
    private Runnable autoConnectRunnable;
    @NotNull
    private final Object connectLock = new Object();
    @Nullable
    private ScanCallback currentCallback;
    @Nullable
    private List<ScanFilter> currentFilters;
    @NotNull
    private ScanSettings scanSettings;
    @NotNull
    private final ScanSettings autoConnectScanSettings;
    @NotNull
    private final Map<String, Integer> connectionRetries = new ConcurrentHashMap<String, Integer>();
    private boolean expectingBluetoothOffDisconnects = false;
    @Nullable
    private Runnable disconnectRunnable;
    @NotNull
    private final Map<String, String> pinCodes = new ConcurrentHashMap<String, String>();
    private final ScanCallback scanByNameCallback = new ScanCallback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onScanResult(int callbackType, final ScanResult result) {
            1 var3_3 = this;
            synchronized (var3_3) {
                String deviceName = result.getDevice().getName();
                if (deviceName == null) {
                    return;
                }
                for (String name : BluetoothCentralManager.this.scanPeripheralNames) {
                    if (!deviceName.contains(name)) continue;
                    BluetoothCentralManager.this.callBackHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            if (BluetoothCentralManager.this.isScanning()) {
                                BluetoothPeripheral peripheral = BluetoothCentralManager.this.getPeripheral(result.getDevice().getAddress());
                                peripheral.setDevice(result.getDevice());
                                BluetoothCentralManager.this.bluetoothCentralManagerCallback.onDiscoveredPeripheral(peripheral, result);
                            }
                        }
                    });
                    return;
                }
            }
        }

        public void onScanFailed(int errorCode) {
            final ScanFailure scanFailure = ScanFailure.fromValue(errorCode);
            Timber.e((String)"scan failed with error code %d (%s)", (Object[])new Object[]{errorCode, scanFailure});
            BluetoothCentralManager.this.currentCallback = null;
            BluetoothCentralManager.this.currentFilters = null;
            BluetoothCentralManager.this.callBackHandler.post(new Runnable(){

                @Override
                public void run() {
                    BluetoothCentralManager.this.bluetoothCentralManagerCallback.onScanFailed(scanFailure);
                }
            });
        }
    };
    private final ScanCallback defaultScanCallback = new ScanCallback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onScanResult(int callbackType, final ScanResult result) {
            2 var3_3 = this;
            synchronized (var3_3) {
                BluetoothCentralManager.this.callBackHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (BluetoothCentralManager.this.isScanning()) {
                            BluetoothPeripheral peripheral = BluetoothCentralManager.this.getPeripheral(result.getDevice().getAddress());
                            peripheral.setDevice(result.getDevice());
                            BluetoothCentralManager.this.bluetoothCentralManagerCallback.onDiscoveredPeripheral(peripheral, result);
                        }
                    }
                });
            }
        }

        public void onScanFailed(int errorCode) {
            final ScanFailure scanFailure = ScanFailure.fromValue(errorCode);
            Timber.e((String)"scan failed with error code %d (%s)", (Object[])new Object[]{errorCode, scanFailure});
            BluetoothCentralManager.this.currentCallback = null;
            BluetoothCentralManager.this.currentFilters = null;
            BluetoothCentralManager.this.callBackHandler.post(new Runnable(){

                @Override
                public void run() {
                    BluetoothCentralManager.this.bluetoothCentralManagerCallback.onScanFailed(scanFailure);
                }
            });
        }
    };
    private final ScanCallback autoConnectScanCallback = new ScanCallback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onScanResult(int callbackType, ScanResult result) {
            3 var3_3 = this;
            synchronized (var3_3) {
                if (!BluetoothCentralManager.this.isAutoScanning()) {
                    return;
                }
                Timber.d((String)"peripheral with address '%s' found", (Object[])new Object[]{result.getDevice().getAddress()});
                BluetoothCentralManager.this.stopAutoconnectScan();
                String deviceAddress = result.getDevice().getAddress();
                BluetoothPeripheral peripheral = (BluetoothPeripheral)BluetoothCentralManager.this.unconnectedPeripherals.get(deviceAddress);
                BluetoothPeripheralCallback callback = (BluetoothPeripheralCallback)BluetoothCentralManager.this.reconnectCallbacks.get(deviceAddress);
                BluetoothCentralManager.this.reconnectPeripheralAddresses.remove(deviceAddress);
                BluetoothCentralManager.this.reconnectCallbacks.remove(deviceAddress);
                BluetoothCentralManager.this.unconnectedPeripherals.remove(deviceAddress);
                BluetoothCentralManager.this.scannedPeripherals.remove(deviceAddress);
                if (peripheral != null && callback != null) {
                    BluetoothCentralManager.this.connectPeripheral(peripheral, callback);
                }
                if (BluetoothCentralManager.this.reconnectPeripheralAddresses.size() > 0) {
                    BluetoothCentralManager.this.scanForAutoConnectPeripherals();
                }
            }
        }

        public void onScanFailed(int errorCode) {
            final ScanFailure scanFailure = ScanFailure.fromValue(errorCode);
            Timber.e((String)"scan failed with error code %d (%s)", (Object[])new Object[]{errorCode, scanFailure});
            BluetoothCentralManager.this.autoConnectScanner = null;
            BluetoothCentralManager.this.callBackHandler.post(new Runnable(){

                @Override
                public void run() {
                    BluetoothCentralManager.this.bluetoothCentralManagerCallback.onScanFailed(scanFailure);
                }
            });
        }
    };
    private final BluetoothPeripheral.InternalCallback internalCallback = new BluetoothPeripheral.InternalCallback(){

        @Override
        public void connected(final @NotNull BluetoothPeripheral peripheral) {
            BluetoothCentralManager.this.connectionRetries.remove(peripheral.getAddress());
            BluetoothCentralManager.this.unconnectedPeripherals.remove(peripheral.getAddress());
            BluetoothCentralManager.this.scannedPeripherals.remove(peripheral.getAddress());
            BluetoothCentralManager.this.connectedPeripherals.put(peripheral.getAddress(), peripheral);
            if (BluetoothCentralManager.this.connectedPeripherals.size() == 7) {
                Timber.w((String)"maximum amount (%d) of connected peripherals reached", (Object[])new Object[]{7});
            }
            BluetoothCentralManager.this.callBackHandler.post(new Runnable(){

                @Override
                public void run() {
                    BluetoothCentralManager.this.bluetoothCentralManagerCallback.onConnectedPeripheral(peripheral);
                }
            });
        }

        @Override
        public void connectFailed(final @NotNull BluetoothPeripheral peripheral, final @NotNull HciStatus status) {
            Integer retries;
            BluetoothCentralManager.this.unconnectedPeripherals.remove(peripheral.getAddress());
            BluetoothCentralManager.this.scannedPeripherals.remove(peripheral.getAddress());
            int nrRetries = 0;
            if (BluetoothCentralManager.this.connectionRetries.get(peripheral.getAddress()) != null && (retries = (Integer)BluetoothCentralManager.this.connectionRetries.get(peripheral.getAddress())) != null) {
                nrRetries = retries;
            }
            if (nrRetries < 1 && status != HciStatus.CONNECTION_FAILED_ESTABLISHMENT) {
                Timber.i((String)"retrying connection to '%s' (%s)", (Object[])new Object[]{peripheral.getName(), peripheral.getAddress()});
                BluetoothCentralManager.this.connectionRetries.put(peripheral.getAddress(), ++nrRetries);
                BluetoothCentralManager.this.unconnectedPeripherals.put(peripheral.getAddress(), peripheral);
                peripheral.connect();
            } else {
                Timber.i((String)"connection to '%s' (%s) failed", (Object[])new Object[]{peripheral.getName(), peripheral.getAddress()});
                BluetoothCentralManager.this.connectionRetries.remove(peripheral.getAddress());
                BluetoothCentralManager.this.callBackHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        BluetoothCentralManager.this.bluetoothCentralManagerCallback.onConnectionFailed(peripheral, status);
                    }
                });
            }
        }

        @Override
        public void disconnected(final @NotNull BluetoothPeripheral peripheral, final @NotNull HciStatus status) {
            if (BluetoothCentralManager.this.expectingBluetoothOffDisconnects) {
                BluetoothCentralManager.this.cancelDisconnectionTimer();
                BluetoothCentralManager.this.expectingBluetoothOffDisconnects = false;
            }
            BluetoothCentralManager.this.connectedPeripherals.remove(peripheral.getAddress());
            BluetoothCentralManager.this.unconnectedPeripherals.remove(peripheral.getAddress());
            BluetoothCentralManager.this.scannedPeripherals.remove(peripheral.getAddress());
            BluetoothCentralManager.this.connectionRetries.remove(peripheral.getAddress());
            BluetoothCentralManager.this.callBackHandler.post(new Runnable(){

                @Override
                public void run() {
                    BluetoothCentralManager.this.bluetoothCentralManagerCallback.onDisconnectedPeripheral(peripheral, status);
                }
            });
        }

        @Override
        @Nullable
        public String getPincode(@NotNull BluetoothPeripheral device) {
            return (String)BluetoothCentralManager.this.pinCodes.get(device.getAddress());
        }
    };
    private final BroadcastReceiver adapterStateReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (action == null) {
                return;
            }
            if (action.equals("android.bluetooth.adapter.action.STATE_CHANGED")) {
                final int state = intent.getIntExtra("android.bluetooth.adapter.extra.STATE", Integer.MIN_VALUE);
                BluetoothCentralManager.this.callBackHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        BluetoothCentralManager.this.bluetoothCentralManagerCallback.onBluetoothAdapterStateChanged(state);
                    }
                });
                BluetoothCentralManager.this.handleAdapterState(state);
            }
        }
    };

    public BluetoothCentralManager(@NotNull Context context, @NotNull BluetoothCentralManagerCallback bluetoothCentralManagerCallback, @NotNull Handler handler) {
        this.context = Objects.requireNonNull(context, "no valid context provided");
        this.bluetoothCentralManagerCallback = Objects.requireNonNull(bluetoothCentralManagerCallback, "no valid bluetoothCallback provided");
        this.callBackHandler = Objects.requireNonNull(handler, "no valid handler provided");
        this.bluetoothAdapter = Objects.requireNonNull(BluetoothAdapter.getDefaultAdapter(), "no bluetooth adapter found");
        this.autoConnectScanSettings = Build.VERSION.SDK_INT >= 23 ? new ScanSettings.Builder().setScanMode(0).setCallbackType(1).setMatchMode(1).setNumOfMatches(1).setReportDelay(0L).build() : new ScanSettings.Builder().setScanMode(0).setReportDelay(0L).build();
        this.scanSettings = this.getScanSettings(2);
        IntentFilter filter = new IntentFilter("android.bluetooth.adapter.action.STATE_CHANGED");
        context.registerReceiver(this.adapterStateReceiver, filter);
    }

    public void close() {
        this.unconnectedPeripherals.clear();
        this.connectedPeripherals.clear();
        this.reconnectCallbacks.clear();
        this.reconnectPeripheralAddresses.clear();
        this.scannedPeripherals.clear();
        this.context.unregisterReceiver(this.adapterStateReceiver);
    }

    private ScanSettings getScanSettings(int scanMode) {
        if (scanMode == 0 || scanMode == 2 || scanMode == 1 || scanMode == -1) {
            if (Build.VERSION.SDK_INT >= 23) {
                return new ScanSettings.Builder().setScanMode(scanMode).setCallbackType(1).setMatchMode(1).setNumOfMatches(1).setReportDelay(0L).build();
            }
            return new ScanSettings.Builder().setScanMode(scanMode).setReportDelay(0L).build();
        }
        throw new IllegalArgumentException("invalid scan mode");
    }

    public void setScanMode(int scanMode) {
        this.scanSettings = this.getScanSettings(scanMode);
    }

    private void startScan(@Nullable List<ScanFilter> filters, @NotNull ScanSettings scanSettings, @NotNull ScanCallback scanCallback) {
        if (this.bleNotReady()) {
            return;
        }
        if (this.isScanning()) {
            Timber.e((String)"other scan still active, stopping scan", (Object[])new Object[0]);
            this.stopScan();
        }
        if (this.bluetoothScanner == null) {
            this.bluetoothScanner = this.bluetoothAdapter.getBluetoothLeScanner();
        }
        if (this.bluetoothScanner != null) {
            this.setScanTimer();
            this.currentCallback = scanCallback;
            this.currentFilters = filters;
            this.bluetoothScanner.startScan(filters, scanSettings, scanCallback);
            Timber.i((String)"scan started", (Object[])new Object[0]);
        } else {
            Timber.e((String)"starting scan failed", (Object[])new Object[0]);
        }
    }

    public void scanForPeripheralsWithServices(@NotNull UUID[] serviceUUIDs) {
        Objects.requireNonNull(serviceUUIDs, "no service UUIDs supplied");
        if (serviceUUIDs.length == 0) {
            throw new IllegalArgumentException("at least one service UUID  must be supplied");
        }
        ArrayList<ScanFilter> filters = new ArrayList<ScanFilter>();
        for (UUID serviceUUID : serviceUUIDs) {
            ScanFilter filter = new ScanFilter.Builder().setServiceUuid(new ParcelUuid(serviceUUID)).build();
            filters.add(filter);
        }
        this.startScan(filters, this.scanSettings, this.defaultScanCallback);
    }

    public void scanForPeripheralsWithNames(@NotNull String[] peripheralNames) {
        Objects.requireNonNull(peripheralNames, "No peripheral names supplied");
        if (peripheralNames.length == 0) {
            throw new IllegalArgumentException("at least one peripheral name must be supplied");
        }
        this.scanPeripheralNames = peripheralNames;
        this.startScan(null, this.scanSettings, this.scanByNameCallback);
    }

    public void scanForPeripheralsWithAddresses(@NotNull String[] peripheralAddresses) {
        Objects.requireNonNull(peripheralAddresses, "No peripheral addresses supplied");
        if (peripheralAddresses.length == 0) {
            throw new IllegalArgumentException("at least one peripheral address must be supplied");
        }
        ArrayList<ScanFilter> filters = new ArrayList<ScanFilter>();
        for (String address : peripheralAddresses) {
            if (BluetoothAdapter.checkBluetoothAddress((String)address)) {
                ScanFilter filter = new ScanFilter.Builder().setDeviceAddress(address).build();
                filters.add(filter);
                continue;
            }
            Timber.e((String)"%s is not a valid address. Make sure all alphabetic characters are uppercase.", (Object[])new Object[]{address});
        }
        this.startScan(filters, this.scanSettings, this.defaultScanCallback);
    }

    public void scanForPeripheralsUsingFilters(@NotNull List<ScanFilter> filters) {
        Objects.requireNonNull(filters, "no filters supplied");
        if (filters.isEmpty()) {
            throw new IllegalArgumentException("at least one scan filter must be supplied");
        }
        this.startScan(filters, this.scanSettings, this.defaultScanCallback);
    }

    public void scanForPeripherals() {
        this.startScan(null, this.scanSettings, this.defaultScanCallback);
    }

    private void scanForAutoConnectPeripherals() {
        if (this.bleNotReady()) {
            return;
        }
        if (this.autoConnectScanner != null) {
            this.stopAutoconnectScan();
        }
        this.autoConnectScanner = this.bluetoothAdapter.getBluetoothLeScanner();
        if (this.autoConnectScanner != null) {
            ArrayList<ScanFilter> filters = new ArrayList<ScanFilter>();
            for (String address : this.reconnectPeripheralAddresses) {
                ScanFilter filter = new ScanFilter.Builder().setDeviceAddress(address).build();
                filters.add(filter);
            }
            this.autoConnectScanner.startScan(filters, this.autoConnectScanSettings, this.autoConnectScanCallback);
            Timber.d((String)("started scanning to autoconnect peripherals (" + this.reconnectPeripheralAddresses.size() + ")"), (Object[])new Object[0]);
            this.setAutoConnectTimer();
        } else {
            Timber.e((String)"starting autoconnect scan failed", (Object[])new Object[0]);
        }
    }

    private void stopAutoconnectScan() {
        this.cancelAutoConnectTimer();
        if (this.autoConnectScanner != null) {
            this.autoConnectScanner.stopScan(this.autoConnectScanCallback);
            this.autoConnectScanner = null;
            Timber.i((String)"autoscan stopped", (Object[])new Object[0]);
        }
    }

    private boolean isAutoScanning() {
        return this.autoConnectScanner != null;
    }

    public void stopScan() {
        this.cancelTimeoutTimer();
        if (this.isScanning()) {
            if (this.bluetoothScanner != null) {
                this.bluetoothScanner.stopScan(this.currentCallback);
                Timber.i((String)"scan stopped", (Object[])new Object[0]);
            }
        } else {
            Timber.i((String)"no scan to stop because no scan is running", (Object[])new Object[0]);
        }
        this.currentCallback = null;
        this.currentFilters = null;
        this.scannedPeripherals.clear();
    }

    public boolean isScanning() {
        return this.bluetoothScanner != null && this.currentCallback != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectPeripheral(@NotNull BluetoothPeripheral peripheral, @NotNull BluetoothPeripheralCallback peripheralCallback) {
        Object object = this.connectLock;
        synchronized (object) {
            Objects.requireNonNull(peripheral, NO_VALID_PERIPHERAL_PROVIDED);
            Objects.requireNonNull(peripheralCallback, NO_VALID_PERIPHERAL_CALLBACK_SPECIFIED);
            if (this.connectedPeripherals.containsKey(peripheral.getAddress())) {
                Timber.w((String)"already connected to %s'", (Object[])new Object[]{peripheral.getAddress()});
                return;
            }
            if (this.unconnectedPeripherals.containsKey(peripheral.getAddress())) {
                Timber.w((String)"already connecting to %s'", (Object[])new Object[]{peripheral.getAddress()});
                return;
            }
            PeripheralType peripheralType = peripheral.getType();
            if (peripheralType == PeripheralType.UNKNOWN) {
                Timber.w((String)"peripheral with address '%s' is not in the Bluetooth cache, hence connection may fail", (Object[])new Object[]{peripheral.getAddress()});
            }
            peripheral.setPeripheralCallback(peripheralCallback);
            this.scannedPeripherals.remove(peripheral.getAddress());
            this.unconnectedPeripherals.put(peripheral.getAddress(), peripheral);
            peripheral.connect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void autoConnectPeripheral(@NotNull BluetoothPeripheral peripheral, @NotNull BluetoothPeripheralCallback peripheralCallback) {
        Object object = this.connectLock;
        synchronized (object) {
            Objects.requireNonNull(peripheral, NO_VALID_PERIPHERAL_PROVIDED);
            Objects.requireNonNull(peripheralCallback, NO_VALID_PERIPHERAL_CALLBACK_SPECIFIED);
            if (this.connectedPeripherals.containsKey(peripheral.getAddress())) {
                Timber.w((String)"already connected to %s'", (Object[])new Object[]{peripheral.getAddress()});
                return;
            }
            if (this.unconnectedPeripherals.get(peripheral.getAddress()) != null) {
                Timber.w((String)"already issued autoconnect for '%s' ", (Object[])new Object[]{peripheral.getAddress()});
                return;
            }
            PeripheralType peripheralType = peripheral.getType();
            if (peripheralType == PeripheralType.UNKNOWN) {
                Timber.d((String)"peripheral with address '%s' not in Bluetooth cache, autoconnecting by scanning", (Object[])new Object[]{peripheral.getAddress()});
                this.scannedPeripherals.remove(peripheral.getAddress());
                this.unconnectedPeripherals.put(peripheral.getAddress(), peripheral);
                this.autoConnectPeripheralByScan(peripheral.getAddress(), peripheralCallback);
                return;
            }
            if (peripheralType != PeripheralType.LE && peripheralType != PeripheralType.DUAL) {
                Timber.e((String)"peripheral does not support Bluetooth LE", (Object[])new Object[0]);
                return;
            }
            peripheral.setPeripheralCallback(peripheralCallback);
            this.scannedPeripherals.remove(peripheral.getAddress());
            this.unconnectedPeripherals.put(peripheral.getAddress(), peripheral);
            peripheral.autoConnect();
        }
    }

    private void autoConnectPeripheralByScan(String peripheralAddress, BluetoothPeripheralCallback peripheralCallback) {
        if (this.reconnectPeripheralAddresses.contains(peripheralAddress)) {
            Timber.w((String)"peripheral already on list for reconnection", (Object[])new Object[0]);
            return;
        }
        this.reconnectPeripheralAddresses.add(peripheralAddress);
        this.reconnectCallbacks.put(peripheralAddress, peripheralCallback);
        this.scanForAutoConnectPeripherals();
    }

    public void cancelConnection(final @NotNull BluetoothPeripheral peripheral) {
        Objects.requireNonNull(peripheral, NO_VALID_PERIPHERAL_PROVIDED);
        String peripheralAddress = peripheral.getAddress();
        if (this.reconnectPeripheralAddresses.contains(peripheralAddress)) {
            this.reconnectPeripheralAddresses.remove(peripheralAddress);
            this.reconnectCallbacks.remove(peripheralAddress);
            this.unconnectedPeripherals.remove(peripheralAddress);
            this.stopAutoconnectScan();
            Timber.d((String)"cancelling autoconnect for %s", (Object[])new Object[]{peripheralAddress});
            this.callBackHandler.post(new Runnable(){

                @Override
                public void run() {
                    BluetoothCentralManager.this.bluetoothCentralManagerCallback.onDisconnectedPeripheral(peripheral, HciStatus.SUCCESS);
                }
            });
            if (this.reconnectPeripheralAddresses.size() > 0) {
                this.scanForAutoConnectPeripherals();
            }
            return;
        }
        if (this.unconnectedPeripherals.containsKey(peripheralAddress) || this.connectedPeripherals.containsKey(peripheralAddress)) {
            peripheral.cancelConnection();
        } else {
            Timber.e((String)"cannot cancel connection to unknown peripheral %s", (Object[])new Object[]{peripheralAddress});
        }
    }

    public void autoConnectPeripheralsBatch(@NotNull Map<BluetoothPeripheral, BluetoothPeripheralCallback> batch) {
        Objects.requireNonNull(batch, "no valid batch provided");
        HashMap<BluetoothPeripheral, BluetoothPeripheralCallback> uncachedPeripherals = new HashMap<BluetoothPeripheral, BluetoothPeripheralCallback>();
        HashMap<BluetoothPeripheral, BluetoothPeripheralCallback> cachedPeripherals = new HashMap<BluetoothPeripheral, BluetoothPeripheralCallback>();
        for (BluetoothPeripheral peripheral : batch.keySet()) {
            if (peripheral.getType() == PeripheralType.UNKNOWN) {
                uncachedPeripherals.put(peripheral, batch.get(peripheral));
                continue;
            }
            cachedPeripherals.put(peripheral, batch.get(peripheral));
        }
        for (BluetoothPeripheral peripheral : cachedPeripherals.keySet()) {
            this.autoConnectPeripheral(peripheral, (BluetoothPeripheralCallback)Objects.requireNonNull(cachedPeripherals.get(peripheral)));
        }
        if (!uncachedPeripherals.isEmpty()) {
            for (BluetoothPeripheral peripheral : uncachedPeripherals.keySet()) {
                String peripheralAddress = peripheral.getAddress();
                if (this.reconnectPeripheralAddresses.contains(peripheralAddress)) {
                    Timber.w((String)"peripheral already on list for reconnection", (Object[])new Object[0]);
                } else {
                    this.reconnectPeripheralAddresses.add(peripheralAddress);
                }
                this.reconnectCallbacks.put(peripheralAddress, (BluetoothPeripheralCallback)uncachedPeripherals.get(peripheral));
                this.unconnectedPeripherals.put(peripheral.getAddress(), peripheral);
            }
            this.scanForAutoConnectPeripherals();
        }
    }

    @NotNull
    public BluetoothPeripheral getPeripheral(@NotNull String peripheralAddress) {
        Objects.requireNonNull(peripheralAddress, NO_PERIPHERAL_ADDRESS_PROVIDED);
        if (!BluetoothAdapter.checkBluetoothAddress((String)peripheralAddress)) {
            String message = String.format("%s is not a valid bluetooth address. Make sure all alphabetic characters are uppercase.", peripheralAddress);
            throw new IllegalArgumentException(message);
        }
        if (this.connectedPeripherals.containsKey(peripheralAddress)) {
            return Objects.requireNonNull(this.connectedPeripherals.get(peripheralAddress));
        }
        if (this.unconnectedPeripherals.containsKey(peripheralAddress)) {
            return Objects.requireNonNull(this.unconnectedPeripherals.get(peripheralAddress));
        }
        if (this.scannedPeripherals.containsKey(peripheralAddress)) {
            return Objects.requireNonNull(this.scannedPeripherals.get(peripheralAddress));
        }
        BluetoothPeripheral peripheral = new BluetoothPeripheral(this.context, this.bluetoothAdapter.getRemoteDevice(peripheralAddress), this.internalCallback, null, this.callBackHandler);
        this.scannedPeripherals.put(peripheralAddress, peripheral);
        return peripheral;
    }

    @NotNull
    public List<BluetoothPeripheral> getConnectedPeripherals() {
        return new ArrayList<BluetoothPeripheral>(this.connectedPeripherals.values());
    }

    private boolean bleNotReady() {
        if (this.isBleSupported() && this.isBluetoothEnabled()) {
            return !this.permissionsGranted();
        }
        return true;
    }

    private boolean isBleSupported() {
        if (this.context.getPackageManager().hasSystemFeature("android.hardware.bluetooth_le")) {
            return true;
        }
        Timber.e((String)"BLE not supported", (Object[])new Object[0]);
        return false;
    }

    public boolean isBluetoothEnabled() {
        if (this.bluetoothAdapter.isEnabled()) {
            return true;
        }
        Timber.e((String)"Bluetooth disabled", (Object[])new Object[0]);
        return false;
    }

    private boolean permissionsGranted() {
        int targetSdkVersion = this.context.getApplicationInfo().targetSdkVersion;
        if (Build.VERSION.SDK_INT >= 29 && targetSdkVersion >= 29) {
            if (this.context.checkSelfPermission("android.permission.ACCESS_FINE_LOCATION") != 0) {
                Timber.e((String)"no ACCESS_FINE_LOCATION permission, cannot scan", (Object[])new Object[0]);
                return false;
            }
            return true;
        }
        if (Build.VERSION.SDK_INT >= 23) {
            if (this.context.checkSelfPermission("android.permission.ACCESS_COARSE_LOCATION") != 0) {
                Timber.e((String)"no ACCESS_COARSE_LOCATION permission, cannot scan", (Object[])new Object[0]);
                return false;
            }
            return true;
        }
        return true;
    }

    private void setScanTimer() {
        this.cancelTimeoutTimer();
        this.timeoutRunnable = new Runnable(){

            @Override
            public void run() {
                Timber.d((String)"scanning timeout, restarting scan", (Object[])new Object[0]);
                final ScanCallback callback = BluetoothCentralManager.this.currentCallback;
                final List filters = BluetoothCentralManager.this.currentFilters;
                BluetoothCentralManager.this.stopScan();
                BluetoothCentralManager.this.callBackHandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        if (callback != null) {
                            BluetoothCentralManager.this.startScan(filters, BluetoothCentralManager.this.scanSettings, callback);
                        }
                    }
                }, 1000L);
            }
        };
        this.mainHandler.postDelayed(this.timeoutRunnable, 180000L);
    }

    private void cancelTimeoutTimer() {
        if (this.timeoutRunnable != null) {
            this.mainHandler.removeCallbacks(this.timeoutRunnable);
            this.timeoutRunnable = null;
        }
    }

    private void setAutoConnectTimer() {
        this.cancelAutoConnectTimer();
        this.autoConnectRunnable = new Runnable(){

            @Override
            public void run() {
                Timber.d((String)"autoconnect scan timeout, restarting scan", (Object[])new Object[0]);
                if (BluetoothCentralManager.this.autoConnectScanner != null) {
                    BluetoothCentralManager.this.autoConnectScanner.stopScan(BluetoothCentralManager.this.autoConnectScanCallback);
                    BluetoothCentralManager.this.autoConnectScanner = null;
                }
                BluetoothCentralManager.this.mainHandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        BluetoothCentralManager.this.scanForAutoConnectPeripherals();
                    }
                }, 1000L);
            }
        };
        this.mainHandler.postDelayed(this.autoConnectRunnable, 180000L);
    }

    private void cancelAutoConnectTimer() {
        if (this.autoConnectRunnable != null) {
            this.mainHandler.removeCallbacks(this.autoConnectRunnable);
            this.autoConnectRunnable = null;
        }
    }

    public boolean setPinCodeForPeripheral(@NotNull String peripheralAddress, @NotNull String pin) {
        Objects.requireNonNull(peripheralAddress, NO_PERIPHERAL_ADDRESS_PROVIDED);
        Objects.requireNonNull(pin, "no pin provided");
        if (!BluetoothAdapter.checkBluetoothAddress((String)peripheralAddress)) {
            Timber.e((String)"%s is not a valid address. Make sure all alphabetic characters are uppercase.", (Object[])new Object[]{peripheralAddress});
            return false;
        }
        if (pin.length() != 6) {
            Timber.e((String)"%s is not 6 digits long", (Object[])new Object[]{pin});
            return false;
        }
        this.pinCodes.put(peripheralAddress, pin);
        return true;
    }

    public boolean removeBond(@NotNull String peripheralAddress) {
        Objects.requireNonNull(peripheralAddress, NO_PERIPHERAL_ADDRESS_PROVIDED);
        Set bondedDevices = this.bluetoothAdapter.getBondedDevices();
        Object peripheralToUnBond = null;
        if (bondedDevices.size() > 0) {
            for (BluetoothDevice device : bondedDevices) {
                if (!device.getAddress().equals(peripheralAddress)) continue;
                peripheralToUnBond = device;
            }
        } else {
            return true;
        }
        if (peripheralToUnBond != null) {
            try {
                Method method = peripheralToUnBond.getClass().getMethod("removeBond", null);
                boolean result = (Boolean)method.invoke(peripheralToUnBond, (Object[])null);
                if (result) {
                    Timber.i((String)"Succesfully removed bond for '%s'", (Object[])new Object[]{peripheralToUnBond.getName()});
                }
                return result;
            }
            catch (Exception e) {
                Timber.i((String)"could not remove bond", (Object[])new Object[0]);
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    public void startPairingPopupHack() {
        String manufacturer = Build.MANUFACTURER;
        if (!manufacturer.equals("samsung")) {
            this.bluetoothAdapter.startDiscovery();
            this.callBackHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    Timber.d((String)"popup hack completed", (Object[])new Object[0]);
                    BluetoothCentralManager.this.bluetoothAdapter.cancelDiscovery();
                }
            }, 1000L);
        }
    }

    private void cancelAllConnectionsWhenBluetoothOff() {
        Timber.d((String)"disconnect all peripherals because bluetooth is off", (Object[])new Object[0]);
        for (BluetoothPeripheral peripheral : this.connectedPeripherals.values()) {
            peripheral.disconnectWhenBluetoothOff();
        }
        this.connectedPeripherals.clear();
        for (BluetoothPeripheral peripheral : this.unconnectedPeripherals.values()) {
            peripheral.disconnectWhenBluetoothOff();
        }
        this.unconnectedPeripherals.clear();
        this.reconnectPeripheralAddresses.clear();
        this.reconnectCallbacks.clear();
    }

    private void startDisconnectionTimer() {
        this.cancelDisconnectionTimer();
        this.disconnectRunnable = new Runnable(){

            @Override
            public void run() {
                Timber.e((String)"bluetooth turned off but no automatic disconnects happening, so doing it ourselves", (Object[])new Object[0]);
                BluetoothCentralManager.this.cancelAllConnectionsWhenBluetoothOff();
                BluetoothCentralManager.this.disconnectRunnable = null;
            }
        };
        this.mainHandler.postDelayed(this.disconnectRunnable, 1000L);
    }

    private void cancelDisconnectionTimer() {
        if (this.disconnectRunnable != null) {
            this.mainHandler.removeCallbacks(this.disconnectRunnable);
            this.disconnectRunnable = null;
        }
    }

    private void handleAdapterState(int state) {
        switch (state) {
            case 10: {
                if (this.connectedPeripherals.size() > 0 || this.unconnectedPeripherals.size() > 0) {
                    this.expectingBluetoothOffDisconnects = true;
                    this.startDisconnectionTimer();
                }
                Timber.d((String)"bluetooth turned off", (Object[])new Object[0]);
                break;
            }
            case 13: {
                this.expectingBluetoothOffDisconnects = true;
                this.cancelTimeoutTimer();
                this.cancelAutoConnectTimer();
                this.currentCallback = null;
                this.currentFilters = null;
                this.autoConnectScanner = null;
                Timber.d((String)"bluetooth turning off", (Object[])new Object[0]);
                break;
            }
            case 12: {
                this.expectingBluetoothOffDisconnects = false;
                Timber.d((String)"bluetooth turned on", (Object[])new Object[0]);
                break;
            }
            case 11: {
                this.expectingBluetoothOffDisconnects = false;
                Timber.d((String)"bluetooth turning on", (Object[])new Object[0]);
            }
        }
    }
}

