/*
 * Decompiled with CFR 0.152.
 */
package com.welie.blessed;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattService;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import com.welie.blessed.BluetoothBytesParser;
import com.welie.blessed.BluetoothPeripheralCallback;
import com.welie.blessed.GattStatus;
import com.welie.blessed.HciStatus;
import com.welie.blessed.PhyOptions;
import com.welie.blessed.PhyType;
import com.welie.blessed.WriteType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import timber.log.Timber;

public class BluetoothPeripheral {
    private static final UUID CCC_DESCRIPTOR_UUID = UUID.fromString("00002902-0000-1000-8000-00805f9b34fb");
    public static final int DEVICE_TYPE_UNKNOWN = 0;
    public static final int DEVICE_TYPE_CLASSIC = 1;
    public static final int DEVICE_TYPE_LE = 2;
    public static final int DEVICE_TYPE_DUAL = 3;
    public static final int BOND_NONE = 10;
    public static final int BOND_BONDING = 11;
    public static final int BOND_BONDED = 12;
    public static final int STATE_DISCONNECTED = 0;
    public static final int STATE_CONNECTING = 1;
    public static final int STATE_CONNECTED = 2;
    public static final int STATE_DISCONNECTING = 3;
    private static final int DEFAULT_MTU = 23;
    public static final int MAX_MTU = 517;
    private static final int MAX_TRIES = 2;
    private static final int DIRECT_CONNECTION_DELAY_IN_MS = 100;
    private static final int CONNECTION_TIMEOUT_IN_MS = 35000;
    private static final int TIMEOUT_THRESHOLD_SAMSUNG = 4500;
    private static final int TIMEOUT_THRESHOLD_DEFAULT = 25000;
    private static final long DELAY_AFTER_BOND_LOST = 1000L;
    private static final int MAX_NOTIFYING_CHARACTERISTICS = 15;
    private static final String NO_VALID_SERVICE_UUID_PROVIDED = "no valid service UUID provided";
    private static final String NO_VALID_CHARACTERISTIC_UUID_PROVIDED = "no valid characteristic UUID provided";
    private static final String NO_VALID_CHARACTERISTIC_PROVIDED = "no valid characteristic provided";
    private static final String NO_VALID_WRITE_TYPE_PROVIDED = "no valid writeType provided";
    private static final String NO_VALID_VALUE_PROVIDED = "no valid value provided";
    private static final String NO_VALID_DESCRIPTOR_PROVIDED = "no valid descriptor provided";
    private static final String PERIPHERAL_NOT_CONNECTED = "peripheral not connectected";
    private static final String VALUE_BYTE_ARRAY_IS_EMPTY = "value byte array is empty";
    private static final String VALUE_BYTE_ARRAY_IS_TOO_LONG = "value byte array is too long";
    @NotNull
    private final Context context;
    @NotNull
    private final Handler callbackHandler;
    @NotNull
    private BluetoothDevice device;
    @NotNull
    private final InternalCallback listener;
    @Nullable
    private BluetoothPeripheralCallback peripheralCallback;
    @NotNull
    private final Queue<Runnable> commandQueue = new ConcurrentLinkedQueue<Runnable>();
    @Nullable
    private volatile BluetoothGatt bluetoothGatt;
    @Nullable
    private String cachedName;
    @Nullable
    private byte[] currentWriteBytes;
    @NotNull
    private final Set<UUID> notifyingCharacteristics = new HashSet<UUID>();
    @NotNull
    private final Handler mainHandler = new Handler(Looper.getMainLooper());
    @Nullable
    private Runnable timeoutRunnable;
    @Nullable
    private Runnable discoverServicesRunnable;
    private volatile boolean commandQueueBusy = false;
    private boolean isRetrying;
    private boolean bondLost = false;
    private boolean manuallyBonding = false;
    private boolean discoveryStarted = false;
    private volatile int state = 0;
    private int nrTries;
    private long connectTimestamp;
    private int currentMtu = 23;
    private final BluetoothGattCallback bluetoothGattCallback = new BluetoothGattCallback(){

        public void onConnectionStateChange(BluetoothGatt gatt, int status, int newState) {
            BluetoothPeripheral.this.cancelConnectionTimer();
            int previousState = BluetoothPeripheral.this.state;
            BluetoothPeripheral.this.state = newState;
            HciStatus hciStatus = HciStatus.fromValue(status);
            if (hciStatus == HciStatus.SUCCESS) {
                switch (newState) {
                    case 2: {
                        BluetoothPeripheral.this.successfullyConnected();
                        break;
                    }
                    case 0: {
                        BluetoothPeripheral.this.successfullyDisconnected(previousState);
                        break;
                    }
                    case 3: {
                        Timber.i((String)"peripheral is disconnecting", (Object[])new Object[0]);
                        break;
                    }
                    case 1: {
                        Timber.i((String)"peripheral is connecting", (Object[])new Object[0]);
                        break;
                    }
                    default: {
                        Timber.e((String)"unknown state received", (Object[])new Object[0]);
                        break;
                    }
                }
            } else {
                BluetoothPeripheral.this.connectionStateChangeUnsuccessful(hciStatus, previousState, newState);
            }
        }

        public void onServicesDiscovered(BluetoothGatt gatt, int status) {
            GattStatus gattStatus = GattStatus.fromValue(status);
            if (gattStatus != GattStatus.SUCCESS) {
                Timber.e((String)"service discovery failed due to internal error '%s', disconnecting", (Object[])new Object[]{gattStatus});
                BluetoothPeripheral.this.disconnect();
                return;
            }
            List services = gatt.getServices();
            Timber.i((String)"discovered %d services for '%s'", (Object[])new Object[]{services.size(), BluetoothPeripheral.this.getName()});
            BluetoothPeripheral.this.listener.connected(BluetoothPeripheral.this);
            BluetoothPeripheral.this.callbackHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (BluetoothPeripheral.this.peripheralCallback != null) {
                        BluetoothPeripheral.this.peripheralCallback.onServicesDiscovered(BluetoothPeripheral.this);
                    }
                }
            });
        }

        public void onDescriptorWrite(BluetoothGatt gatt, final BluetoothGattDescriptor descriptor, int status) {
            final GattStatus gattStatus = GattStatus.fromValue(status);
            final BluetoothGattCharacteristic parentCharacteristic = descriptor.getCharacteristic();
            if (gattStatus != GattStatus.SUCCESS) {
                Timber.e((String)"failed to write <%s> to descriptor of characteristic <%s> for device: '%s', status '%s' ", (Object[])new Object[]{BluetoothBytesParser.bytes2String(BluetoothPeripheral.this.currentWriteBytes), parentCharacteristic.getUuid(), BluetoothPeripheral.this.getAddress(), gattStatus});
                if (this.failureThatShouldTriggerBonding(gattStatus)) {
                    return;
                }
            }
            if (descriptor.getUuid().equals(CCC_DESCRIPTOR_UUID)) {
                if (gattStatus == GattStatus.SUCCESS) {
                    byte[] value = BluetoothPeripheral.this.nonnullOf(descriptor.getValue());
                    if (Arrays.equals(value, BluetoothGattDescriptor.ENABLE_NOTIFICATION_VALUE) || Arrays.equals(value, BluetoothGattDescriptor.ENABLE_INDICATION_VALUE)) {
                        BluetoothPeripheral.this.notifyingCharacteristics.add(parentCharacteristic.getUuid());
                        if (BluetoothPeripheral.this.notifyingCharacteristics.size() > 15) {
                            Timber.e((String)"too many (%d) notifying characteristics. The maximum Android can handle is %d", (Object[])new Object[]{BluetoothPeripheral.this.notifyingCharacteristics.size(), 15});
                        }
                    } else if (Arrays.equals(value, BluetoothGattDescriptor.DISABLE_NOTIFICATION_VALUE)) {
                        BluetoothPeripheral.this.notifyingCharacteristics.remove(parentCharacteristic.getUuid());
                    }
                }
                BluetoothPeripheral.this.callbackHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (BluetoothPeripheral.this.peripheralCallback != null) {
                            BluetoothPeripheral.this.peripheralCallback.onNotificationStateUpdate(BluetoothPeripheral.this, parentCharacteristic, gattStatus);
                        }
                    }
                });
            } else {
                BluetoothPeripheral.this.callbackHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (BluetoothPeripheral.this.peripheralCallback != null) {
                            BluetoothPeripheral.this.peripheralCallback.onDescriptorWrite(BluetoothPeripheral.this, BluetoothPeripheral.this.currentWriteBytes, descriptor, gattStatus);
                        }
                    }
                });
            }
            BluetoothPeripheral.this.completedCommand();
        }

        public void onDescriptorRead(BluetoothGatt gatt, final BluetoothGattDescriptor descriptor, int status) {
            final GattStatus gattStatus = GattStatus.fromValue(status);
            if (gattStatus != GattStatus.SUCCESS) {
                Timber.e((String)"reading descriptor <%s> failed for device '%s, status '%s'", (Object[])new Object[]{descriptor.getUuid(), BluetoothPeripheral.this.getAddress(), gattStatus});
                if (this.failureThatShouldTriggerBonding(gattStatus)) {
                    return;
                }
            }
            final byte[] value = BluetoothPeripheral.this.nonnullOf(descriptor.getValue());
            BluetoothPeripheral.this.callbackHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (BluetoothPeripheral.this.peripheralCallback != null) {
                        BluetoothPeripheral.this.peripheralCallback.onDescriptorRead(BluetoothPeripheral.this, value, descriptor, gattStatus);
                    }
                }
            });
            BluetoothPeripheral.this.completedCommand();
        }

        public void onCharacteristicChanged(BluetoothGatt gatt, final BluetoothGattCharacteristic characteristic) {
            final byte[] value = BluetoothPeripheral.this.nonnullOf(characteristic.getValue());
            BluetoothPeripheral.this.callbackHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (BluetoothPeripheral.this.peripheralCallback != null) {
                        BluetoothPeripheral.this.peripheralCallback.onCharacteristicUpdate(BluetoothPeripheral.this, value, characteristic, GattStatus.SUCCESS);
                    }
                }
            });
        }

        public void onCharacteristicRead(BluetoothGatt gatt, final BluetoothGattCharacteristic characteristic, int status) {
            final GattStatus gattStatus = GattStatus.fromValue(status);
            if (gattStatus != GattStatus.SUCCESS) {
                Timber.e((String)"read failed for characteristic <%s>, status '%s'", (Object[])new Object[]{characteristic.getUuid(), gattStatus});
                if (this.failureThatShouldTriggerBonding(gattStatus)) {
                    return;
                }
            }
            final byte[] value = BluetoothPeripheral.this.nonnullOf(characteristic.getValue());
            BluetoothPeripheral.this.callbackHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (BluetoothPeripheral.this.peripheralCallback != null) {
                        BluetoothPeripheral.this.peripheralCallback.onCharacteristicUpdate(BluetoothPeripheral.this, value, characteristic, gattStatus);
                    }
                }
            });
            BluetoothPeripheral.this.completedCommand();
        }

        public void onCharacteristicWrite(BluetoothGatt gatt, final BluetoothGattCharacteristic characteristic, int status) {
            final GattStatus gattStatus = GattStatus.fromValue(status);
            if (gattStatus != GattStatus.SUCCESS) {
                Timber.e((String)"writing <%s> to characteristic <%s> failed, status '%s'", (Object[])new Object[]{BluetoothBytesParser.bytes2String(BluetoothPeripheral.this.currentWriteBytes), characteristic.getUuid(), gattStatus});
                if (this.failureThatShouldTriggerBonding(gattStatus)) {
                    return;
                }
            }
            final byte[] value = BluetoothPeripheral.this.nonnullOf(BluetoothPeripheral.this.currentWriteBytes);
            BluetoothPeripheral.access$902(BluetoothPeripheral.this, null);
            BluetoothPeripheral.this.callbackHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (BluetoothPeripheral.this.peripheralCallback != null) {
                        BluetoothPeripheral.this.peripheralCallback.onCharacteristicWrite(BluetoothPeripheral.this, value, characteristic, gattStatus);
                    }
                }
            });
            BluetoothPeripheral.this.completedCommand();
        }

        private boolean failureThatShouldTriggerBonding(GattStatus gattStatus) {
            if ((gattStatus == GattStatus.AUTHORIZATION_FAILED || gattStatus == GattStatus.INSUFFICIENT_AUTHENTICATION || gattStatus == GattStatus.INSUFFICIENT_ENCRYPTION) && Build.VERSION.SDK_INT < 26) {
                Timber.i((String)"operation will be retried after bonding, bonding should be in progress", (Object[])new Object[0]);
                return true;
            }
            return false;
        }

        public void onReadRemoteRssi(BluetoothGatt gatt, final int rssi, int status) {
            final GattStatus gattStatus = GattStatus.fromValue(status);
            if (gattStatus != GattStatus.SUCCESS) {
                Timber.e((String)"reading RSSI failed, status '%s'", (Object[])new Object[]{GattStatus.fromValue(status)});
            }
            BluetoothPeripheral.this.callbackHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (BluetoothPeripheral.this.peripheralCallback != null) {
                        BluetoothPeripheral.this.peripheralCallback.onReadRemoteRssi(BluetoothPeripheral.this, rssi, gattStatus);
                    }
                }
            });
            BluetoothPeripheral.this.completedCommand();
        }

        public void onMtuChanged(BluetoothGatt gatt, final int mtu, int status) {
            final GattStatus gattStatus = GattStatus.fromValue(status);
            if (gattStatus != GattStatus.SUCCESS) {
                Timber.e((String)"change MTU failed, status '%s'", (Object[])new Object[]{GattStatus.fromValue(status)});
            }
            BluetoothPeripheral.this.currentMtu = mtu;
            BluetoothPeripheral.this.callbackHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (BluetoothPeripheral.this.peripheralCallback != null) {
                        BluetoothPeripheral.this.peripheralCallback.onMtuChanged(BluetoothPeripheral.this, mtu, gattStatus);
                    }
                }
            });
            BluetoothPeripheral.this.completedCommand();
        }

        public void onPhyRead(BluetoothGatt gatt, final int txPhy, final int rxPhy, int status) {
            final GattStatus gattStatus = GattStatus.fromValue(status);
            if (gattStatus != GattStatus.SUCCESS) {
                Timber.e((String)"read Phy failed, status '%s'", (Object[])new Object[]{GattStatus.fromValue(status)});
            }
            Timber.i((String)"updated Phy: tx = %s, rx = %s", (Object[])new Object[]{PhyType.fromValue(txPhy), PhyType.fromValue(rxPhy)});
            BluetoothPeripheral.this.callbackHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (BluetoothPeripheral.this.peripheralCallback != null) {
                        BluetoothPeripheral.this.peripheralCallback.onPhyUpdate(PhyType.fromValue(txPhy), PhyType.fromValue(rxPhy), gattStatus);
                    }
                }
            });
        }

        public void onPhyUpdate(BluetoothGatt gatt, final int txPhy, final int rxPhy, int status) {
            final GattStatus gattStatus = GattStatus.fromValue(status);
            if (gattStatus != GattStatus.SUCCESS) {
                Timber.e((String)"update Phy failed, status '%s'", (Object[])new Object[]{GattStatus.fromValue(status)});
            }
            Timber.i((String)"updated Phy: tx = %s, rx = %s", (Object[])new Object[]{PhyType.fromValue(txPhy), PhyType.fromValue(rxPhy)});
            BluetoothPeripheral.this.callbackHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (BluetoothPeripheral.this.peripheralCallback != null) {
                        BluetoothPeripheral.this.peripheralCallback.onPhyUpdate(PhyType.fromValue(txPhy), PhyType.fromValue(rxPhy), gattStatus);
                    }
                }
            });
        }
    };
    private final BroadcastReceiver bondStateReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (action == null) {
                return;
            }
            BluetoothDevice receivedDevice = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
            if (receivedDevice == null) {
                return;
            }
            if (!receivedDevice.getAddress().equalsIgnoreCase(BluetoothPeripheral.this.getAddress())) {
                return;
            }
            if (action.equals("android.bluetooth.device.action.BOND_STATE_CHANGED")) {
                int bondState = intent.getIntExtra("android.bluetooth.device.extra.BOND_STATE", Integer.MIN_VALUE);
                int previousBondState = intent.getIntExtra("android.bluetooth.device.extra.PREVIOUS_BOND_STATE", Integer.MIN_VALUE);
                BluetoothPeripheral.this.handleBondStateChange(bondState, previousBondState);
            }
        }
    };
    private final BroadcastReceiver pairingRequestBroadcastReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String pin;
            BluetoothDevice device = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
            if (device == null) {
                return;
            }
            if (!device.getAddress().equalsIgnoreCase(BluetoothPeripheral.this.getAddress())) {
                return;
            }
            int variant = intent.getIntExtra("android.bluetooth.device.extra.PAIRING_VARIANT", Integer.MIN_VALUE);
            Timber.d((String)("pairing request received: " + BluetoothPeripheral.this.pairingVariantToString(variant) + " (" + variant + ")"), (Object[])new Object[0]);
            if (variant == 0 && (pin = BluetoothPeripheral.this.listener.getPincode(BluetoothPeripheral.this)) != null) {
                Timber.d((String)"setting PIN code for this peripheral using '%s'", (Object[])new Object[]{pin});
                device.setPin(pin.getBytes());
                this.abortBroadcast();
            }
        }
    };
    private static final int PAIRING_VARIANT_PIN = 0;
    private static final int PAIRING_VARIANT_PASSKEY = 1;
    private static final int PAIRING_VARIANT_PASSKEY_CONFIRMATION = 2;
    private static final int PAIRING_VARIANT_CONSENT = 3;
    private static final int PAIRING_VARIANT_DISPLAY_PASSKEY = 4;
    private static final int PAIRING_VARIANT_DISPLAY_PIN = 5;
    private static final int PAIRING_VARIANT_OOB_CONSENT = 6;

    private void successfullyConnected() {
        int bondstate = this.device.getBondState();
        long timePassed = SystemClock.elapsedRealtime() - this.connectTimestamp;
        Timber.i((String)"connected to '%s' (%s) in %.1fs", (Object[])new Object[]{this.getName(), this.bondStateToString(bondstate), Float.valueOf((float)timePassed / 1000.0f)});
        if (bondstate == 10 || bondstate == 12) {
            this.delayedDiscoverServices(this.getServiceDiscoveryDelay(bondstate));
        } else if (bondstate == 11) {
            Timber.i((String)"waiting for bonding to complete", (Object[])new Object[0]);
        }
    }

    private void delayedDiscoverServices(final long delay) {
        this.discoverServicesRunnable = new Runnable(){

            @Override
            public void run() {
                Timber.d((String)"discovering services of '%s' with delay of %d ms", (Object[])new Object[]{BluetoothPeripheral.this.getName(), delay});
                if (BluetoothPeripheral.this.bluetoothGatt != null && BluetoothPeripheral.this.bluetoothGatt.discoverServices()) {
                    BluetoothPeripheral.this.discoveryStarted = true;
                } else {
                    Timber.e((String)"discoverServices failed to start", (Object[])new Object[0]);
                }
                BluetoothPeripheral.this.discoverServicesRunnable = null;
            }
        };
        this.mainHandler.postDelayed(this.discoverServicesRunnable, delay);
    }

    private long getServiceDiscoveryDelay(int bondstate) {
        long delayWhenBonded = 0L;
        if (Build.VERSION.SDK_INT <= 24) {
            delayWhenBonded = 1000L;
        }
        return bondstate == 12 ? delayWhenBonded : 0L;
    }

    private void successfullyDisconnected(int previousState) {
        if (previousState == 2 || previousState == 3) {
            Timber.i((String)"disconnected '%s' on request", (Object[])new Object[]{this.getName()});
        } else if (previousState == 1) {
            Timber.i((String)"cancelling connect attempt", (Object[])new Object[0]);
        }
        if (this.bondLost) {
            this.completeDisconnect(false, HciStatus.SUCCESS);
            this.callbackHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    BluetoothPeripheral.this.listener.connectFailed(BluetoothPeripheral.this, HciStatus.SUCCESS);
                }
            }, 1000L);
        } else {
            this.completeDisconnect(true, HciStatus.SUCCESS);
        }
    }

    private void connectionStateChangeUnsuccessful(HciStatus status, int previousState, int newState) {
        boolean servicesDiscovered;
        this.cancelPendingServiceDiscovery();
        boolean bl = servicesDiscovered = !this.getServices().isEmpty();
        if (previousState == 1) {
            long timePassed = SystemClock.elapsedRealtime() - this.connectTimestamp;
            boolean isTimeout = timePassed > (long)this.getTimoutThreshold();
            HciStatus adjustedStatus = status == HciStatus.ERROR && isTimeout ? HciStatus.CONNECTION_FAILED_ESTABLISHMENT : status;
            Timber.i((String)"connection failed with status '%s'", (Object[])new Object[]{adjustedStatus});
            this.completeDisconnect(false, adjustedStatus);
            this.listener.connectFailed(this, adjustedStatus);
        } else if (previousState == 2 && newState == 0 && !servicesDiscovered) {
            Timber.i((String)"peripheral '%s' disconnected with status '%s' (%d) before completing service discovery", (Object[])new Object[]{this.getName(), status, status.getValue()});
            this.completeDisconnect(false, status);
            this.listener.connectFailed(this, status);
        } else {
            if (newState == 0) {
                Timber.i((String)"peripheral '%s' disconnected with status '%s' (%d)", (Object[])new Object[]{this.getName(), status, status.getValue()});
            } else {
                Timber.i((String)"unexpected connection state change for '%s' status '%s' (%d)", (Object[])new Object[]{this.getName(), status, status.getValue()});
            }
            this.completeDisconnect(true, status);
        }
    }

    private void cancelPendingServiceDiscovery() {
        if (this.discoverServicesRunnable != null) {
            this.mainHandler.removeCallbacks(this.discoverServicesRunnable);
            this.discoverServicesRunnable = null;
        }
    }

    private void handleBondStateChange(int bondState, int previousBondState) {
        switch (bondState) {
            case 11: {
                Timber.d((String)"starting bonding with '%s' (%s)", (Object[])new Object[]{this.getName(), this.getAddress()});
                this.callbackHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (BluetoothPeripheral.this.peripheralCallback != null) {
                            BluetoothPeripheral.this.peripheralCallback.onBondingStarted(BluetoothPeripheral.this);
                        }
                    }
                });
                break;
            }
            case 12: {
                Timber.d((String)"bonded with '%s' (%s)", (Object[])new Object[]{this.getName(), this.getAddress()});
                this.callbackHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (BluetoothPeripheral.this.peripheralCallback != null) {
                            BluetoothPeripheral.this.peripheralCallback.onBondingSucceeded(BluetoothPeripheral.this);
                        }
                    }
                });
                if (this.getServices().isEmpty() && !this.discoveryStarted) {
                    this.delayedDiscoverServices(0L);
                }
                if (Build.VERSION.SDK_INT < 26 && this.commandQueueBusy && !this.manuallyBonding) {
                    this.mainHandler.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            Timber.d((String)"retrying command after bonding", (Object[])new Object[0]);
                            BluetoothPeripheral.this.retryCommand();
                        }
                    }, 50L);
                }
                if (!this.manuallyBonding) break;
                this.manuallyBonding = false;
                this.completedCommand();
                break;
            }
            case 10: {
                if (previousBondState == 11) {
                    Timber.e((String)"bonding failed for '%s', disconnecting device", (Object[])new Object[]{this.getName()});
                    this.callbackHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            if (BluetoothPeripheral.this.peripheralCallback != null) {
                                BluetoothPeripheral.this.peripheralCallback.onBondingFailed(BluetoothPeripheral.this);
                            }
                        }
                    });
                } else {
                    Timber.e((String)"bond lost for '%s'", (Object[])new Object[]{this.getName()});
                    this.bondLost = true;
                    this.cancelPendingServiceDiscovery();
                    this.callbackHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            if (BluetoothPeripheral.this.peripheralCallback != null) {
                                BluetoothPeripheral.this.peripheralCallback.onBondLost(BluetoothPeripheral.this);
                            }
                        }
                    });
                }
                this.disconnect();
            }
        }
    }

    BluetoothPeripheral(@NotNull Context context, @NotNull BluetoothDevice device, @NotNull InternalCallback listener, @Nullable BluetoothPeripheralCallback peripheralCallback, @Nullable Handler callbackHandler) {
        this.context = Objects.requireNonNull(context, "no valid context provided");
        this.device = Objects.requireNonNull(device, "no valid device provided");
        this.listener = Objects.requireNonNull(listener, "no valid listener provided");
        this.peripheralCallback = peripheralCallback;
        this.callbackHandler = callbackHandler != null ? callbackHandler : new Handler(Looper.getMainLooper());
    }

    void setPeripheralCallback(@NotNull BluetoothPeripheralCallback peripheralCallback) {
        this.peripheralCallback = Objects.requireNonNull(peripheralCallback, "no valid peripheral callback provided");
    }

    void setDevice(@NotNull BluetoothDevice bluetoothDevice) {
        this.device = Objects.requireNonNull(bluetoothDevice, "bluetoothdevice is not valid");
    }

    void connect() {
        if (this.state == 0) {
            this.mainHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    Timber.i((String)"connect to '%s' (%s) using TRANSPORT_LE", (Object[])new Object[]{BluetoothPeripheral.this.getName(), BluetoothPeripheral.this.getAddress()});
                    BluetoothPeripheral.this.registerBondingBroadcastReceivers();
                    BluetoothPeripheral.this.state = 1;
                    BluetoothPeripheral.this.discoveryStarted = false;
                    BluetoothPeripheral.this.bluetoothGatt = BluetoothPeripheral.this.connectGattHelper(BluetoothPeripheral.this.device, false, BluetoothPeripheral.this.bluetoothGattCallback);
                    BluetoothPeripheral.this.connectTimestamp = SystemClock.elapsedRealtime();
                    BluetoothPeripheral.this.startConnectionTimer(BluetoothPeripheral.this);
                }
            }, 100L);
        } else {
            Timber.e((String)"peripheral '%s' not yet disconnected, will not connect", (Object[])new Object[]{this.getName()});
        }
    }

    void autoConnect() {
        if (this.state == 0) {
            this.mainHandler.post(new Runnable(){

                @Override
                public void run() {
                    Timber.i((String)"autoConnect to '%s' (%s) using TRANSPORT_LE", (Object[])new Object[]{BluetoothPeripheral.this.getName(), BluetoothPeripheral.this.getAddress()});
                    BluetoothPeripheral.this.registerBondingBroadcastReceivers();
                    BluetoothPeripheral.this.state = 1;
                    BluetoothPeripheral.this.discoveryStarted = false;
                    BluetoothPeripheral.this.bluetoothGatt = BluetoothPeripheral.this.connectGattHelper(BluetoothPeripheral.this.device, true, BluetoothPeripheral.this.bluetoothGattCallback);
                    BluetoothPeripheral.this.connectTimestamp = SystemClock.elapsedRealtime();
                }
            });
        } else {
            Timber.e((String)"peripheral '%s' not yet disconnected, will not connect", (Object[])new Object[]{this.getName()});
        }
    }

    private void registerBondingBroadcastReceivers() {
        this.context.registerReceiver(this.bondStateReceiver, new IntentFilter("android.bluetooth.device.action.BOND_STATE_CHANGED"));
        this.context.registerReceiver(this.pairingRequestBroadcastReceiver, new IntentFilter("android.bluetooth.device.action.PAIRING_REQUEST"));
    }

    public boolean createBond() {
        if (this.bluetoothGatt == null) {
            return this.device.createBond();
        }
        boolean result = this.commandQueue.add(new Runnable(){

            @Override
            public void run() {
                BluetoothPeripheral.this.manuallyBonding = true;
                if (!BluetoothPeripheral.this.device.createBond()) {
                    Timber.e((String)"bonding failed for %s", (Object[])new Object[]{BluetoothPeripheral.this.getAddress()});
                    BluetoothPeripheral.this.completedCommand();
                } else {
                    Timber.d((String)"manually bonding %s", (Object[])new Object[]{BluetoothPeripheral.this.getAddress()});
                    BluetoothPeripheral.this.nrTries++;
                }
            }
        });
        if (result) {
            this.nextCommand();
        } else {
            Timber.e((String)"could not enqueue bonding command", (Object[])new Object[0]);
        }
        return result;
    }

    private boolean createBond(int transport) {
        Timber.d((String)"bonding using TRANSPORT_LE", (Object[])new Object[0]);
        boolean result = false;
        try {
            Method bondMethod = this.device.getClass().getMethod("createBond", Integer.TYPE);
            if (bondMethod != null) {
                result = (Boolean)bondMethod.invoke((Object)this.device, transport);
            }
        }
        catch (Exception e) {
            Timber.e((String)"could not invoke createBond method", (Object[])new Object[0]);
        }
        return result;
    }

    public void cancelConnection() {
        if (this.bluetoothGatt == null) {
            Timber.w((String)"cannot cancel connection because no connection attempt is made yet", (Object[])new Object[0]);
            return;
        }
        if (this.state == 0 || this.state == 3) {
            return;
        }
        this.cancelConnectionTimer();
        if (this.state == 1) {
            this.disconnect();
            this.mainHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    BluetoothPeripheral.this.bluetoothGattCallback.onConnectionStateChange(BluetoothPeripheral.this.bluetoothGatt, HciStatus.SUCCESS.getValue(), 0);
                }
            }, 50L);
        } else {
            this.disconnect();
        }
    }

    private void disconnect() {
        if (this.state == 2 || this.state == 1) {
            this.state = 3;
            this.mainHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (BluetoothPeripheral.this.state == 3 && BluetoothPeripheral.this.bluetoothGatt != null) {
                        BluetoothPeripheral.this.bluetoothGatt.disconnect();
                        Timber.i((String)"force disconnect '%s' (%s)", (Object[])new Object[]{BluetoothPeripheral.this.getName(), BluetoothPeripheral.this.getAddress()});
                    }
                }
            });
        } else {
            this.listener.disconnected(this, HciStatus.SUCCESS);
        }
    }

    void disconnectWhenBluetoothOff() {
        this.bluetoothGatt = null;
        this.completeDisconnect(true, HciStatus.SUCCESS);
    }

    private void completeDisconnect(boolean notify, HciStatus status) {
        if (this.bluetoothGatt != null) {
            this.bluetoothGatt.close();
            this.bluetoothGatt = null;
        }
        this.commandQueue.clear();
        this.commandQueueBusy = false;
        try {
            this.context.unregisterReceiver(this.bondStateReceiver);
            this.context.unregisterReceiver(this.pairingRequestBroadcastReceiver);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.bondLost = false;
        if (notify) {
            this.listener.disconnected(this, status);
        }
    }

    @NotNull
    public String getAddress() {
        return this.device.getAddress();
    }

    public int getType() {
        return this.device.getType();
    }

    @Nullable
    public String getName() {
        String name = this.device.getName();
        if (name != null) {
            this.cachedName = name;
            return name;
        }
        return this.cachedName;
    }

    public int getBondState() {
        return this.device.getBondState();
    }

    @NotNull
    public List<BluetoothGattService> getServices() {
        if (this.bluetoothGatt != null) {
            return this.bluetoothGatt.getServices();
        }
        return Collections.emptyList();
    }

    @Nullable
    public BluetoothGattService getService(@NotNull UUID serviceUUID) {
        Objects.requireNonNull(serviceUUID, NO_VALID_SERVICE_UUID_PROVIDED);
        if (this.bluetoothGatt != null) {
            return this.bluetoothGatt.getService(serviceUUID);
        }
        return null;
    }

    @Nullable
    public BluetoothGattCharacteristic getCharacteristic(@NotNull UUID serviceUUID, @NotNull UUID characteristicUUID) {
        Objects.requireNonNull(serviceUUID, NO_VALID_SERVICE_UUID_PROVIDED);
        Objects.requireNonNull(characteristicUUID, NO_VALID_CHARACTERISTIC_UUID_PROVIDED);
        BluetoothGattService service = this.getService(serviceUUID);
        if (service != null) {
            return service.getCharacteristic(characteristicUUID);
        }
        return null;
    }

    public int getState() {
        return this.state;
    }

    public int getCurrentMtu() {
        return this.currentMtu;
    }

    public int getMaximumWriteValueLength(WriteType writeType) {
        switch (writeType) {
            case WITH_RESPONSE: {
                return 512;
            }
            case SIGNED: {
                return this.currentMtu - 15;
            }
        }
        return this.currentMtu - 3;
    }

    public boolean isNotifying(@NotNull BluetoothGattCharacteristic characteristic) {
        Objects.requireNonNull(characteristic, NO_VALID_CHARACTERISTIC_PROVIDED);
        return this.notifyingCharacteristics.contains(characteristic.getUuid());
    }

    private boolean isConnected() {
        return this.bluetoothGatt != null && this.state == 2;
    }

    public boolean readCharacteristic(@NotNull UUID serviceUUID, @NotNull UUID characteristicUUID) {
        Objects.requireNonNull(serviceUUID, NO_VALID_SERVICE_UUID_PROVIDED);
        Objects.requireNonNull(characteristicUUID, NO_VALID_CHARACTERISTIC_UUID_PROVIDED);
        if (!this.isConnected()) {
            Timber.e((String)PERIPHERAL_NOT_CONNECTED, (Object[])new Object[0]);
            return false;
        }
        BluetoothGattCharacteristic characteristic = this.getCharacteristic(serviceUUID, characteristicUUID);
        if (characteristic != null) {
            return this.readCharacteristic(characteristic);
        }
        return false;
    }

    public boolean readCharacteristic(final @NotNull BluetoothGattCharacteristic characteristic) {
        Objects.requireNonNull(characteristic, NO_VALID_CHARACTERISTIC_PROVIDED);
        if (!this.isConnected()) {
            Timber.e((String)PERIPHERAL_NOT_CONNECTED, (Object[])new Object[0]);
            return false;
        }
        if (this.doesNotSupportReading(characteristic)) {
            Timber.e((String)"characteristic does not have read property", (Object[])new Object[0]);
            return false;
        }
        boolean result = this.commandQueue.add(new Runnable(){

            @Override
            public void run() {
                if (BluetoothPeripheral.this.isConnected()) {
                    if (!BluetoothPeripheral.this.bluetoothGatt.readCharacteristic(characteristic)) {
                        Timber.e((String)"readCharacteristic failed for characteristic: %s", (Object[])new Object[]{characteristic.getUuid()});
                        BluetoothPeripheral.this.completedCommand();
                    } else {
                        Timber.d((String)"reading characteristic <%s>", (Object[])new Object[]{characteristic.getUuid()});
                        BluetoothPeripheral.this.nrTries++;
                    }
                } else {
                    BluetoothPeripheral.this.completedCommand();
                }
            }
        });
        if (result) {
            this.nextCommand();
        } else {
            Timber.e((String)"could not enqueue read characteristic command", (Object[])new Object[0]);
        }
        return result;
    }

    private boolean doesNotSupportReading(@NotNull BluetoothGattCharacteristic characteristic) {
        return (characteristic.getProperties() & 2) == 0;
    }

    public boolean writeCharacteristic(@NotNull UUID serviceUUID, @NotNull UUID characteristicUUID, @NotNull byte[] value, @NotNull WriteType writeType) {
        Objects.requireNonNull(serviceUUID, NO_VALID_SERVICE_UUID_PROVIDED);
        Objects.requireNonNull(characteristicUUID, NO_VALID_CHARACTERISTIC_UUID_PROVIDED);
        Objects.requireNonNull(value, NO_VALID_VALUE_PROVIDED);
        Objects.requireNonNull(writeType, NO_VALID_WRITE_TYPE_PROVIDED);
        if (!this.isConnected()) {
            Timber.e((String)PERIPHERAL_NOT_CONNECTED, (Object[])new Object[0]);
            return false;
        }
        BluetoothGattCharacteristic characteristic = this.getCharacteristic(serviceUUID, characteristicUUID);
        if (characteristic != null) {
            return this.writeCharacteristic(characteristic, value, writeType);
        }
        return false;
    }

    public boolean writeCharacteristic(final @NotNull BluetoothGattCharacteristic characteristic, @NotNull byte[] value, final @NotNull WriteType writeType) {
        Objects.requireNonNull(characteristic, NO_VALID_CHARACTERISTIC_PROVIDED);
        Objects.requireNonNull(value, NO_VALID_VALUE_PROVIDED);
        Objects.requireNonNull(writeType, NO_VALID_WRITE_TYPE_PROVIDED);
        if (!this.isConnected()) {
            Timber.e((String)PERIPHERAL_NOT_CONNECTED, (Object[])new Object[0]);
            return false;
        }
        if (value.length == 0) {
            throw new IllegalArgumentException(VALUE_BYTE_ARRAY_IS_EMPTY);
        }
        if (value.length > this.getMaximumWriteValueLength(writeType)) {
            throw new IllegalArgumentException(VALUE_BYTE_ARRAY_IS_TOO_LONG);
        }
        if (this.doesNotSupportWriteType(characteristic, writeType)) {
            Timber.e((String)"characteristic <%s> does not support writeType '%s'", (Object[])new Object[]{characteristic.getUuid(), writeType});
            return false;
        }
        final byte[] bytesToWrite = this.copyOf(value);
        boolean result = this.commandQueue.add(new Runnable(){

            @Override
            public void run() {
                if (BluetoothPeripheral.this.isConnected()) {
                    BluetoothPeripheral.access$902(BluetoothPeripheral.this, bytesToWrite);
                    characteristic.setWriteType(writeType.getWriteType());
                    characteristic.setValue(bytesToWrite);
                    if (BluetoothPeripheral.this.willCauseLongWrite(bytesToWrite, writeType)) {
                        Timber.w((String)"value byte array is longer than allowed by MTU, write will fail if peripheral does not support long writes", (Object[])new Object[0]);
                    }
                    if (!BluetoothPeripheral.this.bluetoothGatt.writeCharacteristic(characteristic)) {
                        Timber.e((String)"writeCharacteristic failed for characteristic: %s", (Object[])new Object[]{characteristic.getUuid()});
                        BluetoothPeripheral.this.completedCommand();
                    } else {
                        Timber.d((String)"writing <%s> to characteristic <%s>", (Object[])new Object[]{BluetoothBytesParser.bytes2String(bytesToWrite), characteristic.getUuid()});
                        BluetoothPeripheral.this.nrTries++;
                    }
                } else {
                    BluetoothPeripheral.this.completedCommand();
                }
            }
        });
        if (result) {
            this.nextCommand();
        } else {
            Timber.e((String)"could not enqueue write characteristic command", (Object[])new Object[0]);
        }
        return result;
    }

    private boolean willCauseLongWrite(@NotNull byte[] value, @NotNull WriteType writeType) {
        return value.length > this.currentMtu - 3 && writeType == WriteType.WITH_RESPONSE;
    }

    private boolean doesNotSupportWriteType(@NotNull BluetoothGattCharacteristic characteristic, @NotNull WriteType writeType) {
        return (characteristic.getProperties() & writeType.getProperty()) == 0;
    }

    public boolean readDescriptor(final @NotNull BluetoothGattDescriptor descriptor) {
        Objects.requireNonNull(descriptor, NO_VALID_DESCRIPTOR_PROVIDED);
        if (!this.isConnected()) {
            Timber.e((String)PERIPHERAL_NOT_CONNECTED, (Object[])new Object[0]);
            return false;
        }
        boolean result = this.commandQueue.add(new Runnable(){

            @Override
            public void run() {
                if (BluetoothPeripheral.this.isConnected()) {
                    if (!BluetoothPeripheral.this.bluetoothGatt.readDescriptor(descriptor)) {
                        Timber.e((String)"readDescriptor failed for characteristic: %s", (Object[])new Object[]{descriptor.getUuid()});
                        BluetoothPeripheral.this.completedCommand();
                    } else {
                        BluetoothPeripheral.this.nrTries++;
                    }
                } else {
                    BluetoothPeripheral.this.completedCommand();
                }
            }
        });
        if (result) {
            this.nextCommand();
        } else {
            Timber.e((String)"could not enqueue read descriptor command", (Object[])new Object[0]);
        }
        return result;
    }

    public boolean writeDescriptor(final @NotNull BluetoothGattDescriptor descriptor, @NotNull byte[] value) {
        Objects.requireNonNull(descriptor, NO_VALID_DESCRIPTOR_PROVIDED);
        Objects.requireNonNull(value, NO_VALID_VALUE_PROVIDED);
        if (!this.isConnected()) {
            Timber.e((String)PERIPHERAL_NOT_CONNECTED, (Object[])new Object[0]);
            return false;
        }
        if (value.length == 0) {
            throw new IllegalArgumentException(VALUE_BYTE_ARRAY_IS_EMPTY);
        }
        if (value.length > this.getMaximumWriteValueLength(WriteType.WITH_RESPONSE)) {
            throw new IllegalArgumentException(VALUE_BYTE_ARRAY_IS_TOO_LONG);
        }
        final byte[] bytesToWrite = this.copyOf(value);
        boolean result = this.commandQueue.add(new Runnable(){

            @Override
            public void run() {
                if (BluetoothPeripheral.this.isConnected()) {
                    BluetoothPeripheral.access$902(BluetoothPeripheral.this, bytesToWrite);
                    descriptor.setValue(bytesToWrite);
                    BluetoothPeripheral.this.adjustWriteTypeIfNeeded(descriptor);
                    if (!BluetoothPeripheral.this.bluetoothGatt.writeDescriptor(descriptor)) {
                        Timber.e((String)"writeDescriptor failed for descriptor: %s", (Object[])new Object[]{descriptor.getUuid()});
                        BluetoothPeripheral.this.completedCommand();
                    } else {
                        Timber.d((String)"writing <%s> to descriptor <%s>", (Object[])new Object[]{BluetoothBytesParser.bytes2String(bytesToWrite), descriptor.getUuid()});
                        BluetoothPeripheral.this.nrTries++;
                    }
                } else {
                    BluetoothPeripheral.this.completedCommand();
                }
            }
        });
        if (result) {
            this.nextCommand();
        } else {
            Timber.e((String)"could not enqueue write descriptor command", (Object[])new Object[0]);
        }
        return result;
    }

    public boolean setNotify(@NotNull UUID serviceUUID, @NotNull UUID characteristicUUID, boolean enable) {
        Objects.requireNonNull(serviceUUID, NO_VALID_SERVICE_UUID_PROVIDED);
        Objects.requireNonNull(characteristicUUID, NO_VALID_CHARACTERISTIC_UUID_PROVIDED);
        if (!this.isConnected()) {
            Timber.e((String)PERIPHERAL_NOT_CONNECTED, (Object[])new Object[0]);
            return false;
        }
        BluetoothGattCharacteristic characteristic = this.getCharacteristic(serviceUUID, characteristicUUID);
        if (characteristic != null) {
            return this.setNotify(characteristic, enable);
        }
        return false;
    }

    public boolean setNotify(final @NotNull BluetoothGattCharacteristic characteristic, final boolean enable) {
        byte[] value;
        Objects.requireNonNull(characteristic, NO_VALID_CHARACTERISTIC_PROVIDED);
        if (!this.isConnected()) {
            Timber.e((String)PERIPHERAL_NOT_CONNECTED, (Object[])new Object[0]);
            return false;
        }
        final BluetoothGattDescriptor descriptor = characteristic.getDescriptor(CCC_DESCRIPTOR_UUID);
        if (descriptor == null) {
            Timber.e((String)"could not get CCC descriptor for characteristic %s", (Object[])new Object[]{characteristic.getUuid()});
            return false;
        }
        int properties = characteristic.getProperties();
        if ((properties & 0x10) > 0) {
            value = BluetoothGattDescriptor.ENABLE_NOTIFICATION_VALUE;
        } else if ((properties & 0x20) > 0) {
            value = BluetoothGattDescriptor.ENABLE_INDICATION_VALUE;
        } else {
            Timber.e((String)"characteristic %s does not have notify or indicate property", (Object[])new Object[]{characteristic.getUuid()});
            return false;
        }
        final byte[] finalValue = enable ? value : BluetoothGattDescriptor.DISABLE_NOTIFICATION_VALUE;
        boolean result = this.commandQueue.add(new Runnable(){

            @Override
            public void run() {
                if (!BluetoothPeripheral.this.isConnected()) {
                    BluetoothPeripheral.this.completedCommand();
                    return;
                }
                if (!BluetoothPeripheral.this.bluetoothGatt.setCharacteristicNotification(characteristic, enable)) {
                    Timber.e((String)"setCharacteristicNotification failed for characteristic: %s", (Object[])new Object[]{characteristic.getUuid()});
                }
                BluetoothPeripheral.access$902(BluetoothPeripheral.this, finalValue);
                descriptor.setValue(finalValue);
                BluetoothPeripheral.this.adjustWriteTypeIfNeeded(descriptor);
                if (!BluetoothPeripheral.this.bluetoothGatt.writeDescriptor(descriptor)) {
                    Timber.e((String)"writeDescriptor failed for descriptor: %s", (Object[])new Object[]{descriptor.getUuid()});
                    BluetoothPeripheral.this.completedCommand();
                } else {
                    BluetoothPeripheral.this.nrTries++;
                }
            }
        });
        if (result) {
            this.nextCommand();
        } else {
            Timber.e((String)"could not enqueue setNotify command", (Object[])new Object[0]);
        }
        return result;
    }

    private void adjustWriteTypeIfNeeded(BluetoothGattDescriptor descriptor) {
        if (Build.VERSION.SDK_INT < 24) {
            BluetoothGattCharacteristic parentCharacteristic = descriptor.getCharacteristic();
            parentCharacteristic.setWriteType(2);
        }
    }

    public boolean readRemoteRssi() {
        if (!this.isConnected()) {
            Timber.e((String)PERIPHERAL_NOT_CONNECTED, (Object[])new Object[0]);
            return false;
        }
        boolean result = this.commandQueue.add(new Runnable(){

            @Override
            public void run() {
                if (BluetoothPeripheral.this.isConnected()) {
                    if (!BluetoothPeripheral.this.bluetoothGatt.readRemoteRssi()) {
                        Timber.e((String)"readRemoteRssi failed", (Object[])new Object[0]);
                        BluetoothPeripheral.this.completedCommand();
                    }
                } else {
                    Timber.e((String)"cannot get rssi, peripheral not connected", (Object[])new Object[0]);
                    BluetoothPeripheral.this.completedCommand();
                }
            }
        });
        if (result) {
            this.nextCommand();
        } else {
            Timber.e((String)"could not enqueue readRemoteRssi command", (Object[])new Object[0]);
        }
        return result;
    }

    public boolean requestMtu(final int mtu) {
        if (mtu < 23 || mtu > 517) {
            throw new IllegalArgumentException("mtu must be between 23 and 517");
        }
        if (!this.isConnected()) {
            Timber.e((String)PERIPHERAL_NOT_CONNECTED, (Object[])new Object[0]);
            return false;
        }
        boolean result = this.commandQueue.add(new Runnable(){

            @Override
            public void run() {
                if (BluetoothPeripheral.this.isConnected()) {
                    if (!BluetoothPeripheral.this.bluetoothGatt.requestMtu(mtu)) {
                        Timber.e((String)"requestMtu failed", (Object[])new Object[0]);
                        BluetoothPeripheral.this.completedCommand();
                    }
                } else {
                    Timber.e((String)"cannot request MTU, peripheral not connected", (Object[])new Object[0]);
                    BluetoothPeripheral.this.completedCommand();
                }
            }
        });
        if (result) {
            this.nextCommand();
        } else {
            Timber.e((String)"could not enqueue requestMtu command", (Object[])new Object[0]);
        }
        return result;
    }

    public boolean requestConnectionPriority(final int priority) {
        if (priority < 0 || priority > 2) {
            throw new IllegalArgumentException("connection priority not valid");
        }
        if (!this.isConnected()) {
            Timber.e((String)PERIPHERAL_NOT_CONNECTED, (Object[])new Object[0]);
            return false;
        }
        boolean result = this.commandQueue.add(new Runnable(){

            @Override
            public void run() {
                if (BluetoothPeripheral.this.isConnected()) {
                    if (!BluetoothPeripheral.this.bluetoothGatt.requestConnectionPriority(priority)) {
                        Timber.e((String)"could not request connection priority", (Object[])new Object[0]);
                    } else {
                        Timber.d((String)"requesting connection priority %d", (Object[])new Object[]{priority});
                    }
                    BluetoothPeripheral.this.completedCommand();
                }
            }
        });
        if (result) {
            this.nextCommand();
        } else {
            Timber.e((String)"could not enqueue request connection priority command", (Object[])new Object[0]);
        }
        return result;
    }

    public boolean setPreferredPhy(final PhyType txPhy, final PhyType rxPhy, final PhyOptions phyOptions) {
        if (!this.isConnected()) {
            Timber.e((String)PERIPHERAL_NOT_CONNECTED, (Object[])new Object[0]);
            return false;
        }
        if (Build.VERSION.SDK_INT < 26) {
            Timber.e((String)"setPreferredPhy requires Android 8.0 or newer", (Object[])new Object[0]);
            return false;
        }
        boolean result = this.commandQueue.add(new Runnable(){

            @Override
            public void run() {
                if (BluetoothPeripheral.this.isConnected() && Build.VERSION.SDK_INT >= 26) {
                    BluetoothPeripheral.this.bluetoothGatt.setPreferredPhy(txPhy.getMask(), rxPhy.getMask(), phyOptions.getValue());
                    Timber.i((String)"setting preferred Phy: tx = %s, rx = %s, options = %s", (Object[])new Object[]{txPhy, rxPhy, phyOptions});
                }
                BluetoothPeripheral.this.completedCommand();
            }
        });
        if (result) {
            this.nextCommand();
        } else {
            Timber.e((String)"could not enqueue setPreferredPhy command", (Object[])new Object[0]);
        }
        return result;
    }

    public boolean readPhy() {
        if (!this.isConnected()) {
            Timber.e((String)PERIPHERAL_NOT_CONNECTED, (Object[])new Object[0]);
            return false;
        }
        if (Build.VERSION.SDK_INT < 26) {
            Timber.e((String)"setPreferredPhy requires Android 8.0 or newer", (Object[])new Object[0]);
            return false;
        }
        boolean result = this.commandQueue.add(new Runnable(){

            @Override
            public void run() {
                if (BluetoothPeripheral.this.isConnected() && Build.VERSION.SDK_INT >= 26) {
                    BluetoothPeripheral.this.bluetoothGatt.readPhy();
                    Timber.d((String)"reading Phy", (Object[])new Object[0]);
                }
                BluetoothPeripheral.this.completedCommand();
            }
        });
        if (result) {
            this.nextCommand();
        } else {
            Timber.e((String)"could not enqueue readyPhy command", (Object[])new Object[0]);
        }
        return result;
    }

    public boolean clearServicesCache() {
        if (this.bluetoothGatt == null) {
            return false;
        }
        boolean result = false;
        try {
            Method refreshMethod = this.bluetoothGatt.getClass().getMethod("refresh", new Class[0]);
            if (refreshMethod != null) {
                result = (Boolean)refreshMethod.invoke((Object)this.bluetoothGatt, new Object[0]);
            }
        }
        catch (Exception e) {
            Timber.e((String)"could not invoke refresh method", (Object[])new Object[0]);
        }
        return result;
    }

    private void completedCommand() {
        this.isRetrying = false;
        this.commandQueue.poll();
        this.commandQueueBusy = false;
        this.nextCommand();
    }

    private void retryCommand() {
        this.commandQueueBusy = false;
        Runnable currentCommand = this.commandQueue.peek();
        if (currentCommand != null) {
            if (this.nrTries >= 2) {
                Timber.d((String)"max number of tries reached, not retrying operation anymore", (Object[])new Object[0]);
                this.commandQueue.poll();
            } else {
                this.isRetrying = true;
            }
        }
        this.nextCommand();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void nextCommand() {
        BluetoothPeripheral bluetoothPeripheral = this;
        synchronized (bluetoothPeripheral) {
            if (this.commandQueueBusy) {
                return;
            }
            final Runnable bluetoothCommand = this.commandQueue.peek();
            if (bluetoothCommand == null) {
                return;
            }
            if (this.bluetoothGatt == null) {
                Timber.e((String)"gatt is 'null' for peripheral '%s', clearing command queue", (Object[])new Object[]{this.getAddress()});
                this.commandQueue.clear();
                this.commandQueueBusy = false;
                return;
            }
            this.commandQueueBusy = true;
            if (!this.isRetrying) {
                this.nrTries = 0;
            }
            this.mainHandler.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        bluetoothCommand.run();
                    }
                    catch (Exception ex) {
                        Timber.e((Throwable)ex, (String)"command exception for device '%s'", (Object[])new Object[]{BluetoothPeripheral.this.getName()});
                        BluetoothPeripheral.this.completedCommand();
                    }
                }
            });
        }
    }

    private String bondStateToString(int state) {
        switch (state) {
            case 10: {
                return "BOND_NONE";
            }
            case 11: {
                return "BOND_BONDING";
            }
            case 12: {
                return "BOND_BONDED";
            }
        }
        return "UNKNOWN";
    }

    private String pairingVariantToString(int variant) {
        switch (variant) {
            case 0: {
                return "PAIRING_VARIANT_PIN";
            }
            case 1: {
                return "PAIRING_VARIANT_PASSKEY";
            }
            case 2: {
                return "PAIRING_VARIANT_PASSKEY_CONFIRMATION";
            }
            case 3: {
                return "PAIRING_VARIANT_CONSENT";
            }
            case 4: {
                return "PAIRING_VARIANT_DISPLAY_PASSKEY";
            }
            case 5: {
                return "PAIRING_VARIANT_DISPLAY_PIN";
            }
            case 6: {
                return "PAIRING_VARIANT_OOB_CONSENT";
            }
        }
        return "UNKNOWN";
    }

    private BluetoothGatt connectGattHelper(BluetoothDevice remoteDevice, boolean autoConnect, BluetoothGattCallback bluetoothGattCallback) {
        if (remoteDevice == null) {
            return null;
        }
        if (Build.VERSION.SDK_INT >= 24 || !autoConnect) {
            return this.connectGattCompat(bluetoothGattCallback, remoteDevice, autoConnect);
        }
        try {
            Object iBluetoothGatt = this.getIBluetoothGatt(this.getIBluetoothManager());
            if (iBluetoothGatt == null) {
                Timber.e((String)"could not get iBluetoothGatt object", (Object[])new Object[0]);
                return this.connectGattCompat(bluetoothGattCallback, remoteDevice, true);
            }
            BluetoothGatt bluetoothGatt = this.createBluetoothGatt(iBluetoothGatt, remoteDevice);
            if (bluetoothGatt == null) {
                Timber.e((String)"could not create BluetoothGatt object", (Object[])new Object[0]);
                return this.connectGattCompat(bluetoothGattCallback, remoteDevice, true);
            }
            boolean connectedSuccessfully = this.connectUsingReflection(remoteDevice, bluetoothGatt, bluetoothGattCallback, true);
            if (!connectedSuccessfully) {
                Timber.i((String)"connection using reflection failed, closing gatt", (Object[])new Object[0]);
                bluetoothGatt.close();
            }
            return bluetoothGatt;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException exception) {
            Timber.e((String)"error during reflection", (Object[])new Object[0]);
            return this.connectGattCompat(bluetoothGattCallback, remoteDevice, true);
        }
    }

    private BluetoothGatt connectGattCompat(BluetoothGattCallback bluetoothGattCallback, BluetoothDevice device, boolean autoConnect) {
        if (Build.VERSION.SDK_INT >= 23) {
            return device.connectGatt(this.context, autoConnect, bluetoothGattCallback, 2);
        }
        try {
            Method connectGattMethod = device.getClass().getMethod("connectGatt", Context.class, Boolean.TYPE, BluetoothGattCallback.class, Integer.TYPE);
            try {
                return (BluetoothGatt)connectGattMethod.invoke((Object)device, this.context, autoConnect, bluetoothGattCallback, 2);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        return device.connectGatt(this.context, autoConnect, bluetoothGattCallback);
    }

    private boolean connectUsingReflection(BluetoothDevice device, BluetoothGatt bluetoothGatt, BluetoothGattCallback bluetoothGattCallback, boolean autoConnect) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException, NoSuchFieldException {
        this.setAutoConnectValue(bluetoothGatt, autoConnect);
        Method connectMethod = bluetoothGatt.getClass().getDeclaredMethod("connect", Boolean.class, BluetoothGattCallback.class);
        connectMethod.setAccessible(true);
        return (Boolean)connectMethod.invoke((Object)bluetoothGatt, true, bluetoothGattCallback);
    }

    private BluetoothGatt createBluetoothGatt(Object iBluetoothGatt, BluetoothDevice remoteDevice) throws IllegalAccessException, InvocationTargetException, InstantiationException {
        Constructor<?> bluetoothGattConstructor = BluetoothGatt.class.getDeclaredConstructors()[0];
        bluetoothGattConstructor.setAccessible(true);
        if (bluetoothGattConstructor.getParameterTypes().length == 4) {
            return (BluetoothGatt)bluetoothGattConstructor.newInstance(this.context, iBluetoothGatt, remoteDevice, 2);
        }
        return (BluetoothGatt)bluetoothGattConstructor.newInstance(this.context, iBluetoothGatt, remoteDevice);
    }

    private Object getIBluetoothGatt(Object iBluetoothManager) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        if (iBluetoothManager == null) {
            return null;
        }
        Method getBluetoothGattMethod = this.getMethodFromClass(iBluetoothManager.getClass(), "getBluetoothGatt");
        return getBluetoothGattMethod.invoke(iBluetoothManager, new Object[0]);
    }

    private Object getIBluetoothManager() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        BluetoothAdapter bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        if (bluetoothAdapter == null) {
            return null;
        }
        Method getBluetoothManagerMethod = this.getMethodFromClass(bluetoothAdapter.getClass(), "getBluetoothManager");
        return getBluetoothManagerMethod.invoke((Object)bluetoothAdapter, new Object[0]);
    }

    private Method getMethodFromClass(Class<?> cls, String methodName) throws NoSuchMethodException {
        Method method = cls.getDeclaredMethod(methodName, new Class[0]);
        method.setAccessible(true);
        return method;
    }

    private void setAutoConnectValue(BluetoothGatt bluetoothGatt, boolean autoConnect) throws NoSuchFieldException, IllegalAccessException {
        Field autoConnectField = bluetoothGatt.getClass().getDeclaredField("mAutoConnect");
        autoConnectField.setAccessible(true);
        autoConnectField.setBoolean(bluetoothGatt, autoConnect);
    }

    private void startConnectionTimer(final BluetoothPeripheral peripheral) {
        this.cancelConnectionTimer();
        this.timeoutRunnable = new Runnable(){

            @Override
            public void run() {
                Timber.e((String)"connection timout, disconnecting '%s'", (Object[])new Object[]{peripheral.getName()});
                BluetoothPeripheral.this.disconnect();
                BluetoothPeripheral.this.mainHandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        BluetoothPeripheral.this.bluetoothGattCallback.onConnectionStateChange(BluetoothPeripheral.this.bluetoothGatt, HciStatus.CONNECTION_FAILED_ESTABLISHMENT.getValue(), 0);
                    }
                }, 50L);
                BluetoothPeripheral.this.timeoutRunnable = null;
            }
        };
        this.mainHandler.postDelayed(this.timeoutRunnable, 35000L);
    }

    private void cancelConnectionTimer() {
        if (this.timeoutRunnable != null) {
            this.mainHandler.removeCallbacks(this.timeoutRunnable);
            this.timeoutRunnable = null;
        }
    }

    private int getTimoutThreshold() {
        String manufacturer = Build.MANUFACTURER;
        if (manufacturer.equals("samsung")) {
            return 4500;
        }
        return 25000;
    }

    @NotNull
    byte[] copyOf(@Nullable byte[] source) {
        return source == null ? new byte[]{} : Arrays.copyOf(source, source.length);
    }

    @NotNull
    byte[] nonnullOf(@Nullable byte[] source) {
        return source == null ? new byte[]{} : source;
    }

    static /* synthetic */ byte[] access$902(BluetoothPeripheral x0, byte[] x1) {
        x0.currentWriteBytes = x1;
        return x1;
    }

    static interface InternalCallback {
        public void connected(@NotNull BluetoothPeripheral var1);

        public void connectFailed(@NotNull BluetoothPeripheral var1, HciStatus var2);

        public void disconnected(@NotNull BluetoothPeripheral var1, HciStatus var2);

        public String getPincode(@NotNull BluetoothPeripheral var1);
    }
}

