/*
 * Decompiled with CFR 0.152.
 */
package com.welie.blessed;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.le.BluetoothLeScanner;
import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanFilter;
import android.bluetooth.le.ScanResult;
import android.bluetooth.le.ScanSettings;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.ParcelUuid;
import com.welie.blessed.BluetoothCentralCallback;
import com.welie.blessed.BluetoothPeripheral;
import com.welie.blessed.BluetoothPeripheralCallback;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import timber.log.Timber;

public class BluetoothCentral {
    private static final long SCAN_TIMEOUT = 180000L;
    private static final int SCAN_RESTART_DELAY = 1000;
    private static final int MAX_CONNECTION_RETRIES = 1;
    private static final int MAX_CONNECTED_PERIPHERALS = 7;
    public static final int SCAN_FAILED_ALREADY_STARTED = 1;
    public static final int SCAN_FAILED_APPLICATION_REGISTRATION_FAILED = 2;
    public static final int SCAN_FAILED_INTERNAL_ERROR = 3;
    public static final int SCAN_FAILED_FEATURE_UNSUPPORTED = 4;
    public static final int SCAN_FAILED_OUT_OF_HARDWARE_RESOURCES = 5;
    public static final int SCAN_FAILED_SCANNING_TOO_FREQUENTLY = 6;
    private final Context context;
    private final Handler callBackHandler;
    private final BluetoothAdapter bluetoothAdapter;
    private BluetoothLeScanner bluetoothScanner;
    private BluetoothLeScanner autoConnectScanner;
    private final BluetoothCentralCallback bluetoothCentralCallback;
    private final Map<String, BluetoothPeripheral> connectedPeripherals = new ConcurrentHashMap<String, BluetoothPeripheral>();
    private final Map<String, BluetoothPeripheral> unconnectedPeripherals = new ConcurrentHashMap<String, BluetoothPeripheral>();
    private final List<String> reconnectPeripheralAddresses = new ArrayList<String>();
    private final Map<String, BluetoothPeripheralCallback> reconnectCallbacks = new ConcurrentHashMap<String, BluetoothPeripheralCallback>();
    private String[] scanPeripheralNames;
    private final Handler mainHandler = new Handler(Looper.getMainLooper());
    private Runnable timeoutRunnable;
    private Runnable autoConnectRunnable;
    private final Object connectLock = new Object();
    private ScanCallback currentCallback;
    private List<ScanFilter> currentFilters;
    private ScanSettings scanSettings;
    private final ScanSettings autoConnectScanSettings;
    private final Map<String, Integer> connectionRetries = new ConcurrentHashMap<String, Integer>();
    private boolean expectingBluetoothOffDisconnects = false;
    private Runnable disconnectRunnable;
    private final ScanCallback scanByNameCallback = new ScanCallback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onScanResult(int callbackType, final ScanResult result) {
            1 var3_3 = this;
            synchronized (var3_3) {
                String deviceName = result.getDevice().getName();
                if (deviceName == null) {
                    return;
                }
                for (String name : BluetoothCentral.this.scanPeripheralNames) {
                    if (!deviceName.contains(name)) continue;
                    BluetoothCentral.this.callBackHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            if (BluetoothCentral.this.isScanning()) {
                                BluetoothPeripheral peripheral = new BluetoothPeripheral(BluetoothCentral.this.context, result.getDevice(), BluetoothCentral.this.internalCallback, null, BluetoothCentral.this.callBackHandler);
                                BluetoothCentral.this.bluetoothCentralCallback.onDiscoveredPeripheral(peripheral, result);
                            }
                        }
                    });
                    return;
                }
            }
        }

        public void onScanFailed(final int errorCode) {
            Timber.e((String)"scan failed with error code %d (%s)", (Object[])new Object[]{errorCode, BluetoothCentral.this.scanErrorToString(errorCode)});
            BluetoothCentral.this.callBackHandler.post(new Runnable(){

                @Override
                public void run() {
                    BluetoothCentral.this.bluetoothCentralCallback.onScanFailed(errorCode);
                }
            });
        }
    };
    private final ScanCallback scanByServiceUUIDCallback = new ScanCallback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onScanResult(int callbackType, final ScanResult result) {
            2 var3_3 = this;
            synchronized (var3_3) {
                BluetoothCentral.this.callBackHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (BluetoothCentral.this.isScanning()) {
                            BluetoothPeripheral peripheral = new BluetoothPeripheral(BluetoothCentral.this.context, result.getDevice(), BluetoothCentral.this.internalCallback, null, BluetoothCentral.this.callBackHandler);
                            BluetoothCentral.this.bluetoothCentralCallback.onDiscoveredPeripheral(peripheral, result);
                        }
                    }
                });
            }
        }

        public void onScanFailed(final int errorCode) {
            Timber.e((String)"scan failed with error code %d (%s)", (Object[])new Object[]{errorCode, BluetoothCentral.this.scanErrorToString(errorCode)});
            BluetoothCentral.this.callBackHandler.post(new Runnable(){

                @Override
                public void run() {
                    BluetoothCentral.this.bluetoothCentralCallback.onScanFailed(errorCode);
                }
            });
        }
    };
    private final ScanCallback autoConnectScanCallback = new ScanCallback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onScanResult(int callbackType, ScanResult result) {
            3 var3_3 = this;
            synchronized (var3_3) {
                if (!BluetoothCentral.this.isAutoScanning()) {
                    return;
                }
                Timber.d((String)"peripheral with address '%s' found", (Object[])new Object[]{result.getDevice().getAddress()});
                BluetoothCentral.this.stopAutoconnectScan();
                String deviceAddress = result.getDevice().getAddress();
                BluetoothPeripheral peripheral = (BluetoothPeripheral)BluetoothCentral.this.unconnectedPeripherals.get(deviceAddress);
                BluetoothPeripheralCallback callback = (BluetoothPeripheralCallback)BluetoothCentral.this.reconnectCallbacks.get(deviceAddress);
                BluetoothCentral.this.reconnectPeripheralAddresses.remove(deviceAddress);
                BluetoothCentral.this.reconnectCallbacks.remove(deviceAddress);
                BluetoothCentral.this.unconnectedPeripherals.remove(deviceAddress);
                BluetoothCentral.this.connectPeripheral(peripheral, callback);
                if (BluetoothCentral.this.reconnectPeripheralAddresses.size() > 0) {
                    BluetoothCentral.this.scanForAutoConnectPeripherals();
                }
            }
        }

        public void onScanFailed(final int errorCode) {
            Timber.e((String)"scan failed with error code %d (%s)", (Object[])new Object[]{errorCode, BluetoothCentral.this.scanErrorToString(errorCode)});
            BluetoothCentral.this.callBackHandler.post(new Runnable(){

                @Override
                public void run() {
                    BluetoothCentral.this.bluetoothCentralCallback.onScanFailed(errorCode);
                }
            });
        }
    };
    private final BluetoothPeripheral.InternalCallback internalCallback = new BluetoothPeripheral.InternalCallback(){

        @Override
        public void connected(final BluetoothPeripheral peripheral) {
            BluetoothCentral.this.connectionRetries.remove(peripheral.getAddress());
            BluetoothCentral.this.unconnectedPeripherals.remove(peripheral.getAddress());
            BluetoothCentral.this.connectedPeripherals.put(peripheral.getAddress(), peripheral);
            if (BluetoothCentral.this.connectedPeripherals.size() == 7) {
                Timber.w((String)"maximum amount (%d) of connected peripherals reached", (Object[])new Object[]{7});
            }
            BluetoothCentral.this.callBackHandler.post(new Runnable(){

                @Override
                public void run() {
                    BluetoothCentral.this.bluetoothCentralCallback.onConnectedPeripheral(peripheral);
                }
            });
        }

        @Override
        public void connectFailed(final BluetoothPeripheral peripheral, final int status) {
            Integer retries;
            BluetoothCentral.this.unconnectedPeripherals.remove(peripheral.getAddress());
            int nrRetries = 0;
            if (BluetoothCentral.this.connectionRetries.get(peripheral.getAddress()) != null && (retries = (Integer)BluetoothCentral.this.connectionRetries.get(peripheral.getAddress())) != null) {
                nrRetries = retries;
            }
            if (nrRetries < 1 && status != 8) {
                Timber.i((String)"retrying connection to '%s' (%s)", (Object[])new Object[]{peripheral.getName(), peripheral.getAddress()});
                BluetoothCentral.this.connectionRetries.put(peripheral.getAddress(), ++nrRetries);
                BluetoothCentral.this.unconnectedPeripherals.put(peripheral.getAddress(), peripheral);
                peripheral.autoConnect();
            } else {
                Timber.i((String)"connection to '%s' (%s) failed", (Object[])new Object[]{peripheral.getName(), peripheral.getAddress()});
                BluetoothCentral.this.callBackHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        BluetoothCentral.this.bluetoothCentralCallback.onConnectionFailed(peripheral, status);
                    }
                });
            }
        }

        @Override
        public void disconnected(final BluetoothPeripheral peripheral, final int status) {
            if (BluetoothCentral.this.expectingBluetoothOffDisconnects) {
                BluetoothCentral.this.cancelDisconnectionTimer();
                BluetoothCentral.this.expectingBluetoothOffDisconnects = false;
            }
            BluetoothCentral.this.connectedPeripherals.remove(peripheral.getAddress());
            BluetoothCentral.this.unconnectedPeripherals.remove(peripheral.getAddress());
            BluetoothCentral.this.callBackHandler.post(new Runnable(){

                @Override
                public void run() {
                    BluetoothCentral.this.bluetoothCentralCallback.onDisconnectedPeripheral(peripheral, status);
                }
            });
        }
    };
    private final BroadcastReceiver adapterStateReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (action == null) {
                return;
            }
            if (action.equals("android.bluetooth.adapter.action.STATE_CHANGED")) {
                final int state = intent.getIntExtra("android.bluetooth.adapter.extra.STATE", Integer.MIN_VALUE);
                BluetoothCentral.this.callBackHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        BluetoothCentral.this.bluetoothCentralCallback.onBluetoothAdapterStateChanged(state);
                    }
                });
                BluetoothCentral.this.handleAdapterState(state);
            }
        }
    };

    public BluetoothCentral(Context context, BluetoothCentralCallback bluetoothCentralCallback, Handler handler) {
        if (context == null) {
            Timber.e((String)"context is 'null', cannot create BluetoothCentral", (Object[])new Object[0]);
        }
        if (bluetoothCentralCallback == null) {
            Timber.e((String)"callback is 'null', cannot create BluetoothCentral", (Object[])new Object[0]);
        }
        this.context = context;
        this.bluetoothCentralCallback = bluetoothCentralCallback;
        this.callBackHandler = handler != null ? handler : new Handler();
        this.bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        this.autoConnectScanSettings = Build.VERSION.SDK_INT >= 23 ? new ScanSettings.Builder().setScanMode(0).setCallbackType(1).setMatchMode(1).setNumOfMatches(1).setReportDelay(0L).build() : new ScanSettings.Builder().setScanMode(0).setReportDelay(0L).build();
        this.setScanMode(2);
        IntentFilter filter = new IntentFilter("android.bluetooth.adapter.action.STATE_CHANGED");
        if (context != null) {
            context.registerReceiver(this.adapterStateReceiver, filter);
        }
    }

    public void close() {
        this.unconnectedPeripherals.clear();
        this.connectedPeripherals.clear();
        this.reconnectCallbacks.clear();
        this.reconnectPeripheralAddresses.clear();
        if (this.context != null) {
            this.context.unregisterReceiver(this.adapterStateReceiver);
        }
    }

    public boolean setScanMode(int scanMode) {
        if (scanMode == 0 || scanMode == 2 || scanMode == 1 || scanMode == -1) {
            this.scanSettings = Build.VERSION.SDK_INT >= 23 ? new ScanSettings.Builder().setScanMode(scanMode).setCallbackType(1).setMatchMode(1).setNumOfMatches(1).setReportDelay(0L).build() : new ScanSettings.Builder().setScanMode(scanMode).setReportDelay(0L).build();
            return true;
        }
        return false;
    }

    private void startScan(List<ScanFilter> filters, ScanSettings scanSettings, ScanCallback scanCallback) {
        if (!this.isBleReady()) {
            return;
        }
        if (this.isScanning()) {
            Timber.e((String)"other scan still active, stopping scan", (Object[])new Object[0]);
            this.stopScan();
        }
        if (this.bluetoothScanner == null) {
            this.bluetoothScanner = this.bluetoothAdapter.getBluetoothLeScanner();
        }
        if (this.bluetoothScanner != null) {
            this.setScanTimer();
            this.currentCallback = scanCallback;
            this.currentFilters = filters;
            this.bluetoothScanner.startScan(filters, scanSettings, scanCallback);
            Timber.i((String)"scan started", (Object[])new Object[0]);
        } else {
            Timber.e((String)"starting scan failed", (Object[])new Object[0]);
        }
    }

    public void scanForPeripheralsWithServices(UUID[] serviceUUIDs) {
        this.currentFilters = null;
        if (serviceUUIDs != null) {
            this.currentFilters = new ArrayList<ScanFilter>();
            for (UUID serviceUUID : serviceUUIDs) {
                ScanFilter filter = new ScanFilter.Builder().setServiceUuid(new ParcelUuid(serviceUUID)).build();
                this.currentFilters.add(filter);
            }
        }
        this.startScan(this.currentFilters, this.scanSettings, this.scanByServiceUUIDCallback);
    }

    public void scanForPeripheralsWithNames(String[] peripheralNames) {
        this.scanPeripheralNames = peripheralNames;
        this.startScan(null, this.scanSettings, this.scanByNameCallback);
    }

    public void scanForPeripheralsWithAddresses(String[] peripheralAddresses) {
        ArrayList<ScanFilter> filters = null;
        if (peripheralAddresses != null) {
            filters = new ArrayList<ScanFilter>();
            for (String address : peripheralAddresses) {
                if (BluetoothAdapter.checkBluetoothAddress((String)address)) {
                    ScanFilter filter = new ScanFilter.Builder().setDeviceAddress(address).build();
                    filters.add(filter);
                    continue;
                }
                Timber.e((String)"%s is not a valid address. Make sure all alphabetic characters are uppercase.", (Object[])new Object[]{address});
            }
        }
        this.startScan(filters, this.scanSettings, this.scanByServiceUUIDCallback);
    }

    public void scanForPeripherals() {
        this.startScan(null, this.scanSettings, this.scanByServiceUUIDCallback);
    }

    private void scanForAutoConnectPeripherals() {
        if (!this.isBleReady()) {
            return;
        }
        if (this.autoConnectScanner != null) {
            this.stopAutoconnectScan();
        }
        this.autoConnectScanner = this.bluetoothAdapter.getBluetoothLeScanner();
        if (this.autoConnectScanner != null) {
            ArrayList<ScanFilter> filters = new ArrayList<ScanFilter>();
            for (String address : this.reconnectPeripheralAddresses) {
                ScanFilter filter = new ScanFilter.Builder().setDeviceAddress(address).build();
                filters.add(filter);
            }
            this.autoConnectScanner.startScan(filters, this.autoConnectScanSettings, this.autoConnectScanCallback);
            Timber.d((String)"started scanning for autoconnect", (Object[])new Object[0]);
            this.setAutoConnectTimer();
        } else {
            Timber.e((String)"starting autoconnect scan failed", (Object[])new Object[0]);
        }
    }

    private void stopAutoconnectScan() {
        this.cancelAutoConnectTimer();
        if (this.autoConnectScanner != null) {
            this.autoConnectScanner.stopScan(this.autoConnectScanCallback);
            this.autoConnectScanner = null;
            Timber.i((String)"autoscan stopped", (Object[])new Object[0]);
        }
    }

    private boolean isAutoScanning() {
        return this.autoConnectScanner != null;
    }

    public void stopScan() {
        this.cancelTimeoutTimer();
        if (this.isScanning()) {
            this.bluetoothScanner.stopScan(this.currentCallback);
            Timber.i((String)"scan stopped", (Object[])new Object[0]);
        } else {
            Timber.i((String)"no scan to stop because no scan is running", (Object[])new Object[0]);
        }
        this.currentCallback = null;
        this.currentFilters = null;
    }

    public boolean isScanning() {
        return this.bluetoothScanner != null && this.currentCallback != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectPeripheral(BluetoothPeripheral peripheral, BluetoothPeripheralCallback peripheralCallback) {
        Object object = this.connectLock;
        synchronized (object) {
            if (peripheral == null) {
                Timber.e((String)"no valid peripheral specified, aborting connection", (Object[])new Object[0]);
                return;
            }
            if (this.connectedPeripherals.containsKey(peripheral.getAddress())) {
                Timber.w((String)"already connected to %s'", (Object[])new Object[]{peripheral.getAddress()});
                return;
            }
            if (this.unconnectedPeripherals.containsKey(peripheral.getAddress())) {
                Timber.w((String)"already connecting to %s'", (Object[])new Object[]{peripheral.getAddress()});
                return;
            }
            int deviceType = peripheral.getType();
            if (deviceType == 0) {
                Timber.w((String)"peripheral with address '%s' is not in the Bluetooth cache, hence connection may fail", (Object[])new Object[]{peripheral.getAddress()});
            }
            peripheral.setPeripheralCallback(peripheralCallback);
            this.unconnectedPeripherals.put(peripheral.getAddress(), peripheral);
            peripheral.connect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void autoConnectPeripheral(BluetoothPeripheral peripheral, BluetoothPeripheralCallback peripheralCallback) {
        Object object = this.connectLock;
        synchronized (object) {
            if (peripheral == null) {
                Timber.e((String)"no valid peripheral specified, aborting connection", (Object[])new Object[0]);
                return;
            }
            if (this.connectedPeripherals.containsKey(peripheral.getAddress())) {
                Timber.w((String)"already connected to %s'", (Object[])new Object[]{peripheral.getAddress()});
                return;
            }
            if (this.unconnectedPeripherals.get(peripheral.getAddress()) != null) {
                Timber.w((String)"already issued autoconnect for '%s' ", (Object[])new Object[]{peripheral.getAddress()});
                return;
            }
            int deviceType = peripheral.getType();
            if (deviceType == 0) {
                Timber.d((String)"peripheral with address '%s' not in Bluetooth cache, autoconnecting by scanning", (Object[])new Object[]{peripheral.getAddress()});
                this.unconnectedPeripherals.put(peripheral.getAddress(), peripheral);
                this.autoConnectPeripheralByScan(peripheral.getAddress(), peripheralCallback);
                return;
            }
            if (deviceType != 2 && deviceType != 3) {
                Timber.e((String)"peripheral does not support Bluetooth LE", (Object[])new Object[0]);
                return;
            }
            peripheral.setPeripheralCallback(peripheralCallback);
            this.unconnectedPeripherals.put(peripheral.getAddress(), peripheral);
            peripheral.autoConnect();
        }
    }

    private void autoConnectPeripheralByScan(String peripheralAddress, BluetoothPeripheralCallback peripheralCallback) {
        if (this.reconnectPeripheralAddresses.contains(peripheralAddress)) {
            Timber.w((String)"peripheral already on list for reconnection", (Object[])new Object[0]);
            return;
        }
        this.reconnectPeripheralAddresses.add(peripheralAddress);
        this.reconnectCallbacks.put(peripheralAddress, peripheralCallback);
        this.scanForAutoConnectPeripherals();
    }

    public void cancelConnection(final BluetoothPeripheral peripheral) {
        if (peripheral == null) {
            Timber.e((String)"cannot cancel connection, peripheral is null", (Object[])new Object[0]);
            return;
        }
        String peripheralAddress = peripheral.getAddress();
        if (this.reconnectPeripheralAddresses.contains(peripheralAddress)) {
            this.reconnectPeripheralAddresses.remove(peripheralAddress);
            this.reconnectCallbacks.remove(peripheralAddress);
            this.stopAutoconnectScan();
            Timber.d((String)"cancelling autoconnect for %s", (Object[])new Object[]{peripheralAddress});
            if (this.reconnectPeripheralAddresses.size() > 0) {
                this.scanForAutoConnectPeripherals();
            }
            this.callBackHandler.post(new Runnable(){

                @Override
                public void run() {
                    BluetoothCentral.this.bluetoothCentralCallback.onDisconnectedPeripheral(peripheral, 0);
                }
            });
            return;
        }
        if (this.unconnectedPeripherals.containsKey(peripheralAddress)) {
            BluetoothPeripheral unconnectedPeripheral = this.unconnectedPeripherals.get(peripheralAddress);
            if (unconnectedPeripheral != null) {
                unconnectedPeripheral.cancelConnection();
            }
            return;
        }
        if (this.connectedPeripherals.containsKey(peripheralAddress)) {
            BluetoothPeripheral connectedPeripheral = this.connectedPeripherals.get(peripheralAddress);
            if (connectedPeripheral != null) {
                connectedPeripheral.cancelConnection();
            }
        } else {
            Timber.e((String)"cannot cancel connection to unknown peripheral %s", (Object[])new Object[]{peripheralAddress});
        }
    }

    public BluetoothPeripheral getPeripheral(String peripheralAddress) {
        if (!BluetoothAdapter.checkBluetoothAddress((String)peripheralAddress)) {
            Timber.e((String)"%s is not a valid address. Make sure all alphabetic characters are uppercase.", (Object[])new Object[]{peripheralAddress});
            return null;
        }
        if (this.connectedPeripherals.containsKey(peripheralAddress)) {
            return this.connectedPeripherals.get(peripheralAddress);
        }
        if (this.unconnectedPeripherals.containsKey(peripheralAddress)) {
            return this.unconnectedPeripherals.get(peripheralAddress);
        }
        return new BluetoothPeripheral(this.context, this.bluetoothAdapter.getRemoteDevice(peripheralAddress), this.internalCallback, null, this.callBackHandler);
    }

    public List<BluetoothPeripheral> getConnectedPeripherals() {
        return new ArrayList<BluetoothPeripheral>(this.connectedPeripherals.values());
    }

    private boolean isBleReady() {
        if (this.isBleSupported() && this.isBleEnabled()) {
            return this.permissionsGranted();
        }
        return false;
    }

    private boolean isBleSupported() {
        if (this.bluetoothAdapter != null && this.context.getPackageManager().hasSystemFeature("android.hardware.bluetooth_le")) {
            return true;
        }
        Timber.e((String)"BLE not supported", (Object[])new Object[0]);
        return false;
    }

    private boolean isBleEnabled() {
        if (this.bluetoothAdapter.isEnabled()) {
            return true;
        }
        Timber.e((String)"Bluetooth disabled", (Object[])new Object[0]);
        return false;
    }

    private boolean permissionsGranted() {
        int targetSdkVersion = this.context.getApplicationInfo().targetSdkVersion;
        if (Build.VERSION.SDK_INT >= 29 && targetSdkVersion >= 29) {
            if (this.context.checkSelfPermission("android.permission.ACCESS_FINE_LOCATION") != 0) {
                Timber.e((String)"no ACCESS_FINE_LOCATION permission, cannot scan", (Object[])new Object[0]);
                return false;
            }
            return true;
        }
        if (Build.VERSION.SDK_INT >= 23) {
            if (this.context.checkSelfPermission("android.permission.ACCESS_COARSE_LOCATION") != 0) {
                Timber.e((String)"no ACCESS_COARSE_LOCATION permission, cannot scan", (Object[])new Object[0]);
                return false;
            }
            return true;
        }
        return true;
    }

    private void setScanTimer() {
        this.cancelTimeoutTimer();
        this.timeoutRunnable = new Runnable(){

            @Override
            public void run() {
                Timber.d((String)"scanning timeout, restarting scan", (Object[])new Object[0]);
                final ScanCallback callback = BluetoothCentral.this.currentCallback;
                final List filters = BluetoothCentral.this.currentFilters;
                BluetoothCentral.this.stopScan();
                BluetoothCentral.this.callBackHandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        BluetoothCentral.this.startScan(filters, BluetoothCentral.this.scanSettings, callback);
                    }
                }, 1000L);
            }
        };
        this.mainHandler.postDelayed(this.timeoutRunnable, 180000L);
    }

    private void cancelTimeoutTimer() {
        if (this.timeoutRunnable != null) {
            this.mainHandler.removeCallbacks(this.timeoutRunnable);
            this.timeoutRunnable = null;
        }
    }

    private void setAutoConnectTimer() {
        this.cancelAutoConnectTimer();
        this.autoConnectRunnable = new Runnable(){

            @Override
            public void run() {
                Timber.d((String)"autoconnect scan timeout, restarting scan", (Object[])new Object[0]);
                if (BluetoothCentral.this.autoConnectScanner != null) {
                    BluetoothCentral.this.autoConnectScanner.stopScan(BluetoothCentral.this.autoConnectScanCallback);
                    BluetoothCentral.this.autoConnectScanner = null;
                }
                BluetoothCentral.this.mainHandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        BluetoothCentral.this.scanForAutoConnectPeripherals();
                    }
                }, 1000L);
            }
        };
        this.mainHandler.postDelayed(this.autoConnectRunnable, 180000L);
    }

    private void cancelAutoConnectTimer() {
        if (this.autoConnectRunnable != null) {
            this.mainHandler.removeCallbacks(this.autoConnectRunnable);
            this.autoConnectRunnable = null;
        }
    }

    public boolean removeBond(String peripheralAddress) {
        Object peripheralToUnBond = null;
        Set bondedDevices = this.bluetoothAdapter.getBondedDevices();
        if (bondedDevices.size() > 0) {
            for (BluetoothDevice device : bondedDevices) {
                if (!device.getAddress().equals(peripheralAddress)) continue;
                peripheralToUnBond = device;
            }
        } else {
            return true;
        }
        if (peripheralToUnBond != null) {
            try {
                Method method = peripheralToUnBond.getClass().getMethod("removeBond", null);
                boolean result = (Boolean)method.invoke(peripheralToUnBond, (Object[])null);
                if (result) {
                    Timber.i((String)"Succesfully removed bond for '%s'", (Object[])new Object[]{peripheralToUnBond.getName()});
                }
                return result;
            }
            catch (Exception e) {
                Timber.i((String)"could not remove bond", (Object[])new Object[0]);
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    public void startPairingPopupHack() {
        String manufacturer = Build.MANUFACTURER;
        if (!manufacturer.equals("samsung")) {
            this.bluetoothAdapter.startDiscovery();
            this.callBackHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    Timber.d((String)"popup hack completed", (Object[])new Object[0]);
                    BluetoothCentral.this.bluetoothAdapter.cancelDiscovery();
                }
            }, 1000L);
        }
    }

    private void cancelAllConnectionsWhenBluetoothOff() {
        Timber.d((String)"disconnect all peripherals because bluetooth is off", (Object[])new Object[0]);
        for (BluetoothPeripheral peripheral : this.connectedPeripherals.values()) {
            peripheral.disconnectWhenBluetoothOff();
        }
        this.connectedPeripherals.clear();
        for (BluetoothPeripheral peripheral : this.unconnectedPeripherals.values()) {
            peripheral.disconnectWhenBluetoothOff();
        }
        this.unconnectedPeripherals.clear();
        this.reconnectPeripheralAddresses.clear();
        this.reconnectCallbacks.clear();
    }

    private void startDisconnectionTimer() {
        this.cancelDisconnectionTimer();
        this.disconnectRunnable = new Runnable(){

            @Override
            public void run() {
                Timber.e((String)"bluetooth turned off but no automatic disconnects happening, so doing it ourselves", (Object[])new Object[0]);
                BluetoothCentral.this.cancelAllConnectionsWhenBluetoothOff();
                BluetoothCentral.this.disconnectRunnable = null;
            }
        };
        this.mainHandler.postDelayed(this.disconnectRunnable, 1000L);
    }

    private void cancelDisconnectionTimer() {
        if (this.disconnectRunnable != null) {
            this.mainHandler.removeCallbacks(this.disconnectRunnable);
            this.disconnectRunnable = null;
        }
    }

    private void handleAdapterState(int state) {
        switch (state) {
            case 10: {
                if (this.connectedPeripherals.size() > 0 || this.unconnectedPeripherals.size() > 0) {
                    this.expectingBluetoothOffDisconnects = true;
                    this.startDisconnectionTimer();
                }
                Timber.d((String)"bluetooth turned off", (Object[])new Object[0]);
                break;
            }
            case 13: {
                this.expectingBluetoothOffDisconnects = true;
                this.cancelTimeoutTimer();
                this.cancelAutoConnectTimer();
                this.currentCallback = null;
                this.currentFilters = null;
                this.autoConnectScanner = null;
                Timber.d((String)"bluetooth turning off", (Object[])new Object[0]);
                break;
            }
            case 12: {
                this.expectingBluetoothOffDisconnects = false;
                Timber.d((String)"bluetooth turned on", (Object[])new Object[0]);
                break;
            }
            case 11: {
                this.expectingBluetoothOffDisconnects = false;
                Timber.d((String)"bluetooth turning on", (Object[])new Object[0]);
            }
        }
    }

    private String scanErrorToString(int errorCode) {
        switch (errorCode) {
            case 1: {
                return "ALREADY STARTED";
            }
            case 2: {
                return "APPLICATION REGISTRATION FAILED";
            }
            case 3: {
                return "INTERNAL ERROR";
            }
            case 4: {
                return "FEATURE UNSUPPORTED";
            }
            case 5: {
                return "OUT OF HARDWARE RESOURCES";
            }
            case 6: {
                return "SCANNING TOO FREQUENTLY";
            }
        }
        return "UNKNOWN";
    }
}

