/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.util;

import java.awt.Color;

public final class ColorUtil {
    private ColorUtil() {
    }

    public static Color shift(Color c, double d) {
        return new Color(ColorUtil.shift(c.getRed(), d), ColorUtil.shift(c.getGreen(), d), ColorUtil.shift(c.getBlue(), d), c.getAlpha());
    }

    private static int shift(int colorComponent, double d) {
        int n = (int)((double)colorComponent * d);
        return n > 255 ? 255 : Math.max(n, 0);
    }

    public static Color toAlpha(Color color, double alpha) {
        return ColorUtil.toAlpha(color, (int)(alpha * 255.0));
    }

    public static Color toAlpha(Color color, int a) {
        Color c = color != null ? color : Color.black;
        return new Color(c.getRed(), c.getGreen(), c.getBlue(), Math.min(Math.max(0, a), 255));
    }

    public static Color fromHex(String str, Color defaultValue) {
        try {
            return ColorUtil.fromHex(str);
        }
        catch (Exception var3) {
            return defaultValue;
        }
    }

    public static String toHex(Color color) {
        if (color == null) {
            return "";
        }
        int r = color.getRed();
        int b = color.getBlue();
        int g = color.getGreen();
        return String.format("%02X%02X%02X", r, g, b);
    }

    public static Color fromHex(String str) {
        if (str.startsWith("#")) {
            str = str.substring(1);
        }
        if (str.length() == 3) {
            return new Color(17 * Integer.valueOf(String.valueOf(str.charAt(0)), 16), 17 * Integer.valueOf(String.valueOf(str.charAt(1)), 16), 17 * Integer.valueOf(String.valueOf(str.charAt(2)), 16));
        }
        if (str.length() == 6) {
            return Color.decode("0x" + str);
        }
        throw new IllegalArgumentException("Should be String of 3 or 6 chars length.");
    }

    public static Color removeAlpha(Color color) {
        return ColorUtil.toAlpha(color, 255);
    }
}

