/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.platform;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.ProviderNotFoundException;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class NativeUtil {
    public static final String NATIVE_FOLDER_PATH_PREFIX = "nativeutils";
    private static final int MIN_PREFIX_LENGTH = 3;
    private static Path temporaryDir;

    private NativeUtil() {
    }

    public static void loadLibraryFromJarWithExtraResources(String path, List<Resource> resources) throws IOException {
        List<Path> resourcePaths = NativeUtil.extractResources(resources);
        try {
            NativeUtil.loadLibraryFromJar(path);
        }
        finally {
            resourcePaths.forEach(NativeUtil::releaseResource);
        }
    }

    private static List<Path> extractResources(List<Resource> resources) throws IOException {
        ArrayList<Path> paths = new ArrayList<Path>(resources.size());
        Path tempDir = NativeUtil.getTemporaryDirectory();
        for (Resource resource : resources) {
            String filename = NativeUtil.getFileNameFromPath(resource.filePath);
            Path destinationDir = tempDir.resolve(resource.destinationDirectoryPath);
            Path destinationPath = destinationDir.resolve(Objects.requireNonNull(filename));
            try {
                Files.createDirectories(destinationDir, new FileAttribute[0]);
                NativeUtil.extractFile(resource.filePath, tempDir, destinationPath);
            }
            catch (IOException e) {
                paths.forEach(NativeUtil::delete);
                throw e;
            }
            paths.add(tempDir.resolve(Objects.requireNonNull(filename)));
        }
        return paths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadLibraryFromJar(String path) throws IOException {
        String filename = NativeUtil.getFileNameFromPath(path);
        if (filename == null || filename.length() < 3) {
            throw new IllegalArgumentException("The filename has to be at least 3 characters long.");
        }
        Path tempDir = NativeUtil.getTemporaryDirectory();
        Path temp = tempDir.resolve(filename);
        NativeUtil.extractFile(path, tempDir, temp);
        try {
            System.load(temp.toAbsolutePath().toString());
        }
        finally {
            NativeUtil.releaseResource(temp);
        }
    }

    private static void extractFile(String path, Path destinationDir, Path destinationPath) throws IOException {
        try (InputStream is = NativeUtil.class.getResourceAsStream(path);){
            if (is == null) {
                throw new FileNotFoundException("File " + path + " was not found inside JAR.");
            }
            if (!destinationDir.toFile().canWrite()) {
                throw new IOException("Can't write to temporary directory.");
            }
            Files.copy(is, destinationPath.toAbsolutePath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            NativeUtil.delete(destinationPath);
            throw e;
        }
    }

    private static String getFileNameFromPath(String path) {
        NativeUtil.checkPath(path);
        String[] parts = path.split("/");
        return parts.length > 1 ? parts[parts.length - 1] : null;
    }

    private static void checkPath(String path) {
        if (null == path || !path.startsWith("/")) {
            throw new IllegalArgumentException("The path has to be absolute (start with '/').");
        }
    }

    private static Path getTemporaryDirectory() throws IOException {
        if (temporaryDir == null) {
            temporaryDir = NativeUtil.createTempDirectory(NATIVE_FOLDER_PATH_PREFIX);
            temporaryDir.toFile().deleteOnExit();
        }
        return temporaryDir;
    }

    private static void releaseResource(Path path) {
        if (NativeUtil.isPosixCompliant()) {
            NativeUtil.delete(path);
        } else {
            path.toFile().deleteOnExit();
        }
    }

    private static void delete(Path path) {
        try {
            Files.deleteIfExists(path);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static Path createTempDirectory(String prefix) throws IOException {
        return Files.createTempDirectory(prefix + System.nanoTime(), new FileAttribute[0]);
    }

    private static boolean isPosixCompliant() {
        try {
            return FileSystems.getDefault().supportedFileAttributeViews().contains("posix");
        }
        catch (SecurityException | FileSystemNotFoundException | ProviderNotFoundException e) {
            return false;
        }
    }

    public static class Resource {
        public final String filePath;
        public final String destinationDirectoryPath;

        public Resource(String filePath, String destinationDirectoryPath) {
            this.filePath = filePath;
            this.destinationDirectoryPath = destinationDirectoryPath;
        }
    }
}

