/*
 * Decompiled with CFR 0.152.
 */
package cn.mrlong.basicframework.utils;

import android.content.Context;
import android.content.SharedPreferences;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class SharedPreferencesUtils {
    public static void clear(Context context, String filename) {
        SharedPreferences sp = context.getSharedPreferences(filename, 0);
        SharedPreferences.Editor editor = sp.edit();
        editor.clear();
        SharedPreferencesCompat.apply(editor);
    }

    public static String getString(Context context, String filename, String key, String defValue) {
        Object object = SharedPreferencesUtils.getObject(context, filename, key, defValue);
        if (object != null) {
            return (String)object;
        }
        return defValue;
    }

    public static int getInt(Context context, String filename, String key, int defValue) {
        Object object = SharedPreferencesUtils.getObject(context, filename, key, defValue);
        if (object != null) {
            return (Integer)object;
        }
        return defValue;
    }

    public static Boolean getBoolean(Context context, String filename, String key, Boolean defValue) {
        Object object = SharedPreferencesUtils.getObject(context, filename, key, defValue);
        if (object != null) {
            return (Boolean)object;
        }
        return defValue;
    }

    public static Object getObject(Context context, String filename, String key, Object defValue) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(filename, 0);
        if (defValue instanceof String || defValue == null) {
            return sharedPreferences.getString(key, (String)defValue);
        }
        if (defValue instanceof Boolean) {
            return sharedPreferences.getBoolean(key, ((Boolean)defValue).booleanValue());
        }
        if (defValue instanceof Integer) {
            return sharedPreferences.getInt(key, ((Integer)defValue).intValue());
        }
        return null;
    }

    public static void putObject(Context context, String filename, String key, Object defValue) {
        if (defValue == null) {
            defValue = "";
        }
        SharedPreferences sharedPreferences = context.getSharedPreferences(filename, 0);
        if (defValue instanceof String) {
            sharedPreferences.edit().putString(key, (String)defValue).commit();
        }
        if (defValue instanceof Boolean) {
            sharedPreferences.edit().putBoolean(key, ((Boolean)defValue).booleanValue()).commit();
        }
        if (defValue instanceof Integer) {
            sharedPreferences.edit().putInt(key, ((Integer)defValue).intValue()).commit();
        }
    }

    public static long getLong(Context context, String filename, String key, Long defValue) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(filename, 0);
        return sharedPreferences.getLong(key, defValue.longValue());
    }

    public static void putLong(Context context, String filename, String key, Long value) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(filename, 0);
        sharedPreferences.edit().putLong(key, value.longValue()).commit();
    }

    private static class SharedPreferencesCompat {
        private static final Method sApplyMethod = SharedPreferencesCompat.findApplyMethod();

        private SharedPreferencesCompat() {
        }

        private static Method findApplyMethod() {
            try {
                Class<SharedPreferences.Editor> clz = SharedPreferences.Editor.class;
                return clz.getMethod("apply", new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return null;
            }
        }

        public static void apply(SharedPreferences.Editor editor) {
            try {
                if (sApplyMethod != null) {
                    sApplyMethod.invoke((Object)editor, new Object[0]);
                    return;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
            editor.commit();
        }
    }
}

