/*
 * Decompiled with CFR 0.152.
 */
package cn.mrlong.basicframework.utils;

public class GPSUtil {
    public static double pi = Math.PI;
    public static double x_pi = 52.35987755982988;
    public static double a = 6378245.0;
    public static double ee = 0.006693421622965943;

    public static void main(String[] ages) {
        double[] d = GPSUtil.bd09_To_Gcj02(30.5526405517, 104.0729371656);
        System.out.println("\u7ecf\u7eac\u5ea6==>" + d[0] + "  " + d[1]);
    }

    public static double transformLat(double x2, double y) {
        double ret = -100.0 + 2.0 * x2 + 3.0 * y + 0.2 * y * y + 0.1 * x2 * y + 0.2 * Math.sqrt(Math.abs(x2));
        ret += (20.0 * Math.sin(6.0 * x2 * pi) + 20.0 * Math.sin(2.0 * x2 * pi)) * 2.0 / 3.0;
        ret += (20.0 * Math.sin(y * pi) + 40.0 * Math.sin(y / 3.0 * pi)) * 2.0 / 3.0;
        return ret += (160.0 * Math.sin(y / 12.0 * pi) + 320.0 * Math.sin(y * pi / 30.0)) * 2.0 / 3.0;
    }

    public static double transformLon(double x2, double y) {
        double ret = 300.0 + x2 + 2.0 * y + 0.1 * x2 * x2 + 0.1 * x2 * y + 0.1 * Math.sqrt(Math.abs(x2));
        ret += (20.0 * Math.sin(6.0 * x2 * pi) + 20.0 * Math.sin(2.0 * x2 * pi)) * 2.0 / 3.0;
        ret += (20.0 * Math.sin(x2 * pi) + 40.0 * Math.sin(x2 / 3.0 * pi)) * 2.0 / 3.0;
        return ret += (150.0 * Math.sin(x2 / 12.0 * pi) + 300.0 * Math.sin(x2 / 30.0 * pi)) * 2.0 / 3.0;
    }

    public static double[] transform(double lat, double lon) {
        if (GPSUtil.outOfChina(lat, lon)) {
            return new double[]{lat, lon};
        }
        double dLat = GPSUtil.transformLat(lon - 105.0, lat - 35.0);
        double dLon = GPSUtil.transformLon(lon - 105.0, lat - 35.0);
        double radLat = lat / 180.0 * pi;
        double magic = Math.sin(radLat);
        magic = 1.0 - ee * magic * magic;
        double sqrtMagic = Math.sqrt(magic);
        dLat = dLat * 180.0 / (a * (1.0 - ee) / (magic * sqrtMagic) * pi);
        dLon = dLon * 180.0 / (a / sqrtMagic * Math.cos(radLat) * pi);
        double mgLat = lat + dLat;
        double mgLon = lon + dLon;
        return new double[]{mgLat, mgLon};
    }

    public static boolean outOfChina(double lat, double lon) {
        if (lon < 72.004 || lon > 137.8347) {
            return true;
        }
        return lat < 0.8293 || lat > 55.8271;
    }

    public static double[] gps84_To_Gcj02(double lat, double lon) {
        if (GPSUtil.outOfChina(lat, lon)) {
            return new double[]{lat, lon};
        }
        double dLat = GPSUtil.transformLat(lon - 105.0, lat - 35.0);
        double dLon = GPSUtil.transformLon(lon - 105.0, lat - 35.0);
        double radLat = lat / 180.0 * pi;
        double magic = Math.sin(radLat);
        magic = 1.0 - ee * magic * magic;
        double sqrtMagic = Math.sqrt(magic);
        dLat = dLat * 180.0 / (a * (1.0 - ee) / (magic * sqrtMagic) * pi);
        dLon = dLon * 180.0 / (a / sqrtMagic * Math.cos(radLat) * pi);
        double mgLat = lat + dLat;
        double mgLon = lon + dLon;
        return new double[]{mgLat, mgLon};
    }

    public static double[] gcj02_To_Gps84(double lat, double lon) {
        double[] gps = GPSUtil.transform(lat, lon);
        double lontitude = lon * 2.0 - gps[1];
        double latitude = lat * 2.0 - gps[0];
        return new double[]{latitude, lontitude};
    }

    public static double[] gcj02_To_Bd09(double lat, double lon) {
        double x2 = lon;
        double y = lat;
        double z = Math.sqrt(x2 * x2 + y * y) + 2.0E-5 * Math.sin(y * x_pi);
        double theta = Math.atan2(y, x2) + 3.0E-6 * Math.cos(x2 * x_pi);
        double tempLon = z * Math.cos(theta) + 0.0065;
        double tempLat = z * Math.sin(theta) + 0.006;
        double[] gps = new double[]{tempLat, tempLon};
        return gps;
    }

    public static double[] bd09_To_Gcj02(double lat, double lon) {
        double x2 = lon - 0.0065;
        double y = lat - 0.006;
        double z = Math.sqrt(x2 * x2 + y * y) - 2.0E-5 * Math.sin(y * x_pi);
        double theta = Math.atan2(y, x2) - 3.0E-6 * Math.cos(x2 * x_pi);
        double tempLon = z * Math.cos(theta);
        double tempLat = z * Math.sin(theta);
        double[] gps = new double[]{tempLat, tempLon};
        return gps;
    }

    public static double[] gps84_To_bd09(double lat, double lon) {
        double[] gcj02 = GPSUtil.gps84_To_Gcj02(lat, lon);
        double[] bd09 = GPSUtil.gcj02_To_Bd09(gcj02[0], gcj02[1]);
        return bd09;
    }

    public static double[] bd09_To_gps84(double lat, double lon) {
        double[] gcj02 = GPSUtil.bd09_To_Gcj02(lat, lon);
        double[] gps84 = GPSUtil.gcj02_To_Gps84(gcj02[0], gcj02[1]);
        gps84[0] = GPSUtil.retain6(gps84[0]);
        gps84[1] = GPSUtil.retain6(gps84[1]);
        return gps84;
    }

    private static double retain6(double num) {
        String result = String.format("%.6f", num);
        return Double.valueOf(result);
    }
}

