/*
 * Decompiled with CFR 0.152.
 */
package cn.mrlong.basicframework.base;

import android.app.Activity;
import android.app.ActivityManager;
import android.content.Context;
import android.databinding.DataBindingUtil;
import android.databinding.ViewDataBinding;
import android.os.Build;
import android.os.Bundle;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.Toast;
import cn.mrlong.basicframework.base.ActivityManager;
import cn.mrlong.basicframework.base.Rx2Activity;
import cn.mrlong.basicframework.utils.AppUtils;
import com.orhanobut.logger.Logger;
import java.util.List;

public abstract class BaseAppCompatActivity<G extends ViewDataBinding>
extends Rx2Activity
implements View.OnClickListener {
    public boolean doubleKeyExit = false;
    public Context context;
    private long firstTime = 0L;
    private long secondTime = 0L;
    public static final int GONE = 8;
    public static final int VISIBLE = 0;
    public static final int INVISIBLE = 4;
    private Toast toast;
    public boolean isAlph = false;
    public boolean isTop = false;
    public View parentView;
    public int page = 0;
    public int pageSize = 10;
    public LayoutInflater inflater;
    public static BaseAppCompatActivity activity;
    public boolean isActive;
    public G viewBinding;
    public Bundle savedInstanceState;

    public abstract int setContentView();

    public abstract void initView();

    public abstract void initData();

    public abstract void initListener();

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.context = this;
        this.savedInstanceState = savedInstanceState;
        this.setRequestedOrientation(1);
        Logger.init((String)AppUtils.getAppName(this.context));
        activity = this;
        this.parentView = View.inflate((Context)this.context, (int)this.setContentView(), null);
        try {
            this.viewBinding = DataBindingUtil.bind((View)this.parentView);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!this.isTop) {
            this.parentView.setFitsSystemWindows(true);
        }
        this.setContentView(this.parentView);
        this.inflater = LayoutInflater.from((Context)this.context);
        ActivityManager.addActivity((Activity)this);
        this.setContentView();
        this.initView();
        this.initData();
        this.initListener();
    }

    public final void titleAlph() {
        if (Build.VERSION.SDK_INT >= 19) {
            this.setTranslucentStatus(true);
            if (!this.isAlph) {
                // empty if block
            }
        }
    }

    private void setTranslucentStatus(boolean on) {
        Window win = this.getWindow();
        WindowManager.LayoutParams winParams = win.getAttributes();
        int bits = 0x4000000;
        winParams.flags = on ? (winParams.flags |= 0x4000000) : (winParams.flags &= 0xFBFFFFFF);
        win.setAttributes(winParams);
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == 4 && this.doubleKeyExit) {
            if (this.firstTime == 0L) {
                this.firstTime = System.currentTimeMillis();
                this.showShortToast("\u518d\u6b21\u70b9\u51fb\u8fd4\u56de\u952e\u9000\u51fa\u5e94\u7528");
            } else {
                this.secondTime = System.currentTimeMillis();
                long interval = this.secondTime - this.firstTime;
                if (interval <= 2000L) {
                    ActivityManager.exitApplicaion();
                } else {
                    this.firstTime = 0L;
                    this.secondTime = 0L;
                }
            }
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    public final <T extends View> T findView(int id) {
        return (T)super.findViewById(id);
    }

    public void showShortToast(final String msg) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                try {
                    BaseAppCompatActivity.this.toast.cancel();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                BaseAppCompatActivity.this.toast = Toast.makeText((Context)BaseAppCompatActivity.this.context, (CharSequence)msg, (int)0);
                BaseAppCompatActivity.this.toast.show();
            }
        });
    }

    public void showLongToast(final String msg) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                try {
                    BaseAppCompatActivity.this.toast.cancel();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                BaseAppCompatActivity.this.toast = Toast.makeText((Context)BaseAppCompatActivity.this.context, (CharSequence)msg, (int)1);
                BaseAppCompatActivity.this.toast.show();
            }
        });
    }

    @Override
    protected void onPause() {
        if (this.toast != null) {
            try {
                this.toast.cancel();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        super.onPause();
    }

    public boolean isBackground() {
        android.app.ActivityManager activityManager = (android.app.ActivityManager)this.getApplicationContext().getSystemService("activity");
        String packageName = this.getApplicationContext().getPackageName();
        List appProcesses = activityManager.getRunningAppProcesses();
        if (appProcesses == null) {
            return false;
        }
        for (ActivityManager.RunningAppProcessInfo appProcess : appProcesses) {
            if (!appProcess.processName.equals(packageName) || appProcess.importance != 100) continue;
            return true;
        }
        return false;
    }
}

