/*
 * Decompiled with CFR 0.152.
 */
package jp.wasabeef.glide.transformations.gpu;

import android.graphics.PointF;
import androidx.annotation.NonNull;
import java.security.MessageDigest;
import jp.co.cyberagent.android.gpuimage.filter.GPUImageFilter;
import jp.co.cyberagent.android.gpuimage.filter.GPUImageSwirlFilter;
import jp.wasabeef.glide.transformations.gpu.GPUFilterTransformation;

public class SwirlFilterTransformation
extends GPUFilterTransformation {
    private static final int VERSION = 1;
    private static final String ID = "jp.wasabeef.glide.transformations.gpu.SwirlFilterTransformation.1";
    private float radius;
    private float angle;
    private PointF center;

    public SwirlFilterTransformation() {
        this(0.5f, 1.0f, new PointF(0.5f, 0.5f));
    }

    public SwirlFilterTransformation(float radius, float angle, PointF center) {
        super((GPUImageFilter)new GPUImageSwirlFilter());
        this.radius = radius;
        this.angle = angle;
        this.center = center;
        GPUImageSwirlFilter filter = (GPUImageSwirlFilter)this.getFilter();
        filter.setRadius(this.radius);
        filter.setAngle(this.angle);
        filter.setCenter(this.center);
    }

    @Override
    public String toString() {
        return "SwirlFilterTransformation(radius=" + this.radius + ",angle=" + this.angle + ",center=" + this.center.toString() + ")";
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof SwirlFilterTransformation && ((SwirlFilterTransformation)o).radius == this.radius && ((SwirlFilterTransformation)o).angle == this.radius && ((SwirlFilterTransformation)o).center.equals(this.center.x, this.center.y);
    }

    @Override
    public int hashCode() {
        return ID.hashCode() + (int)(this.radius * 1000.0f) + (int)(this.angle * 10.0f) + this.center.hashCode();
    }

    @Override
    public void updateDiskCacheKey(@NonNull MessageDigest messageDigest) {
        messageDigest.update((ID + this.radius + this.angle + this.center.hashCode()).getBytes(CHARSET));
    }
}

