/*
 * Decompiled with CFR 0.152.
 */
package com.warkiz.widget;

import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewParent;
import android.view.WindowManager;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import com.warkiz.widget.Builder;
import com.warkiz.widget.ColorCollector;
import com.warkiz.widget.Indicator;
import com.warkiz.widget.OnSeekChangeListener;
import com.warkiz.widget.R;
import com.warkiz.widget.SeekParams;
import com.warkiz.widget.SizeUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;

public class IndicatorSeekBar
extends View {
    private static final int THUMB_MAX_WIDTH = 30;
    private static final String FORMAT_PROGRESS = "${PROGRESS}";
    private static final String FORMAT_TICK_TEXT = "${TICK_TEXT}";
    private Context mContext;
    private Paint mStockPaint;
    private TextPaint mTextPaint;
    private OnSeekChangeListener mSeekChangeListener;
    private Rect mRect;
    private float mCustomDrawableMaxHeight;
    private float lastProgress;
    private float mFaultTolerance = -1.0f;
    private float mScreenWidth = -1.0f;
    private boolean mClearPadding;
    private SeekParams mSeekParams;
    private int mPaddingLeft;
    private int mPaddingRight;
    private int mMeasuredWidth;
    private int mPaddingTop;
    private float mSeekLength;
    private float mSeekBlockLength;
    private boolean mIsTouching;
    private float mMax;
    private float mMin;
    private float mProgress;
    private boolean mIsFloatProgress;
    private int mScale = 1;
    private boolean mUserSeekable;
    private boolean mOnlyThumbDraggable;
    private boolean mSeekSmoothly;
    private float[] mProgressArr;
    private boolean mR2L;
    private boolean mShowTickText;
    private int mTickTextsHeight;
    private String[] mTickTextsArr;
    private float[] mTickTextsWidth;
    private float[] mTextCenterX;
    private float mTickTextY;
    private int mTickTextsSize;
    private Typeface mTextsTypeface;
    private int mSelectedTextsColor;
    private int mUnselectedTextsColor;
    private int mHoveredTextColor;
    private CharSequence[] mTickTextsCustomArray;
    private Indicator mIndicator;
    private int mIndicatorColor;
    private int mIndicatorTextColor;
    private boolean mIndicatorStayAlways;
    private int mIndicatorTextSize;
    private View mIndicatorContentView;
    private View mIndicatorTopContentView;
    private int mShowIndicatorType;
    private String mIndicatorTextFormat;
    private float[] mTickMarksX;
    private int mTicksCount;
    private int mUnSelectedTickMarksColor;
    private int mSelectedTickMarksColor;
    private float mTickRadius;
    private Bitmap mUnselectTickMarksBitmap;
    private Bitmap mSelectTickMarksBitmap;
    private Drawable mTickMarksDrawable;
    private int mShowTickMarksType;
    private boolean mTickMarksEndsHide;
    private boolean mTickMarksSweptHide;
    private int mTickMarksSize;
    private boolean mTrackRoundedCorners;
    private RectF mProgressTrack;
    private RectF mBackgroundTrack;
    private int mBackgroundTrackSize;
    private int mProgressTrackSize;
    private int mBackgroundTrackColor;
    private int mProgressTrackColor;
    private int[] mSectionTrackColorArray;
    private boolean mCustomTrackSectionColorResult;
    private float mThumbRadius;
    private float mThumbTouchRadius;
    private Bitmap mThumbBitmap;
    private int mThumbColor;
    private int mThumbSize;
    private Drawable mThumbDrawable;
    private Bitmap mPressedThumbBitmap;
    private int mPressedThumbColor;
    private boolean mShowThumbText;
    private float mThumbTextY;
    private int mThumbTextColor;
    private boolean mHideThumb;

    public IndicatorSeekBar(Context context) {
        this(context, null);
    }

    public IndicatorSeekBar(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public IndicatorSeekBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
        this.initAttrs(this.mContext, attrs);
        this.initParams();
    }

    IndicatorSeekBar(Builder builder) {
        super(builder.context);
        this.mContext = builder.context;
        int defaultPadding = SizeUtils.dp2px(this.mContext, 16.0f);
        this.setPadding(defaultPadding, this.getPaddingTop(), defaultPadding, this.getPaddingBottom());
        this.apply(builder);
        this.initParams();
    }

    private void initAttrs(Context context, AttributeSet attrs) {
        int indicatorTopContentLayoutId;
        Builder builder = new Builder(context);
        if (attrs == null) {
            this.apply(builder);
            return;
        }
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.IndicatorSeekBar);
        this.mMax = ta.getFloat(R.styleable.IndicatorSeekBar_isb_max, builder.max);
        this.mMin = ta.getFloat(R.styleable.IndicatorSeekBar_isb_min, builder.min);
        this.mProgress = ta.getFloat(R.styleable.IndicatorSeekBar_isb_progress, builder.progress);
        this.mIsFloatProgress = ta.getBoolean(R.styleable.IndicatorSeekBar_isb_progress_value_float, builder.progressValueFloat);
        this.mUserSeekable = ta.getBoolean(R.styleable.IndicatorSeekBar_isb_user_seekable, builder.userSeekable);
        this.mClearPadding = ta.getBoolean(R.styleable.IndicatorSeekBar_isb_clear_default_padding, builder.clearPadding);
        this.mOnlyThumbDraggable = ta.getBoolean(R.styleable.IndicatorSeekBar_isb_only_thumb_draggable, builder.onlyThumbDraggable);
        this.mSeekSmoothly = ta.getBoolean(R.styleable.IndicatorSeekBar_isb_seek_smoothly, builder.seekSmoothly);
        this.mR2L = ta.getBoolean(R.styleable.IndicatorSeekBar_isb_r2l, builder.r2l);
        this.mBackgroundTrackSize = ta.getDimensionPixelSize(R.styleable.IndicatorSeekBar_isb_track_background_size, builder.trackBackgroundSize);
        this.mProgressTrackSize = ta.getDimensionPixelSize(R.styleable.IndicatorSeekBar_isb_track_progress_size, builder.trackProgressSize);
        this.mBackgroundTrackColor = ta.getColor(R.styleable.IndicatorSeekBar_isb_track_background_color, builder.trackBackgroundColor);
        this.mProgressTrackColor = ta.getColor(R.styleable.IndicatorSeekBar_isb_track_progress_color, builder.trackProgressColor);
        this.mTrackRoundedCorners = ta.getBoolean(R.styleable.IndicatorSeekBar_isb_track_rounded_corners, builder.trackRoundedCorners);
        this.mThumbSize = ta.getDimensionPixelSize(R.styleable.IndicatorSeekBar_isb_thumb_size, builder.thumbSize);
        this.mThumbDrawable = ta.getDrawable(R.styleable.IndicatorSeekBar_isb_thumb_drawable);
        this.initThumbColor(ta.getColorStateList(R.styleable.IndicatorSeekBar_isb_thumb_color), builder.thumbColor);
        this.mShowThumbText = ta.getBoolean(R.styleable.IndicatorSeekBar_isb_show_thumb_text, builder.showThumbText);
        this.mThumbTextColor = ta.getColor(R.styleable.IndicatorSeekBar_isb_thumb_text_color, builder.thumbTextColor);
        this.mTicksCount = ta.getInt(R.styleable.IndicatorSeekBar_isb_ticks_count, builder.tickCount);
        this.mShowTickMarksType = ta.getInt(R.styleable.IndicatorSeekBar_isb_show_tick_marks_type, builder.showTickMarksType);
        this.mTickMarksSize = ta.getDimensionPixelSize(R.styleable.IndicatorSeekBar_isb_tick_marks_size, builder.tickMarksSize);
        this.initTickMarksColor(ta.getColorStateList(R.styleable.IndicatorSeekBar_isb_tick_marks_color), builder.tickMarksColor);
        this.mTickMarksDrawable = ta.getDrawable(R.styleable.IndicatorSeekBar_isb_tick_marks_drawable);
        this.mTickMarksSweptHide = ta.getBoolean(R.styleable.IndicatorSeekBar_isb_tick_marks_swept_hide, builder.tickMarksSweptHide);
        this.mTickMarksEndsHide = ta.getBoolean(R.styleable.IndicatorSeekBar_isb_tick_marks_ends_hide, builder.tickMarksEndsHide);
        this.mShowTickText = ta.getBoolean(R.styleable.IndicatorSeekBar_isb_show_tick_texts, builder.showTickText);
        this.mTickTextsSize = ta.getDimensionPixelSize(R.styleable.IndicatorSeekBar_isb_tick_texts_size, builder.tickTextsSize);
        this.initTickTextsColor(ta.getColorStateList(R.styleable.IndicatorSeekBar_isb_tick_texts_color), builder.tickTextsColor);
        this.mTickTextsCustomArray = ta.getTextArray(R.styleable.IndicatorSeekBar_isb_tick_texts_array);
        this.initTextsTypeface(ta.getInt(R.styleable.IndicatorSeekBar_isb_tick_texts_typeface, -1), builder.tickTextsTypeFace);
        this.mShowIndicatorType = ta.getInt(R.styleable.IndicatorSeekBar_isb_show_indicator, builder.showIndicatorType);
        this.mIndicatorColor = ta.getColor(R.styleable.IndicatorSeekBar_isb_indicator_color, builder.indicatorColor);
        this.mIndicatorTextSize = ta.getDimensionPixelSize(R.styleable.IndicatorSeekBar_isb_indicator_text_size, builder.indicatorTextSize);
        this.mIndicatorTextColor = ta.getColor(R.styleable.IndicatorSeekBar_isb_indicator_text_color, builder.indicatorTextColor);
        int indicatorContentViewId = ta.getResourceId(R.styleable.IndicatorSeekBar_isb_indicator_content_layout, 0);
        if (indicatorContentViewId > 0) {
            this.mIndicatorContentView = View.inflate((Context)this.mContext, (int)indicatorContentViewId, null);
        }
        if ((indicatorTopContentLayoutId = ta.getResourceId(R.styleable.IndicatorSeekBar_isb_indicator_top_content_layout, 0)) > 0) {
            this.mIndicatorTopContentView = View.inflate((Context)this.mContext, (int)indicatorTopContentLayoutId, null);
        }
        ta.recycle();
    }

    private void initParams() {
        if (this.mTicksCount < 0 || this.mTicksCount > 50) {
            throw new IllegalArgumentException("the Argument: TICK COUNT must be limited between 0-50, Now is " + this.mTicksCount);
        }
        this.initProgressRangeValue();
        if (this.mBackgroundTrackSize > this.mProgressTrackSize) {
            this.mBackgroundTrackSize = this.mProgressTrackSize;
        }
        if (this.mThumbDrawable == null) {
            this.mThumbRadius = (float)this.mThumbSize / 2.0f;
            this.mThumbTouchRadius = this.mThumbRadius * 1.2f;
        } else {
            this.mThumbTouchRadius = this.mThumbRadius = (float)Math.min(SizeUtils.dp2px(this.mContext, 30.0f), this.mThumbSize) / 2.0f;
        }
        this.mTickRadius = this.mTickMarksDrawable == null ? (float)this.mTickMarksSize / 2.0f : (float)Math.min(SizeUtils.dp2px(this.mContext, 30.0f), this.mTickMarksSize) / 2.0f;
        this.mCustomDrawableMaxHeight = Math.max(this.mThumbTouchRadius, this.mTickRadius) * 2.0f;
        this.initStrokePaint();
        this.measureTickTextsBonds();
        this.lastProgress = this.mProgress;
        if (this.mTicksCount != 0) {
            this.mTickMarksX = new float[this.mTicksCount];
            if (this.mShowTickText) {
                this.mTextCenterX = new float[this.mTicksCount];
                this.mTickTextsWidth = new float[this.mTicksCount];
            }
            this.mProgressArr = new float[this.mTicksCount];
            for (int i = 0; i < this.mProgressArr.length; ++i) {
                this.mProgressArr[i] = this.mMin + (float)i * (this.mMax - this.mMin) / (float)(this.mTicksCount - 1 > 0 ? this.mTicksCount - 1 : 1);
            }
        }
        this.mProgressTrack = new RectF();
        this.mBackgroundTrack = new RectF();
        this.initDefaultPadding();
        this.initIndicatorContentView();
    }

    private void initDefaultPadding() {
        if (!this.mClearPadding) {
            int normalPadding = SizeUtils.dp2px(this.mContext, 16.0f);
            if (this.getPaddingLeft() == 0) {
                this.setPadding(normalPadding, this.getPaddingTop(), this.getPaddingRight(), this.getPaddingBottom());
            }
            if (this.getPaddingRight() == 0) {
                this.setPadding(this.getPaddingLeft(), this.getPaddingTop(), normalPadding, this.getPaddingBottom());
            }
        }
    }

    private void initProgressRangeValue() {
        if (this.mMax < this.mMin) {
            throw new IllegalArgumentException("the Argument: MAX's value must be larger than MIN's.");
        }
        if (this.mProgress < this.mMin) {
            this.mProgress = this.mMin;
        }
        if (this.mProgress > this.mMax) {
            this.mProgress = this.mMax;
        }
    }

    private void initStrokePaint() {
        if (this.mStockPaint == null) {
            this.mStockPaint = new Paint();
        }
        if (this.mTrackRoundedCorners) {
            this.mStockPaint.setStrokeCap(Paint.Cap.ROUND);
        }
        this.mStockPaint.setAntiAlias(true);
        if (this.mBackgroundTrackSize > this.mProgressTrackSize) {
            this.mProgressTrackSize = this.mBackgroundTrackSize;
        }
    }

    private void measureTickTextsBonds() {
        if (this.needDrawText()) {
            this.initTextPaint();
            this.mTextPaint.setTypeface(this.mTextsTypeface);
            this.mTextPaint.getTextBounds("j", 0, 1, this.mRect);
            this.mTickTextsHeight = this.mRect.height() + SizeUtils.dp2px(this.mContext, 3.0f);
        }
    }

    private boolean needDrawText() {
        return this.mShowThumbText || this.mTicksCount != 0 && this.mShowTickText;
    }

    private void initTextPaint() {
        if (this.mTextPaint == null) {
            this.mTextPaint = new TextPaint();
            this.mTextPaint.setAntiAlias(true);
            this.mTextPaint.setTextAlign(Paint.Align.CENTER);
            this.mTextPaint.setTextSize((float)this.mTickTextsSize);
        }
        if (this.mRect == null) {
            this.mRect = new Rect();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int height = Math.round(this.mCustomDrawableMaxHeight + (float)this.getPaddingTop() + (float)this.getPaddingBottom());
        this.setMeasuredDimension(IndicatorSeekBar.resolveSize((int)SizeUtils.dp2px(this.mContext, 170.0f), (int)widthMeasureSpec), height + this.mTickTextsHeight);
        this.initSeekBarInfo();
        this.refreshSeekBarLocation();
    }

    private void initSeekBarInfo() {
        this.mMeasuredWidth = this.getMeasuredWidth();
        if (Build.VERSION.SDK_INT < 17) {
            this.mPaddingLeft = this.getPaddingLeft();
            this.mPaddingRight = this.getPaddingRight();
        } else {
            this.mPaddingLeft = this.getPaddingStart();
            this.mPaddingRight = this.getPaddingEnd();
        }
        this.mPaddingTop = this.getPaddingTop();
        this.mSeekLength = this.mMeasuredWidth - this.mPaddingLeft - this.mPaddingRight;
        this.mSeekBlockLength = this.mSeekLength / (float)(this.mTicksCount - 1 > 0 ? this.mTicksCount - 1 : 1);
    }

    private void refreshSeekBarLocation() {
        this.initTrackLocation();
        if (this.needDrawText()) {
            this.mTextPaint.getTextBounds("j", 0, 1, this.mRect);
            this.mThumbTextY = this.mTickTextY = (float)this.mPaddingTop + this.mCustomDrawableMaxHeight + (float)Math.round((float)this.mRect.height() - this.mTextPaint.descent()) + (float)SizeUtils.dp2px(this.mContext, 3.0f);
        }
        if (this.mTickMarksX == null) {
            return;
        }
        this.initTextsArray();
        if (this.mTicksCount > 2) {
            this.lastProgress = this.mProgress = this.mProgressArr[this.getClosestIndex()];
        }
        this.refreshThumbCenterXByProgress(this.mProgress);
    }

    private void initTextsArray() {
        if (this.mTicksCount == 0) {
            return;
        }
        for (int i = 0; i < this.mTickMarksX.length; ++i) {
            if (this.mShowTickText) {
                if (this.mTickTextsArr == null) {
                    this.mTickTextsArr = new String[this.mTicksCount];
                }
                this.mTickTextsArr[i] = this.getTickTextByPosition(i);
                this.mTextPaint.getTextBounds(this.mTickTextsArr[i], 0, this.mTickTextsArr[i].length(), this.mRect);
                this.mTickTextsWidth[i] = this.mRect.width();
                this.mTextCenterX[i] = (float)this.mPaddingLeft + this.mSeekBlockLength * (float)i;
            }
            this.mTickMarksX[i] = (float)this.mPaddingLeft + this.mSeekBlockLength * (float)i;
        }
    }

    private void initTrackLocation() {
        if (this.mR2L) {
            this.mBackgroundTrack.left = this.mPaddingLeft;
            this.mBackgroundTrack.top = (float)this.mPaddingTop + this.mThumbTouchRadius;
            this.mBackgroundTrack.right = (float)this.mPaddingLeft + this.mSeekLength * (1.0f - (this.mProgress - this.mMin) / this.getAmplitude());
            this.mBackgroundTrack.bottom = this.mBackgroundTrack.top;
            this.mProgressTrack.left = this.mBackgroundTrack.right;
            this.mProgressTrack.top = this.mBackgroundTrack.top;
            this.mProgressTrack.right = this.mMeasuredWidth - this.mPaddingRight;
            this.mProgressTrack.bottom = this.mBackgroundTrack.bottom;
        } else {
            this.mProgressTrack.left = this.mPaddingLeft;
            this.mProgressTrack.top = (float)this.mPaddingTop + this.mThumbTouchRadius;
            this.mProgressTrack.right = (this.mProgress - this.mMin) * this.mSeekLength / this.getAmplitude() + (float)this.mPaddingLeft;
            this.mProgressTrack.bottom = this.mProgressTrack.top;
            this.mBackgroundTrack.left = this.mProgressTrack.right;
            this.mBackgroundTrack.top = this.mProgressTrack.bottom;
            this.mBackgroundTrack.right = this.mMeasuredWidth - this.mPaddingRight;
            this.mBackgroundTrack.bottom = this.mProgressTrack.bottom;
        }
    }

    private String getTickTextByPosition(int index) {
        if (this.mTickTextsCustomArray == null) {
            return this.getProgressString(this.mProgressArr[index]);
        }
        if (index < this.mTickTextsCustomArray.length) {
            return String.valueOf(this.mTickTextsCustomArray[index]);
        }
        return "";
    }

    private void refreshThumbCenterXByProgress(float progress) {
        if (this.mR2L) {
            this.mProgressTrack.left = this.mBackgroundTrack.right = (float)this.mPaddingLeft + this.mSeekLength * (1.0f - (progress - this.mMin) / this.getAmplitude());
        } else {
            this.mBackgroundTrack.left = this.mProgressTrack.right = (progress - this.mMin) * this.mSeekLength / this.getAmplitude() + (float)this.mPaddingLeft;
        }
    }

    protected synchronized void onDraw(Canvas canvas) {
        this.drawTrack(canvas);
        this.drawTickMarks(canvas);
        this.drawTickTexts(canvas);
        this.drawThumb(canvas);
        this.drawThumbText(canvas);
    }

    private void drawTrack(Canvas canvas) {
        if (this.mCustomTrackSectionColorResult) {
            int sectionSize = this.mTicksCount - 1 > 0 ? this.mTicksCount - 1 : 1;
            for (int i = 0; i < sectionSize; ++i) {
                if (this.mR2L) {
                    this.mStockPaint.setColor(this.mSectionTrackColorArray[sectionSize - i - 1]);
                } else {
                    this.mStockPaint.setColor(this.mSectionTrackColorArray[i]);
                }
                float thumbPosFloat = this.getThumbPosOnTickFloat();
                if ((float)i < thumbPosFloat && thumbPosFloat < (float)(i + 1)) {
                    float thumbCenterX = this.getThumbCenterX();
                    this.mStockPaint.setStrokeWidth((float)this.getLeftSideTrackSize());
                    canvas.drawLine(this.mTickMarksX[i], this.mProgressTrack.top, thumbCenterX, this.mProgressTrack.bottom, this.mStockPaint);
                    this.mStockPaint.setStrokeWidth((float)this.getRightSideTrackSize());
                    canvas.drawLine(thumbCenterX, this.mProgressTrack.top, this.mTickMarksX[i + 1], this.mProgressTrack.bottom, this.mStockPaint);
                    continue;
                }
                if ((float)i < thumbPosFloat) {
                    this.mStockPaint.setStrokeWidth((float)this.getLeftSideTrackSize());
                } else {
                    this.mStockPaint.setStrokeWidth((float)this.getRightSideTrackSize());
                }
                canvas.drawLine(this.mTickMarksX[i], this.mProgressTrack.top, this.mTickMarksX[i + 1], this.mProgressTrack.bottom, this.mStockPaint);
            }
        } else {
            this.mStockPaint.setColor(this.mProgressTrackColor);
            this.mStockPaint.setStrokeWidth((float)this.mProgressTrackSize);
            canvas.drawLine(this.mProgressTrack.left, this.mProgressTrack.top, this.mProgressTrack.right, this.mProgressTrack.bottom, this.mStockPaint);
            this.mStockPaint.setColor(this.mBackgroundTrackColor);
            this.mStockPaint.setStrokeWidth((float)this.mBackgroundTrackSize);
            canvas.drawLine(this.mBackgroundTrack.left, this.mBackgroundTrack.top, this.mBackgroundTrack.right, this.mBackgroundTrack.bottom, this.mStockPaint);
        }
    }

    private void drawTickMarks(Canvas canvas) {
        if (this.mTicksCount == 0 || this.mShowTickMarksType == 0 && this.mTickMarksDrawable == null) {
            return;
        }
        float thumbCenterX = this.getThumbCenterX();
        for (int i = 0; i < this.mTickMarksX.length; ++i) {
            float thumbPosFloat = this.getThumbPosOnTickFloat();
            if (this.mTickMarksSweptHide && thumbCenterX >= this.mTickMarksX[i] || this.mTickMarksEndsHide && (i == 0 || i == this.mTickMarksX.length - 1) || i == this.getThumbPosOnTick() && this.mTicksCount > 2 && !this.mSeekSmoothly) continue;
            if ((float)i <= thumbPosFloat) {
                this.mStockPaint.setColor(this.getLeftSideTickColor());
            } else {
                this.mStockPaint.setColor(this.getRightSideTickColor());
            }
            if (this.mTickMarksDrawable != null) {
                if (this.mSelectTickMarksBitmap == null || this.mUnselectTickMarksBitmap == null) {
                    this.initTickMarksBitmap();
                }
                if (this.mSelectTickMarksBitmap == null || this.mUnselectTickMarksBitmap == null) {
                    throw new IllegalArgumentException("the format of the selector TickMarks drawable is wrong!");
                }
                if ((float)i <= thumbPosFloat) {
                    canvas.drawBitmap(this.mSelectTickMarksBitmap, this.mTickMarksX[i] - (float)this.mUnselectTickMarksBitmap.getWidth() / 2.0f, this.mProgressTrack.top - (float)this.mUnselectTickMarksBitmap.getHeight() / 2.0f, this.mStockPaint);
                    continue;
                }
                canvas.drawBitmap(this.mUnselectTickMarksBitmap, this.mTickMarksX[i] - (float)this.mUnselectTickMarksBitmap.getWidth() / 2.0f, this.mProgressTrack.top - (float)this.mUnselectTickMarksBitmap.getHeight() / 2.0f, this.mStockPaint);
                continue;
            }
            if (this.mShowTickMarksType == 1) {
                canvas.drawCircle(this.mTickMarksX[i], this.mProgressTrack.top, this.mTickRadius, this.mStockPaint);
                continue;
            }
            if (this.mShowTickMarksType == 3) {
                int rectWidth = SizeUtils.dp2px(this.mContext, 1.0f);
                float dividerTickHeight = thumbCenterX >= this.mTickMarksX[i] ? (float)this.getLeftSideTrackSize() : (float)this.getRightSideTrackSize();
                canvas.drawRect(this.mTickMarksX[i] - (float)rectWidth, this.mProgressTrack.top - dividerTickHeight / 2.0f, this.mTickMarksX[i] + (float)rectWidth, this.mProgressTrack.top + dividerTickHeight / 2.0f, this.mStockPaint);
                continue;
            }
            if (this.mShowTickMarksType != 2) continue;
            canvas.drawRect(this.mTickMarksX[i] - (float)this.mTickMarksSize / 2.0f, this.mProgressTrack.top - (float)this.mTickMarksSize / 2.0f, this.mTickMarksX[i] + (float)this.mTickMarksSize / 2.0f, this.mProgressTrack.top + (float)this.mTickMarksSize / 2.0f, this.mStockPaint);
        }
    }

    private void drawTickTexts(Canvas canvas) {
        if (this.mTickTextsArr == null) {
            return;
        }
        float thumbPosFloat = this.getThumbPosOnTickFloat();
        for (int i = 0; i < this.mTickTextsArr.length; ++i) {
            if (i == this.getThumbPosOnTick() && (float)i == thumbPosFloat) {
                this.mTextPaint.setColor(this.mHoveredTextColor);
            } else if ((float)i < thumbPosFloat) {
                this.mTextPaint.setColor(this.getLeftSideTickTextsColor());
            } else {
                this.mTextPaint.setColor(this.getRightSideTickTextsColor());
            }
            int index = i;
            if (this.mR2L) {
                index = this.mTickTextsArr.length - i - 1;
            }
            if (i == 0) {
                canvas.drawText(this.mTickTextsArr[index], this.mTextCenterX[i] + this.mTickTextsWidth[index] / 2.0f, this.mTickTextY, (Paint)this.mTextPaint);
                continue;
            }
            if (i == this.mTickTextsArr.length - 1) {
                canvas.drawText(this.mTickTextsArr[index], this.mTextCenterX[i] - this.mTickTextsWidth[index] / 2.0f, this.mTickTextY, (Paint)this.mTextPaint);
                continue;
            }
            canvas.drawText(this.mTickTextsArr[index], this.mTextCenterX[i], this.mTickTextY, (Paint)this.mTextPaint);
        }
    }

    private void drawThumb(Canvas canvas) {
        if (this.mHideThumb) {
            return;
        }
        float thumbCenterX = this.getThumbCenterX();
        if (this.mThumbDrawable != null) {
            if (this.mThumbBitmap == null || this.mPressedThumbBitmap == null) {
                this.initThumbBitmap();
            }
            if (this.mThumbBitmap == null || this.mPressedThumbBitmap == null) {
                throw new IllegalArgumentException("the format of the selector thumb drawable is wrong!");
            }
            this.mStockPaint.setAlpha(255);
            if (this.mIsTouching) {
                canvas.drawBitmap(this.mPressedThumbBitmap, thumbCenterX - (float)this.mPressedThumbBitmap.getWidth() / 2.0f, this.mProgressTrack.top - (float)this.mPressedThumbBitmap.getHeight() / 2.0f, this.mStockPaint);
            } else {
                canvas.drawBitmap(this.mThumbBitmap, thumbCenterX - (float)this.mThumbBitmap.getWidth() / 2.0f, this.mProgressTrack.top - (float)this.mThumbBitmap.getHeight() / 2.0f, this.mStockPaint);
            }
        } else {
            if (this.mIsTouching) {
                this.mStockPaint.setColor(this.mPressedThumbColor);
            } else {
                this.mStockPaint.setColor(this.mThumbColor);
            }
            canvas.drawCircle(thumbCenterX, this.mProgressTrack.top, this.mIsTouching ? this.mThumbTouchRadius : this.mThumbRadius, this.mStockPaint);
        }
    }

    private void drawThumbText(Canvas canvas) {
        if (!this.mShowThumbText || this.mShowTickText && this.mTicksCount > 2) {
            return;
        }
        this.mTextPaint.setColor(this.mThumbTextColor);
        canvas.drawText(this.getProgressString(this.mProgress), this.getThumbCenterX(), this.mThumbTextY, (Paint)this.mTextPaint);
    }

    private float getThumbCenterX() {
        if (this.mR2L) {
            return this.mBackgroundTrack.right;
        }
        return this.mProgressTrack.right;
    }

    private int getLeftSideTickColor() {
        if (this.mR2L) {
            return this.mUnSelectedTickMarksColor;
        }
        return this.mSelectedTickMarksColor;
    }

    private int getRightSideTickColor() {
        if (this.mR2L) {
            return this.mSelectedTickMarksColor;
        }
        return this.mUnSelectedTickMarksColor;
    }

    private int getLeftSideTickTextsColor() {
        if (this.mR2L) {
            return this.mUnselectedTextsColor;
        }
        return this.mSelectedTextsColor;
    }

    private int getRightSideTickTextsColor() {
        if (this.mR2L) {
            return this.mSelectedTextsColor;
        }
        return this.mUnselectedTextsColor;
    }

    private int getLeftSideTrackSize() {
        if (this.mR2L) {
            return this.mBackgroundTrackSize;
        }
        return this.mProgressTrackSize;
    }

    private int getRightSideTrackSize() {
        if (this.mR2L) {
            return this.mProgressTrackSize;
        }
        return this.mBackgroundTrackSize;
    }

    private int getThumbPosOnTick() {
        if (this.mTicksCount != 0) {
            return Math.round((this.getThumbCenterX() - (float)this.mPaddingLeft) / this.mSeekBlockLength);
        }
        return 0;
    }

    private float getThumbPosOnTickFloat() {
        if (this.mTicksCount != 0) {
            return (this.getThumbCenterX() - (float)this.mPaddingLeft) / this.mSeekBlockLength;
        }
        return 0.0f;
    }

    private int getHeightByRatio(Drawable drawable2, int width) {
        int intrinsicWidth = drawable2.getIntrinsicWidth();
        int intrinsicHeight = drawable2.getIntrinsicHeight();
        return Math.round(1.0f * (float)width * (float)intrinsicHeight / (float)intrinsicWidth);
    }

    private Bitmap getDrawBitmap(Drawable drawable2, boolean isThumb) {
        int height;
        int width;
        if (drawable2 == null) {
            return null;
        }
        int maxRange = SizeUtils.dp2px(this.mContext, 30.0f);
        int intrinsicWidth = drawable2.getIntrinsicWidth();
        if (intrinsicWidth > maxRange) {
            width = isThumb ? this.mThumbSize : this.mTickMarksSize;
            height = this.getHeightByRatio(drawable2, width);
            if (width > maxRange) {
                width = maxRange;
                height = this.getHeightByRatio(drawable2, width);
            }
        } else {
            width = drawable2.getIntrinsicWidth();
            height = drawable2.getIntrinsicHeight();
        }
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        drawable2.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        drawable2.draw(canvas);
        return bitmap;
    }

    private void initThumbColor(ColorStateList colorStateList, int defaultColor) {
        if (colorStateList == null) {
            this.mPressedThumbColor = this.mThumbColor = defaultColor;
            return;
        }
        int[][] states = null;
        int[] colors = null;
        Class<?> aClass = colorStateList.getClass();
        try {
            Field[] f;
            for (Field field : f = aClass.getDeclaredFields()) {
                field.setAccessible(true);
                if ("mStateSpecs".equals(field.getName())) {
                    states = (int[][])field.get(colorStateList);
                }
                if (!"mColors".equals(field.getName())) continue;
                colors = (int[])field.get(colorStateList);
            }
            if (states == null || colors == null) {
                return;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Something wrong happened when parseing thumb selector color.");
        }
        if (states.length == 1) {
            this.mPressedThumbColor = this.mThumbColor = colors[0];
        } else if (states.length == 2) {
            block6: for (int i = 0; i < states.length; ++i) {
                int[] attr2 = states[i];
                if (attr2.length == 0) {
                    this.mPressedThumbColor = colors[i];
                    continue;
                }
                switch (attr2[0]) {
                    case 16842919: {
                        this.mThumbColor = colors[i];
                        continue block6;
                    }
                    default: {
                        throw new IllegalArgumentException("the selector color file you set for the argument: isb_thumb_color is in wrong format.");
                    }
                }
            }
        } else {
            throw new IllegalArgumentException("the selector color file you set for the argument: isb_thumb_color is in wrong format.");
        }
    }

    private void initTickMarksColor(ColorStateList colorStateList, int defaultColor) {
        if (colorStateList == null) {
            this.mUnSelectedTickMarksColor = this.mSelectedTickMarksColor = defaultColor;
            return;
        }
        int[][] states = null;
        int[] colors = null;
        Class<?> aClass = colorStateList.getClass();
        try {
            Field[] f;
            for (Field field : f = aClass.getDeclaredFields()) {
                field.setAccessible(true);
                if ("mStateSpecs".equals(field.getName())) {
                    states = (int[][])field.get(colorStateList);
                }
                if (!"mColors".equals(field.getName())) continue;
                colors = (int[])field.get(colorStateList);
            }
            if (states == null || colors == null) {
                return;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Something wrong happened when parsing thumb selector color." + e.getMessage());
        }
        if (states.length == 1) {
            this.mUnSelectedTickMarksColor = this.mSelectedTickMarksColor = colors[0];
        } else if (states.length == 2) {
            block6: for (int i = 0; i < states.length; ++i) {
                int[] attr2 = states[i];
                if (attr2.length == 0) {
                    this.mUnSelectedTickMarksColor = colors[i];
                    continue;
                }
                switch (attr2[0]) {
                    case 0x10100A1: {
                        this.mSelectedTickMarksColor = colors[i];
                        continue block6;
                    }
                    default: {
                        throw new IllegalArgumentException("the selector color file you set for the argument: isb_tick_marks_color is in wrong format.");
                    }
                }
            }
        } else {
            throw new IllegalArgumentException("the selector color file you set for the argument: isb_tick_marks_color is in wrong format.");
        }
    }

    private void initTickTextsColor(ColorStateList colorStateList, int defaultColor) {
        if (colorStateList == null) {
            this.mSelectedTextsColor = this.mUnselectedTextsColor = defaultColor;
            this.mHoveredTextColor = this.mUnselectedTextsColor;
            return;
        }
        int[][] states = null;
        int[] colors = null;
        Class<?> aClass = colorStateList.getClass();
        try {
            Field[] f;
            for (Field field : f = aClass.getDeclaredFields()) {
                field.setAccessible(true);
                if ("mStateSpecs".equals(field.getName())) {
                    states = (int[][])field.get(colorStateList);
                }
                if (!"mColors".equals(field.getName())) continue;
                colors = (int[])field.get(colorStateList);
            }
            if (states == null || colors == null) {
                return;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Something wrong happened when parseing thumb selector color.");
        }
        if (states.length == 1) {
            this.mSelectedTextsColor = this.mUnselectedTextsColor = colors[0];
            this.mHoveredTextColor = this.mUnselectedTextsColor;
        } else if (states.length == 3) {
            block7: for (int i = 0; i < states.length; ++i) {
                int[] attr2 = states[i];
                if (attr2.length == 0) {
                    this.mUnselectedTextsColor = colors[i];
                    continue;
                }
                switch (attr2[0]) {
                    case 0x10100A1: {
                        this.mSelectedTextsColor = colors[i];
                        continue block7;
                    }
                    case 16843623: {
                        this.mHoveredTextColor = colors[i];
                        continue block7;
                    }
                    default: {
                        throw new IllegalArgumentException("the selector color file you set for the argument: isb_tick_texts_color is in wrong format.");
                    }
                }
            }
        } else {
            throw new IllegalArgumentException("the selector color file you set for the argument: isb_tick_texts_color is in wrong format.");
        }
    }

    private void initTextsTypeface(int typeface, Typeface defaultTypeface) {
        switch (typeface) {
            case 0: {
                this.mTextsTypeface = Typeface.DEFAULT;
                break;
            }
            case 1: {
                this.mTextsTypeface = Typeface.MONOSPACE;
                break;
            }
            case 2: {
                this.mTextsTypeface = Typeface.SANS_SERIF;
                break;
            }
            case 3: {
                this.mTextsTypeface = Typeface.SERIF;
                break;
            }
            default: {
                this.mTextsTypeface = defaultTypeface == null ? Typeface.DEFAULT : defaultTypeface;
            }
        }
    }

    private void initThumbBitmap() {
        block10: {
            if (this.mThumbDrawable == null) {
                return;
            }
            if (this.mThumbDrawable instanceof BitmapDrawable) {
                this.mPressedThumbBitmap = this.mThumbBitmap = this.getDrawBitmap(this.mThumbDrawable, true);
            } else {
                if (this.mThumbDrawable instanceof StateListDrawable) {
                    try {
                        StateListDrawable listDrawable = (StateListDrawable)this.mThumbDrawable;
                        Class<?> aClass = listDrawable.getClass();
                        int stateCount = (Integer)aClass.getMethod("getStateCount", new Class[0]).invoke((Object)listDrawable, new Object[0]);
                        if (stateCount == 2) {
                            Method getStateSet = aClass.getMethod("getStateSet", Integer.TYPE);
                            Method getStateDrawable = aClass.getMethod("getStateDrawable", Integer.TYPE);
                            for (int i = 0; i < stateCount; ++i) {
                                Drawable stateDrawable;
                                int[] stateSet = (int[])getStateSet.invoke((Object)listDrawable, i);
                                if (stateSet.length > 0) {
                                    if (stateSet[0] == 16842919) {
                                        stateDrawable = (Drawable)getStateDrawable.invoke((Object)listDrawable, i);
                                        this.mPressedThumbBitmap = this.getDrawBitmap(stateDrawable, true);
                                        continue;
                                    }
                                    throw new IllegalArgumentException("the state of the selector thumb drawable is wrong!");
                                }
                                stateDrawable = (Drawable)getStateDrawable.invoke((Object)listDrawable, i);
                                this.mThumbBitmap = this.getDrawBitmap(stateDrawable, true);
                            }
                            break block10;
                        }
                        throw new IllegalArgumentException("the format of the selector thumb drawable is wrong!");
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Something wrong happened when parsing thumb selector drawable." + e.getMessage());
                    }
                }
                throw new IllegalArgumentException("Nonsupport this drawable's type for custom thumb drawable!");
            }
        }
    }

    private void initTickMarksBitmap() {
        block9: {
            if (this.mTickMarksDrawable instanceof BitmapDrawable) {
                this.mSelectTickMarksBitmap = this.mUnselectTickMarksBitmap = this.getDrawBitmap(this.mTickMarksDrawable, false);
            } else {
                if (this.mTickMarksDrawable instanceof StateListDrawable) {
                    StateListDrawable listDrawable = (StateListDrawable)this.mTickMarksDrawable;
                    try {
                        Class<?> aClass = listDrawable.getClass();
                        Method getStateCount = aClass.getMethod("getStateCount", new Class[0]);
                        int stateCount = (Integer)getStateCount.invoke((Object)listDrawable, new Object[0]);
                        if (stateCount == 2) {
                            Method getStateSet = aClass.getMethod("getStateSet", Integer.TYPE);
                            Method getStateDrawable = aClass.getMethod("getStateDrawable", Integer.TYPE);
                            for (int i = 0; i < stateCount; ++i) {
                                Drawable stateDrawable;
                                int[] stateSet = (int[])getStateSet.invoke((Object)listDrawable, i);
                                if (stateSet.length > 0) {
                                    if (stateSet[0] == 0x10100A1) {
                                        stateDrawable = (Drawable)getStateDrawable.invoke((Object)listDrawable, i);
                                        this.mSelectTickMarksBitmap = this.getDrawBitmap(stateDrawable, false);
                                        continue;
                                    }
                                    throw new IllegalArgumentException("the state of the selector TickMarks drawable is wrong!");
                                }
                                stateDrawable = (Drawable)getStateDrawable.invoke((Object)listDrawable, i);
                                this.mUnselectTickMarksBitmap = this.getDrawBitmap(stateDrawable, false);
                            }
                            break block9;
                        }
                        throw new IllegalArgumentException("the format of the selector TickMarks drawable is wrong!");
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Something wrong happened when parsing TickMarks selector drawable." + e.getMessage());
                    }
                }
                throw new IllegalArgumentException("Nonsupport this drawable's type for custom TickMarks drawable!");
            }
        }
    }

    public void setEnabled(boolean enabled) {
        if (enabled == this.isEnabled()) {
            return;
        }
        super.setEnabled(enabled);
        if (this.isEnabled()) {
            this.setAlpha(1.0f);
            if (this.mIndicatorStayAlways) {
                this.mIndicatorContentView.setAlpha(1.0f);
            }
        } else {
            this.setAlpha(0.3f);
            if (this.mIndicatorStayAlways) {
                this.mIndicatorContentView.setAlpha(0.3f);
            }
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.post(new Runnable(){

            @Override
            public void run() {
                IndicatorSeekBar.this.requestLayout();
            }
        });
    }

    public boolean dispatchTouchEvent(MotionEvent event) {
        ViewParent parent = this.getParent();
        if (parent == null) {
            return super.dispatchTouchEvent(event);
        }
        switch (event.getAction()) {
            case 0: {
                parent.requestDisallowInterceptTouchEvent(true);
                break;
            }
            case 1: 
            case 3: {
                parent.requestDisallowInterceptTouchEvent(false);
            }
        }
        return super.dispatchTouchEvent(event);
    }

    public boolean performClick() {
        return super.performClick();
    }

    protected Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable("isb_instance_state", super.onSaveInstanceState());
        bundle.putFloat("isb_progress", this.mProgress);
        return bundle;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (state instanceof Bundle) {
            Bundle bundle = (Bundle)state;
            this.setProgress(bundle.getFloat("isb_progress"));
            super.onRestoreInstanceState(bundle.getParcelable("isb_instance_state"));
            return;
        }
        super.onRestoreInstanceState(state);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.mUserSeekable || !this.isEnabled()) {
            return false;
        }
        switch (event.getAction()) {
            case 0: {
                this.performClick();
                float mX = event.getX();
                if (!this.isTouchSeekBar(mX, event.getY())) break;
                if (this.mOnlyThumbDraggable && !this.isTouchThumb(mX)) {
                    return false;
                }
                this.mIsTouching = true;
                if (this.mSeekChangeListener != null) {
                    this.mSeekChangeListener.onStartTrackingTouch(this);
                }
                this.refreshSeekBar(event);
                return true;
            }
            case 2: {
                this.refreshSeekBar(event);
                break;
            }
            case 1: 
            case 3: {
                this.mIsTouching = false;
                if (this.mSeekChangeListener != null) {
                    this.mSeekChangeListener.onStopTrackingTouch(this);
                }
                if (!this.autoAdjustThumb()) {
                    this.invalidate();
                }
                if (this.mIndicator == null) break;
                this.mIndicator.hide();
            }
        }
        return super.onTouchEvent(event);
    }

    private void refreshSeekBar(MotionEvent event) {
        this.refreshThumbCenterXByProgress(this.calculateProgress(this.calculateTouchX(this.adjustTouchX(event))));
        this.setSeekListener(true);
        this.invalidate();
        this.updateIndicator();
    }

    private boolean progressChange() {
        if (this.mIsFloatProgress) {
            return this.lastProgress != this.mProgress;
        }
        return Math.round(this.lastProgress) != Math.round(this.mProgress);
    }

    private float adjustTouchX(MotionEvent event) {
        float mTouchXCache = event.getX() < (float)this.mPaddingLeft ? (float)this.mPaddingLeft : (event.getX() > (float)(this.mMeasuredWidth - this.mPaddingRight) ? (float)(this.mMeasuredWidth - this.mPaddingRight) : event.getX());
        return mTouchXCache;
    }

    private float calculateProgress(float touchX) {
        this.lastProgress = this.mProgress;
        this.mProgress = this.mMin + this.getAmplitude() * (touchX - (float)this.mPaddingLeft) / this.mSeekLength;
        return this.mProgress;
    }

    private float calculateTouchX(float touchX) {
        float touchXTemp = touchX;
        if (this.mTicksCount > 2 && !this.mSeekSmoothly) {
            int touchBlockSize = Math.round((touchX - (float)this.mPaddingLeft) / this.mSeekBlockLength);
            touchXTemp = this.mSeekBlockLength * (float)touchBlockSize + (float)this.mPaddingLeft;
        }
        if (this.mR2L) {
            return this.mSeekLength - touchXTemp + (float)(2 * this.mPaddingLeft);
        }
        return touchXTemp;
    }

    private boolean isTouchSeekBar(float mX, float mY) {
        if (this.mFaultTolerance == -1.0f) {
            this.mFaultTolerance = SizeUtils.dp2px(this.mContext, 5.0f);
        }
        boolean inWidthRange = mX >= (float)this.mPaddingLeft - 2.0f * this.mFaultTolerance && mX <= (float)(this.mMeasuredWidth - this.mPaddingRight) + 2.0f * this.mFaultTolerance;
        boolean inHeightRange = mY >= this.mProgressTrack.top - this.mThumbTouchRadius - this.mFaultTolerance && mY <= this.mProgressTrack.top + this.mThumbTouchRadius + this.mFaultTolerance;
        return inWidthRange && inHeightRange;
    }

    private boolean isTouchThumb(float mX) {
        this.refreshThumbCenterXByProgress(this.mProgress);
        float rawTouchX = this.mR2L ? this.mBackgroundTrack.right : this.mProgressTrack.right;
        return rawTouchX - (float)this.mThumbSize / 2.0f <= mX && mX <= rawTouchX + (float)this.mThumbSize / 2.0f;
    }

    private void updateIndicator() {
        if (this.mIndicatorStayAlways) {
            this.updateStayIndicator();
        } else {
            if (this.mIndicator == null) {
                return;
            }
            this.mIndicator.iniPop();
            if (this.mIndicator.isShowing()) {
                this.mIndicator.update(this.getThumbCenterX());
            } else {
                this.mIndicator.show(this.getThumbCenterX());
            }
        }
    }

    private void initIndicatorContentView() {
        if (this.mShowIndicatorType == 0) {
            return;
        }
        if (this.mIndicator == null) {
            this.mIndicator = new Indicator(this.mContext, this, this.mIndicatorColor, this.mShowIndicatorType, this.mIndicatorTextSize, this.mIndicatorTextColor, this.mIndicatorContentView, this.mIndicatorTopContentView);
            this.mIndicatorContentView = this.mIndicator.getInsideContentView();
        }
    }

    private void updateStayIndicator() {
        int arrowOffset;
        int indicatorOffset;
        if (!this.mIndicatorStayAlways || this.mIndicator == null) {
            return;
        }
        this.mIndicator.setProgressTextView(this.getIndicatorTextString());
        this.mIndicatorContentView.measure(0, 0);
        int measuredWidth = this.mIndicatorContentView.getMeasuredWidth();
        float thumbCenterX = this.getThumbCenterX();
        if (this.mScreenWidth == -1.0f) {
            DisplayMetrics metric = new DisplayMetrics();
            WindowManager systemService = (WindowManager)this.mContext.getSystemService("window");
            if (systemService != null) {
                systemService.getDefaultDisplay().getMetrics(metric);
                this.mScreenWidth = metric.widthPixels;
            }
        }
        if ((float)(measuredWidth / 2) + thumbCenterX > (float)this.mMeasuredWidth) {
            indicatorOffset = this.mMeasuredWidth - measuredWidth;
            arrowOffset = (int)(thumbCenterX - (float)indicatorOffset - (float)(measuredWidth / 2));
        } else if (thumbCenterX - (float)(measuredWidth / 2) < 0.0f) {
            indicatorOffset = 0;
            arrowOffset = -((int)((float)(measuredWidth / 2) - thumbCenterX));
        } else {
            indicatorOffset = (int)(this.getThumbCenterX() - (float)(measuredWidth / 2));
            arrowOffset = 0;
        }
        this.mIndicator.updateIndicatorLocation(indicatorOffset);
        this.mIndicator.updateArrowViewLocation(arrowOffset);
    }

    private boolean autoAdjustThumb() {
        if (this.mTicksCount < 3 || !this.mSeekSmoothly) {
            return false;
        }
        final int closestIndex = this.getClosestIndex();
        final float touchUpProgress = this.mProgress;
        ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{0.0f, Math.abs(touchUpProgress - this.mProgressArr[closestIndex])});
        animator.start();
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                IndicatorSeekBar.this.lastProgress = IndicatorSeekBar.this.mProgress;
                if (touchUpProgress - IndicatorSeekBar.this.mProgressArr[closestIndex] > 0.0f) {
                    IndicatorSeekBar.this.mProgress = touchUpProgress - ((Float)animation.getAnimatedValue()).floatValue();
                } else {
                    IndicatorSeekBar.this.mProgress = touchUpProgress + ((Float)animation.getAnimatedValue()).floatValue();
                }
                IndicatorSeekBar.this.refreshThumbCenterXByProgress(IndicatorSeekBar.this.mProgress);
                IndicatorSeekBar.this.setSeekListener(false);
                if (IndicatorSeekBar.this.mIndicator != null && IndicatorSeekBar.this.mIndicatorStayAlways) {
                    IndicatorSeekBar.this.mIndicator.refreshProgressText();
                    IndicatorSeekBar.this.updateStayIndicator();
                }
                IndicatorSeekBar.this.invalidate();
            }
        });
        return true;
    }

    private String getProgressString(float progress) {
        String progressString = this.mIsFloatProgress ? String.valueOf(BigDecimal.valueOf(progress).setScale(this.mScale, 4).floatValue()) : String.valueOf(Math.round(progress));
        return progressString;
    }

    private int getClosestIndex() {
        int closestIndex = 0;
        float amplitude = Math.abs(this.mMax - this.mMin);
        for (int i = 0; i < this.mProgressArr.length; ++i) {
            float amplitudeTemp = Math.abs(this.mProgressArr[i] - this.mProgress);
            if (!(amplitudeTemp <= amplitude)) continue;
            amplitude = amplitudeTemp;
            closestIndex = i;
        }
        return closestIndex;
    }

    private float getAmplitude() {
        return this.mMax - this.mMin > 0.0f ? this.mMax - this.mMin : 1.0f;
    }

    private void setSeekListener(boolean formUser) {
        if (this.mSeekChangeListener == null) {
            return;
        }
        if (this.progressChange()) {
            this.mSeekChangeListener.onSeeking(this.collectParams(formUser));
        }
    }

    private SeekParams collectParams(boolean formUser) {
        if (this.mSeekParams == null) {
            this.mSeekParams = new SeekParams(this);
        }
        this.mSeekParams.progress = this.getProgress();
        this.mSeekParams.progressFloat = this.getProgressFloat();
        this.mSeekParams.fromUser = formUser;
        if (this.mTicksCount > 2) {
            int rawThumbPos = this.getThumbPosOnTick();
            if (this.mShowTickText && this.mTickTextsArr != null) {
                this.mSeekParams.tickText = this.mTickTextsArr[rawThumbPos];
            }
            this.mSeekParams.thumbPosition = this.mR2L ? this.mTicksCount - rawThumbPos - 1 : rawThumbPos;
        }
        return this.mSeekParams;
    }

    private void apply(Builder builder) {
        this.mMax = builder.max;
        this.mMin = builder.min;
        this.mProgress = builder.progress;
        this.mIsFloatProgress = builder.progressValueFloat;
        this.mTicksCount = builder.tickCount;
        this.mSeekSmoothly = builder.seekSmoothly;
        this.mR2L = builder.r2l;
        this.mUserSeekable = builder.userSeekable;
        this.mClearPadding = builder.clearPadding;
        this.mOnlyThumbDraggable = builder.onlyThumbDraggable;
        this.mShowIndicatorType = builder.showIndicatorType;
        this.mIndicatorColor = builder.indicatorColor;
        this.mIndicatorTextColor = builder.indicatorTextColor;
        this.mIndicatorTextSize = builder.indicatorTextSize;
        this.mIndicatorContentView = builder.indicatorContentView;
        this.mIndicatorTopContentView = builder.indicatorTopContentView;
        this.mBackgroundTrackSize = builder.trackBackgroundSize;
        this.mBackgroundTrackColor = builder.trackBackgroundColor;
        this.mProgressTrackSize = builder.trackProgressSize;
        this.mProgressTrackColor = builder.trackProgressColor;
        this.mTrackRoundedCorners = builder.trackRoundedCorners;
        this.mThumbSize = builder.thumbSize;
        this.mThumbDrawable = builder.thumbDrawable;
        this.mThumbTextColor = builder.thumbTextColor;
        this.initThumbColor(builder.thumbColorStateList, builder.thumbColor);
        this.mShowThumbText = builder.showThumbText;
        this.mShowTickMarksType = builder.showTickMarksType;
        this.mTickMarksSize = builder.tickMarksSize;
        this.mTickMarksDrawable = builder.tickMarksDrawable;
        this.mTickMarksEndsHide = builder.tickMarksEndsHide;
        this.mTickMarksSweptHide = builder.tickMarksSweptHide;
        this.initTickMarksColor(builder.tickMarksColorStateList, builder.tickMarksColor);
        this.mShowTickText = builder.showTickText;
        this.mTickTextsSize = builder.tickTextsSize;
        this.mTickTextsCustomArray = builder.tickTextsCustomArray;
        this.mTextsTypeface = builder.tickTextsTypeFace;
        this.initTickTextsColor(builder.tickTextsColorStateList, builder.tickTextsColor);
    }

    void showStayIndicator() {
        this.mIndicatorContentView.setVisibility(4);
        this.postDelayed(new Runnable(){

            @Override
            public void run() {
                AlphaAnimation animation = new AlphaAnimation(0.1f, 1.0f);
                animation.setDuration(180L);
                IndicatorSeekBar.this.mIndicatorContentView.setAnimation((Animation)animation);
                IndicatorSeekBar.this.updateStayIndicator();
                IndicatorSeekBar.this.mIndicatorContentView.setVisibility(0);
            }
        }, 300L);
    }

    void setIndicatorStayAlways(boolean indicatorStayAlways) {
        this.mIndicatorStayAlways = indicatorStayAlways;
    }

    View getIndicatorContentView() {
        return this.mIndicatorContentView;
    }

    String getIndicatorTextString() {
        if (this.mIndicatorTextFormat != null && this.mIndicatorTextFormat.contains(FORMAT_TICK_TEXT)) {
            if (this.mTicksCount > 2 && this.mTickTextsArr != null) {
                return this.mIndicatorTextFormat.replace(FORMAT_TICK_TEXT, this.mTickTextsArr[this.getThumbPosOnTick()]);
            }
        } else if (this.mIndicatorTextFormat != null && this.mIndicatorTextFormat.contains(FORMAT_PROGRESS)) {
            return this.mIndicatorTextFormat.replace(FORMAT_PROGRESS, this.getProgressString(this.mProgress));
        }
        return this.getProgressString(this.mProgress);
    }

    public static Builder with(@NonNull Context context) {
        return new Builder(context);
    }

    public Indicator getIndicator() {
        return this.mIndicator;
    }

    public int getTickCount() {
        return this.mTicksCount;
    }

    public synchronized float getProgressFloat() {
        BigDecimal bigDecimal = BigDecimal.valueOf(this.mProgress);
        return bigDecimal.setScale(this.mScale, 4).floatValue();
    }

    public int getProgress() {
        return Math.round(this.mProgress);
    }

    public float getMax() {
        return this.mMax;
    }

    public float getMin() {
        return this.mMin;
    }

    public OnSeekChangeListener getOnSeekChangeListener() {
        return this.mSeekChangeListener;
    }

    public synchronized void setProgress(float progress) {
        this.lastProgress = this.mProgress;
        float f = progress < this.mMin ? this.mMin : (this.mProgress = progress > this.mMax ? this.mMax : progress);
        if (this.mTicksCount > 2) {
            this.mProgress = this.mProgressArr[this.getClosestIndex()];
        }
        this.setSeekListener(false);
        this.refreshThumbCenterXByProgress(this.mProgress);
        this.postInvalidate();
        this.updateStayIndicator();
    }

    public synchronized void setMax(float max) {
        this.mMax = Math.max(this.mMin, max);
        this.initProgressRangeValue();
        this.refreshSeekBarLocation();
        this.invalidate();
        this.updateStayIndicator();
    }

    public synchronized void setMin(float min) {
        this.mMin = Math.min(this.mMax, min);
        this.initProgressRangeValue();
        this.refreshSeekBarLocation();
        this.invalidate();
        this.updateStayIndicator();
    }

    public void setR2L(boolean isR2L) {
        this.mR2L = isR2L;
        this.requestLayout();
        this.invalidate();
        this.updateStayIndicator();
    }

    public void setThumbDrawable(Drawable drawable2) {
        if (drawable2 == null) {
            this.mThumbDrawable = null;
            this.mThumbBitmap = null;
            this.mPressedThumbBitmap = null;
        } else {
            this.mThumbDrawable = drawable2;
            this.mThumbTouchRadius = this.mThumbRadius = (float)Math.min(SizeUtils.dp2px(this.mContext, 30.0f), this.mThumbSize) / 2.0f;
            this.mCustomDrawableMaxHeight = Math.max(this.mThumbTouchRadius, this.mTickRadius) * 2.0f;
            this.initThumbBitmap();
        }
        this.requestLayout();
        this.invalidate();
    }

    public void hideThumb(boolean hide) {
        this.mHideThumb = hide;
        this.invalidate();
    }

    public void hideThumbText(boolean hide) {
        this.mShowThumbText = hide;
        this.invalidate();
    }

    public void thumbColor(@ColorInt int thumbColor) {
        this.mThumbColor = thumbColor;
        this.mPressedThumbColor = thumbColor;
        this.invalidate();
    }

    public void thumbColorStateList(@NonNull ColorStateList thumbColorStateList) {
        this.initThumbColor(thumbColorStateList, this.mThumbColor);
        this.invalidate();
    }

    public void setTickMarksDrawable(Drawable drawable2) {
        if (drawable2 == null) {
            this.mTickMarksDrawable = null;
            this.mUnselectTickMarksBitmap = null;
            this.mSelectTickMarksBitmap = null;
        } else {
            this.mTickMarksDrawable = drawable2;
            this.mTickRadius = (float)Math.min(SizeUtils.dp2px(this.mContext, 30.0f), this.mTickMarksSize) / 2.0f;
            this.mCustomDrawableMaxHeight = Math.max(this.mThumbTouchRadius, this.mTickRadius) * 2.0f;
            this.initTickMarksBitmap();
        }
        this.invalidate();
    }

    public void tickMarksColor(@ColorInt int tickMarksColor) {
        this.mSelectedTickMarksColor = tickMarksColor;
        this.mUnSelectedTickMarksColor = tickMarksColor;
        this.invalidate();
    }

    public void tickMarksColor(@NonNull ColorStateList tickMarksColorStateList) {
        this.initTickMarksColor(tickMarksColorStateList, this.mSelectedTickMarksColor);
        this.invalidate();
    }

    public void tickTextsColor(@ColorInt int tickTextsColor) {
        this.mUnselectedTextsColor = tickTextsColor;
        this.mSelectedTextsColor = tickTextsColor;
        this.mHoveredTextColor = tickTextsColor;
        this.invalidate();
    }

    public void tickTextsColorStateList(@NonNull ColorStateList tickTextsColorStateList) {
        this.initTickTextsColor(tickTextsColorStateList, this.mSelectedTextsColor);
        this.invalidate();
    }

    public void setDecimalScale(int scale) {
        this.mScale = scale;
    }

    public void setIndicatorTextFormat(String format) {
        this.mIndicatorTextFormat = format;
        this.initTextsArray();
        this.updateStayIndicator();
    }

    public void customSectionTrackColor(@NonNull ColorCollector collector) {
        int[] colorArray = new int[this.mTicksCount - 1 > 0 ? this.mTicksCount - 1 : 1];
        for (int i = 0; i < colorArray.length; ++i) {
            colorArray[i] = this.mBackgroundTrackColor;
        }
        this.mCustomTrackSectionColorResult = collector.collectSectionTrackColor(colorArray);
        this.mSectionTrackColorArray = colorArray;
        this.invalidate();
    }

    public void customTickTexts(@NonNull String[] tickTextsArr) {
        this.mTickTextsCustomArray = tickTextsArr;
        if (this.mTickTextsArr != null) {
            for (int i = 0; i < this.mTickTextsArr.length; ++i) {
                String tickText = i < tickTextsArr.length ? String.valueOf(tickTextsArr[i]) : "";
                int index = i;
                if (this.mR2L) {
                    index = this.mTicksCount - 1 - i;
                }
                this.mTickTextsArr[index] = tickText;
                if (this.mTextPaint == null || this.mRect == null) continue;
                this.mTextPaint.getTextBounds(tickText, 0, tickText.length(), this.mRect);
                this.mTickTextsWidth[index] = this.mRect.width();
            }
            this.invalidate();
        }
    }

    public void customTickTextsTypeface(@NonNull Typeface typeface) {
        this.mTextsTypeface = typeface;
        this.measureTickTextsBonds();
        this.requestLayout();
        this.invalidate();
    }

    public void setOnSeekChangeListener(@NonNull OnSeekChangeListener listener) {
        this.mSeekChangeListener = listener;
    }
}

