/*
 * Decompiled with CFR 0.152.
 */
package com.warkiz.widget;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import android.widget.TextView;
import com.warkiz.widget.ArrowView;
import com.warkiz.widget.CircleBubbleView;
import com.warkiz.widget.IndicatorSeekBar;
import com.warkiz.widget.R;
import com.warkiz.widget.SizeUtils;

public class Indicator {
    private final int mWindowWidth;
    private int[] mLocation = new int[2];
    private ArrowView mArrowView;
    private TextView mProgressTextView;
    private PopupWindow mIndicatorPopW;
    private LinearLayout mTopContentView;
    private int mGap;
    private int mIndicatorColor;
    private Context mContext;
    private int mIndicatorType;
    private IndicatorSeekBar mSeekBar;
    private View mIndicatorView;
    private View mIndicatorCustomView;
    private View mIndicatorCustomTopContentView;
    private float mIndicatorTextSize;
    private int mIndicatorTextColor;

    public Indicator(Context context, IndicatorSeekBar seekBar, int indicatorColor, int indicatorType, int indicatorTextSize, int indicatorTextColor, View indicatorCustomView, View indicatorCustomTopContentView) {
        this.mContext = context;
        this.mSeekBar = seekBar;
        this.mIndicatorColor = indicatorColor;
        this.mIndicatorType = indicatorType;
        this.mIndicatorCustomView = indicatorCustomView;
        this.mIndicatorCustomTopContentView = indicatorCustomTopContentView;
        this.mIndicatorTextSize = indicatorTextSize;
        this.mIndicatorTextColor = indicatorTextColor;
        this.mWindowWidth = this.getWindowWidth();
        this.mGap = SizeUtils.dp2px(this.mContext, 2.0f);
        this.initIndicator();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initIndicator() {
        if (this.mIndicatorType == 4) {
            View view;
            if (this.mIndicatorCustomView == null) throw new IllegalArgumentException("the attr\uff1aindicator_custom_layout must be set while you set the indicator type to CUSTOM.");
            this.mIndicatorView = this.mIndicatorCustomView;
            int progressTextViewId = this.mContext.getResources().getIdentifier("isb_progress", "id", this.mContext.getApplicationContext().getPackageName());
            if (progressTextViewId <= 0 || (view = this.mIndicatorView.findViewById(progressTextViewId)) == null) return;
            if (!(view instanceof TextView)) throw new ClassCastException("the view identified by isb_progress in indicator custom layout can not be cast to TextView");
            this.mProgressTextView = (TextView)view;
            this.mProgressTextView.setText((CharSequence)this.mSeekBar.getIndicatorTextString());
            this.mProgressTextView.setTextSize((float)SizeUtils.px2sp(this.mContext, this.mIndicatorTextSize));
            this.mProgressTextView.setTextColor(this.mIndicatorTextColor);
            return;
        } else if (this.mIndicatorType == 1) {
            this.mIndicatorView = new CircleBubbleView(this.mContext, this.mIndicatorTextSize, this.mIndicatorTextColor, this.mIndicatorColor, "1000");
            ((CircleBubbleView)this.mIndicatorView).setProgress(this.mSeekBar.getIndicatorTextString());
            return;
        } else {
            this.mIndicatorView = View.inflate((Context)this.mContext, (int)R.layout.isb_indicator, null);
            this.mTopContentView = (LinearLayout)this.mIndicatorView.findViewById(R.id.indicator_container);
            this.mArrowView = (ArrowView)this.mIndicatorView.findViewById(R.id.indicator_arrow);
            this.mArrowView.setColor(this.mIndicatorColor);
            this.mProgressTextView = (TextView)this.mIndicatorView.findViewById(R.id.isb_progress);
            this.mProgressTextView.setText((CharSequence)this.mSeekBar.getIndicatorTextString());
            this.mProgressTextView.setTextSize((float)SizeUtils.px2sp(this.mContext, this.mIndicatorTextSize));
            this.mProgressTextView.setTextColor(this.mIndicatorTextColor);
            if (Build.VERSION.SDK_INT >= 16) {
                this.mTopContentView.setBackground((Drawable)this.getGradientDrawable());
            } else {
                this.mTopContentView.setBackgroundDrawable((Drawable)this.getGradientDrawable());
            }
            if (this.mIndicatorCustomTopContentView == null) return;
            int progressTextViewId = this.mContext.getResources().getIdentifier("isb_progress", "id", this.mContext.getApplicationContext().getPackageName());
            View topContentView = this.mIndicatorCustomTopContentView;
            if (progressTextViewId > 0) {
                View tv = topContentView.findViewById(progressTextViewId);
                if (tv != null && tv instanceof TextView) {
                    this.setTopContentView(topContentView, (TextView)tv);
                    return;
                } else {
                    this.setTopContentView(topContentView);
                }
                return;
            } else {
                this.setTopContentView(topContentView);
            }
        }
    }

    @NonNull
    private GradientDrawable getGradientDrawable() {
        GradientDrawable tvDrawable = this.mIndicatorType == 2 ? (GradientDrawable)this.mContext.getResources().getDrawable(R.drawable.isb_indicator_rounded_corners) : (GradientDrawable)this.mContext.getResources().getDrawable(R.drawable.isb_indicator_square_corners);
        tvDrawable.setColor(this.mIndicatorColor);
        return tvDrawable;
    }

    private int getWindowWidth() {
        WindowManager wm = (WindowManager)this.mContext.getSystemService("window");
        if (wm != null) {
            return wm.getDefaultDisplay().getWidth();
        }
        return 0;
    }

    private int getIndicatorScreenX() {
        this.mSeekBar.getLocationOnScreen(this.mLocation);
        return this.mLocation[0];
    }

    private void adjustArrow(float touchX) {
        if (this.mIndicatorType == 4 || this.mIndicatorType == 1) {
            return;
        }
        int indicatorScreenX = this.getIndicatorScreenX();
        if ((float)indicatorScreenX + touchX < (float)(this.mIndicatorPopW.getContentView().getMeasuredWidth() / 2)) {
            this.setMargin(this.mArrowView, -((int)((float)(this.mIndicatorPopW.getContentView().getMeasuredWidth() / 2 - indicatorScreenX) - touchX)), -1, -1, -1);
        } else if ((float)(this.mWindowWidth - indicatorScreenX) - touchX < (float)(this.mIndicatorPopW.getContentView().getMeasuredWidth() / 2)) {
            this.setMargin(this.mArrowView, (int)((float)(this.mIndicatorPopW.getContentView().getMeasuredWidth() / 2) - ((float)(this.mWindowWidth - indicatorScreenX) - touchX)), -1, -1, -1);
        } else {
            this.setMargin(this.mArrowView, 0, 0, 0, 0);
        }
    }

    private void setMargin(View view, int left, int top, int right, int bottom) {
        if (view == null) {
            return;
        }
        if (view.getLayoutParams() instanceof ViewGroup.MarginLayoutParams) {
            ViewGroup.MarginLayoutParams layoutParams = (ViewGroup.MarginLayoutParams)view.getLayoutParams();
            layoutParams.setMargins(left == -1 ? layoutParams.leftMargin : left, top == -1 ? layoutParams.topMargin : top, right == -1 ? layoutParams.rightMargin : right, bottom == -1 ? layoutParams.bottomMargin : bottom);
            view.requestLayout();
        }
    }

    void iniPop(boolean indicatorStayAlways) {
        if (this.mIndicatorPopW != null) {
            return;
        }
        if (this.mIndicatorType != 0 && this.mIndicatorView != null && !indicatorStayAlways) {
            this.mIndicatorView.measure(0, 0);
            this.mIndicatorPopW = new PopupWindow(this.mIndicatorView, -2, -2, false);
        }
    }

    View getInsideContentView() {
        return this.mIndicatorView;
    }

    void setProgressTextView(String text) {
        if (this.mIndicatorView instanceof CircleBubbleView) {
            ((CircleBubbleView)this.mIndicatorView).setProgress(text);
        } else if (this.mProgressTextView != null) {
            this.mProgressTextView.setText((CharSequence)text);
        }
    }

    void updateIndicatorLocation(int offset) {
        this.setMargin(this.mIndicatorView, offset, -1, -1, -1);
    }

    void updateArrowViewLocation(int offset) {
        this.setMargin(this.mArrowView, offset, -1, -1, -1);
    }

    void update(float touchX) {
        if (!this.mSeekBar.isEnabled() || this.mSeekBar.getVisibility() != 0) {
            return;
        }
        this.refreshProgressText();
        if (this.mIndicatorPopW != null) {
            this.mIndicatorPopW.getContentView().measure(0, 0);
            this.mIndicatorPopW.update((View)this.mSeekBar, (int)(touchX - (float)(this.mIndicatorPopW.getContentView().getMeasuredWidth() / 2)), -(this.mSeekBar.getMeasuredHeight() + this.mIndicatorPopW.getContentView().getMeasuredHeight() - this.mSeekBar.getPaddingTop() + this.mGap), -1, -1);
            this.adjustArrow(touchX);
        }
    }

    void show(float touchX) {
        if (!this.mSeekBar.isEnabled() || this.mSeekBar.getVisibility() != 0) {
            return;
        }
        this.refreshProgressText();
        if (this.mIndicatorPopW != null) {
            this.mIndicatorPopW.getContentView().measure(0, 0);
            this.mIndicatorPopW.showAsDropDown((View)this.mSeekBar, (int)(touchX - (float)this.mIndicatorPopW.getContentView().getMeasuredWidth() / 2.0f), -(this.mSeekBar.getMeasuredHeight() + this.mIndicatorPopW.getContentView().getMeasuredHeight() - this.mSeekBar.getPaddingTop() + this.mGap));
            this.adjustArrow(touchX);
        }
    }

    void refreshProgressText() {
        String tickTextString = this.mSeekBar.getIndicatorTextString();
        if (this.mIndicatorView instanceof CircleBubbleView) {
            ((CircleBubbleView)this.mIndicatorView).setProgress(tickTextString);
        } else if (this.mProgressTextView != null) {
            this.mProgressTextView.setText((CharSequence)tickTextString);
        }
    }

    void hide() {
        if (this.mIndicatorPopW == null) {
            return;
        }
        this.mIndicatorPopW.dismiss();
    }

    boolean isShowing() {
        return this.mIndicatorPopW != null && this.mIndicatorPopW.isShowing();
    }

    public View getContentView() {
        return this.mIndicatorView;
    }

    public void setContentView(@NonNull View customIndicatorView) {
        this.mIndicatorType = 4;
        this.mIndicatorCustomView = customIndicatorView;
        this.initIndicator();
    }

    public void setContentView(@NonNull View customIndicatorView, TextView progressTextView) {
        this.mProgressTextView = progressTextView;
        this.mIndicatorType = 4;
        this.mIndicatorCustomView = customIndicatorView;
        this.initIndicator();
    }

    public View getTopContentView() {
        return this.mTopContentView;
    }

    public void setTopContentView(@NonNull View topContentView) {
        this.setTopContentView(topContentView, null);
    }

    public void setTopContentView(@NonNull View topContentView, @Nullable TextView progressTextView) {
        this.mProgressTextView = progressTextView;
        this.mTopContentView.removeAllViews();
        if (Build.VERSION.SDK_INT >= 16) {
            topContentView.setBackground((Drawable)this.getGradientDrawable());
        } else {
            topContentView.setBackgroundDrawable((Drawable)this.getGradientDrawable());
        }
        this.mTopContentView.addView(topContentView);
    }
}

