/*
 * Decompiled with CFR 0.152.
 */
package com.warkiz.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Color;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.support.annotation.ArrayRes;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.view.View;
import com.warkiz.widget.IndicatorSeekBar;
import com.warkiz.widget.SizeUtils;

public class Builder {
    final Context context;
    float max = 100.0f;
    float min = 0.0f;
    float progress = 0.0f;
    boolean progressValueFloat = false;
    boolean seekSmoothly = false;
    boolean r2l = false;
    boolean userSeekable = true;
    boolean onlyThumbDraggable = false;
    boolean clearPadding = false;
    int showIndicatorType = 2;
    int indicatorColor = Color.parseColor((String)"#FF4081");
    int indicatorTextColor = Color.parseColor((String)"#FFFFFF");
    int indicatorTextSize = 0;
    View indicatorContentView = null;
    View indicatorTopContentView = null;
    int trackBackgroundSize = 0;
    int trackBackgroundColor = Color.parseColor((String)"#D7D7D7");
    int trackProgressSize = 0;
    int trackProgressColor = Color.parseColor((String)"#FF4081");
    boolean trackRoundedCorners = false;
    int thumbTextColor = Color.parseColor((String)"#FF4081");
    boolean showThumbText = false;
    int thumbSize = 0;
    int thumbColor = Color.parseColor((String)"#FF4081");
    ColorStateList thumbColorStateList = null;
    Drawable thumbDrawable = null;
    boolean showTickText;
    int tickTextsColor = Color.parseColor((String)"#FF4081");
    int tickTextsSize = 0;
    String[] tickTextsCustomArray = null;
    Typeface tickTextsTypeFace = Typeface.DEFAULT;
    ColorStateList tickTextsColorStateList = null;
    int tickCount = 0;
    int showTickMarksType = 0;
    int tickMarksColor = Color.parseColor((String)"#FF4081");
    int tickMarksSize = 0;
    Drawable tickMarksDrawable = null;
    boolean tickMarksEndsHide = false;
    boolean tickMarksSweptHide = false;
    ColorStateList tickMarksColorStateList = null;

    Builder(Context context) {
        this.context = context;
        this.indicatorTextSize = SizeUtils.sp2px(context, 14.0f);
        this.trackBackgroundSize = SizeUtils.dp2px(context, 2.0f);
        this.trackProgressSize = SizeUtils.dp2px(context, 2.0f);
        this.tickMarksSize = SizeUtils.dp2px(context, 10.0f);
        this.tickTextsSize = SizeUtils.sp2px(context, 13.0f);
        this.thumbSize = SizeUtils.dp2px(context, 14.0f);
    }

    public IndicatorSeekBar build() {
        return new IndicatorSeekBar(this);
    }

    public Builder max(float max) {
        this.max = max;
        return this;
    }

    public Builder min(float min) {
        this.min = min;
        return this;
    }

    public Builder progress(float progress) {
        this.progress = progress;
        return this;
    }

    public Builder progressValueFloat(boolean isFloatProgress) {
        this.progressValueFloat = isFloatProgress;
        return this;
    }

    public Builder seekSmoothly(boolean seekSmoothly) {
        this.seekSmoothly = seekSmoothly;
        return this;
    }

    public Builder r2l(boolean r2l) {
        this.r2l = r2l;
        return this;
    }

    public Builder clearPadding(boolean clearPadding) {
        this.clearPadding = clearPadding;
        return this;
    }

    public Builder userSeekable(boolean userSeekable) {
        this.userSeekable = userSeekable;
        return this;
    }

    public Builder onlyThumbDraggable(boolean onlyThumbDraggable) {
        this.onlyThumbDraggable = onlyThumbDraggable;
        return this;
    }

    public Builder showIndicatorType(int showIndicatorType) {
        this.showIndicatorType = showIndicatorType;
        return this;
    }

    public Builder indicatorColor(@ColorInt int indicatorColor) {
        this.indicatorColor = indicatorColor;
        return this;
    }

    public Builder indicatorTextColor(@ColorInt int indicatorTextColor) {
        this.indicatorTextColor = indicatorTextColor;
        return this;
    }

    public Builder indicatorTextSize(int indicatorTextSize) {
        this.indicatorTextSize = SizeUtils.sp2px(this.context, indicatorTextSize);
        return this;
    }

    public Builder indicatorContentView(@NonNull View indicatorContentView) {
        this.indicatorContentView = indicatorContentView;
        return this;
    }

    public Builder indicatorContentViewLayoutId(@LayoutRes int layoutId) {
        this.indicatorContentView = View.inflate((Context)this.context, (int)layoutId, null);
        return this;
    }

    public Builder indicatorTopContentView(View topContentView) {
        this.indicatorTopContentView = topContentView;
        return this;
    }

    public Builder indicatorTopContentViewLayoutId(@LayoutRes int layoutId) {
        this.indicatorTopContentView = View.inflate((Context)this.context, (int)layoutId, null);
        return this;
    }

    public Builder trackBackgroundSize(int trackBackgroundSize) {
        this.trackBackgroundSize = SizeUtils.dp2px(this.context, trackBackgroundSize);
        return this;
    }

    public Builder trackBackgroundColor(@ColorInt int trackBackgroundColor) {
        this.trackBackgroundColor = trackBackgroundColor;
        return this;
    }

    public Builder trackProgressSize(int trackProgressSize) {
        this.trackProgressSize = SizeUtils.dp2px(this.context, trackProgressSize);
        return this;
    }

    public Builder trackProgressColor(@ColorInt int trackProgressColor) {
        this.trackProgressColor = trackProgressColor;
        return this;
    }

    public Builder trackRoundedCorners(boolean trackRoundedCorners) {
        this.trackRoundedCorners = trackRoundedCorners;
        return this;
    }

    public Builder thumbTextColor(@ColorInt int thumbTextColor) {
        this.thumbTextColor = thumbTextColor;
        return this;
    }

    public Builder showThumbText(boolean showThumbText) {
        this.showThumbText = showThumbText;
        return this;
    }

    public Builder thumbColor(@ColorInt int thumbColor) {
        this.thumbColor = thumbColor;
        return this;
    }

    public Builder thumbColorStateList(@NonNull ColorStateList thumbColorStateList) {
        this.thumbColorStateList = thumbColorStateList;
        return this;
    }

    public Builder thumbSize(int thumbSize) {
        this.thumbSize = SizeUtils.dp2px(this.context, thumbSize);
        return this;
    }

    public Builder thumbDrawable(@NonNull Drawable thumbDrawable) {
        this.thumbDrawable = thumbDrawable;
        return this;
    }

    public Builder thumbDrawable(@NonNull StateListDrawable thumbStateListDrawable) {
        this.thumbDrawable = thumbStateListDrawable;
        return this;
    }

    public Builder thumbDrawable(@DrawableRes int thumbDrawableId) {
        this.thumbDrawable = this.context.getResources().getDrawable(thumbDrawableId);
        return this;
    }

    public Builder showTickTexts(boolean showTickText) {
        this.showTickText = showTickText;
        return this;
    }

    public Builder tickTextsColor(@ColorInt int tickTextsColor) {
        this.tickTextsColor = tickTextsColor;
        return this;
    }

    public Builder tickTextsColorStateList(@NonNull ColorStateList tickTextsColorStateList) {
        this.tickTextsColorStateList = tickTextsColorStateList;
        return this;
    }

    public Builder tickTextsSize(int tickTextsSize) {
        this.tickTextsSize = SizeUtils.sp2px(this.context, tickTextsSize);
        return this;
    }

    public Builder tickTextsArray(String[] tickTextsArray) {
        this.tickTextsCustomArray = tickTextsArray;
        return this;
    }

    public Builder tickTextsArray(@ArrayRes int tickTextsArray) {
        this.tickTextsCustomArray = this.context.getResources().getStringArray(tickTextsArray);
        return this;
    }

    public Builder tickTextsTypeFace(Typeface tickTextsTypeFace) {
        this.tickTextsTypeFace = tickTextsTypeFace;
        return this;
    }

    public Builder tickCount(int tickCount) {
        this.tickCount = tickCount;
        return this;
    }

    public Builder showTickMarksType(int tickMarksType) {
        this.showTickMarksType = tickMarksType;
        return this;
    }

    public Builder tickMarksColor(@ColorInt int tickMarksColor) {
        this.tickMarksColor = tickMarksColor;
        return this;
    }

    public Builder tickMarksColor(@NonNull ColorStateList tickMarksColorStateList) {
        this.tickMarksColorStateList = tickMarksColorStateList;
        return this;
    }

    public Builder tickMarksSize(int tickMarksSize) {
        this.tickMarksSize = SizeUtils.dp2px(this.context, tickMarksSize);
        return this;
    }

    public Builder tickMarksDrawable(@DrawableRes int tickMarksDrawableID) {
        this.tickMarksDrawable = this.context.getResources().getDrawable(tickMarksDrawableID);
        return this;
    }

    public Builder tickMarksDrawable(@NonNull Drawable tickMarksDrawable) {
        this.tickMarksDrawable = tickMarksDrawable;
        return this;
    }

    public Builder tickMarksDrawable(@NonNull StateListDrawable tickMarksStateListDrawable) {
        this.tickMarksDrawable = tickMarksStateListDrawable;
        return this;
    }

    public Builder tickMarksEndsHide(boolean tickMarksEndsHide) {
        this.tickMarksEndsHide = tickMarksEndsHide;
        return this;
    }

    public Builder tickMarksSweptHide(boolean tickMarksSweptHide) {
        this.tickMarksSweptHide = tickMarksSweptHide;
        return this;
    }
}

