/*
 * Decompiled with CFR 0.152.
 */
package com.warkiz.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import com.warkiz.widget.BuilderParams;
import com.warkiz.widget.IndicatorUtils;

class CircleBubbleView
extends View {
    private int mIndicatorTextColor;
    private int mIndicatorColor;
    private int mIndicatorTextSize;
    private Context mContext;
    private Path mPath;
    private Paint mPaint;
    private float mIndicatorWidth;
    private float mIndicatorHeight;
    private float mTextHeight;
    private String mProgress;

    CircleBubbleView(Context context) {
        this(context, null);
    }

    CircleBubbleView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    CircleBubbleView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init("100");
    }

    CircleBubbleView(BuilderParams p, String maxLengthText) {
        super(p.mContext, null, 0);
        this.mContext = p.mContext;
        this.mIndicatorTextSize = p.mIndicatorTextSize;
        this.mIndicatorTextColor = p.mIndicatorTextColor;
        this.mIndicatorColor = p.mIndicatorColor;
        this.init(maxLengthText);
    }

    private void init(String maxLengthText) {
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStrokeWidth(1.0f);
        this.mPaint.setTextAlign(Paint.Align.CENTER);
        this.mPaint.setTextSize((float)this.mIndicatorTextSize);
        Rect mRect = new Rect();
        this.mPaint.getTextBounds(maxLengthText, 0, maxLengthText.length(), mRect);
        this.mIndicatorWidth = mRect.width() + IndicatorUtils.dp2px(this.mContext, 4.0f);
        int minWidth = IndicatorUtils.dp2px(this.mContext, 36.0f);
        if (this.mIndicatorWidth < (float)minWidth) {
            this.mIndicatorWidth = minWidth;
        }
        this.mTextHeight = mRect.height();
        this.mIndicatorHeight = this.mIndicatorWidth * 1.2f;
        this.initPath();
    }

    private void initPath() {
        this.mPath = new Path();
        RectF rectF = new RectF(0.0f, 0.0f, this.mIndicatorWidth, this.mIndicatorWidth);
        this.mPath.arcTo(rectF, 135.0f, 270.0f);
        this.mPath.lineTo(this.mIndicatorWidth / 2.0f, this.mIndicatorHeight);
        this.mPath.close();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension((int)this.mIndicatorWidth, (int)this.mIndicatorHeight);
    }

    protected void onDraw(Canvas canvas) {
        this.mPaint.setColor(this.mIndicatorColor);
        canvas.drawPath(this.mPath, this.mPaint);
        this.mPaint.setColor(this.mIndicatorTextColor);
        canvas.drawText(this.mProgress, this.mIndicatorWidth / 2.0f, this.mIndicatorHeight / 2.0f + this.mTextHeight / 4.0f, this.mPaint);
    }

    void setProgress(String progress) {
        this.mProgress = progress;
        this.invalidate();
    }
}

