/*
 * Decompiled with CFR 0.152.
 */
package com.warkiz.widget;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.support.annotation.IdRes;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import android.widget.TextView;
import com.warkiz.widget.ArrowView;
import com.warkiz.widget.BuilderParams;
import com.warkiz.widget.IndicatorSeekBar;
import com.warkiz.widget.IndicatorUtils;
import com.warkiz.widget.R;

class Indicator {
    private final Context mContext;
    private final int mIndicatorType;
    private final IndicatorSeekBar mSeekBar;
    private final int mWindowWidth;
    private final View mIndicatorCustomView;
    private final View mIndicatorCustomTopContentView;
    private final int mIndicatorTextSize;
    private final int mIndicatorTextColor;
    private final boolean mIndicatorStay;
    private int mIndicatorColor;
    private int[] mLocation = new int[2];
    private ArrowView mIndicatorArrow;
    private TextView mIndicatorText;
    private PopupWindow mIndicator;
    private LinearLayout mTopContentView;
    private int mGap;

    Indicator(Context context, IndicatorSeekBar seekBar, BuilderParams p) {
        this.mContext = context;
        this.mSeekBar = seekBar;
        this.mIndicatorColor = p.mIndicatorColor;
        this.mIndicatorType = p.mIndicatorType;
        this.mIndicatorCustomView = p.mIndicatorCustomView;
        this.mIndicatorCustomTopContentView = p.mIndicatorCustomTopContentView;
        this.mIndicatorTextSize = p.mIndicatorTextSize;
        this.mIndicatorTextColor = p.mIndicatorTextColor;
        this.mIndicatorStay = p.mIndicatorStay;
        this.initIndicator();
        this.mWindowWidth = this.getWindowWidth();
        this.mGap = IndicatorUtils.dp2px(this.mContext, 2.0f);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initIndicator() {
        View mIndicatorView = null;
        if (this.mIndicatorType == 2) {
            if (this.mIndicatorCustomView != null) {
                View view;
                mIndicatorView = this.mIndicatorCustomView;
                int progressTextViewId = this.mContext.getResources().getIdentifier("isb_progress", "id", this.mContext.getApplicationContext().getPackageName());
                if (progressTextViewId > 0 && (view = mIndicatorView.findViewById(progressTextViewId)) != null) {
                    if (!(view instanceof TextView)) throw new ClassCastException("the view identified by isb_progress in indicator custom layout can not be cast to TextView");
                    this.mIndicatorText = (TextView)view;
                    this.mIndicatorText.setText((CharSequence)String.valueOf(this.mSeekBar.getProgress()));
                    this.mIndicatorText.setTextSize((float)IndicatorUtils.px2sp(this.mContext, this.mIndicatorTextSize));
                    this.mIndicatorText.setTextColor(this.mIndicatorTextColor);
                }
            }
        } else {
            mIndicatorView = View.inflate((Context)this.mContext, (int)R.layout.isb_indicator, null);
            this.mTopContentView = (LinearLayout)mIndicatorView.findViewById(R.id.indicator_container);
            this.mIndicatorArrow = (ArrowView)mIndicatorView.findViewById(R.id.indicator_arrow);
            this.mIndicatorArrow.setColor(this.mIndicatorColor);
            this.mIndicatorText = (TextView)mIndicatorView.findViewById(R.id.isb_progress);
            this.mIndicatorText.setText((CharSequence)String.valueOf(this.mSeekBar.getProgress()));
            this.mIndicatorText.setTextSize((float)IndicatorUtils.px2sp(this.mContext, this.mIndicatorTextSize));
            this.mIndicatorText.setTextColor(this.mIndicatorTextColor);
            if (Build.VERSION.SDK_INT >= 16) {
                this.mTopContentView.setBackground((Drawable)this.getGradientDrawable());
            } else {
                this.mTopContentView.setBackgroundDrawable((Drawable)this.getGradientDrawable());
            }
            if (this.mIndicatorCustomTopContentView != null) {
                int progressTextViewId = this.mContext.getResources().getIdentifier("isb_progress", "id", this.mContext.getApplicationContext().getPackageName());
                View topContentView = this.mIndicatorCustomTopContentView;
                if (progressTextViewId > 0) {
                    View tv = topContentView.findViewById(progressTextViewId);
                    if (tv != null) {
                        this.setIndicatorTopContentView(topContentView, progressTextViewId);
                    } else {
                        this.setIndicatorTopContentView(topContentView);
                    }
                } else {
                    this.setIndicatorTopContentView(topContentView);
                }
            }
        }
        if (mIndicatorView == null) return;
        mIndicatorView.measure(0, 0);
        this.mIndicator = new PopupWindow(mIndicatorView, -2, -2, false);
    }

    @NonNull
    private GradientDrawable getGradientDrawable() {
        GradientDrawable tvDrawable = this.mIndicatorType == 0 ? (GradientDrawable)this.mContext.getResources().getDrawable(R.drawable.isb_indicator_square_corners) : (GradientDrawable)this.mContext.getResources().getDrawable(R.drawable.isb_indicator_rounded_corners);
        tvDrawable.setColor(this.mIndicatorColor);
        return tvDrawable;
    }

    private int getWindowWidth() {
        WindowManager wm = (WindowManager)this.mContext.getSystemService("window");
        if (wm != null) {
            return wm.getDefaultDisplay().getWidth();
        }
        return 0;
    }

    private int getIndicatorScreenX() {
        this.mSeekBar.getLocationOnScreen(this.mLocation);
        return this.mLocation[0];
    }

    private void adjustArrow(float touchX) {
        if (this.mIndicatorType == 2) {
            return;
        }
        int indicatorScreenX = this.getIndicatorScreenX();
        if ((float)indicatorScreenX + touchX < (float)(this.mIndicator.getContentView().getMeasuredWidth() / 2)) {
            this.setMargin(-((int)((float)(this.mIndicator.getContentView().getMeasuredWidth() / 2 - indicatorScreenX) - touchX)), -1, -1, -1);
        } else if ((float)(this.mWindowWidth - indicatorScreenX) - touchX < (float)(this.mIndicator.getContentView().getMeasuredWidth() / 2)) {
            this.setMargin((int)((float)(this.mIndicator.getContentView().getMeasuredWidth() / 2) - ((float)(this.mWindowWidth - indicatorScreenX) - touchX)), -1, -1, -1);
        } else {
            this.setMargin(0, 0, 0, 0);
        }
    }

    private void setMargin(int left, int top, int right, int bottom) {
        if (this.mIndicatorArrow == null) {
            return;
        }
        if (this.mIndicatorArrow.getLayoutParams() instanceof ViewGroup.MarginLayoutParams) {
            ViewGroup.MarginLayoutParams layoutParams = (ViewGroup.MarginLayoutParams)this.mIndicatorArrow.getLayoutParams();
            layoutParams.setMargins(left == -1 ? layoutParams.leftMargin : left, top == -1 ? layoutParams.topMargin : top, right == -1 ? layoutParams.rightMargin : right, bottom == -1 ? layoutParams.bottomMargin : bottom);
            this.mIndicatorArrow.requestLayout();
        }
    }

    void update(float touchX, int seekBarType, int thumbPos) {
        if (this.mIndicator != null) {
            if (this.mIndicatorText != null) {
                if (this.hasTextArray(seekBarType)) {
                    if (thumbPos >= this.mSeekBar.getTextArray().length) {
                        this.mIndicatorText.setText((CharSequence)"");
                    } else {
                        this.mIndicatorText.setText(this.mSeekBar.getTextArray()[thumbPos]);
                    }
                } else {
                    this.mIndicatorText.setText((CharSequence)this.mSeekBar.getProgressString());
                }
                this.mIndicator.getContentView().measure(0, 0);
            }
            this.mIndicator.update((View)this.mSeekBar, (int)(touchX - (float)(this.mIndicator.getContentView().getMeasuredWidth() / 2)), -(this.mSeekBar.getMeasuredHeight() + this.mIndicator.getContentView().getMeasuredHeight() - this.mSeekBar.getPaddingTop() + this.mGap), -1, -1);
            this.adjustArrow(touchX);
        }
    }

    void showIndicator(float touchX, int seekBarType, int thumbPos) {
        if (this.mIndicator != null && !this.mIndicator.isShowing()) {
            if (this.mIndicatorText != null) {
                if (this.hasTextArray(seekBarType)) {
                    if (thumbPos >= this.mSeekBar.getTextArray().length) {
                        this.mIndicatorText.setText((CharSequence)"");
                    } else {
                        this.mIndicatorText.setText(this.mSeekBar.getTextArray()[thumbPos]);
                    }
                } else {
                    this.mIndicatorText.setText((CharSequence)this.mSeekBar.getProgressString());
                }
                this.mIndicator.getContentView().measure(0, 0);
            }
            this.mIndicator.showAsDropDown((View)this.mSeekBar, (int)(touchX - (float)this.mIndicator.getContentView().getMeasuredWidth() / 2.0f), -(this.mSeekBar.getMeasuredHeight() + this.mIndicator.getContentView().getMeasuredHeight() - this.mSeekBar.getPaddingTop() + this.mGap));
            this.adjustArrow(touchX);
        }
    }

    private boolean hasTextArray(int seekBarType) {
        CharSequence[] textArray = this.mSeekBar.getTextArray();
        return seekBarType == 3 && textArray != null && textArray.length > 0;
    }

    public void hideIndicator() {
        if (this.mIndicator != null && this.mIndicator.isShowing() && !this.mIndicatorStay) {
            this.mIndicator.dismiss();
        }
    }

    public void forceHideIndicator() {
        if (this.mIndicator != null && this.mIndicator.isShowing()) {
            this.mIndicator.dismiss();
        }
    }

    public void setIndicatorTopContentView(@NonNull View topContentView) {
        this.mTopContentView.removeAllViews();
        if (Build.VERSION.SDK_INT >= 16) {
            topContentView.setBackground((Drawable)this.getGradientDrawable());
        } else {
            topContentView.setBackgroundDrawable((Drawable)this.getGradientDrawable());
        }
        this.mTopContentView.addView(topContentView);
    }

    public void setIndicatorTopContentLayout(@LayoutRes int topContentLayoutId) {
        this.mTopContentView.removeAllViews();
        View topContentView = View.inflate((Context)this.mContext, (int)topContentLayoutId, null);
        if (Build.VERSION.SDK_INT >= 16) {
            topContentView.setBackground((Drawable)this.getGradientDrawable());
        } else {
            topContentView.setBackgroundDrawable((Drawable)this.getGradientDrawable());
        }
        this.mTopContentView.addView(topContentView);
    }

    public void setIndicatorTopContentView(@NonNull View topContentView, @IdRes int progressTextViewId) {
        View tv = topContentView.findViewById(progressTextViewId);
        if (tv == null) {
            throw new IllegalArgumentException(" can not find the TextView in indicator topContentView by id: " + progressTextViewId);
        }
        if (!(tv instanceof TextView)) {
            throw new ClassCastException(" the view identified by progressTextViewId can not be cast to TextView. ");
        }
        this.mIndicatorText = (TextView)tv;
        this.mTopContentView.removeAllViews();
        if (Build.VERSION.SDK_INT >= 16) {
            topContentView.setBackground((Drawable)this.getGradientDrawable());
        } else {
            topContentView.setBackgroundDrawable((Drawable)this.getGradientDrawable());
        }
        this.mTopContentView.addView(topContentView);
    }

    public boolean isShowing() {
        return this.mIndicator != null && this.mIndicator.isShowing();
    }

    public void setCustomIndicator(@NonNull View customIndicatorView) {
        this.mIndicator.setContentView(customIndicatorView);
    }

    public void setProgressTextView(@NonNull TextView view) {
        this.mIndicatorText = view;
    }
}

