/*
 * Decompiled with CFR 0.152.
 */
package waffle.spring;

import java.util.ArrayList;
import java.util.Collection;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import waffle.servlet.WindowsPrincipal;
import waffle.spring.FqnGrantedAuthorityFactory;
import waffle.spring.GrantedAuthorityFactory;
import waffle.windows.auth.WindowsAccount;

public class WindowsAuthenticationToken
implements Authentication {
    private static final long serialVersionUID = 1L;
    public static final GrantedAuthorityFactory DEFAULT_GRANTED_AUTHORITY_FACTORY = new FqnGrantedAuthorityFactory("ROLE_", true);
    public static final GrantedAuthority DEFAULT_GRANTED_AUTHORITY = new SimpleGrantedAuthority("ROLE_USER");
    private final WindowsPrincipal principal;
    private final Collection<GrantedAuthority> authorities;

    public WindowsAuthenticationToken(WindowsPrincipal identity) {
        this(identity, DEFAULT_GRANTED_AUTHORITY_FACTORY, DEFAULT_GRANTED_AUTHORITY);
    }

    public WindowsAuthenticationToken(WindowsPrincipal identity, GrantedAuthorityFactory grantedAuthorityFactory, GrantedAuthority defaultGrantedAuthority) {
        this.principal = identity;
        this.authorities = new ArrayList<GrantedAuthority>();
        if (defaultGrantedAuthority != null) {
            this.authorities.add(defaultGrantedAuthority);
        }
        for (WindowsAccount group : this.principal.getGroups().values()) {
            this.authorities.add(grantedAuthorityFactory.createGrantedAuthority(group));
        }
    }

    public Collection<GrantedAuthority> getAuthorities() {
        return this.authorities;
    }

    public Object getCredentials() {
        return null;
    }

    public Object getDetails() {
        return null;
    }

    public Object getPrincipal() {
        return this.principal;
    }

    public boolean isAuthenticated() {
        return this.principal != null;
    }

    public void setAuthenticated(boolean authenticated) {
        throw new IllegalArgumentException();
    }

    public String getName() {
        return this.principal.getName();
    }
}

