/*
 * Decompiled with CFR 0.152.
 */
package sj.keyboard.utils.imageloader;

import android.widget.ImageView;
import java.io.IOException;
import java.util.Locale;

public interface ImageBase {
    public void displayImage(String var1, ImageView var2) throws IOException;

    public static enum Scheme {
        HTTP("http"),
        HTTPS("https"),
        FILE("file"),
        CONTENT("content"),
        ASSETS("assets"),
        DRAWABLE("drawable"),
        UNKNOWN("");

        private String scheme;
        private String uriPrefix;

        private Scheme(String scheme) {
            this.scheme = scheme;
            this.uriPrefix = scheme + "://";
        }

        public static Scheme ofUri(String uri) {
            if (uri != null) {
                for (Scheme s : Scheme.values()) {
                    if (!s.belongsTo(uri)) continue;
                    return s;
                }
            }
            return UNKNOWN;
        }

        public String toUri(String path) {
            return this.uriPrefix + path;
        }

        public String crop(String uri) {
            if (!this.belongsTo(uri)) {
                throw new IllegalArgumentException(String.format("URI [%1$s] doesn't have expected scheme [%2$s]", uri, this.scheme));
            }
            return uri.substring(this.uriPrefix.length());
        }

        protected boolean belongsTo(String uri) {
            return uri.toLowerCase(Locale.US).startsWith(this.uriPrefix);
        }

        public static String cropScheme(String uri) throws IllegalArgumentException {
            return Scheme.ofUri(uri).crop(uri);
        }
    }
}

