/*
 * Decompiled with CFR 0.152.
 */
package sj.keyboard;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.PopupWindow;
import com.keyboard.view.R;
import java.util.ArrayList;
import sj.keyboard.adpater.PageSetAdapter;
import sj.keyboard.data.PageSetEntity;
import sj.keyboard.utils.EmoticonsKeyboardUtils;
import sj.keyboard.widget.EmoticonsFuncView;
import sj.keyboard.widget.EmoticonsIndicatorView;
import sj.keyboard.widget.EmoticonsToolBarView;

public class EmoticonsKeyBoardPopWindow
extends PopupWindow
implements EmoticonsFuncView.OnEmoticonsPageViewListener,
EmoticonsToolBarView.OnToolBarItemClickListener {
    private Context mContext;
    protected EmoticonsFuncView mEmoticonsFuncView;
    protected EmoticonsIndicatorView mEmoticonsIndicatorView;
    protected EmoticonsToolBarView mEmoticonsToolBarView;

    public EmoticonsKeyBoardPopWindow(Context context) {
        super(context, null);
        this.mContext = context;
        LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
        View mConentView = inflater.inflate(R.layout.view_func_emoticon, null);
        this.setContentView(mConentView);
        this.setWidth(EmoticonsKeyboardUtils.getDisplayWidthPixels(this.mContext));
        this.setHeight(EmoticonsKeyboardUtils.getDefKeyboardHeight(this.mContext));
        this.setAnimationStyle(R.style.PopupAnimation);
        this.setOutsideTouchable(true);
        this.update();
        ColorDrawable dw = new ColorDrawable(0);
        this.setBackgroundDrawable((Drawable)dw);
        this.updateView(mConentView);
    }

    private void updateView(View view) {
        this.mEmoticonsFuncView = (EmoticonsFuncView)view.findViewById(R.id.view_epv);
        this.mEmoticonsIndicatorView = (EmoticonsIndicatorView)view.findViewById(R.id.view_eiv);
        this.mEmoticonsToolBarView = (EmoticonsToolBarView)view.findViewById(R.id.view_etv);
        this.mEmoticonsFuncView.setOnIndicatorListener(this);
        this.mEmoticonsToolBarView.setOnToolBarItemClickListener(this);
    }

    public void setAdapter(PageSetAdapter pageSetAdapter) {
        ArrayList<PageSetEntity> pageSetEntities;
        if (pageSetAdapter != null && (pageSetEntities = pageSetAdapter.getPageSetEntityList()) != null) {
            for (PageSetEntity pageSetEntity : pageSetEntities) {
                this.mEmoticonsToolBarView.addToolItemView(pageSetEntity);
            }
        }
        this.mEmoticonsFuncView.setAdapter(pageSetAdapter);
    }

    public void showPopupWindow() {
        View rootView = EmoticonsKeyboardUtils.getRootView((Activity)this.mContext);
        if (this.isShowing()) {
            this.dismiss();
        } else {
            EmoticonsKeyboardUtils.closeSoftKeyboard(this.mContext);
            this.showAtLocation(rootView, 80, 0, 0);
        }
    }

    @Override
    public void emoticonSetChanged(PageSetEntity pageSetEntity) {
        this.mEmoticonsToolBarView.setToolBtnSelect(pageSetEntity.getUuid());
    }

    @Override
    public void playTo(int position, PageSetEntity pageSetEntity) {
        this.mEmoticonsIndicatorView.playTo(position, pageSetEntity);
    }

    @Override
    public void playBy(int oldPosition, int newPosition, PageSetEntity pageSetEntity) {
        this.mEmoticonsIndicatorView.playBy(oldPosition, newPosition, pageSetEntity);
    }

    @Override
    public void onToolBarItemClick(PageSetEntity pageSetEntity) {
        this.mEmoticonsFuncView.setCurrentPageSet(pageSetEntity);
    }
}

