/*
 * Decompiled with CFR 0.152.
 */
package sj.keyboard.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.keyboard.view.R;
import java.util.ArrayList;
import sj.keyboard.data.PageSetEntity;
import sj.keyboard.utils.EmoticonsKeyboardUtils;

public class EmoticonsIndicatorView
extends LinearLayout {
    private static final int MARGIN_LEFT = 4;
    protected Context mContext;
    protected ArrayList<ImageView> mImageViews;
    protected Drawable mDrawableSelect;
    protected Drawable mDrawableNomal;
    protected LinearLayout.LayoutParams mLeftLayoutParams;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EmoticonsIndicatorView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        this.setOrientation(0);
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.EmoticonsIndicatorView, 0, 0);
        try {
            this.mDrawableSelect = a.getDrawable(R.styleable.EmoticonsIndicatorView_bmpSelect);
            this.mDrawableNomal = a.getDrawable(R.styleable.EmoticonsIndicatorView_bmpNomal);
        }
        finally {
            a.recycle();
        }
        if (this.mDrawableNomal == null) {
            this.mDrawableNomal = this.getResources().getDrawable(R.drawable.indicator_point_nomal);
        }
        if (this.mDrawableSelect == null) {
            this.mDrawableSelect = this.getResources().getDrawable(R.drawable.indicator_point_select);
        }
        this.mLeftLayoutParams = new LinearLayout.LayoutParams(-2, -2);
        this.mLeftLayoutParams.leftMargin = EmoticonsKeyboardUtils.dip2px(context, 4.0f);
    }

    public void playTo(int position, PageSetEntity pageSetEntity) {
        if (!this.checkPageSetEntity(pageSetEntity)) {
            return;
        }
        this.updateIndicatorCount(pageSetEntity.getPageCount());
        for (ImageView iv : this.mImageViews) {
            iv.setImageDrawable(this.mDrawableNomal);
        }
        this.mImageViews.get(position).setImageDrawable(this.mDrawableSelect);
    }

    public void playBy(int startPosition, int nextPosition, PageSetEntity pageSetEntity) {
        if (!this.checkPageSetEntity(pageSetEntity)) {
            return;
        }
        this.updateIndicatorCount(pageSetEntity.getPageCount());
        if (startPosition < 0 || nextPosition < 0 || nextPosition == startPosition) {
            nextPosition = 0;
            startPosition = 0;
        }
        if (startPosition < 0) {
            nextPosition = 0;
            startPosition = 0;
        }
        ImageView imageViewStrat = this.mImageViews.get(startPosition);
        ImageView imageViewNext = this.mImageViews.get(nextPosition);
        imageViewStrat.setImageDrawable(this.mDrawableNomal);
        imageViewNext.setImageDrawable(this.mDrawableSelect);
    }

    protected boolean checkPageSetEntity(PageSetEntity pageSetEntity) {
        if (pageSetEntity != null && pageSetEntity.isShowIndicator()) {
            this.setVisibility(0);
            return true;
        }
        this.setVisibility(8);
        return false;
    }

    protected void updateIndicatorCount(int count) {
        int i;
        if (this.mImageViews == null) {
            this.mImageViews = new ArrayList();
        }
        if (count > this.mImageViews.size()) {
            for (i = this.mImageViews.size(); i < count; ++i) {
                ImageView imageView = new ImageView(this.mContext);
                imageView.setImageDrawable(i == 0 ? this.mDrawableSelect : this.mDrawableNomal);
                this.addView((View)imageView, (ViewGroup.LayoutParams)this.mLeftLayoutParams);
                this.mImageViews.add(imageView);
            }
        }
        for (i = 0; i < this.mImageViews.size(); ++i) {
            if (i >= count) {
                this.mImageViews.get(i).setVisibility(8);
                continue;
            }
            this.mImageViews.get(i).setVisibility(0);
        }
    }
}

