/*
 * Decompiled with CFR 0.152.
 */
package sj.keyboard.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.LinearLayout;
import java.util.ArrayList;
import java.util.List;
import sj.keyboard.utils.EmoticonsKeyboardUtils;

public class FuncLayout
extends LinearLayout {
    public final int DEF_KEY = Integer.MIN_VALUE;
    private final SparseArray<View> mFuncViewArrayMap = new SparseArray();
    private int mCurrentFuncKey = Integer.MIN_VALUE;
    protected int mHeight = 0;
    private List<OnFuncKeyBoardListener> mListenerList;
    private OnFuncChangeListener onFuncChangeListener;

    public FuncLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setOrientation(1);
    }

    public void addFuncView(int key, View view) {
        if (this.mFuncViewArrayMap.get(key) != null) {
            return;
        }
        this.mFuncViewArrayMap.put(key, (Object)view);
        ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(-1, -1);
        this.addView(view, params);
        view.setVisibility(8);
    }

    public void hideAllFuncView() {
        for (int i = 0; i < this.mFuncViewArrayMap.size(); ++i) {
            int keyTemp = this.mFuncViewArrayMap.keyAt(i);
            ((View)this.mFuncViewArrayMap.get(keyTemp)).setVisibility(8);
        }
        this.mCurrentFuncKey = Integer.MIN_VALUE;
        this.setVisibility(false);
    }

    public void toggleFuncView(int key, boolean isSoftKeyboardPop, EditText editText) {
        if (this.getCurrentFuncKey() == key) {
            if (isSoftKeyboardPop) {
                EmoticonsKeyboardUtils.closeSoftKeyboard(this.getContext());
            } else {
                EmoticonsKeyboardUtils.openSoftKeyboard(editText);
            }
        } else {
            if (isSoftKeyboardPop) {
                EmoticonsKeyboardUtils.closeSoftKeyboard(this.getContext());
            }
            this.showFuncView(key);
        }
    }

    public void showFuncView(int key) {
        if (this.mFuncViewArrayMap.get(key) == null) {
            return;
        }
        for (int i = 0; i < this.mFuncViewArrayMap.size(); ++i) {
            int keyTemp = this.mFuncViewArrayMap.keyAt(i);
            if (keyTemp == key) {
                ((View)this.mFuncViewArrayMap.get(keyTemp)).setVisibility(0);
                continue;
            }
            ((View)this.mFuncViewArrayMap.get(keyTemp)).setVisibility(8);
        }
        this.mCurrentFuncKey = key;
        this.setVisibility(true);
        if (this.onFuncChangeListener != null) {
            this.onFuncChangeListener.onFuncChange(this.mCurrentFuncKey);
        }
    }

    public int getCurrentFuncKey() {
        return this.mCurrentFuncKey;
    }

    public void updateHeight(int height) {
        this.mHeight = height;
    }

    public void setVisibility(boolean b) {
        LinearLayout.LayoutParams params = (LinearLayout.LayoutParams)this.getLayoutParams();
        if (b) {
            this.setVisibility(0);
            params.height = this.mHeight;
            if (this.mListenerList != null) {
                for (OnFuncKeyBoardListener l : this.mListenerList) {
                    l.OnFuncPop(this.mHeight);
                }
            }
        } else {
            this.setVisibility(8);
            params.height = 0;
            if (this.mListenerList != null) {
                for (OnFuncKeyBoardListener l : this.mListenerList) {
                    l.OnFuncClose();
                }
            }
        }
        this.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    public boolean isOnlyShowSoftKeyboard() {
        return this.mCurrentFuncKey == Integer.MIN_VALUE;
    }

    public void addOnKeyBoardListener(OnFuncKeyBoardListener l) {
        if (this.mListenerList == null) {
            this.mListenerList = new ArrayList<OnFuncKeyBoardListener>();
        }
        this.mListenerList.add(l);
    }

    public void setOnFuncChangeListener(OnFuncChangeListener listener) {
        this.onFuncChangeListener = listener;
    }

    public static interface OnFuncChangeListener {
        public void onFuncChange(int var1);
    }

    public static interface OnFuncKeyBoardListener {
        public void OnFuncPop(int var1);

        public void OnFuncClose();
    }
}

