/*
 * Decompiled with CFR 0.152.
 */
package sj.keyboard.utils.imageloader;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.widget.ImageView;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import sj.keyboard.utils.imageloader.ImageBase;

public class ImageLoader
implements ImageBase {
    protected final Context context;
    private static volatile ImageLoader instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ImageLoader getInstance(Context context) {
        if (instance != null) return instance;
        Class<ImageLoader> clazz = ImageLoader.class;
        synchronized (ImageLoader.class) {
            if (instance != null) return instance;
            instance = new ImageLoader(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public ImageLoader(Context context) {
        this.context = context.getApplicationContext();
    }

    @Override
    public void displayImage(String uriStr, ImageView imageView) throws IOException {
        switch (ImageBase.Scheme.ofUri(uriStr)) {
            case FILE: {
                this.displayImageFromFile(uriStr, imageView);
                return;
            }
            case ASSETS: {
                this.displayImageFromAssets(uriStr, imageView);
                return;
            }
            case DRAWABLE: {
                this.displayImageFromDrawable(uriStr, imageView);
                return;
            }
            case HTTP: 
            case HTTPS: {
                this.displayImageFromNetwork(uriStr, imageView);
                return;
            }
            case CONTENT: {
                this.displayImageFromContent(uriStr, imageView);
                return;
            }
        }
        this.displayImageFromOtherSource(uriStr, imageView);
    }

    protected void displayImageFromFile(String imageUri, ImageView imageView) throws IOException {
        Bitmap bitmap;
        String filePath = ImageBase.Scheme.FILE.crop(imageUri);
        File file = new File(filePath);
        if (!file.exists()) {
            return;
        }
        try {
            bitmap = BitmapFactory.decodeFile((String)filePath);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        if (imageView != null) {
            imageView.setImageBitmap(bitmap);
        }
    }

    protected void displayImageFromAssets(String imageUri, ImageView imageView) throws IOException {
        Bitmap bitmap;
        String filePath = ImageBase.Scheme.ASSETS.crop(imageUri);
        try {
            bitmap = BitmapFactory.decodeStream((InputStream)this.context.getAssets().open(filePath));
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        if (imageView != null) {
            imageView.setImageBitmap(bitmap);
        }
    }

    protected void displayImageFromDrawable(String imageUri, ImageView imageView) {
        String drawableIdString = ImageBase.Scheme.DRAWABLE.crop(imageUri);
        int resID = this.context.getResources().getIdentifier(drawableIdString, "mipmap", this.context.getPackageName());
        if (resID <= 0) {
            resID = this.context.getResources().getIdentifier(drawableIdString, "drawable", this.context.getPackageName());
        }
        if (resID > 0 && imageView != null) {
            imageView.setImageResource(resID);
        }
    }

    protected void displayImageFromNetwork(String imageUri, Object extra) throws IOException {
    }

    protected void displayImageFromContent(String imageUri, ImageView imageView) throws FileNotFoundException {
    }

    protected void displayImageFromOtherSource(String imageUri, ImageView imageView) throws IOException {
    }
}

