/*
 * Decompiled with CFR 0.152.
 */
package sj.keyboard.interfaces;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.TextUtils;
import android.widget.EditText;
import java.io.IOException;
import java.io.InputStream;

public abstract class EmoticonFilter {
    public abstract void filter(EditText var1, CharSequence var2, int var3, int var4, int var5);

    public static Drawable getDrawableFromAssets(Context context, String emoticonName) {
        try {
            Bitmap bitmap = BitmapFactory.decodeStream((InputStream)context.getAssets().open(emoticonName));
            return new BitmapDrawable(bitmap);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Drawable getDrawable(Context context, String emojiName) {
        int resID;
        if (TextUtils.isEmpty((CharSequence)emojiName)) {
            return null;
        }
        if (emojiName.indexOf(".") >= 0) {
            emojiName = emojiName.substring(0, emojiName.indexOf("."));
        }
        if ((resID = context.getResources().getIdentifier(emojiName, "mipmap", context.getPackageName())) <= 0) {
            resID = context.getResources().getIdentifier(emojiName, "drawable", context.getPackageName());
        }
        try {
            return Build.VERSION.SDK_INT >= 21 ? context.getResources().getDrawable(resID, (Resources.Theme)null) : context.getResources().getDrawable(resID);
        }
        catch (Exception var4) {
            var4.printStackTrace();
            return null;
        }
    }
}

