/*
 * Decompiled with CFR 0.152.
 */
package sj.keyboard;

import android.content.Context;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import com.keyboard.view.R;
import java.util.ArrayList;
import sj.keyboard.adpater.PageSetAdapter;
import sj.keyboard.data.PageSetEntity;
import sj.keyboard.utils.EmoticonsKeyboardUtils;
import sj.keyboard.widget.AutoHeightLayout;
import sj.keyboard.widget.EmoticonsEditText;
import sj.keyboard.widget.EmoticonsFuncView;
import sj.keyboard.widget.EmoticonsIndicatorView;
import sj.keyboard.widget.EmoticonsToolBarView;
import sj.keyboard.widget.FuncLayout;

public class XhsEmoticonsKeyBoard
extends AutoHeightLayout
implements View.OnClickListener,
EmoticonsFuncView.OnEmoticonsPageViewListener,
EmoticonsToolBarView.OnToolBarItemClickListener,
EmoticonsEditText.OnBackKeyClickListener,
FuncLayout.OnFuncChangeListener {
    public static final int FUNC_TYPE_EMOTION = -1;
    public static final int FUNC_TYPE_APPPS = -2;
    protected LayoutInflater mInflater;
    protected ImageView mBtnVoiceOrText;
    protected Button mBtnVoice;
    protected EmoticonsEditText mEtChat;
    protected ImageView mBtnFace;
    protected RelativeLayout mRlInput;
    protected ImageView mBtnMultimedia;
    protected Button mBtnSend;
    protected FuncLayout mLyKvml;
    protected EmoticonsFuncView mEmoticonsFuncView;
    protected EmoticonsIndicatorView mEmoticonsIndicatorView;
    protected EmoticonsToolBarView mEmoticonsToolBarView;
    protected boolean mDispatchKeyEventPreImeLock = false;

    public XhsEmoticonsKeyBoard(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mInflater = (LayoutInflater)context.getSystemService("layout_inflater");
        this.inflateKeyboardBar();
        this.initView();
        this.initFuncView();
    }

    protected void inflateKeyboardBar() {
        this.mInflater.inflate(R.layout.view_keyboard_xhs, (ViewGroup)this);
    }

    protected View inflateFunc() {
        return this.mInflater.inflate(R.layout.view_func_emoticon, null);
    }

    protected void initView() {
        this.mBtnVoiceOrText = (ImageView)this.findViewById(R.id.btn_voice_or_text);
        this.mBtnVoice = (Button)this.findViewById(R.id.btn_voice);
        this.mEtChat = (EmoticonsEditText)this.findViewById(R.id.et_chat);
        this.mBtnFace = (ImageView)this.findViewById(R.id.btn_face);
        this.mRlInput = (RelativeLayout)this.findViewById(R.id.rl_input);
        this.mBtnMultimedia = (ImageView)this.findViewById(R.id.btn_multimedia);
        this.mBtnSend = (Button)this.findViewById(R.id.btn_send);
        this.mLyKvml = (FuncLayout)this.findViewById(R.id.ly_kvml);
        this.mBtnVoiceOrText.setOnClickListener((View.OnClickListener)this);
        this.mBtnFace.setOnClickListener((View.OnClickListener)this);
        this.mBtnMultimedia.setOnClickListener((View.OnClickListener)this);
        this.mEtChat.setOnBackKeyClickListener(this);
    }

    protected void initFuncView() {
        this.initEmoticonFuncView();
        this.initEditView();
    }

    protected void initEmoticonFuncView() {
        View keyboardView = this.inflateFunc();
        this.mLyKvml.addFuncView(-1, keyboardView);
        this.mEmoticonsFuncView = (EmoticonsFuncView)this.findViewById(R.id.view_epv);
        this.mEmoticonsIndicatorView = (EmoticonsIndicatorView)this.findViewById(R.id.view_eiv);
        this.mEmoticonsToolBarView = (EmoticonsToolBarView)this.findViewById(R.id.view_etv);
        this.mEmoticonsFuncView.setOnIndicatorListener(this);
        this.mEmoticonsToolBarView.setOnToolBarItemClickListener(this);
        this.mLyKvml.setOnFuncChangeListener(this);
    }

    protected void initEditView() {
        this.mEtChat.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                if (!XhsEmoticonsKeyBoard.this.mEtChat.isFocused()) {
                    XhsEmoticonsKeyBoard.this.mEtChat.setFocusable(true);
                    XhsEmoticonsKeyBoard.this.mEtChat.setFocusableInTouchMode(true);
                }
                return false;
            }
        });
        this.mEtChat.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                if (!TextUtils.isEmpty((CharSequence)s)) {
                    XhsEmoticonsKeyBoard.this.mBtnSend.setVisibility(0);
                    XhsEmoticonsKeyBoard.this.mBtnMultimedia.setVisibility(8);
                    XhsEmoticonsKeyBoard.this.mBtnSend.setBackgroundResource(R.drawable.btn_send_bg);
                } else {
                    XhsEmoticonsKeyBoard.this.mBtnMultimedia.setVisibility(0);
                    XhsEmoticonsKeyBoard.this.mBtnSend.setVisibility(8);
                }
            }
        });
    }

    public void setAdapter(PageSetAdapter pageSetAdapter) {
        ArrayList<PageSetEntity> pageSetEntities;
        if (pageSetAdapter != null && (pageSetEntities = pageSetAdapter.getPageSetEntityList()) != null) {
            for (PageSetEntity pageSetEntity : pageSetEntities) {
                this.mEmoticonsToolBarView.addToolItemView(pageSetEntity);
            }
        }
        this.mEmoticonsFuncView.setAdapter(pageSetAdapter);
    }

    public void addFuncView(View view) {
        this.mLyKvml.addFuncView(-2, view);
    }

    public void reset() {
        EmoticonsKeyboardUtils.closeSoftKeyboard(this.getContext());
        this.mLyKvml.hideAllFuncView();
        this.mBtnFace.setImageResource(R.drawable.icon_face_nomal);
    }

    protected void showVoice() {
        this.mRlInput.setVisibility(8);
        this.mBtnVoice.setVisibility(0);
        this.reset();
    }

    protected void checkVoice() {
        if (this.mBtnVoice.isShown()) {
            this.mBtnVoiceOrText.setImageResource(R.drawable.btn_voice_or_text_keyboard);
        } else {
            this.mBtnVoiceOrText.setImageResource(R.drawable.btn_voice_or_text);
        }
    }

    protected void showText() {
        this.mRlInput.setVisibility(0);
        this.mBtnVoice.setVisibility(8);
    }

    protected void toggleFuncView(int key) {
        this.showText();
        this.mLyKvml.toggleFuncView(key, this.isSoftKeyboardPop(), this.mEtChat);
    }

    @Override
    public void onFuncChange(int key) {
        if (-1 == key) {
            this.mBtnFace.setImageResource(R.drawable.icon_face_pop);
        } else {
            this.mBtnFace.setImageResource(R.drawable.icon_face_nomal);
        }
        this.checkVoice();
    }

    protected void setFuncViewHeight(int height) {
        LinearLayout.LayoutParams params = (LinearLayout.LayoutParams)this.mLyKvml.getLayoutParams();
        params.height = height;
        this.mLyKvml.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    @Override
    public void onSoftKeyboardHeightChanged(int height) {
        this.mLyKvml.updateHeight(height);
    }

    @Override
    public void OnSoftPop(int height) {
        super.OnSoftPop(height);
        this.mLyKvml.setVisibility(true);
        this.onFuncChange(this.mLyKvml.DEF_KEY);
    }

    @Override
    public void OnSoftClose() {
        super.OnSoftClose();
        if (this.mLyKvml.isOnlyShowSoftKeyboard()) {
            this.reset();
        } else {
            this.onFuncChange(this.mLyKvml.getCurrentFuncKey());
        }
    }

    public void addOnFuncKeyBoardListener(FuncLayout.OnFuncKeyBoardListener l) {
        this.mLyKvml.addOnKeyBoardListener(l);
    }

    @Override
    public void emoticonSetChanged(PageSetEntity pageSetEntity) {
        this.mEmoticonsToolBarView.setToolBtnSelect(pageSetEntity.getUuid());
    }

    @Override
    public void playTo(int position, PageSetEntity pageSetEntity) {
        this.mEmoticonsIndicatorView.playTo(position, pageSetEntity);
    }

    @Override
    public void playBy(int oldPosition, int newPosition, PageSetEntity pageSetEntity) {
        this.mEmoticonsIndicatorView.playBy(oldPosition, newPosition, pageSetEntity);
    }

    public void onClick(View v) {
        int i = v.getId();
        if (i == R.id.btn_voice_or_text) {
            if (this.mRlInput.isShown()) {
                this.mBtnVoiceOrText.setImageResource(R.drawable.btn_voice_or_text_keyboard);
                this.showVoice();
            } else {
                this.showText();
                this.mBtnVoiceOrText.setImageResource(R.drawable.btn_voice_or_text);
                EmoticonsKeyboardUtils.openSoftKeyboard(this.mEtChat);
            }
        } else if (i == R.id.btn_face) {
            this.toggleFuncView(-1);
        } else if (i == R.id.btn_multimedia) {
            this.toggleFuncView(-2);
        }
    }

    @Override
    public void onToolBarItemClick(PageSetEntity pageSetEntity) {
        this.mEmoticonsFuncView.setCurrentPageSet(pageSetEntity);
    }

    @Override
    public void onBackKeyClick() {
        if (this.mLyKvml.isShown()) {
            this.mDispatchKeyEventPreImeLock = true;
            this.reset();
        }
    }

    public boolean dispatchKeyEvent(KeyEvent event) {
        switch (event.getKeyCode()) {
            case 4: {
                if (this.mDispatchKeyEventPreImeLock) {
                    this.mDispatchKeyEventPreImeLock = false;
                    return true;
                }
                if (this.mLyKvml.isShown()) {
                    this.reset();
                    return true;
                }
                return super.dispatchKeyEvent(event);
            }
        }
        return super.dispatchKeyEvent(event);
    }

    public EmoticonsEditText getEtChat() {
        return this.mEtChat;
    }

    public Button getBtnVoice() {
        return this.mBtnVoice;
    }

    public Button getBtnSend() {
        return this.mBtnSend;
    }

    public EmoticonsFuncView getEmoticonsFuncView() {
        return this.mEmoticonsFuncView;
    }

    public EmoticonsIndicatorView getEmoticonsIndicatorView() {
        return this.mEmoticonsIndicatorView;
    }

    public EmoticonsToolBarView getEmoticonsToolBarView() {
        return this.mEmoticonsToolBarView;
    }
}

