/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.view;

import com.mxgraph.canvas.mxGraphics2DCanvas;
import com.mxgraph.canvas.mxICanvas;
import com.mxgraph.canvas.mxImageCanvas;
import com.mxgraph.model.mxCell;
import com.mxgraph.model.mxGeometry;
import com.mxgraph.model.mxGraphModel;
import com.mxgraph.model.mxICell;
import com.mxgraph.model.mxIGraphModel;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxEvent;
import com.mxgraph.util.mxEventObject;
import com.mxgraph.util.mxEventSource;
import com.mxgraph.util.mxImageBundle;
import com.mxgraph.util.mxPoint;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.util.mxResources;
import com.mxgraph.util.mxStyleUtils;
import com.mxgraph.util.mxUndoableEdit;
import com.mxgraph.util.mxUtils;
import com.mxgraph.view.mxCellState;
import com.mxgraph.view.mxConnectionConstraint;
import com.mxgraph.view.mxEdgeStyle;
import com.mxgraph.view.mxGraphSelectionModel;
import com.mxgraph.view.mxGraphView;
import com.mxgraph.view.mxMultiplicity;
import com.mxgraph.view.mxStylesheet;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class mxGraph
extends mxEventSource {
    private static final Logger log = Logger.getLogger(mxGraph.class.getName());
    public static final String VERSION = "3.9.9";
    protected PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    protected mxIGraphModel model;
    protected mxGraphView view;
    protected mxStylesheet stylesheet;
    protected mxGraphSelectionModel selectionModel;
    protected int gridSize = 10;
    protected boolean gridEnabled = true;
    protected boolean portsEnabled = true;
    protected double defaultOverlap = 0.5;
    protected Object defaultParent;
    protected String alternateEdgeStyle;
    protected boolean enabled = true;
    protected boolean cellsLocked = false;
    protected boolean cellsEditable = true;
    protected boolean cellsResizable = true;
    protected boolean cellsMovable = true;
    protected boolean cellsBendable = true;
    protected boolean cellsSelectable = true;
    protected boolean cellsDeletable = true;
    protected boolean cellsCloneable = true;
    protected boolean cellsDisconnectable = true;
    protected boolean labelsClipped = false;
    protected boolean edgeLabelsMovable = true;
    protected boolean vertexLabelsMovable = false;
    protected boolean dropEnabled = true;
    protected boolean splitEnabled = true;
    protected boolean autoSizeCells = false;
    protected mxRectangle maximumGraphBounds = null;
    protected mxRectangle minimumGraphSize = null;
    protected int border = 0;
    protected boolean keepEdgesInForeground = false;
    protected boolean keepEdgesInBackground = false;
    protected boolean collapseToPreferredSize = true;
    protected boolean allowNegativeCoordinates = true;
    protected boolean constrainChildren = true;
    protected boolean extendParents = true;
    protected boolean extendParentsOnAdd = true;
    protected boolean resetViewOnRootChange = true;
    protected boolean resetEdgesOnResize = false;
    protected boolean resetEdgesOnMove = false;
    protected boolean resetEdgesOnConnect = true;
    protected boolean allowLoops = false;
    protected mxMultiplicity[] multiplicities;
    protected mxEdgeStyle.mxEdgeStyleFunction defaultLoopStyle = mxEdgeStyle.Loop;
    protected boolean multigraph = true;
    protected boolean connectableEdges = false;
    protected boolean allowDanglingEdges = true;
    protected boolean cloneInvalidEdges = false;
    protected boolean disconnectOnMove = true;
    protected boolean labelsVisible = true;
    protected boolean htmlLabels = false;
    protected boolean swimlaneNesting = true;
    protected int changesRepaintThreshold = 1000;
    protected boolean autoOrigin = false;
    protected mxPoint origin = new mxPoint();
    protected static List<mxImageBundle> imageBundles;
    protected mxEventSource.mxIEventListener fullRepaintHandler = new mxEventSource.mxIEventListener(){

        public void invoke(Object sender, mxEventObject evt) {
            mxGraph.this.repaint();
        }
    };
    protected mxEventSource.mxIEventListener updateOriginHandler = new mxEventSource.mxIEventListener(){

        public void invoke(Object sender, mxEventObject evt) {
            if (mxGraph.this.isAutoOrigin()) {
                mxGraph.this.updateOrigin();
            }
        }
    };
    protected mxEventSource.mxIEventListener graphModelChangeHandler = new mxEventSource.mxIEventListener(){

        public void invoke(Object sender, mxEventObject evt) {
            mxRectangle dirty = mxGraph.this.graphModelChanged((mxIGraphModel)sender, ((mxUndoableEdit)evt.getProperty("edit")).getChanges());
            mxGraph.this.repaint(dirty);
        }
    };

    public mxGraph() {
        this(null, null);
    }

    public mxGraph(mxIGraphModel model) {
        this(model, null);
    }

    public mxGraph(mxStylesheet stylesheet) {
        this(null, stylesheet);
    }

    public mxGraph(mxIGraphModel model, mxStylesheet stylesheet) {
        this.selectionModel = this.createSelectionModel();
        this.setModel(model != null ? model : new mxGraphModel());
        this.setStylesheet(stylesheet != null ? stylesheet : this.createStylesheet());
        this.setView(this.createGraphView());
    }

    protected mxGraphSelectionModel createSelectionModel() {
        return new mxGraphSelectionModel(this);
    }

    protected mxStylesheet createStylesheet() {
        return new mxStylesheet();
    }

    protected mxGraphView createGraphView() {
        return new mxGraphView(this);
    }

    public mxIGraphModel getModel() {
        return this.model;
    }

    public void setModel(mxIGraphModel value) {
        if (this.model != null) {
            this.model.removeListener(this.graphModelChangeHandler);
        }
        mxIGraphModel oldModel = this.model;
        this.model = value;
        if (this.view != null) {
            this.view.revalidate();
        }
        this.model.addListener("change", this.graphModelChangeHandler);
        this.changeSupport.firePropertyChange("model", oldModel, this.model);
        this.repaint();
    }

    public mxGraphView getView() {
        return this.view;
    }

    public void setView(mxGraphView value) {
        if (this.view != null) {
            this.view.removeListener(this.fullRepaintHandler);
            this.view.removeListener(this.updateOriginHandler);
        }
        mxGraphView oldView = this.view;
        this.view = value;
        if (this.view != null) {
            this.view.revalidate();
        }
        this.view.addListener("scale", this.fullRepaintHandler);
        this.view.addListener("scale", this.updateOriginHandler);
        this.view.addListener("translate", this.fullRepaintHandler);
        this.view.addListener("scaleAndTranslate", this.fullRepaintHandler);
        this.view.addListener("scaleAndTranslate", this.updateOriginHandler);
        this.view.addListener("up", this.fullRepaintHandler);
        this.view.addListener("down", this.fullRepaintHandler);
        this.changeSupport.firePropertyChange("view", oldView, this.view);
    }

    public mxStylesheet getStylesheet() {
        return this.stylesheet;
    }

    public void setStylesheet(mxStylesheet value) {
        mxStylesheet oldValue = this.stylesheet;
        this.stylesheet = value;
        this.changeSupport.firePropertyChange("stylesheet", oldValue, this.stylesheet);
    }

    public Object[] getSelectionCellsForChanges(List<mxUndoableEdit.mxUndoableChange> changes) {
        ArrayList<Object> cells = new ArrayList<Object>();
        for (mxUndoableEdit.mxUndoableChange change : changes) {
            mxGraphModel.mxVisibleChange vc;
            if (change instanceof mxGraphModel.mxChildChange) {
                cells.add(((mxGraphModel.mxChildChange)change).getChild());
                continue;
            }
            if (change instanceof mxGraphModel.mxTerminalChange) {
                cells.add(((mxGraphModel.mxTerminalChange)change).getCell());
                continue;
            }
            if (change instanceof mxGraphModel.mxValueChange) {
                cells.add(((mxGraphModel.mxValueChange)change).getCell());
                continue;
            }
            if (change instanceof mxGraphModel.mxStyleChange) {
                cells.add(((mxGraphModel.mxStyleChange)change).getCell());
                continue;
            }
            if (change instanceof mxGraphModel.mxGeometryChange) {
                cells.add(((mxGraphModel.mxGeometryChange)change).getCell());
                continue;
            }
            if (change instanceof mxGraphModel.mxCollapseChange) {
                cells.add(((mxGraphModel.mxCollapseChange)change).getCell());
                continue;
            }
            if (!(change instanceof mxGraphModel.mxVisibleChange) || !(vc = (mxGraphModel.mxVisibleChange)change).isVisible()) continue;
            cells.add(((mxGraphModel.mxVisibleChange)change).getCell());
        }
        return mxGraphModel.getTopmostCells(this.model, cells.toArray());
    }

    public mxRectangle graphModelChanged(mxIGraphModel sender, List<mxUndoableEdit.mxUndoableChange> changes) {
        mxRectangle tmp;
        boolean ignoreDirty;
        int thresh = this.getChangesRepaintThreshold();
        boolean bl = ignoreDirty = thresh > 0 && changes.size() > thresh;
        if (!ignoreDirty) {
            Iterator<mxUndoableEdit.mxUndoableChange> it = changes.iterator();
            while (it.hasNext()) {
                if (!(it.next() instanceof mxGraphModel.mxRootChange)) continue;
                ignoreDirty = true;
                break;
            }
        }
        mxRectangle dirty = this.processChanges(changes, true, ignoreDirty);
        this.view.validate();
        if (this.isAutoOrigin()) {
            this.updateOrigin();
        }
        if (!ignoreDirty && (tmp = this.processChanges(changes, false, ignoreDirty)) != null) {
            if (dirty == null) {
                dirty = tmp;
            } else {
                dirty.add(tmp);
            }
        }
        this.removeSelectionCells(this.getRemovedCellsForChanges(changes));
        return dirty;
    }

    protected void updateOrigin() {
        mxRectangle bounds = this.getGraphBounds();
        if (bounds != null) {
            double scale = this.getView().getScale();
            double x = bounds.getX() / scale - (double)this.getBorder();
            double y = bounds.getY() / scale - (double)this.getBorder();
            if (x < 0.0 || y < 0.0) {
                double x0 = Math.min(0.0, x);
                double y0 = Math.min(0.0, y);
                this.origin.setX(this.origin.getX() + x0);
                this.origin.setY(this.origin.getY() + y0);
                mxPoint t = this.getView().getTranslate();
                this.getView().setTranslate(new mxPoint(t.getX() - x0, t.getY() - y0));
            } else if ((x > 0.0 || y > 0.0) && (this.origin.getX() < 0.0 || this.origin.getY() < 0.0)) {
                double dx = Math.min(-this.origin.getX(), x);
                double dy = Math.min(-this.origin.getY(), y);
                this.origin.setX(this.origin.getX() + dx);
                this.origin.setY(this.origin.getY() + dy);
                mxPoint t = this.getView().getTranslate();
                this.getView().setTranslate(new mxPoint(t.getX() - dx, t.getY() - dy));
            }
        }
    }

    public Object[] getRemovedCellsForChanges(List<mxUndoableEdit.mxUndoableChange> changes) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (mxUndoableEdit.mxUndoableChange change : changes) {
            if (change instanceof mxGraphModel.mxRootChange) break;
            if (change instanceof mxGraphModel.mxChildChange) {
                mxGraphModel.mxChildChange cc = (mxGraphModel.mxChildChange)change;
                if (cc.getParent() != null) continue;
                result.addAll(mxGraphModel.getDescendants(this.model, cc.getChild()));
                continue;
            }
            if (!(change instanceof mxGraphModel.mxVisibleChange)) continue;
            Object cell = ((mxGraphModel.mxVisibleChange)change).getCell();
            result.addAll(mxGraphModel.getDescendants(this.model, cell));
        }
        return result.toArray();
    }

    public mxRectangle processChanges(List<mxUndoableEdit.mxUndoableChange> changes, boolean invalidate, boolean ignoreDirty) {
        mxRectangle bounds = null;
        Iterator<mxUndoableEdit.mxUndoableChange> it = changes.iterator();
        while (it.hasNext()) {
            mxRectangle rect = this.processChange(it.next(), invalidate, ignoreDirty);
            if (bounds == null) {
                bounds = rect;
                continue;
            }
            bounds.add(rect);
        }
        return bounds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public mxRectangle processChange(mxUndoableEdit.mxUndoableChange change, boolean invalidate, boolean ignoreDirty) {
        mxRectangle result = null;
        if (change instanceof mxGraphModel.mxRootChange) {
            mxRectangle mxRectangle2 = result = ignoreDirty ? null : this.getGraphBounds();
            if (invalidate) {
                this.clearSelection();
                this.removeStateForCell(((mxGraphModel.mxRootChange)change).getPrevious());
                if (this.isResetViewOnRootChange()) {
                    this.view.setEventsEnabled(false);
                    try {
                        this.view.scaleAndTranslate(1.0, 0.0, 0.0);
                    }
                    finally {
                        this.view.setEventsEnabled(true);
                    }
                }
            }
            this.fireEvent(new mxEventObject(mxEvent.ROOT));
        } else if (change instanceof mxGraphModel.mxChildChange) {
            mxGraphModel.mxChildChange cc = (mxGraphModel.mxChildChange)change;
            if (!ignoreDirty) {
                if (cc.getParent() != cc.getPrevious()) {
                    if (this.model.isVertex(cc.getParent()) || this.model.isEdge(cc.getParent())) {
                        result = this.getBoundingBox(cc.getParent(), true, true);
                    }
                    if (this.model.isVertex(cc.getPrevious()) || this.model.isEdge(cc.getPrevious())) {
                        if (result != null) {
                            result.add(this.getBoundingBox(cc.getPrevious(), true, true));
                        } else {
                            result = this.getBoundingBox(cc.getPrevious(), true, true);
                        }
                    }
                }
                if (result == null) {
                    result = this.getBoundingBox(cc.getChild(), true, true);
                }
            }
            if (invalidate) {
                if (cc.getParent() != null) {
                    this.view.clear(cc.getChild(), false, true);
                } else {
                    this.removeStateForCell(cc.getChild());
                }
            }
        } else if (change instanceof mxGraphModel.mxTerminalChange) {
            Object cell = ((mxGraphModel.mxTerminalChange)change).getCell();
            if (!ignoreDirty) {
                result = this.getBoundingBox(cell, true);
            }
            if (invalidate) {
                this.view.invalidate(cell);
            }
        } else if (change instanceof mxGraphModel.mxValueChange) {
            Object cell = ((mxGraphModel.mxValueChange)change).getCell();
            if (!ignoreDirty) {
                result = this.getBoundingBox(cell);
            }
            if (invalidate) {
                this.view.clear(cell, false, false);
            }
        } else if (change instanceof mxGraphModel.mxStyleChange) {
            Object cell = ((mxGraphModel.mxStyleChange)change).getCell();
            if (!ignoreDirty) {
                result = this.getBoundingBox(cell, true);
            }
            if (invalidate) {
                this.view.clear(cell, false, false);
                this.view.invalidate(cell);
            }
        } else if (change instanceof mxGraphModel.mxGeometryChange) {
            Object cell = ((mxGraphModel.mxGeometryChange)change).getCell();
            if (!ignoreDirty) {
                result = this.getBoundingBox(cell, true, true);
            }
            if (invalidate) {
                this.view.invalidate(cell);
            }
        } else if (change instanceof mxGraphModel.mxCollapseChange) {
            Object cell = ((mxGraphModel.mxCollapseChange)change).getCell();
            if (!ignoreDirty) {
                result = this.getBoundingBox(((mxGraphModel.mxCollapseChange)change).getCell(), true, true);
            }
            if (invalidate) {
                this.removeStateForCell(cell);
            }
        } else if (change instanceof mxGraphModel.mxVisibleChange) {
            Object cell = ((mxGraphModel.mxVisibleChange)change).getCell();
            if (!ignoreDirty) {
                result = this.getBoundingBox(((mxGraphModel.mxVisibleChange)change).getCell(), true, true);
            }
            if (invalidate) {
                this.removeStateForCell(cell);
            }
        }
        return result;
    }

    protected void removeStateForCell(Object cell) {
        int childCount = this.model.getChildCount(cell);
        for (int i = 0; i < childCount; ++i) {
            this.removeStateForCell(this.model.getChildAt(cell, i));
        }
        this.view.invalidate(cell);
        this.view.removeState(cell);
    }

    public Map<String, Object> getCellStyle(Object cell) {
        Map<String, Object> style = this.model.isEdge(cell) ? this.stylesheet.getDefaultEdgeStyle() : this.stylesheet.getDefaultVertexStyle();
        String name = this.model.getStyle(cell);
        if (name != null) {
            style = this.postProcessCellStyle(this.stylesheet.getCellStyle(name, style));
        }
        if (style == null) {
            style = mxStylesheet.EMPTY_STYLE;
        }
        return style;
    }

    protected Map<String, Object> postProcessCellStyle(Map<String, Object> style) {
        if (style != null) {
            String key = mxUtils.getString(style, mxConstants.STYLE_IMAGE);
            String image = this.getImageFromBundles(key);
            if (image != null) {
                style.put(mxConstants.STYLE_IMAGE, image);
            } else {
                image = key;
            }
            if (image != null && image.startsWith("data:image/")) {
                int comma = image.indexOf(44);
                if (comma > 0) {
                    image = image.substring(0, comma) + ";base64," + image.substring(comma + 1);
                }
                style.put(mxConstants.STYLE_IMAGE, image);
            }
        }
        return style;
    }

    public Object[] setCellStyle(String style) {
        return this.setCellStyle(style, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] setCellStyle(String style, Object[] cells) {
        if (cells == null) {
            cells = this.getSelectionCells();
        }
        if (cells != null) {
            this.model.beginUpdate();
            try {
                for (int i = 0; i < cells.length; ++i) {
                    this.model.setStyle(cells[i], style);
                }
            }
            finally {
                this.model.endUpdate();
            }
        }
        return cells;
    }

    public Object toggleCellStyle(String key, boolean defaultValue, Object cell) {
        return this.toggleCellStyles(key, defaultValue, new Object[]{cell})[0];
    }

    public Object[] toggleCellStyles(String key, boolean defaultValue) {
        return this.toggleCellStyles(key, defaultValue, null);
    }

    public Object[] toggleCellStyles(String key, boolean defaultValue, Object[] cells) {
        if (cells == null) {
            cells = this.getSelectionCells();
        }
        if (cells != null && cells.length > 0) {
            Map<String, Object> style;
            mxCellState state = this.view.getState(cells[0]);
            Map<String, Object> map = style = state != null ? state.getStyle() : this.getCellStyle(cells[0]);
            if (style != null) {
                String value = mxUtils.isTrue(style, key, defaultValue) ? "0" : "1";
                this.setCellStyles(key, value, cells);
            }
        }
        return cells;
    }

    public Object[] setCellStyles(String key, String value) {
        return this.setCellStyles(key, value, null);
    }

    public Object[] setCellStyles(String key, String value, Object[] cells) {
        if (cells == null) {
            cells = this.getSelectionCells();
        }
        mxStyleUtils.setCellStyles(this.model, cells, key, value);
        return cells;
    }

    public Object[] toggleCellStyleFlags(String key, int flag) {
        return this.toggleCellStyleFlags(key, flag, null);
    }

    public Object[] toggleCellStyleFlags(String key, int flag, Object[] cells) {
        return this.setCellStyleFlags(key, flag, null, cells);
    }

    public Object[] setCellStyleFlags(String key, int flag, boolean value) {
        return this.setCellStyleFlags(key, flag, value, null);
    }

    public Object[] setCellStyleFlags(String key, int flag, Boolean value, Object[] cells) {
        if (cells == null) {
            cells = this.getSelectionCells();
        }
        if (cells != null && cells.length > 0) {
            if (value == null) {
                Map<String, Object> style;
                mxCellState state = this.view.getState(cells[0]);
                Map<String, Object> map = style = state != null ? state.getStyle() : this.getCellStyle(cells[0]);
                if (style != null) {
                    int current = mxUtils.getInt(style, key);
                    value = (current & flag) != flag;
                }
            }
            mxStyleUtils.setCellStyleFlags(this.model, cells, key, flag, value);
        }
        return cells;
    }

    public void addImageBundle(mxImageBundle bundle) {
        imageBundles.add(bundle);
    }

    public void removeImageBundle(mxImageBundle bundle) {
        imageBundles.remove(bundle);
    }

    public String getImageFromBundles(String key) {
        if (key != null) {
            Iterator<mxImageBundle> it = imageBundles.iterator();
            while (it.hasNext()) {
                String value = it.next().getImage(key);
                if (value == null) continue;
                return value;
            }
        }
        return null;
    }

    public List<mxImageBundle> getImageBundles() {
        return imageBundles;
    }

    public void getImageBundles(List<mxImageBundle> value) {
        imageBundles = value;
    }

    public Object[] alignCells(String align) {
        return this.alignCells(align, null);
    }

    public Object[] alignCells(String align, Object[] cells) {
        return this.alignCells(align, cells, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] alignCells(String align, Object[] cells, Object param) {
        if (cells == null) {
            cells = this.getSelectionCells();
        }
        if (cells != null && cells.length > 1) {
            if (param == null) {
                for (int i = 0; i < cells.length; ++i) {
                    mxGeometry geo = this.getCellGeometry(cells[i]);
                    if (geo == null || this.model.isEdge(cells[i])) continue;
                    if (param == null) {
                        if (align == null || align.equals("left")) {
                            param = geo.getX();
                            continue;
                        }
                        if (align.equals("center")) {
                            param = geo.getX() + geo.getWidth() / 2.0;
                            break;
                        }
                        if (align.equals("right")) {
                            param = geo.getX() + geo.getWidth();
                            continue;
                        }
                        if (align.equals("top")) {
                            param = geo.getY();
                            continue;
                        }
                        if (align.equals("middle")) {
                            param = geo.getY() + geo.getHeight() / 2.0;
                            break;
                        }
                        if (!align.equals("bottom")) continue;
                        param = geo.getY() + geo.getHeight();
                        continue;
                    }
                    double tmp = Double.parseDouble(String.valueOf(param));
                    if (align == null || align.equals("left")) {
                        param = Math.min(tmp, geo.getX());
                        continue;
                    }
                    if (align.equals("right")) {
                        param = Math.max(tmp, geo.getX() + geo.getWidth());
                        continue;
                    }
                    if (align.equals("top")) {
                        param = Math.min(tmp, geo.getY());
                        continue;
                    }
                    if (!align.equals("bottom")) continue;
                    param = Math.max(tmp, geo.getY() + geo.getHeight());
                }
            }
            this.model.beginUpdate();
            try {
                double tmp = Double.parseDouble(String.valueOf(param));
                for (int i = 0; i < cells.length; ++i) {
                    mxGeometry geo = this.getCellGeometry(cells[i]);
                    if (geo == null || this.model.isEdge(cells[i])) continue;
                    geo = (mxGeometry)geo.clone();
                    if (align == null || align.equals("left")) {
                        geo.setX(tmp);
                    } else if (align.equals("center")) {
                        geo.setX(tmp - geo.getWidth() / 2.0);
                    } else if (align.equals("right")) {
                        geo.setX(tmp - geo.getWidth());
                    } else if (align.equals("top")) {
                        geo.setY(tmp);
                    } else if (align.equals("middle")) {
                        geo.setY(tmp - geo.getHeight() / 2.0);
                    } else if (align.equals("bottom")) {
                        geo.setY(tmp - geo.getHeight());
                    }
                    this.model.setGeometry(cells[i], geo);
                    if (!this.isResetEdgesOnMove()) continue;
                    this.resetEdges(new Object[]{cells[i]});
                }
                this.fireEvent(new mxEventObject("alignCells", "cells", cells, "align", align));
            }
            finally {
                this.model.endUpdate();
            }
        }
        return cells;
    }

    public Object flipEdge(Object edge) {
        if (edge != null && this.alternateEdgeStyle != null) {
            this.model.beginUpdate();
            try {
                String style = this.model.getStyle(edge);
                if (style == null || style.length() == 0) {
                    this.model.setStyle(edge, this.alternateEdgeStyle);
                } else {
                    this.model.setStyle(edge, null);
                }
                this.resetEdge(edge);
                this.fireEvent(new mxEventObject("flipEdge", "edge", edge));
            }
            finally {
                this.model.endUpdate();
            }
        }
        return edge;
    }

    public Object[] orderCells(boolean back) {
        return this.orderCells(back, null);
    }

    public Object[] orderCells(boolean back, Object[] cells) {
        if (cells == null) {
            cells = mxUtils.sortCells(this.getSelectionCells(), true);
        }
        this.model.beginUpdate();
        try {
            this.cellsOrdered(cells, back);
            this.fireEvent(new mxEventObject("orderCells", "cells", cells, "back", back));
        }
        finally {
            this.model.endUpdate();
        }
        return cells;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cellsOrdered(Object[] cells, boolean back) {
        if (cells != null) {
            this.model.beginUpdate();
            try {
                for (int i = 0; i < cells.length; ++i) {
                    Object parent = this.model.getParent(cells[i]);
                    if (back) {
                        this.model.add(parent, cells[i], i);
                        continue;
                    }
                    this.model.add(parent, cells[i], this.model.getChildCount(parent) - 1);
                }
                this.fireEvent(new mxEventObject("cellsOrdered", "cells", cells, "back", back));
            }
            finally {
                this.model.endUpdate();
            }
        }
    }

    public Object groupCells() {
        return this.groupCells(null);
    }

    public Object groupCells(Object group) {
        return this.groupCells(group, 0.0);
    }

    public Object groupCells(Object group, double border) {
        return this.groupCells(group, border, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object groupCells(Object group, double border, Object[] cells) {
        if (cells == null) {
            cells = mxUtils.sortCells(this.getSelectionCells(), true);
        }
        cells = this.getCellsForGroup(cells);
        if (group == null) {
            group = this.createGroupCell(cells);
        }
        mxRectangle bounds = this.getBoundsForGroup(group, cells, border);
        if (cells.length > 0 && bounds != null) {
            Object parent = this.model.getParent(group);
            if (parent == null) {
                parent = this.model.getParent(cells[0]);
            }
            this.model.beginUpdate();
            try {
                if (this.getCellGeometry(group) == null) {
                    this.model.setGeometry(group, new mxGeometry());
                }
                int index = this.model.getChildCount(group);
                this.cellsAdded(cells, group, index, null, null, false);
                this.cellsMoved(cells, -bounds.getX(), -bounds.getY(), false, true);
                index = this.model.getChildCount(parent);
                this.cellsAdded(new Object[]{group}, parent, index, null, null, false, false);
                this.cellsResized(new Object[]{group}, new mxRectangle[]{bounds});
                this.fireEvent(new mxEventObject("groupCells", "group", group, "cells", cells, "border", border));
            }
            finally {
                this.model.endUpdate();
            }
        }
        return group;
    }

    public Object[] getCellsForGroup(Object[] cells) {
        ArrayList<Object> result = new ArrayList<Object>(cells.length);
        if (cells.length > 0) {
            Object parent = this.model.getParent(cells[0]);
            result.add(cells[0]);
            for (int i = 1; i < cells.length; ++i) {
                if (this.model.getParent(cells[i]) != parent) continue;
                result.add(cells[i]);
            }
        }
        return result.toArray();
    }

    public mxRectangle getBoundsForGroup(Object group, Object[] children, double border) {
        mxRectangle result = this.getBoundingBoxFromGeometry(children);
        if (result != null) {
            if (this.isSwimlane(group)) {
                mxRectangle size = this.getStartSize(group);
                result.setX(result.getX() - size.getWidth());
                result.setY(result.getY() - size.getHeight());
                result.setWidth(result.getWidth() + size.getWidth());
                result.setHeight(result.getHeight() + size.getHeight());
            }
            result.setX(result.getX() - border);
            result.setY(result.getY() - border);
            result.setWidth(result.getWidth() + 2.0 * border);
            result.setHeight(result.getHeight() + 2.0 * border);
        }
        return result;
    }

    public Object createGroupCell(Object[] cells) {
        mxCell group = new mxCell("", new mxGeometry(), null);
        group.setVertex(true);
        group.setConnectable(false);
        return group;
    }

    public Object[] ungroupCells() {
        return this.ungroupCells(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] ungroupCells(Object[] cells) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (cells == null) {
            cells = this.getSelectionCells();
            ArrayList<Object> tmp = new ArrayList<Object>(cells.length);
            for (int i = 0; i < cells.length; ++i) {
                if (this.model.getChildCount(cells[i]) <= 0) continue;
                tmp.add(cells[i]);
            }
            cells = tmp.toArray();
        }
        if (cells != null && cells.length > 0) {
            this.model.beginUpdate();
            try {
                for (int i = 0; i < cells.length; ++i) {
                    Object[] children = mxGraphModel.getChildren(this.model, cells[i]);
                    if (children == null || children.length <= 0) continue;
                    Object parent = this.model.getParent(cells[i]);
                    int index = this.model.getChildCount(parent);
                    this.cellsAdded(children, parent, index, null, null, true);
                    result.addAll(Arrays.asList(children));
                }
                this.cellsRemoved(this.addAllEdges(cells));
                this.fireEvent(new mxEventObject("ungroupCells", "cells", cells));
            }
            finally {
                this.model.endUpdate();
            }
        }
        return result.toArray();
    }

    public Object[] removeCellsFromParent() {
        return this.removeCellsFromParent(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] removeCellsFromParent(Object[] cells) {
        if (cells == null) {
            cells = this.getSelectionCells();
        }
        this.model.beginUpdate();
        try {
            Object parent = this.getDefaultParent();
            int index = this.model.getChildCount(parent);
            this.cellsAdded(cells, parent, index, null, null, true);
            this.fireEvent(new mxEventObject("removeCellsFromParent", "cells", cells));
        }
        finally {
            this.model.endUpdate();
        }
        return cells;
    }

    public Object[] updateGroupBounds() {
        return this.updateGroupBounds(null);
    }

    public Object[] updateGroupBounds(Object[] cells) {
        return this.updateGroupBounds(cells, 0);
    }

    public Object[] updateGroupBounds(Object[] cells, int border) {
        return this.updateGroupBounds(cells, border, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] updateGroupBounds(Object[] cells, int border, boolean moveParent) {
        if (cells == null) {
            cells = this.getSelectionCells();
        }
        this.model.beginUpdate();
        try {
            for (int i = 0; i < cells.length; ++i) {
                mxRectangle childBounds;
                Object[] children;
                mxGeometry geo = this.getCellGeometry(cells[i]);
                if (geo == null || (children = this.getChildCells(cells[i])) == null || children.length <= 0 || !((childBounds = this.getBoundingBoxFromGeometry(children)).getWidth() > 0.0) || !(childBounds.getHeight() > 0.0)) continue;
                mxRectangle size = this.isSwimlane(cells[i]) ? this.getStartSize(cells[i]) : new mxRectangle();
                geo = (mxGeometry)geo.clone();
                if (moveParent) {
                    geo.setX(geo.getX() + childBounds.getX() - size.getWidth() - (double)border);
                    geo.setY(geo.getY() + childBounds.getY() - size.getHeight() - (double)border);
                }
                geo.setWidth(childBounds.getWidth() + size.getWidth() + (double)(2 * border));
                geo.setHeight(childBounds.getHeight() + size.getHeight() + (double)(2 * border));
                this.model.setGeometry(cells[i], geo);
                this.moveCells(children, -childBounds.getX() + size.getWidth() + (double)border, -childBounds.getY() + size.getHeight() + (double)border);
            }
        }
        finally {
            this.model.endUpdate();
        }
        return cells;
    }

    public Object[] cloneCells(Object[] cells) {
        return this.cloneCells(cells, true);
    }

    public Object[] cloneCells(Object[] cells, boolean allowInvalidEdges) {
        Object[] clones = null;
        if (cells != null) {
            LinkedHashSet<Object> tmp = new LinkedHashSet<Object>(cells.length);
            tmp.addAll(Arrays.asList(cells));
            if (!tmp.isEmpty()) {
                double scale = this.view.getScale();
                mxPoint trans = this.view.getTranslate();
                clones = this.model.cloneCells(cells, true);
                for (int i = 0; i < cells.length; ++i) {
                    if (!allowInvalidEdges && this.model.isEdge(clones[i]) && this.getEdgeValidationError(clones[i], this.model.getTerminal(clones[i], true), this.model.getTerminal(clones[i], false)) != null) {
                        clones[i] = null;
                        continue;
                    }
                    mxGeometry g = this.model.getGeometry(clones[i]);
                    if (g == null) continue;
                    mxCellState state = this.view.getState(cells[i]);
                    mxCellState pstate = this.view.getState(this.model.getParent(cells[i]));
                    if (state == null || pstate == null) continue;
                    double dx = pstate.getOrigin().getX();
                    double dy = pstate.getOrigin().getY();
                    if (this.model.isEdge(clones[i])) {
                        List<mxPoint> points;
                        Object src = this.model.getTerminal(cells[i], true);
                        while (src != null && !tmp.contains(src)) {
                            src = this.model.getParent(src);
                        }
                        if (src == null) {
                            mxPoint pt = state.getAbsolutePoint(0);
                            g.setTerminalPoint(new mxPoint(pt.getX() / scale - trans.getX(), pt.getY() / scale - trans.getY()), true);
                        }
                        Object trg = this.model.getTerminal(cells[i], false);
                        while (trg != null && !tmp.contains(trg)) {
                            trg = this.model.getParent(trg);
                        }
                        if (trg == null) {
                            mxPoint pt = state.getAbsolutePoint(state.getAbsolutePointCount() - 1);
                            g.setTerminalPoint(new mxPoint(pt.getX() / scale - trans.getX(), pt.getY() / scale - trans.getY()), false);
                        }
                        if ((points = g.getPoints()) == null) continue;
                        for (mxPoint pt : points) {
                            pt.setX(pt.getX() + dx);
                            pt.setY(pt.getY() + dy);
                        }
                        continue;
                    }
                    g.setX(g.getX() + dx);
                    g.setY(g.getY() + dy);
                }
            } else {
                clones = new Object[]{};
            }
        }
        return clones;
    }

    public Object insertVertex(Object parent, String id, Object value, double x, double y, double width, double height) {
        return this.insertVertex(parent, id, value, x, y, width, height, null);
    }

    public Object insertVertex(Object parent, String id, Object value, double x, double y, double width, double height, String style) {
        return this.insertVertex(parent, id, value, x, y, width, height, style, false);
    }

    public Object insertVertex(Object parent, String id, Object value, double x, double y, double width, double height, String style, boolean relative) {
        Object vertex = this.createVertex(parent, id, value, x, y, width, height, style, relative);
        return this.addCell(vertex, parent);
    }

    public Object createVertex(Object parent, String id, Object value, double x, double y, double width, double height, String style) {
        return this.createVertex(parent, id, value, x, y, width, height, style, false);
    }

    public Object createVertex(Object parent, String id, Object value, double x, double y, double width, double height, String style, boolean relative) {
        mxGeometry geometry = new mxGeometry(x, y, width, height);
        geometry.setRelative(relative);
        mxCell vertex = new mxCell(value, geometry, style);
        vertex.setId(id);
        vertex.setVertex(true);
        vertex.setConnectable(true);
        return vertex;
    }

    public Object insertEdge(Object parent, String id, Object value, Object source, Object target) {
        return this.insertEdge(parent, id, value, source, target, null);
    }

    public Object insertEdge(Object parent, String id, Object value, Object source, Object target, String style) {
        Object edge = this.createEdge(parent, id, value, source, target, style);
        return this.addEdge(edge, parent, source, target, null);
    }

    public Object createEdge(Object parent, String id, Object value, Object source, Object target, String style) {
        mxCell edge = new mxCell(value, new mxGeometry(), style);
        edge.setId(id);
        edge.setEdge(true);
        edge.getGeometry().setRelative(true);
        return edge;
    }

    public Object addEdge(Object edge, Object parent, Object source, Object target, Integer index) {
        return this.addCell(edge, parent, index, source, target);
    }

    public Object addCell(Object cell) {
        return this.addCell(cell, null);
    }

    public Object addCell(Object cell, Object parent) {
        return this.addCell(cell, parent, null, null, null);
    }

    public Object addCell(Object cell, Object parent, Integer index, Object source, Object target) {
        return this.addCells(new Object[]{cell}, parent, index, source, target)[0];
    }

    public Object[] addCells(Object[] cells) {
        return this.addCells(cells, null);
    }

    public Object[] addCells(Object[] cells, Object parent) {
        return this.addCells(cells, parent, null);
    }

    public Object[] addCells(Object[] cells, Object parent, Integer index) {
        return this.addCells(cells, parent, index, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] addCells(Object[] cells, Object parent, Integer index, Object source, Object target) {
        if (parent == null) {
            parent = this.getDefaultParent();
        }
        if (index == null) {
            index = this.model.getChildCount(parent);
        }
        this.model.beginUpdate();
        try {
            this.cellsAdded(cells, parent, index, source, target, false, true);
            this.fireEvent(new mxEventObject("addCells", "cells", cells, "parent", parent, "index", index, "source", source, "target", target));
        }
        finally {
            this.model.endUpdate();
        }
        return cells;
    }

    public void cellsAdded(Object[] cells, Object parent, Integer index, Object source, Object target, boolean absolute) {
        this.cellsAdded(cells, parent, index, source, target, absolute, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cellsAdded(Object[] cells, Object parent, Integer index, Object source, Object target, boolean absolute, boolean constrain) {
        if (cells != null && parent != null && index != null) {
            this.model.beginUpdate();
            try {
                mxCellState parentState = absolute ? this.view.getState(parent) : null;
                mxPoint o1 = parentState != null ? parentState.getOrigin() : null;
                mxPoint zero = new mxPoint(0.0, 0.0);
                for (int i = 0; i < cells.length; ++i) {
                    Integer n;
                    if (cells[i] == null) {
                        Integer n2 = index;
                        n = index = Integer.valueOf(index - 1);
                        continue;
                    }
                    Object previous = this.model.getParent(cells[i]);
                    if (o1 != null && cells[i] != parent && parent != previous) {
                        mxCellState oldState = this.view.getState(previous);
                        mxPoint o2 = oldState != null ? oldState.getOrigin() : zero;
                        mxGeometry geo = this.model.getGeometry(cells[i]);
                        if (geo != null) {
                            double dx = o2.getX() - o1.getX();
                            double dy = o2.getY() - o1.getY();
                            geo = (mxGeometry)geo.clone();
                            geo.translate(dx, dy);
                            if (!geo.isRelative() && this.model.isVertex(cells[i]) && !this.isAllowNegativeCoordinates()) {
                                geo.setX(Math.max(0.0, geo.getX()));
                                geo.setY(Math.max(0.0, geo.getY()));
                            }
                            this.model.setGeometry(cells[i], geo);
                        }
                    }
                    if (parent == previous) {
                        n = index;
                        Integer n3 = index = Integer.valueOf(index - 1);
                    }
                    this.model.add(parent, cells[i], index + i);
                    if (this.isExtendParentsOnAdd() && this.isExtendParent(cells[i])) {
                        this.extendParent(cells[i]);
                    }
                    if (constrain) {
                        this.constrainChild(cells[i]);
                    }
                    if (source != null) {
                        this.cellConnected(cells[i], source, true, null);
                    }
                    if (target == null) continue;
                    this.cellConnected(cells[i], target, false, null);
                }
                this.fireEvent(new mxEventObject("cellsAdded", "cells", cells, "parent", parent, "index", index, "source", source, "target", target, "absolute", absolute));
            }
            finally {
                this.model.endUpdate();
            }
        }
    }

    public Object[] removeCells() {
        return this.removeCells(null);
    }

    public Object[] removeCells(Object[] cells) {
        return this.removeCells(cells, true);
    }

    public Object[] removeCells(Object[] cells, boolean includeEdges) {
        if (cells == null) {
            cells = this.getDeletableCells(this.getSelectionCells());
        }
        if (includeEdges) {
            cells = this.getDeletableCells(this.addAllEdges(cells));
        }
        this.model.beginUpdate();
        try {
            this.cellsRemoved(cells);
            this.fireEvent(new mxEventObject("removeCells", "cells", cells, "includeEdges", includeEdges));
        }
        finally {
            this.model.endUpdate();
        }
        return cells;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cellsRemoved(Object[] cells) {
        if (cells != null && cells.length > 0) {
            double scale = this.view.getScale();
            mxPoint tr = this.view.getTranslate();
            this.model.beginUpdate();
            try {
                for (int i = 0; i < cells.length; ++i) {
                    HashSet<Object> cellSet = new HashSet<Object>();
                    cellSet.addAll(Arrays.asList(cells));
                    Object[] edges = this.getConnections(cells[i]);
                    for (int j = 0; j < edges.length; ++j) {
                        mxCellState state;
                        mxGeometry geo;
                        if (cellSet.contains(edges[j]) || (geo = this.model.getGeometry(edges[j])) == null || (state = this.view.getState(edges[j])) == null) continue;
                        Object tmp = state.getVisibleTerminal(true);
                        boolean source = false;
                        while (tmp != null) {
                            if (cells[i] == tmp) {
                                source = true;
                                break;
                            }
                            tmp = this.model.getParent(tmp);
                        }
                        geo = (mxGeometry)geo.clone();
                        int n = source ? 0 : state.getAbsolutePointCount() - 1;
                        mxPoint pt = state.getAbsolutePoint(n);
                        geo.setTerminalPoint(new mxPoint(pt.getX() / scale - tr.getX(), pt.getY() / scale - tr.getY()), source);
                        this.model.setTerminal(edges[j], null, source);
                        this.model.setGeometry(edges[j], geo);
                    }
                    this.model.remove(cells[i]);
                }
                this.fireEvent(new mxEventObject("cellsRemoved", "cells", cells));
            }
            finally {
                this.model.endUpdate();
            }
        }
    }

    public Object splitEdge(Object edge, Object[] cells) {
        return this.splitEdge(edge, cells, null, 0.0, 0.0);
    }

    public Object splitEdge(Object edge, Object[] cells, double dx, double dy) {
        return this.splitEdge(edge, cells, null, dx, dy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object splitEdge(Object edge, Object[] cells, Object newEdge, double dx, double dy) {
        if (newEdge == null) {
            newEdge = this.cloneCells(new Object[]{edge})[0];
        }
        Object parent = this.model.getParent(edge);
        Object source = this.model.getTerminal(edge, true);
        this.model.beginUpdate();
        try {
            this.cellsMoved(cells, dx, dy, false, false);
            this.cellsAdded(cells, parent, this.model.getChildCount(parent), null, null, true);
            this.cellsAdded(new Object[]{newEdge}, parent, this.model.getChildCount(parent), source, cells[0], false);
            this.cellConnected(edge, cells[0], true, null);
            this.fireEvent(new mxEventObject("splitEdge", "edge", edge, "cells", cells, "newEdge", newEdge, "dx", dx, "dy", dy));
        }
        finally {
            this.model.endUpdate();
        }
        return newEdge;
    }

    public Object[] toggleCells(boolean show) {
        return this.toggleCells(show, null);
    }

    public Object[] toggleCells(boolean show, Object[] cells) {
        return this.toggleCells(show, cells, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toggleCells(boolean show, Object[] cells, boolean includeEdges) {
        if (cells == null) {
            cells = this.getSelectionCells();
        }
        if (includeEdges) {
            cells = this.addAllEdges(cells);
        }
        this.model.beginUpdate();
        try {
            this.cellsToggled(cells, show);
            this.fireEvent(new mxEventObject("toggleCells", "show", show, "cells", cells, "includeEdges", includeEdges));
        }
        finally {
            this.model.endUpdate();
        }
        return cells;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cellsToggled(Object[] cells, boolean show) {
        if (cells != null && cells.length > 0) {
            this.model.beginUpdate();
            try {
                for (int i = 0; i < cells.length; ++i) {
                    this.model.setVisible(cells[i], show);
                }
            }
            finally {
                this.model.endUpdate();
            }
        }
    }

    public Object[] foldCells(boolean collapse) {
        return this.foldCells(collapse, false);
    }

    public Object[] foldCells(boolean collapse, boolean recurse) {
        return this.foldCells(collapse, recurse, null);
    }

    public Object[] foldCells(boolean collapse, boolean recurse, Object[] cells) {
        return this.foldCells(collapse, recurse, cells, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] foldCells(boolean collapse, boolean recurse, Object[] cells, boolean checkFoldable) {
        if (cells == null) {
            cells = this.getFoldableCells(this.getSelectionCells(), collapse);
        }
        this.model.beginUpdate();
        try {
            this.cellsFolded(cells, collapse, recurse, checkFoldable);
            this.fireEvent(new mxEventObject("foldCells", "cells", cells, "collapse", collapse, "recurse", recurse));
        }
        finally {
            this.model.endUpdate();
        }
        return cells;
    }

    public void cellsFolded(Object[] cells, boolean collapse, boolean recurse) {
        this.cellsFolded(cells, collapse, recurse, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cellsFolded(Object[] cells, boolean collapse, boolean recurse, boolean checkFoldable) {
        if (cells != null && cells.length > 0) {
            this.model.beginUpdate();
            try {
                for (int i = 0; i < cells.length; ++i) {
                    if (checkFoldable && !this.isCellFoldable(cells[i], collapse) || collapse == this.isCellCollapsed(cells[i])) continue;
                    this.model.setCollapsed(cells[i], collapse);
                    this.swapBounds(cells[i], collapse);
                    if (this.isExtendParent(cells[i])) {
                        this.extendParent(cells[i]);
                    }
                    if (!recurse) continue;
                    Object[] children = mxGraphModel.getChildren(this.model, cells[i]);
                    this.cellsFolded(children, collapse, recurse);
                }
                this.fireEvent(new mxEventObject("cellsFolded", "cells", cells, "collapse", collapse, "recurse", recurse));
            }
            finally {
                this.model.endUpdate();
            }
        }
    }

    public void swapBounds(Object cell, boolean willCollapse) {
        mxGeometry geo;
        if (cell != null && (geo = this.model.getGeometry(cell)) != null) {
            geo = (mxGeometry)geo.clone();
            this.updateAlternateBounds(cell, geo, willCollapse);
            geo.swap();
            this.model.setGeometry(cell, geo);
        }
    }

    public void updateAlternateBounds(Object cell, mxGeometry geo, boolean willCollapse) {
        if (cell != null && geo != null) {
            if (geo.getAlternateBounds() == null) {
                mxRectangle bounds = null;
                if (this.isCollapseToPreferredSize()) {
                    bounds = this.getPreferredSizeForCell(cell);
                    if (this.isSwimlane(cell)) {
                        mxRectangle size = this.getStartSize(cell);
                        bounds.setHeight(Math.max(bounds.getHeight(), size.getHeight()));
                        bounds.setWidth(Math.max(bounds.getWidth(), size.getWidth()));
                    }
                }
                if (bounds == null) {
                    bounds = geo;
                }
                geo.setAlternateBounds(new mxRectangle(geo.getX(), geo.getY(), bounds.getWidth(), bounds.getHeight()));
            } else {
                geo.getAlternateBounds().setX(geo.getX());
                geo.getAlternateBounds().setY(geo.getY());
            }
        }
    }

    public Object[] addAllEdges(Object[] cells) {
        ArrayList<Object> allCells = new ArrayList<Object>(cells.length);
        allCells.addAll(Arrays.asList(cells));
        allCells.addAll(Arrays.asList(this.getAllEdges(cells)));
        return allCells.toArray();
    }

    public Object[] getAllEdges(Object[] cells) {
        ArrayList<Object> edges = new ArrayList<Object>();
        if (cells != null) {
            for (int i = 0; i < cells.length; ++i) {
                int edgeCount = this.model.getEdgeCount(cells[i]);
                for (int j = 0; j < edgeCount; ++j) {
                    edges.add(this.model.getEdgeAt(cells[i], j));
                }
                Object[] children = mxGraphModel.getChildren(this.model, cells[i]);
                edges.addAll(Arrays.asList(this.getAllEdges(children)));
            }
        }
        return edges.toArray();
    }

    public Object updateCellSize(Object cell) {
        return this.updateCellSize(cell, false);
    }

    public Object updateCellSize(Object cell, boolean ignoreChildren) {
        this.model.beginUpdate();
        try {
            this.cellSizeUpdated(cell, ignoreChildren);
            this.fireEvent(new mxEventObject("updateCellSize", "cell", cell, "ignoreChildren", ignoreChildren));
        }
        finally {
            this.model.endUpdate();
        }
        return cell;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cellSizeUpdated(Object cell, boolean ignoreChildren) {
        if (cell != null) {
            this.model.beginUpdate();
            try {
                mxRectangle size = this.getPreferredSizeForCell(cell);
                mxGeometry geo = this.model.getGeometry(cell);
                if (size != null && geo != null) {
                    mxRectangle bounds;
                    boolean collapsed = this.isCellCollapsed(cell);
                    geo = (mxGeometry)geo.clone();
                    if (this.isSwimlane(cell)) {
                        mxCellState state = this.view.getState(cell);
                        Map<String, Object> style = state != null ? state.getStyle() : this.getCellStyle(cell);
                        String cellStyle = this.model.getStyle(cell);
                        if (cellStyle == null) {
                            cellStyle = "";
                        }
                        if (mxUtils.isTrue(style, mxConstants.STYLE_HORIZONTAL, true)) {
                            cellStyle = mxStyleUtils.setStyle(cellStyle, mxConstants.STYLE_STARTSIZE, String.valueOf(size.getHeight() + 8.0));
                            if (collapsed) {
                                geo.setHeight(size.getHeight() + 8.0);
                            }
                            geo.setWidth(size.getWidth());
                        } else {
                            cellStyle = mxStyleUtils.setStyle(cellStyle, mxConstants.STYLE_STARTSIZE, String.valueOf(size.getWidth() + 8.0));
                            if (collapsed) {
                                geo.setWidth(size.getWidth() + 8.0);
                            }
                            geo.setHeight(size.getHeight());
                        }
                        this.model.setStyle(cell, cellStyle);
                    } else {
                        geo.setWidth(size.getWidth());
                        geo.setHeight(size.getHeight());
                    }
                    if (!ignoreChildren && !collapsed && (bounds = this.view.getBounds(mxGraphModel.getChildren(this.model, cell))) != null) {
                        mxPoint tr = this.view.getTranslate();
                        double scale = this.view.getScale();
                        double width = (bounds.getX() + bounds.getWidth()) / scale - geo.getX() - tr.getX();
                        double height = (bounds.getY() + bounds.getHeight()) / scale - geo.getY() - tr.getY();
                        geo.setWidth(Math.max(geo.getWidth(), width));
                        geo.setHeight(Math.max(geo.getHeight(), height));
                    }
                    this.cellsResized(new Object[]{cell}, new mxRectangle[]{geo});
                }
            }
            finally {
                this.model.endUpdate();
            }
        }
    }

    public mxRectangle getPreferredSizeForCell(Object cell) {
        mxRectangle result = null;
        if (cell != null) {
            Map<String, Object> style;
            mxCellState state = this.view.getState(cell);
            Map<String, Object> map = style = state != null ? state.style : this.getCellStyle(cell);
            if (style != null && !this.model.isEdge(cell)) {
                double dx = 0.0;
                double dy = 0.0;
                if ((this.getImage(state) != null || mxUtils.getString(style, mxConstants.STYLE_IMAGE) != null) && mxUtils.getString(style, mxConstants.STYLE_SHAPE, "").equals("label")) {
                    if (mxUtils.getString(style, mxConstants.STYLE_VERTICAL_ALIGN, "").equals("middle")) {
                        dx += mxUtils.getDouble(style, mxConstants.STYLE_IMAGE_WIDTH, mxConstants.DEFAULT_IMAGESIZE);
                    }
                    if (mxUtils.getString(style, mxConstants.STYLE_ALIGN, "").equals("center")) {
                        dy += mxUtils.getDouble(style, mxConstants.STYLE_IMAGE_HEIGHT, mxConstants.DEFAULT_IMAGESIZE);
                    }
                }
                double spacing = mxUtils.getDouble(style, mxConstants.STYLE_SPACING);
                dx += 2.0 * spacing;
                dx += mxUtils.getDouble(style, mxConstants.STYLE_SPACING_LEFT);
                dx += mxUtils.getDouble(style, mxConstants.STYLE_SPACING_RIGHT);
                dy += 2.0 * spacing;
                dy += mxUtils.getDouble(style, mxConstants.STYLE_SPACING_TOP);
                dy += mxUtils.getDouble(style, mxConstants.STYLE_SPACING_BOTTOM);
                String value = this.getLabel(cell);
                if (value != null && value.length() > 0) {
                    mxRectangle size = mxUtils.getLabelSize(value, style, this.isHtmlLabel(cell), 1.0);
                    double width = size.getWidth() + dx;
                    double height = size.getHeight() + dy;
                    if (!mxUtils.isTrue(style, mxConstants.STYLE_HORIZONTAL, true)) {
                        double tmp = height;
                        height = width;
                        width = tmp;
                    }
                    if (this.gridEnabled) {
                        width = this.snap(width + (double)(this.gridSize / 2));
                        height = this.snap(height + (double)(this.gridSize / 2));
                    }
                    result = new mxRectangle(0.0, 0.0, width, height);
                } else {
                    double gs2 = 4 * this.gridSize;
                    result = new mxRectangle(0.0, 0.0, gs2, gs2);
                }
            }
        }
        return result;
    }

    public Object resizeCell(Object cell, mxRectangle bounds) {
        return this.resizeCells(new Object[]{cell}, new mxRectangle[]{bounds})[0];
    }

    public Object[] resizeCells(Object[] cells, mxRectangle[] bounds) {
        this.model.beginUpdate();
        try {
            this.cellsResized(cells, bounds);
            this.fireEvent(new mxEventObject("resizeCells", "cells", cells, "bounds", bounds));
        }
        finally {
            this.model.endUpdate();
        }
        return cells;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cellsResized(Object[] cells, mxRectangle[] bounds) {
        if (cells != null && bounds != null && cells.length == bounds.length) {
            this.model.beginUpdate();
            try {
                for (int i = 0; i < cells.length; ++i) {
                    mxRectangle tmp = bounds[i];
                    mxGeometry geo = this.model.getGeometry(cells[i]);
                    if (geo == null || geo.getX() == tmp.getX() && geo.getY() == tmp.getY() && geo.getWidth() == tmp.getWidth() && geo.getHeight() == tmp.getHeight()) continue;
                    if ((geo = (mxGeometry)geo.clone()).isRelative()) {
                        mxPoint offset = geo.getOffset();
                        if (offset != null) {
                            offset.setX(offset.getX() + tmp.getX());
                            offset.setY(offset.getY() + tmp.getY());
                        }
                    } else {
                        geo.setX(tmp.getX());
                        geo.setY(tmp.getY());
                    }
                    geo.setWidth(tmp.getWidth());
                    geo.setHeight(tmp.getHeight());
                    if (!geo.isRelative() && this.model.isVertex(cells[i]) && !this.isAllowNegativeCoordinates()) {
                        geo.setX(Math.max(0.0, geo.getX()));
                        geo.setY(Math.max(0.0, geo.getY()));
                    }
                    this.model.setGeometry(cells[i], geo);
                    if (!this.isExtendParent(cells[i])) continue;
                    this.extendParent(cells[i]);
                }
                if (this.isResetEdgesOnResize()) {
                    this.resetEdges(cells);
                }
                this.fireEvent(new mxEventObject("cellsResized", "cells", cells, "bounds", bounds));
            }
            finally {
                this.model.endUpdate();
            }
        }
    }

    public void extendParent(Object cell) {
        if (cell != null) {
            mxGeometry geo;
            Object parent = this.model.getParent(cell);
            mxGeometry p = this.model.getGeometry(parent);
            if (parent != null && p != null && !this.isCellCollapsed(parent) && (geo = this.model.getGeometry(cell)) != null && (p.getWidth() < geo.getX() + geo.getWidth() || p.getHeight() < geo.getY() + geo.getHeight())) {
                p = (mxGeometry)p.clone();
                p.setWidth(Math.max(p.getWidth(), geo.getX() + geo.getWidth()));
                p.setHeight(Math.max(p.getHeight(), geo.getY() + geo.getHeight()));
                this.cellsResized(new Object[]{parent}, new mxRectangle[]{p});
            }
        }
    }

    public Object[] moveCells(Object[] cells, double dx, double dy) {
        return this.moveCells(cells, dx, dy, false);
    }

    public Object[] moveCells(Object[] cells, double dx, double dy, boolean clone) {
        return this.moveCells(cells, dx, dy, clone, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] moveCells(Object[] cells, double dx, double dy, boolean clone, Object target, Point location) {
        if (cells != null && (dx != 0.0 || dy != 0.0 || clone || target != null)) {
            this.model.beginUpdate();
            try {
                if (clone) {
                    cells = this.cloneCells(cells, this.isCloneInvalidEdges());
                    if (target == null) {
                        target = this.getDefaultParent();
                    }
                }
                boolean previous = this.isAllowNegativeCoordinates();
                if (target != null) {
                    this.setAllowNegativeCoordinates(true);
                }
                this.cellsMoved(cells, dx, dy, !clone && this.isDisconnectOnMove() && this.isAllowDanglingEdges(), target == null);
                this.setAllowNegativeCoordinates(previous);
                if (target != null) {
                    Integer index = this.model.getChildCount(target);
                    this.cellsAdded(cells, target, index, null, null, true);
                }
                this.fireEvent(new mxEventObject("moveCells", "cells", cells, "dx", dx, "dy", dy, "clone", clone, "target", target, "location", location));
            }
            finally {
                this.model.endUpdate();
            }
        }
        return cells;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cellsMoved(Object[] cells, double dx, double dy, boolean disconnect, boolean constrain) {
        if (cells != null && (dx != 0.0 || dy != 0.0)) {
            this.model.beginUpdate();
            try {
                if (disconnect) {
                    this.disconnectGraph(cells);
                }
                for (int i = 0; i < cells.length; ++i) {
                    this.translateCell(cells[i], dx, dy);
                    if (!constrain) continue;
                    this.constrainChild(cells[i]);
                }
                if (this.isResetEdgesOnMove()) {
                    this.resetEdges(cells);
                }
                this.fireEvent(new mxEventObject("cellsMoved", "cells", cells, "dx", dx, "dy", dy, "disconnect", disconnect));
            }
            finally {
                this.model.endUpdate();
            }
        }
    }

    public void translateCell(Object cell, double dx, double dy) {
        mxGeometry geo = this.model.getGeometry(cell);
        if (geo != null) {
            geo = (mxGeometry)geo.clone();
            geo.translate(dx, dy);
            if (!geo.isRelative() && this.model.isVertex(cell) && !this.isAllowNegativeCoordinates()) {
                geo.setX(Math.max(0.0, geo.getX()));
                geo.setY(Math.max(0.0, geo.getY()));
            }
            if (geo.isRelative() && !this.model.isEdge(cell)) {
                if (geo.getOffset() == null) {
                    geo.setOffset(new mxPoint(dx, dy));
                } else {
                    mxPoint offset = geo.getOffset();
                    offset.setX(offset.getX() + dx);
                    offset.setY(offset.getY() + dy);
                }
            }
            this.model.setGeometry(cell, geo);
        }
    }

    public mxRectangle getCellContainmentArea(Object cell) {
        if (cell != null && !this.model.isEdge(cell)) {
            mxGeometry g;
            Object parent = this.model.getParent(cell);
            if (parent == this.getDefaultParent() || parent == this.getCurrentRoot()) {
                return this.getMaximumGraphBounds();
            }
            if (parent != null && parent != this.getDefaultParent() && (g = this.model.getGeometry(parent)) != null) {
                double x = 0.0;
                double y = 0.0;
                double w = g.getWidth();
                double h = g.getHeight();
                if (this.isSwimlane(parent)) {
                    mxRectangle size = this.getStartSize(parent);
                    x = size.getWidth();
                    w -= size.getWidth();
                    y = size.getHeight();
                    h -= size.getHeight();
                }
                return new mxRectangle(x, y, w, h);
            }
        }
        return null;
    }

    public mxRectangle getMaximumGraphBounds() {
        return this.maximumGraphBounds;
    }

    public void setMaximumGraphBounds(mxRectangle value) {
        mxRectangle oldValue = this.maximumGraphBounds;
        this.maximumGraphBounds = value;
        this.changeSupport.firePropertyChange("maximumGraphBounds", oldValue, this.maximumGraphBounds);
    }

    public void constrainChild(Object cell) {
        if (cell != null) {
            mxRectangle area;
            mxGeometry geo = this.model.getGeometry(cell);
            mxRectangle mxRectangle2 = area = this.isConstrainChild(cell) ? this.getCellContainmentArea(cell) : this.getMaximumGraphBounds();
            if (geo != null && area != null && !geo.isRelative() && (geo.getX() < area.getX() || geo.getY() < area.getY() || area.getWidth() < geo.getX() + geo.getWidth() || area.getHeight() < geo.getY() + geo.getHeight())) {
                double overlap = this.getOverlap(cell);
                if (area.getWidth() > 0.0) {
                    geo.setX(Math.min(geo.getX(), area.getX() + area.getWidth() - (1.0 - overlap) * geo.getWidth()));
                }
                if (area.getHeight() > 0.0) {
                    geo.setY(Math.min(geo.getY(), area.getY() + area.getHeight() - (1.0 - overlap) * geo.getHeight()));
                }
                geo.setX(Math.max(geo.getX(), area.getX() - geo.getWidth() * overlap));
                geo.setY(Math.max(geo.getY(), area.getY() - geo.getHeight() * overlap));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetEdges(Object[] cells) {
        if (cells != null) {
            HashSet<Object> set = new HashSet<Object>(Arrays.asList(cells));
            this.model.beginUpdate();
            try {
                for (int i = 0; i < cells.length; ++i) {
                    Object[] edges = mxGraphModel.getEdges(this.model, cells[i]);
                    if (edges != null) {
                        for (int j = 0; j < edges.length; ++j) {
                            Object target;
                            mxCellState state = this.view.getState(edges[j]);
                            Object source = state != null ? state.getVisibleTerminal(true) : this.view.getVisibleTerminal(edges[j], true);
                            Object object = target = state != null ? state.getVisibleTerminal(false) : this.view.getVisibleTerminal(edges[j], false);
                            if (set.contains(source) && set.contains(target)) continue;
                            this.resetEdge(edges[j]);
                        }
                    }
                    this.resetEdges(mxGraphModel.getChildren(this.model, cells[i]));
                }
            }
            finally {
                this.model.endUpdate();
            }
        }
    }

    public Object resetEdge(Object edge) {
        List<mxPoint> points;
        mxGeometry geo = this.model.getGeometry(edge);
        if (geo != null && (points = geo.getPoints()) != null && !points.isEmpty()) {
            geo = (mxGeometry)geo.clone();
            geo.setPoints(null);
            this.model.setGeometry(edge, geo);
        }
        return edge;
    }

    public mxConnectionConstraint[] getAllConnectionConstraints(mxCellState terminal, boolean source) {
        return null;
    }

    public mxConnectionConstraint getConnectionConstraint(mxCellState edge, mxCellState terminal, boolean source) {
        Object y;
        mxPoint point = null;
        Object x = edge.getStyle().get(source ? mxConstants.STYLE_EXIT_X : mxConstants.STYLE_ENTRY_X);
        if (x != null && (y = edge.getStyle().get(source ? mxConstants.STYLE_EXIT_Y : mxConstants.STYLE_ENTRY_Y)) != null) {
            point = new mxPoint(Double.parseDouble(x.toString()), Double.parseDouble(y.toString()));
        }
        boolean perimeter = false;
        if (point != null) {
            perimeter = mxUtils.isTrue(edge.style, source ? mxConstants.STYLE_EXIT_PERIMETER : mxConstants.STYLE_ENTRY_PERIMETER, true);
        }
        return new mxConnectionConstraint(point, perimeter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConnectionConstraint(Object edge, Object terminal, boolean source, mxConnectionConstraint constraint) {
        if (constraint != null) {
            this.model.beginUpdate();
            try {
                Object[] cells = new Object[]{edge};
                if (constraint == null || constraint.point == null) {
                    this.setCellStyles(source ? mxConstants.STYLE_EXIT_X : mxConstants.STYLE_ENTRY_X, null, cells);
                    this.setCellStyles(source ? mxConstants.STYLE_EXIT_Y : mxConstants.STYLE_ENTRY_Y, null, cells);
                    this.setCellStyles(source ? mxConstants.STYLE_EXIT_PERIMETER : mxConstants.STYLE_ENTRY_PERIMETER, null, cells);
                } else if (constraint.point != null) {
                    this.setCellStyles(source ? mxConstants.STYLE_EXIT_X : mxConstants.STYLE_ENTRY_X, String.valueOf(constraint.point.getX()), cells);
                    this.setCellStyles(source ? mxConstants.STYLE_EXIT_Y : mxConstants.STYLE_ENTRY_Y, String.valueOf(constraint.point.getY()), cells);
                    if (!constraint.perimeter) {
                        this.setCellStyles(source ? mxConstants.STYLE_EXIT_PERIMETER : mxConstants.STYLE_ENTRY_PERIMETER, "0", cells);
                    } else {
                        this.setCellStyles(source ? mxConstants.STYLE_EXIT_PERIMETER : mxConstants.STYLE_ENTRY_PERIMETER, null, cells);
                    }
                }
            }
            finally {
                this.model.endUpdate();
            }
        }
    }

    public mxPoint getConnectionPoint(mxCellState vertex, mxConnectionConstraint constraint) {
        mxPoint point = null;
        if (vertex != null && constraint.point != null) {
            mxRectangle bounds = this.view.getPerimeterBounds(vertex, 0.0);
            mxPoint cx = new mxPoint(bounds.getCenterX(), bounds.getCenterY());
            String direction = mxUtils.getString(vertex.getStyle(), mxConstants.STYLE_DIRECTION);
            double r1 = 0.0;
            if (direction != null) {
                if (direction.equals("north")) {
                    r1 += 270.0;
                } else if (direction.equals("west")) {
                    r1 += 180.0;
                } else if (direction.equals("south")) {
                    r1 += 90.0;
                }
                if (direction == "north" || direction == "south") {
                    bounds.rotate90();
                }
            }
            point = new mxPoint(bounds.getX() + constraint.point.getX() * bounds.getWidth(), bounds.getY() + constraint.point.getY() * bounds.getHeight());
            double r2 = mxUtils.getDouble(vertex.getStyle(), mxConstants.STYLE_ROTATION);
            if (constraint.perimeter) {
                if (r1 != 0.0) {
                    double cos = 0.0;
                    double sin = 0.0;
                    if (r1 == 90.0) {
                        sin = 1.0;
                    } else if (r1 == 180.0) {
                        cos = -1.0;
                    } else if (r1 == 270.0) {
                        sin = -1.0;
                    }
                    point = mxUtils.getRotatedPoint(point, cos, sin, cx);
                }
                point = this.view.getPerimeterPoint(vertex, point, false);
            } else {
                r2 += r1;
                if (this.getModel().isVertex(vertex.cell)) {
                    boolean flipH = mxUtils.getString(vertex.getStyle(), mxConstants.STYLE_FLIPH).equals(1);
                    boolean flipV = mxUtils.getString(vertex.getStyle(), mxConstants.STYLE_FLIPV).equals(1);
                    if (flipH) {
                        point.setX(2.0 * bounds.getCenterX() - point.getX());
                    }
                    if (flipV) {
                        point.setY(2.0 * bounds.getCenterY() - point.getY());
                    }
                }
            }
            if (r2 != 0.0 && point != null) {
                double rad = Math.toRadians(2.0);
                double cos = Math.cos(rad);
                double sin = Math.sin(rad);
                point = mxUtils.getRotatedPoint(point, cos, sin, cx);
            }
        }
        if (point != null) {
            point.setX(Math.round(point.getX()));
            point.setY(Math.round(point.getY()));
        }
        return point;
    }

    public Object connectCell(Object edge, Object terminal, boolean source) {
        return this.connectCell(edge, terminal, source, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object connectCell(Object edge, Object terminal, boolean source, mxConnectionConstraint constraint) {
        this.model.beginUpdate();
        try {
            Object previous = this.model.getTerminal(edge, source);
            this.cellConnected(edge, terminal, source, constraint);
            this.fireEvent(new mxEventObject("connectCell", "edge", edge, "terminal", terminal, "source", source, "previous", previous));
        }
        finally {
            this.model.endUpdate();
        }
        return edge;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cellConnected(Object edge, Object terminal, boolean source, mxConnectionConstraint constraint) {
        if (edge != null) {
            this.model.beginUpdate();
            try {
                Object previous = this.model.getTerminal(edge, source);
                this.setConnectionConstraint(edge, terminal, source, constraint);
                if (this.isPortsEnabled()) {
                    String id = null;
                    if (this.isPort(terminal) && terminal instanceof mxICell) {
                        id = ((mxICell)terminal).getId();
                        terminal = this.getTerminalForPort(terminal, source);
                    }
                    String key = source ? mxConstants.STYLE_SOURCE_PORT : mxConstants.STYLE_TARGET_PORT;
                    this.setCellStyles(key, id, new Object[]{edge});
                }
                this.model.setTerminal(edge, terminal, source);
                if (this.isResetEdgesOnConnect()) {
                    this.resetEdge(edge);
                }
                this.fireEvent(new mxEventObject("cellConnected", "edge", edge, "terminal", terminal, "source", source, "previous", previous));
            }
            finally {
                this.model.endUpdate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnectGraph(Object[] cells) {
        if (cells != null) {
            this.model.beginUpdate();
            try {
                int i;
                double scale = this.view.getScale();
                mxPoint tr = this.view.getTranslate();
                HashSet<Object> hash = new HashSet<Object>();
                for (i = 0; i < cells.length; ++i) {
                    hash.add(cells[i]);
                }
                for (i = 0; i < cells.length; ++i) {
                    mxGeometry geo;
                    if (!this.model.isEdge(cells[i]) || (geo = this.model.getGeometry(cells[i])) == null) continue;
                    mxCellState state = this.view.getState(cells[i]);
                    mxCellState pstate = this.view.getState(this.model.getParent(cells[i]));
                    if (state != null && pstate != null) {
                        Object trg;
                        geo = (mxGeometry)geo.clone();
                        double dx = -pstate.getOrigin().getX();
                        double dy = -pstate.getOrigin().getY();
                        Object src = this.model.getTerminal(cells[i], true);
                        if (src != null && this.isCellDisconnectable(cells[i], src, true)) {
                            while (src != null && !hash.contains(src)) {
                                src = this.model.getParent(src);
                            }
                            if (src == null) {
                                mxPoint pt = state.getAbsolutePoint(0);
                                geo.setTerminalPoint(new mxPoint(pt.getX() / scale - tr.getX() + dx, pt.getY() / scale - tr.getY() + dy), true);
                                this.model.setTerminal(cells[i], null, true);
                            }
                        }
                        if ((trg = this.model.getTerminal(cells[i], false)) != null && this.isCellDisconnectable(cells[i], trg, false)) {
                            while (trg != null && !hash.contains(trg)) {
                                trg = this.model.getParent(trg);
                            }
                            if (trg == null) {
                                int n = state.getAbsolutePointCount() - 1;
                                mxPoint pt = state.getAbsolutePoint(n);
                                geo.setTerminalPoint(new mxPoint(pt.getX() / scale - tr.getX() + dx, pt.getY() / scale - tr.getY() + dy), false);
                                this.model.setTerminal(cells[i], null, false);
                            }
                        }
                    }
                    this.model.setGeometry(cells[i], geo);
                }
            }
            finally {
                this.model.endUpdate();
            }
        }
    }

    public Object getCurrentRoot() {
        return this.view.getCurrentRoot();
    }

    public mxPoint getTranslateForRoot(Object cell) {
        return null;
    }

    public boolean isPort(Object cell) {
        return false;
    }

    public Object getTerminalForPort(Object cell, boolean source) {
        return this.getModel().getParent(cell);
    }

    public mxPoint getChildOffsetForCell(Object cell) {
        return null;
    }

    public void enterGroup() {
        this.enterGroup(null);
    }

    public void enterGroup(Object cell) {
        if (cell == null) {
            cell = this.getSelectionCell();
        }
        if (cell != null && this.isValidRoot(cell)) {
            this.view.setCurrentRoot(cell);
            this.clearSelection();
        }
    }

    public void exitGroup() {
        Object root = this.model.getRoot();
        Object current = this.getCurrentRoot();
        if (current != null) {
            Object next = this.model.getParent(current);
            while (next != root && !this.isValidRoot(next) && this.model.getParent(next) != root) {
                next = this.model.getParent(next);
            }
            if (next == root || this.model.getParent(next) == root) {
                this.view.setCurrentRoot(null);
            } else {
                this.view.setCurrentRoot(next);
            }
            mxCellState state = this.view.getState(current);
            if (state != null) {
                this.setSelectionCell(current);
            }
        }
    }

    public void home() {
        Object current = this.getCurrentRoot();
        if (current != null) {
            this.view.setCurrentRoot(null);
            mxCellState state = this.view.getState(current);
            if (state != null) {
                this.setSelectionCell(current);
            }
        }
    }

    public boolean isValidRoot(Object cell) {
        return cell != null;
    }

    public mxRectangle getGraphBounds() {
        return this.view.getGraphBounds();
    }

    public mxRectangle getCellBounds(Object cell) {
        return this.getCellBounds(cell, false);
    }

    public mxRectangle getCellBounds(Object cell, boolean includeEdges) {
        return this.getCellBounds(cell, includeEdges, false);
    }

    public mxRectangle getCellBounds(Object cell, boolean includeEdges, boolean includeDescendants) {
        return this.getCellBounds(cell, includeEdges, includeDescendants, false);
    }

    public mxRectangle getBoundingBoxFromGeometry(Object[] cells) {
        mxRectangle result = null;
        if (cells != null) {
            for (int i = 0; i < cells.length; ++i) {
                if (!this.getModel().isVertex(cells[i])) continue;
                mxGeometry geo = this.getCellGeometry(cells[i]);
                if (result == null) {
                    result = new mxRectangle(geo);
                    continue;
                }
                result.add(geo);
            }
        }
        return result;
    }

    public mxRectangle getBoundingBox(Object cell) {
        return this.getBoundingBox(cell, false);
    }

    public mxRectangle getBoundingBox(Object cell, boolean includeEdges) {
        return this.getBoundingBox(cell, includeEdges, false);
    }

    public mxRectangle getBoundingBox(Object cell, boolean includeEdges, boolean includeDescendants) {
        return this.getCellBounds(cell, includeEdges, includeDescendants, true);
    }

    public mxRectangle getPaintBounds(Object[] cells) {
        return this.getBoundsForCells(cells, false, true, true);
    }

    public mxRectangle getBoundsForCells(Object[] cells, boolean includeEdges, boolean includeDescendants, boolean boundingBox) {
        mxRectangle result = null;
        if (cells != null && cells.length > 0) {
            for (int i = 0; i < cells.length; ++i) {
                mxRectangle tmp = this.getCellBounds(cells[i], includeEdges, includeDescendants, boundingBox);
                if (tmp == null) continue;
                if (result == null) {
                    result = new mxRectangle(tmp);
                    continue;
                }
                result.add(tmp);
            }
        }
        return result;
    }

    public mxRectangle getCellBounds(Object cell, boolean includeEdges, boolean includeDescendants, boolean boundingBox) {
        Object[] cells;
        if (includeEdges) {
            HashSet<Object> allCells = new HashSet<Object>();
            allCells.add(cell);
            HashSet<Object> edges = new HashSet<Object>(Arrays.asList(this.getEdges(cell)));
            while (!edges.isEmpty() && !allCells.containsAll(edges)) {
                allCells.addAll(edges);
                HashSet<Object> tmp = new HashSet<Object>();
                for (Object e : edges) {
                    tmp.addAll(Arrays.asList(this.getEdges(e)));
                }
                edges = tmp;
            }
            cells = allCells.toArray();
        } else {
            cells = new Object[]{cell};
        }
        mxRectangle result = this.view.getBounds(cells, boundingBox);
        if (includeDescendants) {
            for (int i = 0; i < cells.length; ++i) {
                int childCount = this.model.getChildCount(cells[i]);
                for (int j = 0; j < childCount; ++j) {
                    mxRectangle mxRectangle2 = this.getCellBounds(this.model.getChildAt(cells[i], j), includeEdges, true, boundingBox);
                    if (result != null) {
                        result.add(mxRectangle2);
                        continue;
                    }
                    result = mxRectangle2;
                }
            }
        }
        return result;
    }

    public void refresh() {
        this.view.reload();
        this.repaint();
    }

    public void repaint() {
        this.repaint(null);
    }

    public void repaint(mxRectangle region) {
        this.fireEvent(new mxEventObject("repaint", "region", region));
    }

    public double snap(double value) {
        if (this.gridEnabled) {
            value = Math.round(value / (double)this.gridSize) * (long)this.gridSize;
        }
        return value;
    }

    public mxGeometry getCellGeometry(Object cell) {
        return this.model.getGeometry(cell);
    }

    public boolean isCellVisible(Object cell) {
        return this.model.isVisible(cell);
    }

    public boolean isCellCollapsed(Object cell) {
        return this.model.isCollapsed(cell);
    }

    public boolean isCellConnectable(Object cell) {
        return this.model.isConnectable(cell);
    }

    public boolean isOrthogonal(mxCellState edge) {
        if (edge.getStyle().containsKey(mxConstants.STYLE_ORTHOGONAL)) {
            return mxUtils.isTrue(edge.getStyle(), mxConstants.STYLE_ORTHOGONAL);
        }
        mxEdgeStyle.mxEdgeStyleFunction tmp = this.view.getEdgeStyle(edge, null, null, null);
        return tmp == mxEdgeStyle.SegmentConnector || tmp == mxEdgeStyle.ElbowConnector || tmp == mxEdgeStyle.SideToSide || tmp == mxEdgeStyle.TopToBottom || tmp == mxEdgeStyle.EntityRelation || tmp == mxEdgeStyle.OrthConnector;
    }

    public boolean isLoop(mxCellState state) {
        mxCellState src = state.getVisibleTerminalState(true);
        mxCellState trg = state.getVisibleTerminalState(false);
        return src != null && src == trg;
    }

    public void setMultiplicities(mxMultiplicity[] value) {
        mxMultiplicity[] oldValue = this.multiplicities;
        this.multiplicities = value;
        this.changeSupport.firePropertyChange("multiplicities", oldValue, this.multiplicities);
    }

    public mxMultiplicity[] getMultiplicities() {
        return this.multiplicities;
    }

    public boolean isEdgeValid(Object edge, Object source, Object target) {
        return this.getEdgeValidationError(edge, source, target) == null;
    }

    public String getEdgeValidationError(Object edge, Object source, Object target) {
        if (!(edge == null || this.isAllowDanglingEdges() || source != null && target != null)) {
            return "";
        }
        if (edge != null && this.model.getTerminal(edge, true) == null && this.model.getTerminal(edge, false) == null) {
            return null;
        }
        if (!this.isAllowLoops() && source == target && source != null) {
            return "";
        }
        if (!this.isValidConnection(source, target)) {
            return "";
        }
        if (source != null && target != null) {
            String err;
            Object[] tmp;
            StringBuffer error = new StringBuffer();
            if (!this.multigraph && ((tmp = mxGraphModel.getEdgesBetween(this.model, source, target, true)).length > 1 || tmp.length == 1 && tmp[0] != edge)) {
                error.append(mxResources.get("alreadyConnected", "Already Connected") + "\n");
            }
            int sourceOut = mxGraphModel.getDirectedEdgeCount(this.model, source, true, edge);
            int targetIn = mxGraphModel.getDirectedEdgeCount(this.model, target, false, edge);
            if (this.multiplicities != null) {
                for (int i = 0; i < this.multiplicities.length; ++i) {
                    String err2 = this.multiplicities[i].check(this, edge, source, target, sourceOut, targetIn);
                    if (err2 == null) continue;
                    error.append(err2);
                }
            }
            if ((err = this.validateEdge(edge, source, target)) != null) {
                error.append(err);
            }
            return error.length() > 0 ? error.toString() : null;
        }
        return this.allowDanglingEdges ? null : "";
    }

    public String validateEdge(Object edge, Object source, Object target) {
        return null;
    }

    public String getCellValidationError(Object cell) {
        int outCount = mxGraphModel.getDirectedEdgeCount(this.model, cell, true);
        int inCount = mxGraphModel.getDirectedEdgeCount(this.model, cell, false);
        StringBuffer error = new StringBuffer();
        Object value = this.model.getValue(cell);
        if (this.multiplicities != null) {
            for (int i = 0; i < this.multiplicities.length; ++i) {
                mxMultiplicity rule = this.multiplicities[i];
                int max = rule.getMaxValue();
                if (rule.source && mxUtils.isNode(value, rule.type, rule.attr, rule.value) && (max == 0 && outCount > 0 || rule.min == 1 && outCount == 0 || max == 1 && outCount > 1)) {
                    error.append(rule.countError + '\n');
                    continue;
                }
                if (rule.source || !mxUtils.isNode(value, rule.type, rule.attr, rule.value) || !(max == 0 && inCount > 0 || rule.min == 1 && inCount == 0) && (max != 1 || inCount <= 1)) continue;
                error.append(rule.countError + '\n');
            }
        }
        return error.length() > 0 ? error.toString() : null;
    }

    public String validateCell(Object cell, Hashtable<Object, Object> context) {
        return null;
    }

    public boolean isLabelsVisible() {
        return this.labelsVisible;
    }

    public void setLabelsVisible(boolean value) {
        boolean oldValue = this.labelsVisible;
        this.labelsVisible = value;
        this.changeSupport.firePropertyChange("labelsVisible", oldValue, this.labelsVisible);
    }

    public void setHtmlLabels(boolean value) {
        boolean oldValue = this.htmlLabels;
        this.htmlLabels = value;
        this.changeSupport.firePropertyChange("htmlLabels", oldValue, this.htmlLabels);
    }

    public boolean isHtmlLabels() {
        return this.htmlLabels;
    }

    public String convertValueToString(Object cell) {
        Object result = this.model.getValue(cell);
        return result != null ? result.toString() : "";
    }

    public String getLabel(Object cell) {
        String result = "";
        if (cell != null) {
            Map<String, Object> style;
            mxCellState state = this.view.getState(cell);
            Map<String, Object> map = style = state != null ? state.getStyle() : this.getCellStyle(cell);
            if (this.labelsVisible && !mxUtils.isTrue(style, mxConstants.STYLE_NOLABEL, false)) {
                result = this.convertValueToString(cell);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cellLabelChanged(Object cell, Object value, boolean autoSize) {
        this.model.beginUpdate();
        try {
            this.getModel().setValue(cell, value);
            if (autoSize) {
                this.cellSizeUpdated(cell, false);
            }
        }
        finally {
            this.model.endUpdate();
        }
    }

    public boolean isHtmlLabel(Object cell) {
        return this.isHtmlLabels();
    }

    public String getToolTipForCell(Object cell) {
        return this.convertValueToString(cell);
    }

    public mxRectangle getStartSize(Object swimlane) {
        Map<String, Object> style;
        mxRectangle result = new mxRectangle();
        mxCellState state = this.view.getState(swimlane);
        Map<String, Object> map = style = state != null ? state.getStyle() : this.getCellStyle(swimlane);
        if (style != null) {
            double size = mxUtils.getDouble(style, mxConstants.STYLE_STARTSIZE, mxConstants.DEFAULT_STARTSIZE);
            if (mxUtils.isTrue(style, mxConstants.STYLE_HORIZONTAL, true)) {
                result.setHeight(size);
            } else {
                result.setWidth(size);
            }
        }
        return result;
    }

    public String getImage(mxCellState state) {
        return state != null && state.getStyle() != null ? mxUtils.getString(state.getStyle(), mxConstants.STYLE_IMAGE) : null;
    }

    public int getBorder() {
        return this.border;
    }

    public void setBorder(int value) {
        this.border = value;
    }

    public mxEdgeStyle.mxEdgeStyleFunction getDefaultLoopStyle() {
        return this.defaultLoopStyle;
    }

    public void setDefaultLoopStyle(mxEdgeStyle.mxEdgeStyleFunction value) {
        mxEdgeStyle.mxEdgeStyleFunction oldValue = this.defaultLoopStyle;
        this.defaultLoopStyle = value;
        this.changeSupport.firePropertyChange("defaultLoopStyle", oldValue, this.defaultLoopStyle);
    }

    public boolean isSwimlane(Object cell) {
        if (cell != null && this.model.getParent(cell) != this.model.getRoot()) {
            Map<String, Object> style;
            mxCellState state = this.view.getState(cell);
            Map<String, Object> map = style = state != null ? state.getStyle() : this.getCellStyle(cell);
            if (style != null && !this.model.isEdge(cell)) {
                return mxUtils.getString(style, mxConstants.STYLE_SHAPE, "").equals("swimlane");
            }
        }
        return false;
    }

    public boolean isCellLocked(Object cell) {
        mxGeometry geometry = this.model.getGeometry(cell);
        return this.isCellsLocked() || geometry != null && this.model.isVertex(cell) && geometry.isRelative();
    }

    public boolean isCellsLocked() {
        return this.cellsLocked;
    }

    public void setCellsLocked(boolean value) {
        boolean oldValue = this.cellsLocked;
        this.cellsLocked = value;
        this.changeSupport.firePropertyChange("cellsLocked", oldValue, this.cellsLocked);
    }

    public boolean isCellEditable(Object cell) {
        mxCellState state = this.view.getState(cell);
        Map<String, Object> style = state != null ? state.getStyle() : this.getCellStyle(cell);
        return this.isCellsEditable() && !this.isCellLocked(cell) && mxUtils.isTrue(style, mxConstants.STYLE_EDITABLE, true);
    }

    public boolean isCellsEditable() {
        return this.cellsEditable;
    }

    public void setCellsEditable(boolean value) {
        boolean oldValue = this.cellsEditable;
        this.cellsEditable = value;
        this.changeSupport.firePropertyChange("cellsEditable", oldValue, this.cellsEditable);
    }

    public boolean isCellResizable(Object cell) {
        mxCellState state = this.view.getState(cell);
        Map<String, Object> style = state != null ? state.getStyle() : this.getCellStyle(cell);
        return this.isCellsResizable() && !this.isCellLocked(cell) && mxUtils.isTrue(style, mxConstants.STYLE_RESIZABLE, true);
    }

    public boolean isCellsResizable() {
        return this.cellsResizable;
    }

    public void setCellsResizable(boolean value) {
        boolean oldValue = this.cellsResizable;
        this.cellsResizable = value;
        this.changeSupport.firePropertyChange("cellsResizable", oldValue, this.cellsResizable);
    }

    public Object[] getMovableCells(Object[] cells) {
        return mxGraphModel.filterCells(cells, new mxGraphModel.Filter(){

            public boolean filter(Object cell) {
                return mxGraph.this.isCellMovable(cell);
            }
        });
    }

    public boolean isCellMovable(Object cell) {
        mxCellState state = this.view.getState(cell);
        Map<String, Object> style = state != null ? state.getStyle() : this.getCellStyle(cell);
        return this.isCellsMovable() && !this.isCellLocked(cell) && mxUtils.isTrue(style, mxConstants.STYLE_MOVABLE, true);
    }

    public boolean isCellsMovable() {
        return this.cellsMovable;
    }

    public void setCellsMovable(boolean value) {
        boolean oldValue = this.cellsMovable;
        this.cellsMovable = value;
        this.changeSupport.firePropertyChange("cellsMovable", oldValue, this.cellsMovable);
    }

    public boolean isTerminalPointMovable(Object cell, boolean source) {
        return true;
    }

    public boolean isCellBendable(Object cell) {
        mxCellState state = this.view.getState(cell);
        Map<String, Object> style = state != null ? state.getStyle() : this.getCellStyle(cell);
        return this.isCellsBendable() && !this.isCellLocked(cell) && mxUtils.isTrue(style, mxConstants.STYLE_BENDABLE, true);
    }

    public boolean isCellsBendable() {
        return this.cellsBendable;
    }

    public void setCellsBendable(boolean value) {
        boolean oldValue = this.cellsBendable;
        this.cellsBendable = value;
        this.changeSupport.firePropertyChange("cellsBendable", oldValue, this.cellsBendable);
    }

    public boolean isCellSelectable(Object cell) {
        return this.isCellsSelectable();
    }

    public boolean isCellsSelectable() {
        return this.cellsSelectable;
    }

    public void setCellsSelectable(boolean value) {
        boolean oldValue = this.cellsSelectable;
        this.cellsSelectable = value;
        this.changeSupport.firePropertyChange("cellsSelectable", oldValue, this.cellsSelectable);
    }

    public Object[] getDeletableCells(Object[] cells) {
        return mxGraphModel.filterCells(cells, new mxGraphModel.Filter(){

            public boolean filter(Object cell) {
                return mxGraph.this.isCellDeletable(cell);
            }
        });
    }

    public boolean isCellDeletable(Object cell) {
        mxCellState state = this.view.getState(cell);
        Map<String, Object> style = state != null ? state.getStyle() : this.getCellStyle(cell);
        return this.isCellsDeletable() && mxUtils.isTrue(style, mxConstants.STYLE_DELETABLE, true);
    }

    public boolean isCellsDeletable() {
        return this.cellsDeletable;
    }

    public void setCellsDeletable(boolean value) {
        boolean oldValue = this.cellsDeletable;
        this.cellsDeletable = value;
        this.changeSupport.firePropertyChange("cellsDeletable", oldValue, this.cellsDeletable);
    }

    public Object[] getCloneableCells(Object[] cells) {
        return mxGraphModel.filterCells(cells, new mxGraphModel.Filter(){

            public boolean filter(Object cell) {
                return mxGraph.this.isCellCloneable(cell);
            }
        });
    }

    public boolean isCellCloneable(Object cell) {
        mxCellState state = this.view.getState(cell);
        Map<String, Object> style = state != null ? state.getStyle() : this.getCellStyle(cell);
        return this.isCellsCloneable() && mxUtils.isTrue(style, mxConstants.STYLE_CLONEABLE, true);
    }

    public boolean isCellsCloneable() {
        return this.cellsCloneable;
    }

    public void setCellsCloneable(boolean value) {
        boolean oldValue = this.cellsCloneable;
        this.cellsCloneable = value;
        this.changeSupport.firePropertyChange("cellsCloneable", oldValue, this.cellsCloneable);
    }

    public boolean isCellDisconnectable(Object cell, Object terminal, boolean source) {
        return this.isCellsDisconnectable() && !this.isCellLocked(cell);
    }

    public boolean isCellsDisconnectable() {
        return this.cellsDisconnectable;
    }

    public void setCellsDisconnectable(boolean value) {
        boolean oldValue = this.cellsDisconnectable;
        this.cellsDisconnectable = value;
        this.changeSupport.firePropertyChange("cellsDisconnectable", oldValue, this.cellsDisconnectable);
    }

    public boolean isLabelClipped(Object cell) {
        if (!this.isLabelsClipped()) {
            mxCellState state = this.view.getState(cell);
            Map<String, Object> style = state != null ? state.getStyle() : this.getCellStyle(cell);
            return style != null ? mxUtils.getString(style, mxConstants.STYLE_OVERFLOW, "").equals("hidden") : false;
        }
        return this.isLabelsClipped();
    }

    public boolean isLabelsClipped() {
        return this.labelsClipped;
    }

    public void setLabelsClipped(boolean value) {
        boolean oldValue = this.labelsClipped;
        this.labelsClipped = value;
        this.changeSupport.firePropertyChange("labelsClipped", oldValue, this.labelsClipped);
    }

    public boolean isLabelMovable(Object cell) {
        return !this.isCellLocked(cell) && (this.model.isEdge(cell) && this.isEdgeLabelsMovable() || this.model.isVertex(cell) && this.isVertexLabelsMovable());
    }

    public boolean isVertexLabelsMovable() {
        return this.vertexLabelsMovable;
    }

    public void setVertexLabelsMovable(boolean value) {
        boolean oldValue = this.vertexLabelsMovable;
        this.vertexLabelsMovable = value;
        this.changeSupport.firePropertyChange("vertexLabelsMovable", oldValue, this.vertexLabelsMovable);
    }

    public boolean isEdgeLabelsMovable() {
        return this.edgeLabelsMovable;
    }

    public void setEdgeLabelsMovable(boolean value) {
        boolean oldValue = this.edgeLabelsMovable;
        this.edgeLabelsMovable = value;
        this.changeSupport.firePropertyChange("edgeLabelsMovable", oldValue, this.edgeLabelsMovable);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean value) {
        boolean oldValue = this.enabled;
        this.enabled = value;
        this.changeSupport.firePropertyChange("enabled", oldValue, this.enabled);
    }

    public boolean isDropEnabled() {
        return this.dropEnabled;
    }

    public void setDropEnabled(boolean value) {
        boolean oldValue = this.dropEnabled;
        this.dropEnabled = value;
        this.changeSupport.firePropertyChange("dropEnabled", oldValue, this.dropEnabled);
    }

    public boolean isSplitEnabled() {
        return this.splitEnabled;
    }

    public void setSplitEnabled(boolean value) {
        this.splitEnabled = value;
    }

    public boolean isMultigraph() {
        return this.multigraph;
    }

    public void setMultigraph(boolean value) {
        boolean oldValue = this.multigraph;
        this.multigraph = value;
        this.changeSupport.firePropertyChange("multigraph", oldValue, this.multigraph);
    }

    public boolean isSwimlaneNesting() {
        return this.swimlaneNesting;
    }

    public void setSwimlaneNesting(boolean value) {
        boolean oldValue = this.swimlaneNesting;
        this.swimlaneNesting = value;
        this.changeSupport.firePropertyChange("swimlaneNesting", oldValue, this.swimlaneNesting);
    }

    public boolean isAllowDanglingEdges() {
        return this.allowDanglingEdges;
    }

    public void setAllowDanglingEdges(boolean value) {
        boolean oldValue = this.allowDanglingEdges;
        this.allowDanglingEdges = value;
        this.changeSupport.firePropertyChange("allowDanglingEdges", oldValue, this.allowDanglingEdges);
    }

    public boolean isCloneInvalidEdges() {
        return this.cloneInvalidEdges;
    }

    public void setCloneInvalidEdges(boolean value) {
        boolean oldValue = this.cloneInvalidEdges;
        this.cloneInvalidEdges = value;
        this.changeSupport.firePropertyChange("cloneInvalidEdges", oldValue, this.cloneInvalidEdges);
    }

    public boolean isDisconnectOnMove() {
        return this.disconnectOnMove;
    }

    public void setDisconnectOnMove(boolean value) {
        boolean oldValue = this.disconnectOnMove;
        this.disconnectOnMove = value;
        this.changeSupport.firePropertyChange("disconnectOnMove", oldValue, this.disconnectOnMove);
    }

    public boolean isAllowLoops() {
        return this.allowLoops;
    }

    public void setAllowLoops(boolean value) {
        boolean oldValue = this.allowLoops;
        this.allowLoops = value;
        this.changeSupport.firePropertyChange("allowLoops", oldValue, this.allowLoops);
    }

    public boolean isConnectableEdges() {
        return this.connectableEdges;
    }

    public void setConnectableEdges(boolean value) {
        boolean oldValue = this.connectableEdges;
        this.connectableEdges = value;
        this.changeSupport.firePropertyChange("connectableEdges", oldValue, this.connectableEdges);
    }

    public boolean isResetEdgesOnMove() {
        return this.resetEdgesOnMove;
    }

    public void setResetEdgesOnMove(boolean value) {
        boolean oldValue = this.resetEdgesOnMove;
        this.resetEdgesOnMove = value;
        this.changeSupport.firePropertyChange("resetEdgesOnMove", oldValue, this.resetEdgesOnMove);
    }

    public boolean isResetViewOnRootChange() {
        return this.resetViewOnRootChange;
    }

    public void setResetViewOnRootChange(boolean value) {
        boolean oldValue = this.resetViewOnRootChange;
        this.resetViewOnRootChange = value;
        this.changeSupport.firePropertyChange("resetViewOnRootChange", oldValue, this.resetViewOnRootChange);
    }

    public boolean isResetEdgesOnResize() {
        return this.resetEdgesOnResize;
    }

    public void setResetEdgesOnResize(boolean value) {
        boolean oldValue = this.resetEdgesOnResize;
        this.resetEdgesOnResize = value;
        this.changeSupport.firePropertyChange("resetEdgesOnResize", oldValue, this.resetEdgesOnResize);
    }

    public boolean isResetEdgesOnConnect() {
        return this.resetEdgesOnConnect;
    }

    public void setResetEdgesOnConnect(boolean value) {
        boolean oldValue = this.resetEdgesOnConnect;
        this.resetEdgesOnConnect = value;
        this.changeSupport.firePropertyChange("resetEdgesOnConnect", oldValue, this.resetEdgesOnResize);
    }

    public boolean isAutoSizeCell(Object cell) {
        mxCellState state = this.view.getState(cell);
        Map<String, Object> style = state != null ? state.getStyle() : this.getCellStyle(cell);
        return this.isAutoSizeCells() || mxUtils.isTrue(style, mxConstants.STYLE_AUTOSIZE, false);
    }

    public boolean isAutoSizeCells() {
        return this.autoSizeCells;
    }

    public void setAutoSizeCells(boolean value) {
        boolean oldValue = this.autoSizeCells;
        this.autoSizeCells = value;
        this.changeSupport.firePropertyChange("autoSizeCells", oldValue, this.autoSizeCells);
    }

    public boolean isExtendParent(Object cell) {
        return !this.getModel().isEdge(cell) && this.isExtendParents();
    }

    public boolean isExtendParents() {
        return this.extendParents;
    }

    public void setExtendParents(boolean value) {
        boolean oldValue = this.extendParents;
        this.extendParents = value;
        this.changeSupport.firePropertyChange("extendParents", oldValue, this.extendParents);
    }

    public boolean isExtendParentsOnAdd() {
        return this.extendParentsOnAdd;
    }

    public void setExtendParentsOnAdd(boolean value) {
        boolean oldValue = this.extendParentsOnAdd;
        this.extendParentsOnAdd = value;
        this.changeSupport.firePropertyChange("extendParentsOnAdd", oldValue, this.extendParentsOnAdd);
    }

    public boolean isConstrainChild(Object cell) {
        return this.isConstrainChildren() && !this.getModel().isEdge(this.getModel().getParent(cell));
    }

    public boolean isConstrainChildren() {
        return this.constrainChildren;
    }

    public void setConstrainChildren(boolean value) {
        boolean oldValue = this.constrainChildren;
        this.constrainChildren = value;
        this.changeSupport.firePropertyChange("constrainChildren", oldValue, this.constrainChildren);
    }

    public boolean isAutoOrigin() {
        return this.autoOrigin;
    }

    public void setAutoOrigin(boolean value) {
        boolean oldValue = this.autoOrigin;
        this.autoOrigin = value;
        this.changeSupport.firePropertyChange("autoOrigin", oldValue, this.autoOrigin);
    }

    public mxPoint getOrigin() {
        return this.origin;
    }

    public void setOrigin(mxPoint value) {
        mxPoint oldValue = this.origin;
        this.origin = value;
        this.changeSupport.firePropertyChange("origin", oldValue, this.origin);
    }

    public int getChangesRepaintThreshold() {
        return this.changesRepaintThreshold;
    }

    public void setChangesRepaintThreshold(int value) {
        int oldValue = this.changesRepaintThreshold;
        this.changesRepaintThreshold = value;
        this.changeSupport.firePropertyChange("changesRepaintThreshold", oldValue, this.changesRepaintThreshold);
    }

    public boolean isAllowNegativeCoordinates() {
        return this.allowNegativeCoordinates;
    }

    public void setAllowNegativeCoordinates(boolean value) {
        boolean oldValue = this.allowNegativeCoordinates;
        this.allowNegativeCoordinates = value;
        this.changeSupport.firePropertyChange("allowNegativeCoordinates", oldValue, this.allowNegativeCoordinates);
    }

    public boolean isCollapseToPreferredSize() {
        return this.collapseToPreferredSize;
    }

    public void setCollapseToPreferredSize(boolean value) {
        boolean oldValue = this.collapseToPreferredSize;
        this.collapseToPreferredSize = value;
        this.changeSupport.firePropertyChange("collapseToPreferredSize", oldValue, this.collapseToPreferredSize);
    }

    public boolean isKeepEdgesInForeground() {
        return this.keepEdgesInForeground;
    }

    public void setKeepEdgesInForeground(boolean value) {
        boolean oldValue = this.keepEdgesInForeground;
        this.keepEdgesInForeground = value;
        this.changeSupport.firePropertyChange("keepEdgesInForeground", oldValue, this.keepEdgesInForeground);
    }

    public boolean isKeepEdgesInBackground() {
        return this.keepEdgesInBackground;
    }

    public void setKeepEdgesInBackground(boolean value) {
        boolean oldValue = this.keepEdgesInBackground;
        this.keepEdgesInBackground = value;
        this.changeSupport.firePropertyChange("keepEdgesInBackground", oldValue, this.keepEdgesInBackground);
    }

    public boolean isValidSource(Object cell) {
        return cell == null && this.allowDanglingEdges || cell != null && (!this.model.isEdge(cell) || this.isConnectableEdges()) && this.isCellConnectable(cell);
    }

    public boolean isValidTarget(Object cell) {
        return this.isValidSource(cell);
    }

    public boolean isValidConnection(Object source, Object target) {
        return this.isValidSource(source) && this.isValidTarget(target) && (this.isAllowLoops() || source != target);
    }

    public mxRectangle getMinimumGraphSize() {
        return this.minimumGraphSize;
    }

    public void setMinimumGraphSize(mxRectangle value) {
        mxRectangle oldValue = this.minimumGraphSize;
        this.minimumGraphSize = value;
        this.changeSupport.firePropertyChange("minimumGraphSize", oldValue, value);
    }

    public double getOverlap(Object cell) {
        return this.isAllowOverlapParent(cell) ? this.getDefaultOverlap() : 0.0;
    }

    public double getDefaultOverlap() {
        return this.defaultOverlap;
    }

    public void setDefaultOverlap(double value) {
        double oldValue = this.defaultOverlap;
        this.defaultOverlap = value;
        this.changeSupport.firePropertyChange("defaultOverlap", oldValue, value);
    }

    public boolean isAllowOverlapParent(Object cell) {
        return false;
    }

    public Object[] getFoldableCells(Object[] cells, final boolean collapse) {
        return mxGraphModel.filterCells(cells, new mxGraphModel.Filter(){

            public boolean filter(Object cell) {
                return mxGraph.this.isCellFoldable(cell, collapse);
            }
        });
    }

    public boolean isCellFoldable(Object cell, boolean collapse) {
        mxCellState state = this.view.getState(cell);
        Map<String, Object> style = state != null ? state.getStyle() : this.getCellStyle(cell);
        return this.model.getChildCount(cell) > 0 && mxUtils.isTrue(style, mxConstants.STYLE_FOLDABLE, true);
    }

    public boolean isGridEnabled() {
        return this.gridEnabled;
    }

    public void setGridEnabled(boolean value) {
        boolean oldValue = this.gridEnabled;
        this.gridEnabled = value;
        this.changeSupport.firePropertyChange("gridEnabled", oldValue, this.gridEnabled);
    }

    public boolean isPortsEnabled() {
        return this.portsEnabled;
    }

    public void setPortsEnabled(boolean value) {
        boolean oldValue = this.portsEnabled;
        this.portsEnabled = value;
        this.changeSupport.firePropertyChange("portsEnabled", oldValue, this.portsEnabled);
    }

    public int getGridSize() {
        return this.gridSize;
    }

    public void setGridSize(int value) {
        int oldValue = this.gridSize;
        this.gridSize = value;
        this.changeSupport.firePropertyChange("gridSize", oldValue, this.gridSize);
    }

    public String getAlternateEdgeStyle() {
        return this.alternateEdgeStyle;
    }

    public void setAlternateEdgeStyle(String value) {
        String oldValue = this.alternateEdgeStyle;
        this.alternateEdgeStyle = value;
        this.changeSupport.firePropertyChange("alternateEdgeStyle", oldValue, this.alternateEdgeStyle);
    }

    public boolean isValidDropTarget(Object cell, Object[] cells) {
        return cell != null && (this.isSplitEnabled() && this.isSplitTarget(cell, cells) || !this.model.isEdge(cell) && (this.isSwimlane(cell) || this.model.getChildCount(cell) > 0 && !this.isCellCollapsed(cell)));
    }

    public boolean isSplitTarget(Object target, Object[] cells) {
        if (target != null && cells != null && cells.length == 1) {
            Object src = this.model.getTerminal(target, true);
            Object trg = this.model.getTerminal(target, false);
            return this.model.isEdge(target) && this.isCellConnectable(cells[0]) && this.getEdgeValidationError(target, this.model.getTerminal(target, true), cells[0]) == null && !this.model.isAncestor(cells[0], src) && !this.model.isAncestor(cells[0], trg);
        }
        return false;
    }

    public Object getDropTarget(Object[] cells, Point pt, Object cell) {
        if (!this.isSwimlaneNesting()) {
            for (int i = 0; i < cells.length; ++i) {
                if (!this.isSwimlane(cells[i])) continue;
                return null;
            }
        }
        Object swimlane = null;
        if (cell == null) {
            cell = swimlane;
        }
        while (cell != null && !this.isValidDropTarget(cell, cells) && this.model.getParent(cell) != this.model.getRoot()) {
            cell = this.model.getParent(cell);
        }
        return this.model.getParent(cell) != this.model.getRoot() && !mxUtils.contains(cells, cell) ? cell : null;
    }

    public Object getDefaultParent() {
        Object parent = this.defaultParent;
        if (parent == null && (parent = this.view.getCurrentRoot()) == null) {
            Object root = this.model.getRoot();
            parent = this.model.getChildAt(root, 0);
        }
        return parent;
    }

    public void setDefaultParent(Object value) {
        this.defaultParent = value;
    }

    public Object[] getChildVertices(Object parent) {
        return this.getChildCells(parent, true, false);
    }

    public Object[] getChildEdges(Object parent) {
        return this.getChildCells(parent, false, true);
    }

    public Object[] getChildCells(Object parent) {
        return this.getChildCells(parent, false, false);
    }

    public Object[] getChildCells(Object parent, boolean vertices, boolean edges) {
        Object[] cells = mxGraphModel.getChildCells(this.model, parent, vertices, edges);
        ArrayList<Object> result = new ArrayList<Object>(cells.length);
        for (int i = 0; i < cells.length; ++i) {
            if (!this.isCellVisible(cells[i])) continue;
            result.add(cells[i]);
        }
        return result.toArray();
    }

    public Object[] getConnections(Object cell) {
        return this.getConnections(cell, null);
    }

    public Object[] getConnections(Object cell, Object parent) {
        return this.getConnections(cell, parent, false);
    }

    public Object[] getConnections(Object cell, Object parent, boolean recurse) {
        return this.getEdges(cell, parent, true, true, false, recurse);
    }

    public Object[] getIncomingEdges(Object cell) {
        return this.getIncomingEdges(cell, null);
    }

    public Object[] getIncomingEdges(Object cell, Object parent) {
        return this.getEdges(cell, parent, true, false, false);
    }

    public Object[] getOutgoingEdges(Object cell) {
        return this.getOutgoingEdges(cell, null);
    }

    public Object[] getOutgoingEdges(Object cell, Object parent) {
        return this.getEdges(cell, parent, false, true, false);
    }

    public Object[] getEdges(Object cell) {
        return this.getEdges(cell, null);
    }

    public Object[] getEdges(Object cell, Object parent) {
        return this.getEdges(cell, parent, true, true, true);
    }

    public Object[] getEdges(Object cell, Object parent, boolean incoming, boolean outgoing, boolean includeLoops) {
        return this.getEdges(cell, parent, incoming, outgoing, includeLoops, false);
    }

    public Object[] getEdges(Object cell, Object parent, boolean incoming, boolean outgoing, boolean includeLoops, boolean recurse) {
        boolean isCollapsed = this.isCellCollapsed(cell);
        ArrayList<Object> edges = new ArrayList<Object>();
        int childCount = this.model.getChildCount(cell);
        for (int i = 0; i < childCount; ++i) {
            Object child = this.model.getChildAt(cell, i);
            if (!isCollapsed && this.isCellVisible(child)) continue;
            edges.addAll(Arrays.asList(mxGraphModel.getEdges(this.model, child, incoming, outgoing, includeLoops)));
        }
        edges.addAll(Arrays.asList(mxGraphModel.getEdges(this.model, cell, incoming, outgoing, includeLoops)));
        ArrayList result = new ArrayList(edges.size());
        for (Object e : edges) {
            Object target;
            mxCellState state = this.view.getState(e);
            Object source = state != null ? state.getVisibleTerminal(true) : this.view.getVisibleTerminal(e, true);
            Object object = target = state != null ? state.getVisibleTerminal(false) : this.view.getVisibleTerminal(e, false);
            if ((!includeLoops || source != target) && (source == target || (!incoming || target != cell || parent != null && !this.isValidAncestor(source, parent, recurse)) && (!outgoing || source != cell || parent != null && !this.isValidAncestor(target, parent, recurse)))) continue;
            result.add(e);
        }
        return result.toArray();
    }

    public boolean isValidAncestor(Object cell, Object parent, boolean recurse) {
        return recurse ? this.model.isAncestor(parent, cell) : this.model.getParent(cell) == parent;
    }

    public Object[] getOpposites(Object[] edges, Object terminal) {
        return this.getOpposites(edges, terminal, true, true);
    }

    public Object[] getOpposites(Object[] edges, Object terminal, boolean sources, boolean targets) {
        LinkedHashSet<Object> terminals = new LinkedHashSet<Object>();
        if (edges != null) {
            for (int i = 0; i < edges.length; ++i) {
                Object target;
                mxCellState state = this.view.getState(edges[i]);
                Object source = state != null ? state.getVisibleTerminal(true) : this.view.getVisibleTerminal(edges[i], true);
                Object object = target = state != null ? state.getVisibleTerminal(false) : this.view.getVisibleTerminal(edges[i], false);
                if (targets && source == terminal && target != null && target != terminal) {
                    terminals.add(target);
                    continue;
                }
                if (!sources || target != terminal || source == null || source == terminal) continue;
                terminals.add(source);
            }
        }
        return terminals.toArray();
    }

    public Object[] getEdgesBetween(Object source, Object target) {
        return this.getEdgesBetween(source, target, false);
    }

    public Object[] getEdgesBetween(Object source, Object target, boolean directed) {
        Object[] edges = this.getEdges(source);
        ArrayList<Object> result = new ArrayList<Object>(edges.length);
        for (int i = 0; i < edges.length; ++i) {
            Object trg;
            mxCellState state = this.view.getState(edges[i]);
            Object src = state != null ? state.getVisibleTerminal(true) : this.view.getVisibleTerminal(edges[i], true);
            Object object = trg = state != null ? state.getVisibleTerminal(false) : this.view.getVisibleTerminal(edges[i], false);
            if ((src != source || trg != target) && (directed || src != target || trg != source)) continue;
            result.add(edges[i]);
        }
        return result.toArray();
    }

    public Object[] getCellsBeyond(double x0, double y0, Object parent, boolean rightHalfpane, boolean bottomHalfpane) {
        if (parent == null) {
            parent = this.getDefaultParent();
        }
        int childCount = this.model.getChildCount(parent);
        ArrayList<Object> result = new ArrayList<Object>(childCount);
        if ((rightHalfpane || bottomHalfpane) && parent != null) {
            for (int i = 0; i < childCount; ++i) {
                Object child = this.model.getChildAt(parent, i);
                mxCellState state = this.view.getState(child);
                if (!this.isCellVisible(child) || state == null || rightHalfpane && !(state.getX() >= x0) || bottomHalfpane && !(state.getY() >= y0)) continue;
                result.add(child);
            }
        }
        return result.toArray();
    }

    public List<Object> findTreeRoots(Object parent) {
        return this.findTreeRoots(parent, false);
    }

    public List<Object> findTreeRoots(Object parent, boolean isolate) {
        return this.findTreeRoots(parent, isolate, false);
    }

    public List<Object> findTreeRoots(Object parent, boolean isolate, boolean invert) {
        ArrayList<Object> roots = new ArrayList<Object>();
        if (parent != null) {
            int childCount = this.model.getChildCount(parent);
            Object best = null;
            int maxDiff = 0;
            for (int i = 0; i < childCount; ++i) {
                int diff;
                Object cell = this.model.getChildAt(parent, i);
                if (!this.model.isVertex(cell) || !this.isCellVisible(cell)) continue;
                Object[] conns = this.getConnections(cell, isolate ? parent : null);
                int fanOut = 0;
                int fanIn = 0;
                for (int j = 0; j < conns.length; ++j) {
                    Object src = this.view.getVisibleTerminal(conns[j], true);
                    if (src == cell) {
                        ++fanOut;
                        continue;
                    }
                    ++fanIn;
                }
                if (invert && fanOut == 0 && fanIn > 0 || !invert && fanIn == 0 && fanOut > 0) {
                    roots.add(cell);
                }
                int n = diff = invert ? fanIn - fanOut : fanOut - fanIn;
                if (diff <= maxDiff) continue;
                maxDiff = diff;
                best = cell;
            }
            if (roots.isEmpty() && best != null) {
                roots.add(best);
            }
        }
        return roots;
    }

    public void traverse(Object vertex, boolean directed, mxICellVisitor visitor) {
        this.traverse(vertex, directed, visitor, null, null);
    }

    public void traverse(Object vertex, boolean directed, mxICellVisitor visitor, Object edge, Set<Object> visited) {
        if (vertex != null && visitor != null) {
            if (visited == null) {
                visited = new HashSet<Object>();
            }
            if (!visited.contains(vertex)) {
                int edgeCount;
                visited.add(vertex);
                if (visitor.visit(vertex, edge) && (edgeCount = this.model.getEdgeCount(vertex)) > 0) {
                    for (int i = 0; i < edgeCount; ++i) {
                        boolean isSource;
                        Object e = this.model.getEdgeAt(vertex, i);
                        boolean bl = isSource = this.model.getTerminal(e, true) == vertex;
                        if (directed && !isSource) continue;
                        Object next = this.model.getTerminal(e, !isSource);
                        this.traverse(next, directed, visitor, e, visited);
                    }
                }
            }
        }
    }

    public mxGraphSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public int getSelectionCount() {
        return this.selectionModel.size();
    }

    public boolean isCellSelected(Object cell) {
        return this.selectionModel.isSelected(cell);
    }

    public boolean isSelectionEmpty() {
        return this.selectionModel.isEmpty();
    }

    public void clearSelection() {
        this.selectionModel.clear();
    }

    public Object getSelectionCell() {
        return this.selectionModel.getCell();
    }

    public void setSelectionCell(Object cell) {
        this.selectionModel.setCell(cell);
    }

    public Object[] getSelectionCells() {
        return this.selectionModel.getCells();
    }

    public void setSelectionCells(Object[] cells) {
        this.selectionModel.setCells(cells);
    }

    public void setSelectionCells(Collection<Object> cells) {
        if (cells != null) {
            this.setSelectionCells(cells.toArray());
        }
    }

    public void addSelectionCell(Object cell) {
        this.selectionModel.addCell(cell);
    }

    public void addSelectionCells(Object[] cells) {
        this.selectionModel.addCells(cells);
    }

    public void removeSelectionCell(Object cell) {
        this.selectionModel.removeCell(cell);
    }

    public void removeSelectionCells(Object[] cells) {
        this.selectionModel.removeCells(cells);
    }

    public void selectNextCell() {
        this.selectCell(true, false, false);
    }

    public void selectPreviousCell() {
        this.selectCell(false, false, false);
    }

    public void selectParentCell() {
        this.selectCell(false, true, false);
    }

    public void selectChildCell() {
        this.selectCell(false, false, true);
    }

    public void selectCell(boolean isNext, boolean isParent, boolean isChild) {
        Object cell = this.getSelectionCell();
        if (this.getSelectionCount() > 1) {
            this.clearSelection();
        }
        Object parent = cell != null ? this.model.getParent(cell) : this.getDefaultParent();
        int childCount = this.model.getChildCount(parent);
        if (cell == null && childCount > 0) {
            Object child = this.model.getChildAt(parent, 0);
            this.setSelectionCell(child);
        } else if ((cell == null || isParent) && this.view.getState(parent) != null && this.model.getGeometry(parent) != null) {
            if (this.getCurrentRoot() != parent) {
                this.setSelectionCell(parent);
            }
        } else if (cell != null && isChild) {
            int tmp = this.model.getChildCount(cell);
            if (tmp > 0) {
                Object child = this.model.getChildAt(cell, 0);
                this.setSelectionCell(child);
            }
        } else if (childCount > 0) {
            int i = ((mxICell)parent).getIndex((mxICell)cell);
            if (isNext) {
                this.setSelectionCell(this.model.getChildAt(parent, ++i % childCount));
            } else {
                int index = --i < 0 ? childCount - 1 : i;
                this.setSelectionCell(this.model.getChildAt(parent, index));
            }
        }
    }

    public void selectVertices() {
        this.selectVertices(null);
    }

    public void selectVertices(Object parent) {
        this.selectCells(true, false, parent);
    }

    public void selectEdges() {
        this.selectEdges(null);
    }

    public void selectEdges(Object parent) {
        this.selectCells(false, true, parent);
    }

    public void selectCells(boolean vertices, boolean edges) {
        this.selectCells(vertices, edges, null);
    }

    public void selectCells(final boolean vertices, final boolean edges, Object parent) {
        if (parent == null) {
            parent = this.getDefaultParent();
        }
        Collection<Object> cells = mxGraphModel.filterDescendants(this.getModel(), new mxGraphModel.Filter(){

            public boolean filter(Object cell) {
                return mxGraph.this.view.getState(cell) != null && mxGraph.this.model.getChildCount(cell) == 0 && (mxGraph.this.model.isVertex(cell) && vertices || mxGraph.this.model.isEdge(cell) && edges);
            }
        });
        this.setSelectionCells(cells);
    }

    public void selectAll() {
        this.selectAll(null);
    }

    public void selectAll(Object parent) {
        Object[] children;
        if (parent == null) {
            parent = this.getDefaultParent();
        }
        if ((children = mxGraphModel.getChildren(this.model, parent)) != null) {
            this.setSelectionCells(children);
        }
    }

    public void drawGraph(mxICanvas canvas) {
        this.drawCell(canvas, this.getModel().getRoot());
    }

    public void drawCell(mxICanvas canvas, Object cell) {
        this.drawState(canvas, this.getView().getState(cell), true);
        int childCount = this.model.getChildCount(cell);
        for (int i = 0; i < childCount; ++i) {
            Object child = this.model.getChildAt(cell, i);
            this.drawCell(canvas, child);
        }
    }

    public void drawState(mxICanvas canvas, mxCellState state, boolean drawLabel) {
        Object cell;
        Object object = cell = state != null ? state.getCell() : null;
        if (cell != null && cell != this.view.getCurrentRoot() && cell != this.model.getRoot() && (this.model.isVertex(cell) || this.model.isEdge(cell))) {
            String label;
            mxICanvas clippedCanvas;
            Object obj = canvas.drawCell(state);
            Object lab = null;
            Shape clip = null;
            Rectangle newClip = state.getRectangle();
            mxICanvas mxICanvas2 = clippedCanvas = this.isLabelClipped(state.getCell()) ? canvas : null;
            if (clippedCanvas instanceof mxImageCanvas) {
                clippedCanvas = ((mxImageCanvas)clippedCanvas).getGraphicsCanvas();
            }
            if (clippedCanvas instanceof mxGraphics2DCanvas) {
                Graphics2D g = ((mxGraphics2DCanvas)clippedCanvas).getGraphics();
                clip = g.getClip();
                if (clip instanceof Rectangle) {
                    g.setClip(newClip.intersection((Rectangle)clip));
                } else {
                    g.setClip(newClip);
                }
            }
            if (drawLabel && (label = state.getLabel()) != null && state.getLabelBounds() != null) {
                lab = canvas.drawLabel(label, state, this.isHtmlLabel(cell));
            }
            if (clippedCanvas instanceof mxGraphics2DCanvas) {
                ((mxGraphics2DCanvas)clippedCanvas).getGraphics().setClip(clip);
            }
            if (obj != null) {
                this.cellDrawn(canvas, state, obj, lab);
            }
        }
    }

    protected void cellDrawn(mxICanvas canvas, mxCellState state, Object element, Object labelElement) {
        String link;
        if (element instanceof Element && (link = this.getLinkForCell(state.getCell())) != null) {
            String target;
            String title = this.getToolTipForCell(state.getCell());
            Element elem = (Element)element;
            if (elem.getNodeName().startsWith("v:")) {
                elem.setAttribute("href", link.toString());
                if (title != null) {
                    elem.setAttribute("title", title);
                }
            } else if (elem.getOwnerDocument().getElementsByTagName("svg").getLength() > 0) {
                Element xlink = elem.getOwnerDocument().createElement("a");
                xlink.setAttribute("xlink:href", link.toString());
                elem.getParentNode().replaceChild(xlink, elem);
                xlink.appendChild(elem);
                if (title != null) {
                    xlink.setAttribute("xlink:title", title);
                }
                elem = xlink;
            } else {
                Element a = elem.getOwnerDocument().createElement("a");
                a.setAttribute("href", link.toString());
                a.setAttribute("style", "text-decoration:none;");
                elem.getParentNode().replaceChild(a, elem);
                a.appendChild(elem);
                if (title != null) {
                    a.setAttribute("title", title);
                }
                elem = a;
            }
            if ((target = this.getTargetForCell(state.getCell())) != null) {
                elem.setAttribute("target", target);
            }
        }
    }

    protected String getLinkForCell(Object cell) {
        return null;
    }

    protected String getTargetForCell(Object cell) {
        return null;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(propertyName, listener);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append(" [");
        builder.append("model=");
        builder.append(this.model);
        builder.append(", view=");
        builder.append(this.view);
        builder.append("]");
        return builder.toString();
    }

    public static void main(String[] args) {
        log.info("mxGraph version \"3.9.9\"");
    }

    static {
        try {
            mxResources.add("com.mxgraph.resources.graph");
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Failed to add the resource bundle", e);
        }
        imageBundles = new LinkedList<mxImageBundle>();
    }

    public static interface mxICellVisitor {
        public boolean visit(Object var1, Object var2);
    }
}

