/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.swing;

import com.mxgraph.canvas.mxGraphics2DCanvas;
import com.mxgraph.canvas.mxICanvas;
import com.mxgraph.model.mxGraphModel;
import com.mxgraph.model.mxIGraphModel;
import com.mxgraph.swing.handler.mxCellHandler;
import com.mxgraph.swing.handler.mxConnectionHandler;
import com.mxgraph.swing.handler.mxEdgeHandler;
import com.mxgraph.swing.handler.mxElbowEdgeHandler;
import com.mxgraph.swing.handler.mxGraphHandler;
import com.mxgraph.swing.handler.mxGraphTransferHandler;
import com.mxgraph.swing.handler.mxPanningHandler;
import com.mxgraph.swing.handler.mxSelectionCellsHandler;
import com.mxgraph.swing.handler.mxVertexHandler;
import com.mxgraph.swing.util.mxCellOverlay;
import com.mxgraph.swing.util.mxICellOverlay;
import com.mxgraph.swing.view.mxCellEditor;
import com.mxgraph.swing.view.mxICellEditor;
import com.mxgraph.swing.view.mxInteractiveCanvas;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxEventObject;
import com.mxgraph.util.mxEventSource;
import com.mxgraph.util.mxPoint;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.util.mxResources;
import com.mxgraph.util.mxUtils;
import com.mxgraph.view.mxCellState;
import com.mxgraph.view.mxEdgeStyle;
import com.mxgraph.view.mxGraph;
import com.mxgraph.view.mxGraphView;
import com.mxgraph.view.mxTemporaryCellStates;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.BoundedRangeModel;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.TransferHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class mxGraphComponent
extends JScrollPane
implements Printable {
    private static final Logger log = Logger.getLogger(mxGraphComponent.class.getName());
    private static final long serialVersionUID = -30203858391633447L;
    public static final int GRID_STYLE_DOT = 0;
    public static final int GRID_STYLE_CROSS = 1;
    public static final int GRID_STYLE_LINE = 2;
    public static final int GRID_STYLE_DASHED = 3;
    public static final int ZOOM_POLICY_NONE = 0;
    public static final int ZOOM_POLICY_PAGE = 1;
    public static final int ZOOM_POLICY_WIDTH = 2;
    public static ImageIcon DEFAULT_EXPANDED_ICON = null;
    public static ImageIcon DEFAULT_COLLAPSED_ICON = null;
    public static ImageIcon DEFAULT_WARNING_ICON = null;
    public static final double DEFAULT_PAGESCALE = 1.4;
    protected mxGraph graph;
    protected mxGraphControl graphControl;
    protected mxEventSource eventSource = new mxEventSource(this);
    protected mxICellEditor cellEditor;
    protected mxConnectionHandler connectionHandler;
    protected mxPanningHandler panningHandler;
    protected mxSelectionCellsHandler selectionCellsHandler;
    protected mxGraphHandler graphHandler;
    protected float previewAlpha = 0.5f;
    protected ImageIcon backgroundImage;
    protected PageFormat pageFormat = new PageFormat();
    protected mxInteractiveCanvas canvas;
    protected BufferedImage tripleBuffer;
    protected Graphics2D tripleBufferGraphics;
    protected double pageScale = 1.4;
    protected boolean pageVisible = false;
    protected boolean preferPageSize = false;
    protected boolean pageBreaksVisible = true;
    protected Color pageBreakColor = Color.darkGray;
    protected int horizontalPageCount = 1;
    protected int verticalPageCount = 1;
    protected boolean centerPage = true;
    protected Color pageBackgroundColor = new Color(144, 153, 174);
    protected Color pageShadowColor = new Color(110, 120, 140);
    protected Color pageBorderColor = Color.black;
    protected boolean gridVisible = false;
    protected Color gridColor = new Color(192, 192, 192);
    protected boolean autoScroll = true;
    protected boolean autoExtend = true;
    protected boolean dragEnabled = true;
    protected boolean importEnabled = true;
    protected boolean exportEnabled = true;
    protected boolean foldingEnabled = true;
    protected int tolerance = 4;
    protected boolean swimlaneSelectionEnabled = true;
    protected boolean transparentSwimlaneContent = true;
    protected int gridStyle = 0;
    protected ImageIcon expandedIcon = DEFAULT_EXPANDED_ICON;
    protected ImageIcon collapsedIcon = DEFAULT_COLLAPSED_ICON;
    protected ImageIcon warningIcon = DEFAULT_WARNING_ICON;
    protected boolean antiAlias = true;
    protected boolean textAntiAlias = true;
    protected boolean escapeEnabled = true;
    protected boolean invokesStopCellEditing = true;
    protected boolean enterStopsCellEditing = false;
    protected int zoomPolicy = 1;
    private transient boolean zooming = false;
    protected double zoomFactor = 1.2;
    protected boolean keepSelectionVisibleOnZoom = false;
    protected boolean centerZoom = true;
    protected boolean tripleBuffered = false;
    public boolean showDirtyRectangle = false;
    protected Hashtable<Object, Component[]> components = new Hashtable();
    protected Hashtable<Object, mxICellOverlay[]> overlays = new Hashtable();
    private transient boolean centerOnResize = true;
    protected mxEventSource.mxIEventListener updateHandler = new mxEventSource.mxIEventListener(){

        public void invoke(Object sender, mxEventObject evt) {
            mxGraphComponent.this.updateComponents();
            mxGraphComponent.this.graphControl.updatePreferredSize();
        }
    };
    protected mxEventSource.mxIEventListener repaintHandler = new mxEventSource.mxIEventListener(){

        public void invoke(Object source, mxEventObject evt) {
            Rectangle rect;
            mxRectangle dirty = (mxRectangle)evt.getProperty("region");
            Rectangle rectangle = rect = dirty != null ? dirty.getRectangle() : null;
            if (rect != null) {
                rect.grow(1, 1);
            }
            mxGraphComponent.this.repaintTripleBuffer(rect);
            mxGraphComponent.this.graphControl.repaint(rect != null ? rect : mxGraphComponent.this.getViewport().getViewRect());
            JPanel panel = (JPanel)mxGraphComponent.this.getClientProperty("dirty");
            if (mxGraphComponent.this.showDirtyRectangle) {
                if (panel == null) {
                    panel = new JPanel();
                    panel.setOpaque(false);
                    panel.setBorder(BorderFactory.createLineBorder(Color.RED));
                    mxGraphComponent.this.putClientProperty("dirty", panel);
                    mxGraphComponent.this.graphControl.add(panel);
                }
                if (dirty != null) {
                    panel.setBounds(dirty.getRectangle());
                }
                panel.setVisible(dirty != null);
            } else if (panel != null && panel.getParent() != null) {
                panel.getParent().remove(panel);
                mxGraphComponent.this.putClientProperty("dirty", null);
                mxGraphComponent.this.repaint();
            }
        }
    };
    protected PropertyChangeListener viewChangeHandler = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("view")) {
                mxGraphView oldView = (mxGraphView)evt.getOldValue();
                mxGraphView newView = (mxGraphView)evt.getNewValue();
                if (oldView != null) {
                    oldView.removeListener(mxGraphComponent.this.updateHandler);
                }
                if (newView != null) {
                    newView.addListener("scale", mxGraphComponent.this.updateHandler);
                    newView.addListener("translate", mxGraphComponent.this.updateHandler);
                    newView.addListener("scaleAndTranslate", mxGraphComponent.this.updateHandler);
                    newView.addListener("up", mxGraphComponent.this.updateHandler);
                    newView.addListener("down", mxGraphComponent.this.updateHandler);
                }
            } else if (evt.getPropertyName().equals("model")) {
                mxGraphModel oldModel = (mxGraphModel)evt.getOldValue();
                mxGraphModel newModel = (mxGraphModel)evt.getNewValue();
                if (oldModel != null) {
                    oldModel.removeListener(mxGraphComponent.this.updateHandler);
                }
                if (newModel != null) {
                    newModel.addListener("change", mxGraphComponent.this.updateHandler);
                }
            }
        }
    };
    protected mxEventSource.mxIEventListener scaleHandler = new mxEventSource.mxIEventListener(){

        public void invoke(Object sender, mxEventObject evt) {
            if (!mxGraphComponent.this.zooming) {
                mxGraphComponent.this.zoomPolicy = 0;
            }
        }
    };

    public mxGraphComponent(mxGraph graph) {
        this.setCellEditor(this.createCellEditor());
        this.canvas = this.createCanvas();
        this.graphControl = this.createGraphControl();
        this.installFocusHandler();
        this.installKeyHandler();
        this.installResizeHandler();
        this.setGraph(graph);
        this.setViewportView(this.graphControl);
        this.createHandlers();
        this.installDoubleClickHandler();
    }

    protected void installFocusHandler() {
        this.graphControl.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (!mxGraphComponent.this.hasFocus()) {
                    mxGraphComponent.this.requestFocus();
                }
            }
        });
    }

    protected void installKeyHandler() {
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27 && mxGraphComponent.this.isEscapeEnabled()) {
                    mxGraphComponent.this.escape(e);
                }
            }
        });
    }

    protected void installResizeHandler() {
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                mxGraphComponent.this.zoomAndCenter();
            }
        });
    }

    protected void installDoubleClickHandler() {
        this.graphControl.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                if (mxGraphComponent.this.isEnabled()) {
                    if (!e.isConsumed() && mxGraphComponent.this.isEditEvent(e)) {
                        Object cell = mxGraphComponent.this.getCellAt(e.getX(), e.getY(), false);
                        if (cell != null && mxGraphComponent.this.getGraph().isCellEditable(cell)) {
                            mxGraphComponent.this.startEditingAtCell(cell, e);
                        }
                    } else {
                        mxGraphComponent.this.stopEditing(!mxGraphComponent.this.invokesStopCellEditing);
                    }
                }
            }
        });
    }

    protected mxICellEditor createCellEditor() {
        return new mxCellEditor(this);
    }

    public void setGraph(mxGraph value) {
        mxGraph oldValue = this.graph;
        if (this.graph != null) {
            this.graph.removeListener(this.repaintHandler);
            this.graph.getModel().removeListener(this.updateHandler);
            this.graph.getView().removeListener(this.updateHandler);
            this.graph.removePropertyChangeListener(this.viewChangeHandler);
            this.graph.getView().removeListener(this.scaleHandler);
        }
        this.graph = value;
        this.graph.addListener("repaint", this.repaintHandler);
        this.graph.getModel().addListener("change", this.updateHandler);
        mxGraphView view = this.graph.getView();
        view.addListener("scale", this.updateHandler);
        view.addListener("translate", this.updateHandler);
        view.addListener("scaleAndTranslate", this.updateHandler);
        view.addListener("up", this.updateHandler);
        view.addListener("down", this.updateHandler);
        this.graph.addPropertyChangeListener(this.viewChangeHandler);
        this.graph.getView().addListener("scale", this.scaleHandler);
        this.graph.getView().addListener("scaleAndTranslate", this.scaleHandler);
        this.updateHandler.invoke(this.graph.getView(), null);
        this.firePropertyChange("graph", oldValue, this.graph);
    }

    public mxGraph getGraph() {
        return this.graph;
    }

    protected mxGraphControl createGraphControl() {
        return new mxGraphControl();
    }

    public mxGraphControl getGraphControl() {
        return this.graphControl;
    }

    protected void createHandlers() {
        this.setTransferHandler(this.createTransferHandler());
        this.panningHandler = this.createPanningHandler();
        this.selectionCellsHandler = this.createSelectionCellsHandler();
        this.connectionHandler = this.createConnectionHandler();
        this.graphHandler = this.createGraphHandler();
    }

    protected TransferHandler createTransferHandler() {
        return new mxGraphTransferHandler();
    }

    protected mxSelectionCellsHandler createSelectionCellsHandler() {
        return new mxSelectionCellsHandler(this);
    }

    protected mxGraphHandler createGraphHandler() {
        return new mxGraphHandler(this);
    }

    public mxSelectionCellsHandler getSelectionCellsHandler() {
        return this.selectionCellsHandler;
    }

    public mxGraphHandler getGraphHandler() {
        return this.graphHandler;
    }

    protected mxConnectionHandler createConnectionHandler() {
        return new mxConnectionHandler(this);
    }

    public mxConnectionHandler getConnectionHandler() {
        return this.connectionHandler;
    }

    protected mxPanningHandler createPanningHandler() {
        return new mxPanningHandler(this);
    }

    public mxPanningHandler getPanningHandler() {
        return this.panningHandler;
    }

    public boolean isEditing() {
        return this.getCellEditor().getEditingCell() != null;
    }

    public mxICellEditor getCellEditor() {
        return this.cellEditor;
    }

    public void setCellEditor(mxICellEditor value) {
        mxICellEditor oldValue = this.cellEditor;
        this.cellEditor = value;
        this.firePropertyChange("cellEditor", oldValue, this.cellEditor);
    }

    public int getTolerance() {
        return this.tolerance;
    }

    public void setTolerance(int value) {
        int oldValue = this.tolerance;
        this.tolerance = value;
        this.firePropertyChange("tolerance", oldValue, this.tolerance);
    }

    public PageFormat getPageFormat() {
        return this.pageFormat;
    }

    public void setPageFormat(PageFormat value) {
        PageFormat oldValue = this.pageFormat;
        this.pageFormat = value;
        this.firePropertyChange("pageFormat", oldValue, this.pageFormat);
    }

    public double getPageScale() {
        return this.pageScale;
    }

    public void setPageScale(double value) {
        double oldValue = this.pageScale;
        this.pageScale = value;
        this.firePropertyChange("pageScale", oldValue, this.pageScale);
    }

    public mxRectangle getLayoutAreaSize() {
        if (this.pageVisible) {
            Dimension d = this.getPreferredSizeForPage();
            return new mxRectangle(new Rectangle(d));
        }
        return new mxRectangle(new Rectangle(this.graphControl.getSize()));
    }

    public ImageIcon getBackgroundImage() {
        return this.backgroundImage;
    }

    public void setBackgroundImage(ImageIcon value) {
        ImageIcon oldValue = this.backgroundImage;
        this.backgroundImage = value;
        this.firePropertyChange("backgroundImage", oldValue, this.backgroundImage);
    }

    public boolean isPageVisible() {
        return this.pageVisible;
    }

    public void setPageVisible(boolean value) {
        boolean oldValue = this.pageVisible;
        this.pageVisible = value;
        this.firePropertyChange("pageVisible", oldValue, this.pageVisible);
    }

    public boolean isPreferPageSize() {
        return this.preferPageSize;
    }

    public void setPreferPageSize(boolean value) {
        boolean oldValue = this.preferPageSize;
        this.preferPageSize = value;
        this.firePropertyChange("preferPageSize", oldValue, this.preferPageSize);
    }

    public boolean isPageBreaksVisible() {
        return this.pageBreaksVisible;
    }

    public void setPageBreaksVisible(boolean value) {
        boolean oldValue = this.pageBreaksVisible;
        this.pageBreaksVisible = value;
        this.firePropertyChange("pageBreaksVisible", oldValue, this.pageBreaksVisible);
    }

    public Color getPageBreakColor() {
        return this.pageBreakColor;
    }

    public void setPageBreakColor(Color pageBreakColor) {
        this.pageBreakColor = pageBreakColor;
    }

    public void setHorizontalPageCount(int value) {
        int oldValue = this.horizontalPageCount;
        this.horizontalPageCount = value;
        this.firePropertyChange("horizontalPageCount", oldValue, this.horizontalPageCount);
    }

    public int getHorizontalPageCount() {
        return this.horizontalPageCount;
    }

    public void setVerticalPageCount(int value) {
        int oldValue = this.verticalPageCount;
        this.verticalPageCount = value;
        this.firePropertyChange("verticalPageCount", oldValue, this.verticalPageCount);
    }

    public int getVerticalPageCount() {
        return this.verticalPageCount;
    }

    public boolean isCenterPage() {
        return this.centerPage;
    }

    public void setCenterPage(boolean value) {
        boolean oldValue = this.centerPage;
        this.centerPage = value;
        this.firePropertyChange("centerPage", oldValue, this.centerPage);
    }

    public Color getPageBackgroundColor() {
        return this.pageBackgroundColor;
    }

    public void setPageBackgroundColor(Color value) {
        Color oldValue = this.pageBackgroundColor;
        this.pageBackgroundColor = value;
        this.firePropertyChange("pageBackgroundColor", oldValue, this.pageBackgroundColor);
    }

    public Color getPageShadowColor() {
        return this.pageShadowColor;
    }

    public void setPageShadowColor(Color value) {
        Color oldValue = this.pageShadowColor;
        this.pageShadowColor = value;
        this.firePropertyChange("pageShadowColor", oldValue, this.pageShadowColor);
    }

    public Color getPageBorderColor() {
        return this.pageBorderColor;
    }

    public void setPageBorderColor(Color value) {
        Color oldValue = this.pageBorderColor;
        this.pageBorderColor = value;
        this.firePropertyChange("pageBorderColor", oldValue, this.pageBorderColor);
    }

    public boolean isKeepSelectionVisibleOnZoom() {
        return this.keepSelectionVisibleOnZoom;
    }

    public void setKeepSelectionVisibleOnZoom(boolean value) {
        boolean oldValue = this.keepSelectionVisibleOnZoom;
        this.keepSelectionVisibleOnZoom = value;
        this.firePropertyChange("keepSelectionVisibleOnZoom", oldValue, this.keepSelectionVisibleOnZoom);
    }

    public double getZoomFactor() {
        return this.zoomFactor;
    }

    public void setZoomFactor(double value) {
        double oldValue = this.zoomFactor;
        this.zoomFactor = value;
        this.firePropertyChange("zoomFactor", oldValue, this.zoomFactor);
    }

    public boolean isCenterZoom() {
        return this.centerZoom;
    }

    public void setCenterZoom(boolean value) {
        boolean oldValue = this.centerZoom;
        this.centerZoom = value;
        this.firePropertyChange("centerZoom", oldValue, this.centerZoom);
    }

    public void setZoomPolicy(int value) {
        int oldValue = this.zoomPolicy;
        this.zoomPolicy = value;
        if (this.zoomPolicy != 0) {
            this.zoom(this.zoomPolicy == 1, true);
        }
        this.firePropertyChange("zoomPolicy", oldValue, this.zoomPolicy);
    }

    public int getZoomPolicy() {
        return this.zoomPolicy;
    }

    public void escape(KeyEvent e) {
        if (this.selectionCellsHandler != null) {
            this.selectionCellsHandler.reset();
        }
        if (this.connectionHandler != null) {
            this.connectionHandler.reset();
        }
        if (this.graphHandler != null) {
            this.graphHandler.reset();
        }
        if (this.cellEditor != null) {
            this.cellEditor.stopEditing(true);
        }
    }

    public Object[] importCells(Object[] cells, double dx, double dy, Object target, Point location) {
        return this.graph.moveCells(cells, dx, dy, true, target, location);
    }

    public void refresh() {
        this.graph.refresh();
        this.selectionCellsHandler.refresh();
    }

    public mxPoint getPointForEvent(MouseEvent e) {
        return this.getPointForEvent(e, true);
    }

    public mxPoint getPointForEvent(MouseEvent e, boolean addOffset) {
        double s = this.graph.getView().getScale();
        mxPoint tr = this.graph.getView().getTranslate();
        double off = addOffset ? (double)(this.graph.getGridSize() / 2) : 0.0;
        double x = this.graph.snap((double)e.getX() / s - tr.getX() - off);
        double y = this.graph.snap((double)e.getY() / s - tr.getY() - off);
        return new mxPoint(x, y);
    }

    public void startEditing() {
        this.startEditingAtCell(null);
    }

    public void startEditingAtCell(Object cell) {
        this.startEditingAtCell(cell, null);
    }

    public void startEditingAtCell(Object cell, EventObject evt) {
        if (cell == null && (cell = this.graph.getSelectionCell()) != null && !this.graph.isCellEditable(cell)) {
            cell = null;
        }
        if (cell != null) {
            this.eventSource.fireEvent(new mxEventObject("startEditing", "cell", cell, "event", evt));
            this.cellEditor.startEditing(cell, evt);
        }
    }

    public String getEditingValue(Object cell, EventObject trigger) {
        return this.graph.convertValueToString(cell);
    }

    public void stopEditing(boolean cancel) {
        this.cellEditor.stopEditing(cancel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object labelChanged(Object cell, Object value, EventObject evt) {
        mxIGraphModel model = this.graph.getModel();
        model.beginUpdate();
        try {
            this.graph.cellLabelChanged(cell, value, this.graph.isAutoSizeCell(cell));
            this.eventSource.fireEvent(new mxEventObject("labelChanged", "cell", cell, "value", value, "event", evt));
        }
        finally {
            model.endUpdate();
        }
        return cell;
    }

    protected Dimension getPreferredSizeForPage() {
        return new Dimension((int)Math.round(this.pageFormat.getWidth() * this.pageScale * (double)this.horizontalPageCount), (int)Math.round(this.pageFormat.getHeight() * this.pageScale * (double)this.verticalPageCount));
    }

    public int getVerticalPageBorder() {
        return (int)Math.round(this.pageFormat.getWidth() * this.pageScale);
    }

    public int getHorizontalPageBorder() {
        return (int)Math.round(0.5 * this.pageFormat.getHeight() * this.pageScale);
    }

    protected Dimension getScaledPreferredSizeForGraph() {
        mxRectangle bounds = this.graph.getGraphBounds();
        int border = this.graph.getBorder();
        return new Dimension((int)Math.round(bounds.getX() + bounds.getWidth()) + border + 1, (int)Math.round(bounds.getY() + bounds.getHeight()) + border + 1);
    }

    protected mxPoint getPageTranslate(double scale) {
        Dimension d = this.getPreferredSizeForPage();
        Dimension bd = new Dimension(d);
        if (!this.preferPageSize) {
            bd.width += 2 * this.getHorizontalPageBorder();
            bd.height += 2 * this.getVerticalPageBorder();
        }
        double width = Math.max((double)bd.width, (double)(this.getViewport().getWidth() - 8) / scale);
        double height = Math.max((double)bd.height, (double)(this.getViewport().getHeight() - 8) / scale);
        double dx = Math.max(0.0, (width - (double)d.width) / 2.0);
        double dy = Math.max(0.0, (height - (double)d.height) / 2.0);
        return new mxPoint(dx, dy);
    }

    public void zoomAndCenter() {
        if (this.zoomPolicy != 0) {
            this.zoom(this.zoomPolicy == 1, this.centerOnResize || this.zoomPolicy == 1);
            this.centerOnResize = false;
        } else if (this.pageVisible && this.centerPage) {
            mxPoint translate = this.getPageTranslate(this.graph.getView().getScale());
            this.graph.getView().setTranslate(translate);
        } else {
            this.getGraphControl().updatePreferredSize();
        }
    }

    public void zoomIn() {
        this.zoom(this.zoomFactor);
    }

    public void zoomOut() {
        this.zoom(1.0 / this.zoomFactor);
    }

    public void zoom(double factor) {
        mxGraphView view = this.graph.getView();
        double newScale = (double)((int)(view.getScale() * 100.0 * factor)) / 100.0;
        if (newScale != view.getScale() && newScale > 0.04) {
            mxPoint translate = this.pageVisible && this.centerPage ? this.getPageTranslate(newScale) : new mxPoint();
            this.graph.getView().scaleAndTranslate(newScale, translate.getX(), translate.getY());
            if (this.keepSelectionVisibleOnZoom && !this.graph.isSelectionEmpty()) {
                this.getGraphControl().scrollRectToVisible(view.getBoundingBox(this.graph.getSelectionCells()).getRectangle());
            } else {
                this.maintainScrollBar(true, factor, this.centerZoom);
                this.maintainScrollBar(false, factor, this.centerZoom);
            }
        }
    }

    public void zoomTo(final double newScale, final boolean center) {
        mxGraphView view = this.graph.getView();
        final double scale = view.getScale();
        mxPoint translate = this.pageVisible && this.centerPage ? this.getPageTranslate(newScale) : new mxPoint();
        this.graph.getView().scaleAndTranslate(newScale, translate.getX(), translate.getY());
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                mxGraphComponent.this.maintainScrollBar(true, newScale / scale, center);
                mxGraphComponent.this.maintainScrollBar(false, newScale / scale, center);
            }
        });
    }

    public void zoomActual() {
        mxPoint translate = this.pageVisible && this.centerPage ? this.getPageTranslate(1.0) : new mxPoint();
        this.graph.getView().scaleAndTranslate(1.0, translate.getX(), translate.getY());
        if (this.isPageVisible()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JScrollBar scrollBar;
                    Dimension pageSize = mxGraphComponent.this.getPreferredSizeForPage();
                    if ((double)mxGraphComponent.this.getViewport().getWidth() > pageSize.getWidth()) {
                        mxGraphComponent.this.scrollToCenter(true);
                    } else {
                        scrollBar = mxGraphComponent.this.getHorizontalScrollBar();
                        if (scrollBar != null) {
                            scrollBar.setValue(scrollBar.getMaximum() / 3 - 4);
                        }
                    }
                    if ((double)mxGraphComponent.this.getViewport().getHeight() > pageSize.getHeight()) {
                        mxGraphComponent.this.scrollToCenter(false);
                    } else {
                        scrollBar = mxGraphComponent.this.getVerticalScrollBar();
                        if (scrollBar != null) {
                            scrollBar.setValue(scrollBar.getMaximum() / 4 - 4);
                        }
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zoom(final boolean page, final boolean center) {
        if (this.pageVisible && !this.zooming) {
            this.zooming = true;
            try {
                int off = this.getPageShadowColor() != null ? 8 : 0;
                double width = this.getViewport().getWidth() - off;
                double height = this.getViewport().getHeight() - off;
                Dimension d = this.getPreferredSizeForPage();
                double pageWidth = d.width;
                double pageHeight = d.height;
                double scaleX = width / pageWidth;
                double scaleY = page ? height / pageHeight : scaleX;
                double newScale = (double)((int)(Math.min(scaleX, scaleY) * 20.0)) / 20.0;
                if (newScale > 0.0) {
                    mxGraphView graphView = this.graph.getView();
                    double scale = graphView.getScale();
                    mxPoint translate = this.centerPage ? this.getPageTranslate(newScale) : new mxPoint();
                    graphView.scaleAndTranslate(newScale, translate.getX(), translate.getY());
                    final double factor = newScale / scale;
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            if (center) {
                                if (page) {
                                    mxGraphComponent.this.scrollToCenter(true);
                                    mxGraphComponent.this.scrollToCenter(false);
                                } else {
                                    mxGraphComponent.this.scrollToCenter(true);
                                    mxGraphComponent.this.maintainScrollBar(false, factor, false);
                                }
                            } else if (factor != 1.0) {
                                mxGraphComponent.this.maintainScrollBar(true, factor, false);
                                mxGraphComponent.this.maintainScrollBar(false, factor, false);
                            }
                        }
                    });
                }
            }
            finally {
                this.zooming = false;
            }
        }
    }

    protected void maintainScrollBar(boolean horizontal, double factor, boolean center) {
        JScrollBar scrollBar;
        JScrollBar jScrollBar = scrollBar = horizontal ? this.getHorizontalScrollBar() : this.getVerticalScrollBar();
        if (scrollBar != null) {
            BoundedRangeModel model = scrollBar.getModel();
            int newValue = (int)Math.round((double)model.getValue() * factor) + (int)Math.round(center ? (double)model.getExtent() * (factor - 1.0) / 2.0 : 0.0);
            model.setValue(newValue);
        }
    }

    public void scrollToCenter(boolean horizontal) {
        JScrollBar scrollBar;
        JScrollBar jScrollBar = scrollBar = horizontal ? this.getHorizontalScrollBar() : this.getVerticalScrollBar();
        if (scrollBar != null) {
            BoundedRangeModel model = scrollBar.getModel();
            int newValue = model.getMaximum() / 2 - model.getExtent() / 2;
            model.setValue(newValue);
        }
    }

    public void scrollCellToVisible(Object cell) {
        this.scrollCellToVisible(cell, false);
    }

    public void scrollCellToVisible(Object cell, boolean center) {
        mxCellState state = this.graph.getView().getState(cell);
        if (state != null) {
            mxRectangle bounds = state;
            if (center) {
                bounds = (mxRectangle)bounds.clone();
                bounds.setX(bounds.getCenterX() - (double)(this.getWidth() / 2));
                bounds.setWidth(this.getWidth());
                bounds.setY(bounds.getCenterY() - (double)(this.getHeight() / 2));
                bounds.setHeight(this.getHeight());
            }
            this.getGraphControl().scrollRectToVisible(bounds.getRectangle());
        }
    }

    public Object getCellAt(int x, int y) {
        return this.getCellAt(x, y, true);
    }

    public Object getCellAt(int x, int y, boolean hitSwimlaneContent) {
        return this.getCellAt(x, y, hitSwimlaneContent, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getCellAt(int x, int y, boolean hitSwimlaneContent, Object parent) {
        if (parent == null) {
            parent = this.graph.getDefaultParent();
        }
        if (parent != null) {
            mxPoint previousTranslate = this.canvas.getTranslate();
            double previousScale = this.canvas.getScale();
            try {
                this.canvas.setScale(this.graph.getView().getScale());
                this.canvas.setTranslate(0.0, 0.0);
                mxIGraphModel model = this.graph.getModel();
                mxGraphView view = this.graph.getView();
                Rectangle hit = new Rectangle(x, y, 1, 1);
                int childCount = model.getChildCount(parent);
                for (int i = childCount - 1; i >= 0; --i) {
                    mxCellState state;
                    Object cell = model.getChildAt(parent, i);
                    Object result = this.getCellAt(x, y, hitSwimlaneContent, cell);
                    if (result != null) {
                        Object object = result;
                        return object;
                    }
                    if (!this.graph.isCellVisible(cell) || (state = view.getState(cell)) == null || !this.canvas.intersects(this, hit, state) || this.graph.isSwimlane(cell) && !hitSwimlaneContent && (!this.transparentSwimlaneContent || this.canvas.hitSwimlaneContent(this, state, x, y))) continue;
                    Object object = cell;
                    return object;
                }
            }
            finally {
                this.canvas.setScale(previousScale);
                this.canvas.setTranslate((int)previousTranslate.getX(), (int)previousTranslate.getY());
            }
        }
        return null;
    }

    public void setSwimlaneSelectionEnabled(boolean value) {
        boolean oldValue = this.swimlaneSelectionEnabled;
        this.swimlaneSelectionEnabled = value;
        this.firePropertyChange("swimlaneSelectionEnabled", oldValue, this.swimlaneSelectionEnabled);
    }

    public boolean isSwimlaneSelectionEnabled() {
        return this.swimlaneSelectionEnabled;
    }

    public Object[] selectRegion(Rectangle rect, MouseEvent e) {
        Object[] cells = this.getCells(rect);
        if (cells.length > 0) {
            this.selectCellsForEvent(cells, e);
        } else if (!this.graph.isSelectionEmpty() && !e.isConsumed()) {
            this.graph.clearSelection();
        }
        return cells;
    }

    public Object[] getCells(Rectangle rect) {
        return this.getCells(rect, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getCells(Rectangle rect, Object parent) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (rect.width > 0 || rect.height > 0) {
            if (parent == null) {
                parent = this.graph.getDefaultParent();
            }
            if (parent != null) {
                mxPoint previousTranslate = this.canvas.getTranslate();
                double previousScale = this.canvas.getScale();
                try {
                    this.canvas.setScale(this.graph.getView().getScale());
                    this.canvas.setTranslate(0.0, 0.0);
                    mxIGraphModel model = this.graph.getModel();
                    mxGraphView view = this.graph.getView();
                    int childCount = model.getChildCount(parent);
                    for (int i = 0; i < childCount; ++i) {
                        Object cell = model.getChildAt(parent, i);
                        mxCellState state = view.getState(cell);
                        if (!this.graph.isCellVisible(cell) || state == null) continue;
                        if (this.canvas.contains(this, rect, state)) {
                            result.add(cell);
                            continue;
                        }
                        result.addAll(Arrays.asList(this.getCells(rect, cell)));
                    }
                }
                finally {
                    this.canvas.setScale(previousScale);
                    this.canvas.setTranslate(previousTranslate.getX(), previousTranslate.getY());
                }
            }
        }
        return result.toArray();
    }

    public void selectCellsForEvent(Object[] cells, MouseEvent event) {
        if (this.isToggleEvent(event)) {
            this.graph.addSelectionCells(cells);
        } else {
            this.graph.setSelectionCells(cells);
        }
    }

    public void selectCellForEvent(Object cell, MouseEvent e) {
        boolean isSelected = this.graph.isCellSelected(cell);
        if (this.isToggleEvent(e)) {
            if (isSelected) {
                this.graph.removeSelectionCell(cell);
            } else {
                this.graph.addSelectionCell(cell);
            }
        } else if (!isSelected || this.graph.getSelectionCount() != 1) {
            this.graph.setSelectionCell(cell);
        }
    }

    public boolean isSignificant(double dx, double dy) {
        return Math.abs(dx) > (double)this.tolerance || Math.abs(dy) > (double)this.tolerance;
    }

    public ImageIcon getFoldingIcon(mxCellState state) {
        boolean tmp;
        Object cell;
        if (state != null && this.isFoldingEnabled() && !this.getGraph().getModel().isEdge(state.getCell()) && this.graph.isCellFoldable(cell, !(tmp = this.graph.isCellCollapsed(cell = state.getCell())))) {
            return tmp ? this.collapsedIcon : this.expandedIcon;
        }
        return null;
    }

    public Rectangle getFoldingIconBounds(mxCellState state, ImageIcon icon) {
        mxIGraphModel model = this.graph.getModel();
        boolean isEdge = model.isEdge(state.getCell());
        double scale = this.getGraph().getView().getScale();
        int x = (int)Math.round(state.getX() + 4.0 * scale);
        int y = (int)Math.round(state.getY() + 4.0 * scale);
        int w = (int)Math.max(8.0, (double)icon.getIconWidth() * scale);
        int h = (int)Math.max(8.0, (double)icon.getIconHeight() * scale);
        if (isEdge) {
            mxPoint pt = this.graph.getView().getPoint(state);
            x = (int)pt.getX() - w / 2;
            y = (int)pt.getY() - h / 2;
        }
        return new Rectangle(x, y, w, h);
    }

    public boolean hitFoldingIcon(Object cell, int x, int y) {
        if (cell != null) {
            ImageIcon icon;
            mxCellState state;
            mxIGraphModel model = this.graph.getModel();
            boolean isEdge = model.isEdge(cell);
            if (this.foldingEnabled && (model.isVertex(cell) || isEdge) && (state = this.graph.getView().getState(cell)) != null && (icon = this.getFoldingIcon(state)) != null) {
                return this.getFoldingIconBounds(state, icon).contains(x, y);
            }
        }
        return false;
    }

    public void setToolTips(boolean enabled) {
        if (enabled) {
            ToolTipManager.sharedInstance().registerComponent(this.graphControl);
        } else {
            ToolTipManager.sharedInstance().unregisterComponent(this.graphControl);
        }
    }

    public boolean isConnectable() {
        return this.connectionHandler.isEnabled();
    }

    public void setConnectable(boolean connectable) {
        this.connectionHandler.setEnabled(connectable);
    }

    public boolean isPanning() {
        return this.panningHandler.isEnabled();
    }

    public void setPanning(boolean enabled) {
        this.panningHandler.setEnabled(enabled);
    }

    public boolean isAutoScroll() {
        return this.autoScroll;
    }

    public void setAutoScroll(boolean value) {
        this.autoScroll = value;
    }

    public boolean isAutoExtend() {
        return this.autoExtend;
    }

    public void setAutoExtend(boolean value) {
        this.autoExtend = value;
    }

    public boolean isEscapeEnabled() {
        return this.escapeEnabled;
    }

    public void setEscapeEnabled(boolean value) {
        boolean oldValue = this.escapeEnabled;
        this.escapeEnabled = value;
        this.firePropertyChange("escapeEnabled", oldValue, this.escapeEnabled);
    }

    public boolean isInvokesStopCellEditing() {
        return this.invokesStopCellEditing;
    }

    public void setInvokesStopCellEditing(boolean value) {
        boolean oldValue = this.invokesStopCellEditing;
        this.invokesStopCellEditing = value;
        this.firePropertyChange("invokesStopCellEditing", oldValue, this.invokesStopCellEditing);
    }

    public boolean isEnterStopsCellEditing() {
        return this.enterStopsCellEditing;
    }

    public void setEnterStopsCellEditing(boolean value) {
        boolean oldValue = this.enterStopsCellEditing;
        this.enterStopsCellEditing = value;
        this.firePropertyChange("enterStopsCellEditing", oldValue, this.enterStopsCellEditing);
    }

    public boolean isDragEnabled() {
        return this.dragEnabled;
    }

    public void setDragEnabled(boolean value) {
        boolean oldValue = this.dragEnabled;
        this.dragEnabled = value;
        this.firePropertyChange("dragEnabled", oldValue, this.dragEnabled);
    }

    public boolean isGridVisible() {
        return this.gridVisible;
    }

    public void setGridVisible(boolean value) {
        boolean oldValue = this.gridVisible;
        this.gridVisible = value;
        this.firePropertyChange("gridVisible", oldValue, this.gridVisible);
    }

    public boolean isAntiAlias() {
        return this.antiAlias;
    }

    public void setAntiAlias(boolean value) {
        boolean oldValue = this.antiAlias;
        this.antiAlias = value;
        this.firePropertyChange("antiAlias", oldValue, this.antiAlias);
    }

    public boolean isTextAntiAlias() {
        return this.antiAlias;
    }

    public void setTextAntiAlias(boolean value) {
        boolean oldValue = this.textAntiAlias;
        this.textAntiAlias = value;
        this.firePropertyChange("textAntiAlias", oldValue, this.textAntiAlias);
    }

    public float getPreviewAlpha() {
        return this.previewAlpha;
    }

    public void setPreviewAlpha(float value) {
        float oldValue = this.previewAlpha;
        this.previewAlpha = value;
        this.firePropertyChange("previewAlpha", oldValue, this.previewAlpha);
    }

    public boolean isTripleBuffered() {
        return this.tripleBuffered;
    }

    public boolean isForceTripleBuffered() {
        return false;
    }

    public void setTripleBuffered(boolean value) {
        boolean oldValue = this.tripleBuffered;
        this.tripleBuffered = value;
        this.firePropertyChange("tripleBuffered", oldValue, this.tripleBuffered);
    }

    public Color getGridColor() {
        return this.gridColor;
    }

    public void setGridColor(Color value) {
        Color oldValue = this.gridColor;
        this.gridColor = value;
        this.firePropertyChange("gridColor", oldValue, this.gridColor);
    }

    public int getGridStyle() {
        return this.gridStyle;
    }

    public void setGridStyle(int value) {
        int oldValue = this.gridStyle;
        this.gridStyle = value;
        this.firePropertyChange("gridStyle", oldValue, this.gridStyle);
    }

    public boolean isImportEnabled() {
        return this.importEnabled;
    }

    public void setImportEnabled(boolean value) {
        boolean oldValue = this.importEnabled;
        this.importEnabled = value;
        this.firePropertyChange("importEnabled", oldValue, this.importEnabled);
    }

    public Object[] getImportableCells(Object[] cells) {
        return mxGraphModel.filterCells(cells, new mxGraphModel.Filter(){

            public boolean filter(Object cell) {
                return mxGraphComponent.this.canImportCell(cell);
            }
        });
    }

    public boolean canImportCell(Object cell) {
        return this.isImportEnabled();
    }

    public boolean isExportEnabled() {
        return this.exportEnabled;
    }

    public void setExportEnabled(boolean value) {
        boolean oldValue = this.exportEnabled;
        this.exportEnabled = value;
        this.firePropertyChange("exportEnabled", oldValue, this.exportEnabled);
    }

    public Object[] getExportableCells(Object[] cells) {
        return mxGraphModel.filterCells(cells, new mxGraphModel.Filter(){

            public boolean filter(Object cell) {
                return mxGraphComponent.this.canExportCell(cell);
            }
        });
    }

    public boolean canExportCell(Object cell) {
        return this.isExportEnabled();
    }

    public boolean isFoldingEnabled() {
        return this.foldingEnabled;
    }

    public void setFoldingEnabled(boolean value) {
        boolean oldValue = this.foldingEnabled;
        this.foldingEnabled = value;
        this.firePropertyChange("foldingEnabled", oldValue, this.foldingEnabled);
    }

    public boolean isEditEvent(MouseEvent e) {
        return e != null ? e.getClickCount() == 2 : false;
    }

    public boolean isCloneEvent(MouseEvent event) {
        return event != null ? event.isControlDown() : false;
    }

    public boolean isToggleEvent(MouseEvent event) {
        return event != null ? (mxUtils.IS_MAC ? SwingUtilities.isLeftMouseButton(event) && event.isMetaDown() || SwingUtilities.isRightMouseButton(event) && event.isControlDown() : event.isControlDown()) : false;
    }

    public boolean isGridEnabledEvent(MouseEvent event) {
        return event != null ? !event.isAltDown() : false;
    }

    public boolean isPanningEvent(MouseEvent event) {
        return event != null ? event.isShiftDown() && event.isControlDown() : false;
    }

    public boolean isConstrainedEvent(MouseEvent event) {
        return event != null ? event.isShiftDown() : false;
    }

    public boolean isForceMarqueeEvent(MouseEvent event) {
        return event != null ? event.isAltDown() : false;
    }

    public mxPoint snapScaledPoint(mxPoint pt) {
        return this.snapScaledPoint(pt, 0.0, 0.0);
    }

    public mxPoint snapScaledPoint(mxPoint pt, double dx, double dy) {
        if (pt != null) {
            double scale = this.graph.getView().getScale();
            mxPoint trans = this.graph.getView().getTranslate();
            pt.setX((this.graph.snap(pt.getX() / scale - trans.getX() + dx / scale) + trans.getX()) * scale - dx);
            pt.setY((this.graph.snap(pt.getY() / scale - trans.getY() + dy / scale) + trans.getY()) * scale - dy);
        }
        return pt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int print(Graphics g, PageFormat printFormat, int page) {
        int result = 1;
        RepaintManager currentManager = RepaintManager.currentManager(this);
        currentManager.setDoubleBufferingEnabled(false);
        mxGraphView view = this.graph.getView();
        boolean eventsEnabled = view.isEventsEnabled();
        mxPoint translate = view.getTranslate();
        view.setEventsEnabled(false);
        mxTemporaryCellStates tempStates = new mxTemporaryCellStates(view, 1.0 / this.pageScale);
        try {
            view.setTranslate(new mxPoint(0.0, 0.0));
            mxInteractiveCanvas canvas = this.createCanvas();
            canvas.setGraphics((Graphics2D)g);
            canvas.setScale(1.0 / this.pageScale);
            view.revalidate();
            mxRectangle graphBounds = this.graph.getGraphBounds();
            Dimension pSize = new Dimension((int)Math.ceil(graphBounds.getX() + graphBounds.getWidth()) + 1, (int)Math.ceil(graphBounds.getY() + graphBounds.getHeight()) + 1);
            int w = (int)printFormat.getImageableWidth();
            int h = (int)printFormat.getImageableHeight();
            int cols = (int)Math.max(Math.ceil((double)(pSize.width - 5) / (double)w), 1.0);
            int rows = (int)Math.max(Math.ceil((double)(pSize.height - 5) / (double)h), 1.0);
            if (page < cols * rows) {
                int dx = (int)((double)(page % cols) * printFormat.getImageableWidth());
                int dy = (int)(Math.floor(page / cols) * printFormat.getImageableHeight());
                g.translate(-dx + (int)printFormat.getImageableX(), -dy + (int)printFormat.getImageableY());
                g.setClip(dx, dy, (int)((double)dx + printFormat.getWidth()), (int)((double)dy + printFormat.getHeight()));
                this.graph.drawGraph(canvas);
                result = 0;
            }
        }
        finally {
            view.setTranslate(translate);
            tempStates.destroy();
            view.setEventsEnabled(eventsEnabled);
            currentManager.setDoubleBufferingEnabled(true);
        }
        return result;
    }

    public mxInteractiveCanvas getCanvas() {
        return this.canvas;
    }

    public BufferedImage getTripleBuffer() {
        return this.tripleBuffer;
    }

    public mxInteractiveCanvas createCanvas() {
        return new mxInteractiveCanvas();
    }

    public mxCellHandler createHandler(mxCellState state) {
        if (this.graph.getModel().isVertex(state.getCell())) {
            return new mxVertexHandler(this, state);
        }
        if (this.graph.getModel().isEdge(state.getCell())) {
            mxEdgeStyle.mxEdgeStyleFunction style = this.graph.getView().getEdgeStyle(state, null, null, null);
            if (this.graph.isLoop(state) || style == mxEdgeStyle.ElbowConnector || style == mxEdgeStyle.SideToSide || style == mxEdgeStyle.TopToBottom) {
                return new mxElbowEdgeHandler(this, state);
            }
            return new mxEdgeHandler(this, state);
        }
        return new mxCellHandler(this, state);
    }

    public Component[] createComponents(mxCellState state) {
        return null;
    }

    public void insertComponent(mxCellState state, Component c) {
        this.getGraphControl().add(c, 0);
    }

    public void removeComponent(Component c, Object cell) {
        if (c.getParent() != null) {
            c.getParent().remove(c);
        }
    }

    public void updateComponent(mxCellState state, Component c) {
        int x = (int)state.getX();
        int y = (int)state.getY();
        int width = (int)state.getWidth();
        int height = (int)state.getHeight();
        Dimension s = c.getMinimumSize();
        if (s.width > width) {
            x -= (s.width - width) / 2;
            width = s.width;
        }
        if (s.height > height) {
            y -= (s.height - height) / 2;
            height = s.height;
        }
        c.setBounds(x, y, width, height);
    }

    public void updateComponents() {
        Object root = this.graph.getModel().getRoot();
        Hashtable<Object, Component[]> result = this.updateComponents(root);
        this.removeAllComponents(this.components);
        this.components = result;
        if (!this.overlays.isEmpty()) {
            Hashtable<Object, mxICellOverlay[]> result2 = this.updateCellOverlays(root);
            this.removeAllOverlays(this.overlays);
            this.overlays = result2;
        }
    }

    public void removeAllComponents(Hashtable<Object, Component[]> map) {
        for (Map.Entry<Object, Component[]> entry : map.entrySet()) {
            Component[] c = entry.getValue();
            for (int i = 0; i < c.length; ++i) {
                this.removeComponent(c[i], entry.getKey());
            }
        }
    }

    public void removeAllOverlays(Hashtable<Object, mxICellOverlay[]> map) {
        for (Map.Entry<Object, mxICellOverlay[]> entry : map.entrySet()) {
            mxICellOverlay[] c = entry.getValue();
            for (int i = 0; i < c.length; ++i) {
                this.removeCellOverlayComponent(c[i], entry.getKey());
            }
        }
    }

    public Hashtable<Object, Component[]> updateComponents(Object cell) {
        Hashtable<Object, Component[]> result = new Hashtable<Object, Component[]>();
        Component[] c = this.components.remove(cell);
        mxCellState state = this.getGraph().getView().getState(cell);
        if (state != null) {
            int i;
            if (c == null && (c = this.createComponents(state)) != null) {
                for (i = 0; i < c.length; ++i) {
                    this.insertComponent(state, c[i]);
                }
            }
            if (c != null) {
                result.put(cell, c);
                for (i = 0; i < c.length; ++i) {
                    this.updateComponent(state, c[i]);
                }
            }
        } else if (c != null) {
            this.components.put(cell, c);
        }
        int childCount = this.getGraph().getModel().getChildCount(cell);
        for (int i = 0; i < childCount; ++i) {
            result.putAll(this.updateComponents(this.getGraph().getModel().getChildAt(cell, i)));
        }
        return result;
    }

    public String validateGraph() {
        return this.validateGraph(this.graph.getModel().getRoot(), new Hashtable<Object, Object>());
    }

    public String validateGraph(Object cell, Hashtable<Object, Object> context) {
        Object tmp;
        mxIGraphModel model = this.graph.getModel();
        mxGraphView view = this.graph.getView();
        boolean isValid = true;
        int childCount = model.getChildCount(cell);
        for (int i = 0; i < childCount; ++i) {
            String warn;
            tmp = model.getChildAt(cell, i);
            Hashtable<Object, Object> ctx = context;
            if (this.graph.isValidRoot(tmp)) {
                ctx = new Hashtable();
            }
            if ((warn = this.validateGraph(tmp, ctx)) != null) {
                String html = warn.replaceAll("\n", "<br>");
                int len = html.length();
                this.setCellWarning(tmp, html.substring(0, Math.max(0, len - 4)));
            } else {
                this.setCellWarning(tmp, null);
            }
            isValid = isValid && warn == null;
        }
        StringBuffer warning = new StringBuffer();
        if (this.graph.isCellCollapsed(cell) && !isValid) {
            warning.append(mxResources.get("containsValidationErrors", "Contains Validation Errors") + "\n");
        }
        if (model.isEdge(cell)) {
            tmp = this.graph.getEdgeValidationError(cell, model.getTerminal(cell, true), model.getTerminal(cell, false));
            if (tmp != null) {
                warning.append((String)tmp);
            }
        } else {
            tmp = this.graph.getCellValidationError(cell);
            if (tmp != null) {
                warning.append((String)tmp);
            }
        }
        String err = this.graph.validateCell(cell, context);
        if (err != null) {
            warning.append(err);
        }
        if (model.getParent(cell) == null) {
            view.validate();
        }
        return warning.length() > 0 || !isValid ? warning.toString() : null;
    }

    public mxICellOverlay addCellOverlay(Object cell, mxICellOverlay overlay) {
        mxICellOverlay[] arr = this.getCellOverlays(cell);
        if (arr == null) {
            arr = new mxICellOverlay[]{overlay};
        } else {
            mxICellOverlay[] arr2 = new mxICellOverlay[arr.length + 1];
            System.arraycopy(arr, 0, arr2, 0, arr.length);
            arr2[arr.length] = overlay;
            arr = arr2;
        }
        this.overlays.put(cell, arr);
        mxCellState state = this.graph.getView().getState(cell);
        if (state != null) {
            this.updateCellOverlayComponent(state, overlay);
        }
        this.eventSource.fireEvent(new mxEventObject("addOverlay", "cell", cell, "overlay", overlay));
        return overlay;
    }

    public mxICellOverlay[] getCellOverlays(Object cell) {
        return this.overlays.get(cell);
    }

    public mxICellOverlay removeCellOverlay(Object cell, mxICellOverlay overlay) {
        if (overlay == null) {
            this.removeCellOverlays(cell);
        } else {
            mxICellOverlay[] arr = this.getCellOverlays(cell);
            if (arr != null) {
                ArrayList<mxICellOverlay> list = new ArrayList<mxICellOverlay>(Arrays.asList(arr));
                if (list.remove(overlay)) {
                    this.removeCellOverlayComponent(overlay, cell);
                }
                arr = list.toArray(new mxICellOverlay[list.size()]);
                this.overlays.put(cell, arr);
            }
        }
        return overlay;
    }

    public mxICellOverlay[] removeCellOverlays(Object cell) {
        mxICellOverlay[] ovls = this.overlays.remove(cell);
        if (ovls != null) {
            for (int i = 0; i < ovls.length; ++i) {
                this.removeCellOverlayComponent(ovls[i], cell);
            }
        }
        return ovls;
    }

    protected void removeCellOverlayComponent(mxICellOverlay overlay, Object cell) {
        Component comp;
        if (overlay instanceof Component && (comp = (Component)((Object)overlay)).getParent() != null) {
            comp.setVisible(false);
            comp.getParent().remove(comp);
            this.eventSource.fireEvent(new mxEventObject("removeOverlay", "cell", cell, "overlay", overlay));
        }
    }

    protected void updateCellOverlayComponent(mxCellState state, mxICellOverlay overlay) {
        if (overlay instanceof Component) {
            mxRectangle rect;
            Component comp = (Component)((Object)overlay);
            if (comp.getParent() == null) {
                this.getGraphControl().add(comp, 0);
            }
            if ((rect = overlay.getBounds(state)) != null) {
                comp.setBounds(rect.getRectangle());
                comp.setVisible(true);
            } else {
                comp.setVisible(false);
            }
        }
    }

    public void clearCellOverlays() {
        this.clearCellOverlays(null);
    }

    public void clearCellOverlays(Object cell) {
        mxIGraphModel model = this.graph.getModel();
        if (cell == null) {
            cell = model.getRoot();
        }
        this.removeCellOverlays(cell);
        int childCount = model.getChildCount(cell);
        for (int i = 0; i < childCount; ++i) {
            Object child = model.getChildAt(cell, i);
            this.clearCellOverlays(child);
        }
    }

    public mxICellOverlay setCellWarning(Object cell, String warning) {
        return this.setCellWarning(cell, warning, null, false);
    }

    public mxICellOverlay setCellWarning(Object cell, String warning, ImageIcon icon) {
        return this.setCellWarning(cell, warning, icon, false);
    }

    public mxICellOverlay setCellWarning(final Object cell, String warning, ImageIcon icon, boolean select) {
        if (warning != null && warning.length() > 0) {
            icon = icon != null ? icon : this.warningIcon;
            mxCellOverlay overlay = new mxCellOverlay(icon, warning);
            if (select) {
                overlay.addMouseListener(new MouseAdapter(){

                    public void mousePressed(MouseEvent e) {
                        if (mxGraphComponent.this.getGraph().isEnabled()) {
                            mxGraphComponent.this.getGraph().setSelectionCell(cell);
                        }
                    }
                });
                overlay.setCursor(new Cursor(12));
            }
            return this.addCellOverlay(cell, overlay);
        }
        this.removeCellOverlays(cell);
        return null;
    }

    public Hashtable<Object, mxICellOverlay[]> updateCellOverlays(Object cell) {
        Hashtable<Object, mxICellOverlay[]> result = new Hashtable<Object, mxICellOverlay[]>();
        mxICellOverlay[] c = this.overlays.remove(cell);
        mxCellState state = this.getGraph().getView().getState(cell);
        if (c != null) {
            int i;
            if (state != null) {
                for (i = 0; i < c.length; ++i) {
                    this.updateCellOverlayComponent(state, c[i]);
                }
            } else {
                for (i = 0; i < c.length; ++i) {
                    this.removeCellOverlayComponent(c[i], cell);
                }
            }
            result.put(cell, c);
        }
        int childCount = this.getGraph().getModel().getChildCount(cell);
        for (int i = 0; i < childCount; ++i) {
            result.putAll(this.updateCellOverlays(this.getGraph().getModel().getChildAt(cell, i)));
        }
        return result;
    }

    protected void paintBackground(Graphics g) {
        Rectangle clip = g.getClipBounds();
        Rectangle rect = this.paintBackgroundPage(g);
        if (this.isPageVisible()) {
            g.clipRect(rect.x + 1, rect.y + 1, rect.width - 1, rect.height - 1);
        }
        this.paintBackgroundImage(g);
        this.paintGrid(g);
        g.setClip(clip);
    }

    protected Rectangle paintBackgroundPage(Graphics g) {
        mxPoint translate = this.graph.getView().getTranslate();
        double scale = this.graph.getView().getScale();
        int x0 = (int)Math.round(translate.getX() * scale) - 1;
        int y0 = (int)Math.round(translate.getY() * scale) - 1;
        Dimension d = this.getPreferredSizeForPage();
        int w = (int)Math.round((double)d.width * scale) + 2;
        int h = (int)Math.round((double)d.height * scale) + 2;
        if (this.isPageVisible()) {
            Color c = this.getPageBackgroundColor();
            if (c != null) {
                g.setColor(c);
                mxUtils.fillClippedRect(g, 0, 0, this.getGraphControl().getWidth(), this.getGraphControl().getHeight());
            }
            if ((c = this.getPageShadowColor()) != null) {
                g.setColor(c);
                mxUtils.fillClippedRect(g, x0 + w, y0 + 6, 6, h - 6);
                mxUtils.fillClippedRect(g, x0 + 8, y0 + h, w - 2, 6);
            }
            Color bg = this.getBackground();
            if (this.getViewport().isOpaque()) {
                bg = this.getViewport().getBackground();
            }
            g.setColor(bg);
            mxUtils.fillClippedRect(g, x0 + 1, y0 + 1, w, h);
            c = this.getPageBorderColor();
            if (c != null) {
                g.setColor(c);
                g.drawRect(x0, y0, w, h);
            }
        }
        if (this.isPageBreaksVisible() && (this.horizontalPageCount > 1 || this.verticalPageCount > 1)) {
            int i;
            Graphics2D g2 = (Graphics2D)g;
            Stroke previousStroke = g2.getStroke();
            g2.setStroke(new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{1.0f, 2.0f}, 0.0f));
            g2.setColor(this.pageBreakColor);
            for (i = 1; i <= this.horizontalPageCount - 1; ++i) {
                int dx = i * w / this.horizontalPageCount;
                g2.drawLine(x0 + dx, y0 + 1, x0 + dx, y0 + h);
            }
            for (i = 1; i <= this.verticalPageCount - 1; ++i) {
                int dy = i * h / this.verticalPageCount;
                g2.drawLine(x0 + 1, y0 + dy, x0 + w, y0 + dy);
            }
            g2.setStroke(previousStroke);
        }
        return new Rectangle(x0, y0, w, h);
    }

    protected void paintBackgroundImage(Graphics g) {
        if (this.backgroundImage != null) {
            mxPoint translate = this.graph.getView().getTranslate();
            double scale = this.graph.getView().getScale();
            g.drawImage(this.backgroundImage.getImage(), (int)(translate.getX() * scale), (int)(translate.getY() * scale), (int)((double)this.backgroundImage.getIconWidth() * scale), (int)((double)this.backgroundImage.getIconHeight() * scale), this);
        }
    }

    protected void paintGrid(Graphics g) {
        if (this.isGridVisible()) {
            int gridSize;
            g.setColor(this.getGridColor());
            Rectangle clip = g.getClipBounds();
            if (clip == null) {
                clip = this.getGraphControl().getBounds();
            }
            double left = clip.getX();
            double top = clip.getY();
            double right = left + clip.getWidth();
            double bottom = top + clip.getHeight();
            int style = this.getGridStyle();
            int minStepping = gridSize = this.graph.getGridSize();
            if (style == 1 || style == 0) {
                minStepping /= 2;
            }
            mxPoint trans = this.graph.getView().getTranslate();
            double scale = this.graph.getView().getScale();
            double tx = trans.getX() * scale;
            double ty = trans.getY() * scale;
            double stepping = (double)gridSize * scale;
            if (stepping < (double)minStepping) {
                int count = (int)Math.round(Math.ceil((double)minStepping / stepping) / 2.0) * 2;
                stepping = (double)count * stepping;
            }
            double xs = Math.floor((left - tx) / stepping) * stepping + tx;
            double xe = Math.ceil(right / stepping) * stepping;
            double ys = Math.floor((top - ty) / stepping) * stepping + ty;
            double ye = Math.ceil(bottom / stepping) * stepping;
            switch (style) {
                case 1: {
                    int cs = stepping > 16.0 ? 2 : 1;
                    for (double x = xs; x <= xe; x += stepping) {
                        for (double y = ys; y <= ye; y += stepping) {
                            x = (double)Math.round((x - tx) / stepping) * stepping + tx;
                            y = (double)Math.round((y - ty) / stepping) * stepping + ty;
                            int ix = (int)Math.round(x);
                            int iy = (int)Math.round(y);
                            g.drawLine(ix - cs, iy, ix + cs, iy);
                            g.drawLine(ix, iy - cs, ix, iy + cs);
                        }
                    }
                    break;
                }
                case 2: {
                    int ixs = (int)Math.round(xs);
                    int ixe = (int)Math.round(xe += (double)((int)Math.ceil(stepping)));
                    int iys = (int)Math.round(ys);
                    int iye = (int)Math.round(ye += (double)((int)Math.ceil(stepping)));
                    for (double x = xs; x <= xe; x += stepping) {
                        x = (double)Math.round((x - tx) / stepping) * stepping + tx;
                        int ix = (int)Math.round(x);
                        g.drawLine(ix, iys, ix, iye);
                    }
                    for (double y = ys; y <= ye; y += stepping) {
                        y = (double)Math.round((y - ty) / stepping) * stepping + ty;
                        int iy = (int)Math.round(y);
                        g.drawLine(ixs, iy, ixe, iy);
                    }
                    break;
                }
                case 3: {
                    Graphics2D g2 = (Graphics2D)g;
                    Stroke stroke = g2.getStroke();
                    int ixs = (int)Math.round(xs);
                    int ixe = (int)Math.round(xe += (double)((int)Math.ceil(stepping)));
                    int iys = (int)Math.round(ys);
                    int iye = (int)Math.round(ye += (double)((int)Math.ceil(stepping)));
                    Stroke[] strokes = new Stroke[]{new BasicStroke(1.0f, 0, 0, 1.0f, new float[]{3.0f, 1.0f}, Math.max(0, iys) % 4), new BasicStroke(1.0f, 0, 0, 1.0f, new float[]{2.0f, 2.0f}, Math.max(0, iys) % 4), new BasicStroke(1.0f, 0, 0, 1.0f, new float[]{1.0f, 1.0f}, 0.0f), new BasicStroke(1.0f, 0, 0, 1.0f, new float[]{2.0f, 2.0f}, Math.max(0, iys) % 4)};
                    for (double x = xs; x <= xe; x += stepping) {
                        g2.setStroke(strokes[(int)(x / stepping) % strokes.length]);
                        double xx = (double)Math.round((x - tx) / stepping) * stepping + tx;
                        int ix = (int)Math.round(xx);
                        g.drawLine(ix, iys, ix, iye);
                    }
                    strokes = new Stroke[]{new BasicStroke(1.0f, 0, 0, 1.0f, new float[]{3.0f, 1.0f}, Math.max(0, ixs) % 4), new BasicStroke(1.0f, 0, 0, 1.0f, new float[]{2.0f, 2.0f}, Math.max(0, ixs) % 4), new BasicStroke(1.0f, 0, 0, 1.0f, new float[]{1.0f, 1.0f}, 0.0f), new BasicStroke(1.0f, 0, 0, 1.0f, new float[]{2.0f, 2.0f}, Math.max(0, ixs) % 4)};
                    for (double y = ys; y <= ye; y += stepping) {
                        g2.setStroke(strokes[(int)(y / stepping) % strokes.length]);
                        double yy = (double)Math.round((y - ty) / stepping) * stepping + ty;
                        int iy = (int)Math.round(yy);
                        g.drawLine(ixs, iy, ixe, iy);
                    }
                    g2.setStroke(stroke);
                    break;
                }
                default: {
                    for (double x = xs; x <= xe; x += stepping) {
                        for (double y = ys; y <= ye; y += stepping) {
                            x = (double)Math.round((x - tx) / stepping) * stepping + tx;
                            y = (double)Math.round((y - ty) / stepping) * stepping + ty;
                            int ix = (int)Math.round(x);
                            int iy = (int)Math.round(y);
                            g.drawLine(ix, iy, ix, iy);
                        }
                    }
                }
            }
        }
    }

    public void redraw(mxCellState state) {
        if (state != null) {
            Rectangle dirty = state.getBoundingBox().getRectangle();
            this.repaintTripleBuffer(new Rectangle(dirty));
            dirty = SwingUtilities.convertRectangle(this.graphControl, dirty, this);
            this.repaint(dirty);
        }
    }

    public void checkTripleBuffer() {
        mxRectangle bounds = this.graph.getGraphBounds();
        int width = (int)Math.ceil(bounds.getX() + bounds.getWidth() + 2.0);
        int height = (int)Math.ceil(bounds.getY() + bounds.getHeight() + 2.0);
        if (this.tripleBuffer != null && (this.tripleBuffer.getWidth() != width || this.tripleBuffer.getHeight() != height)) {
            this.destroyTripleBuffer();
        }
        if (this.tripleBuffer == null) {
            this.createTripleBuffer(width, height);
        }
    }

    protected void createTripleBuffer(int width, int height) {
        try {
            this.tripleBuffer = mxUtils.createBufferedImage(width, height, null);
            this.tripleBufferGraphics = this.tripleBuffer.createGraphics();
            mxUtils.setAntiAlias(this.tripleBufferGraphics, this.antiAlias, this.textAntiAlias);
            this.repaintTripleBuffer(null);
        }
        catch (OutOfMemoryError error) {
            log.log(Level.SEVERE, "Failed to create a triple buffer", error);
        }
    }

    public void destroyTripleBuffer() {
        if (this.tripleBuffer != null) {
            this.tripleBuffer = null;
            this.tripleBufferGraphics.dispose();
            this.tripleBufferGraphics = null;
        }
    }

    public void repaintTripleBuffer(Rectangle dirty) {
        if (this.tripleBuffered && this.tripleBufferGraphics != null) {
            if (dirty == null) {
                dirty = new Rectangle(this.tripleBuffer.getWidth(), this.tripleBuffer.getHeight());
            }
            mxUtils.clearRect(this.tripleBufferGraphics, dirty, null);
            this.tripleBufferGraphics.setClip(dirty);
            this.graphControl.drawGraph(this.tripleBufferGraphics, true);
            this.tripleBufferGraphics.setClip(null);
        }
    }

    public boolean isEventsEnabled() {
        return this.eventSource.isEventsEnabled();
    }

    public void setEventsEnabled(boolean eventsEnabled) {
        this.eventSource.setEventsEnabled(eventsEnabled);
    }

    public void addListener(String eventName, mxEventSource.mxIEventListener listener) {
        this.eventSource.addListener(eventName, listener);
    }

    public void removeListener(mxEventSource.mxIEventListener listener) {
        this.eventSource.removeListener(listener);
    }

    public void removeListener(mxEventSource.mxIEventListener listener, String eventName) {
        this.eventSource.removeListener(listener, eventName);
    }

    static {
        DEFAULT_EXPANDED_ICON = new ImageIcon(mxGraphComponent.class.getResource("/com/mxgraph/swing/images/expanded.gif"));
        DEFAULT_COLLAPSED_ICON = new ImageIcon(mxGraphComponent.class.getResource("/com/mxgraph/swing/images/collapsed.gif"));
        DEFAULT_WARNING_ICON = new ImageIcon(mxGraphComponent.class.getResource("/com/mxgraph/swing/images/warning.gif"));
    }

    public static class mxMouseRedirector
    implements MouseListener,
    MouseMotionListener {
        protected mxGraphComponent graphComponent;

        public mxMouseRedirector(mxGraphComponent graphComponent) {
            this.graphComponent = graphComponent;
        }

        public void mouseClicked(MouseEvent e) {
            this.graphComponent.getGraphControl().dispatchEvent(SwingUtilities.convertMouseEvent(e.getComponent(), e, this.graphComponent.getGraphControl()));
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
            this.mouseClicked(e);
        }

        public void mousePressed(MouseEvent e) {
            this.mouseClicked(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.mouseClicked(e);
        }

        public void mouseDragged(MouseEvent e) {
            this.mouseClicked(e);
        }

        public void mouseMoved(MouseEvent e) {
            this.mouseClicked(e);
        }
    }

    public class mxGraphControl
    extends JComponent {
        private static final long serialVersionUID = -8916603170766739124L;
        protected Point translate = new Point(0, 0);

        public mxGraphControl() {
            this.addMouseListener(new MouseAdapter(){

                public void mouseReleased(MouseEvent e) {
                    if (mxGraphControl.this.translate.x != 0 || mxGraphControl.this.translate.y != 0) {
                        mxGraphControl.this.translate = new Point(0, 0);
                        mxGraphControl.this.repaint();
                    }
                }
            });
        }

        public Point getTranslate() {
            return this.translate;
        }

        public void setTranslate(Point value) {
            this.translate = value;
        }

        public mxGraphComponent getGraphContainer() {
            return mxGraphComponent.this;
        }

        public void scrollRectToVisible(Rectangle aRect, boolean extend) {
            super.scrollRectToVisible(aRect);
            if (extend) {
                this.extendComponent(aRect);
            }
        }

        protected void extendComponent(Rectangle rect) {
            int right = rect.x + rect.width;
            int bottom = rect.y + rect.height;
            Dimension d = new Dimension(this.getPreferredSize());
            Dimension sp = mxGraphComponent.this.getScaledPreferredSizeForGraph();
            mxRectangle min = mxGraphComponent.this.graph.getMinimumGraphSize();
            double scale = mxGraphComponent.this.graph.getView().getScale();
            boolean update = false;
            if (rect.x < 0) {
                this.translate.x = Math.max(this.translate.x, Math.max(0, -rect.x));
                d.width = sp.width;
                if (min != null) {
                    d.width = (int)Math.max((long)d.width, Math.round(min.getWidth() * scale));
                }
                d.width += this.translate.x;
                update = true;
            } else if (right > this.getWidth()) {
                d.width = Math.max(right, this.getWidth());
                update = true;
            }
            if (rect.y < 0) {
                this.translate.y = Math.max(this.translate.y, Math.max(0, -rect.y));
                d.height = sp.height;
                if (min != null) {
                    d.height = (int)Math.max((long)d.height, Math.round(min.getHeight() * scale));
                }
                d.height += this.translate.y;
                update = true;
            } else if (bottom > this.getHeight()) {
                d.height = Math.max(bottom, this.getHeight());
                update = true;
            }
            if (update) {
                this.setPreferredSize(d);
                this.setMinimumSize(d);
                this.revalidate();
            }
        }

        public String getToolTipText(MouseEvent e) {
            Object cell;
            String tip = mxGraphComponent.this.getSelectionCellsHandler().getToolTipText(e);
            if (tip == null && (cell = mxGraphComponent.this.getCellAt(e.getX(), e.getY())) != null) {
                tip = mxGraphComponent.this.hitFoldingIcon(cell, e.getX(), e.getY()) ? mxResources.get("collapse-expand") : mxGraphComponent.this.graph.getToolTipForCell(cell);
            }
            if (tip != null && tip.length() > 0) {
                return tip;
            }
            return super.getToolTipText(e);
        }

        public void updatePreferredSize() {
            double scale = mxGraphComponent.this.graph.getView().getScale();
            Dimension d = null;
            if (mxGraphComponent.this.preferPageSize || mxGraphComponent.this.pageVisible) {
                Dimension page = mxGraphComponent.this.getPreferredSizeForPage();
                if (!mxGraphComponent.this.preferPageSize) {
                    page.width += 2 * mxGraphComponent.this.getHorizontalPageBorder();
                    page.height += 2 * mxGraphComponent.this.getVerticalPageBorder();
                }
                d = new Dimension((int)((double)page.width * scale), (int)((double)page.height * scale));
            } else {
                d = mxGraphComponent.this.getScaledPreferredSizeForGraph();
            }
            mxRectangle min = mxGraphComponent.this.graph.getMinimumGraphSize();
            if (min != null) {
                d.width = (int)Math.max((long)d.width, Math.round(min.getWidth() * scale));
                d.height = (int)Math.max((long)d.height, Math.round(min.getHeight() * scale));
            }
            if (!this.getPreferredSize().equals(d)) {
                this.setPreferredSize(d);
                this.setMinimumSize(d);
                this.revalidate();
            }
        }

        public void paint(Graphics g) {
            g.translate(this.translate.x, this.translate.y);
            mxGraphComponent.this.eventSource.fireEvent(new mxEventObject("beforePaint", "g", g));
            super.paint(g);
            mxGraphComponent.this.eventSource.fireEvent(new mxEventObject("afterPaint", "g", g));
            g.translate(-this.translate.x, -this.translate.y);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            mxGraphComponent.this.paintBackground(g);
            if (mxGraphComponent.this.tripleBuffered) {
                mxGraphComponent.this.checkTripleBuffer();
            } else if (mxGraphComponent.this.tripleBuffer != null) {
                mxGraphComponent.this.destroyTripleBuffer();
            }
            if (mxGraphComponent.this.tripleBuffer != null) {
                mxUtils.drawImageClip(g, mxGraphComponent.this.tripleBuffer, this);
            } else {
                Graphics2D g2 = (Graphics2D)g;
                RenderingHints tmp = g2.getRenderingHints();
                try {
                    mxUtils.setAntiAlias(g2, mxGraphComponent.this.antiAlias, mxGraphComponent.this.textAntiAlias);
                    this.drawGraph(g2, true);
                }
                finally {
                    g2.setRenderingHints(tmp);
                }
            }
            mxGraphComponent.this.eventSource.fireEvent(new mxEventObject("paint", "g", g));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void drawGraph(Graphics2D g, boolean drawLabels) {
            Graphics2D previousGraphics = mxGraphComponent.this.canvas.getGraphics();
            boolean previousDrawLabels = mxGraphComponent.this.canvas.isDrawLabels();
            mxPoint previousTranslate = mxGraphComponent.this.canvas.getTranslate();
            double previousScale = mxGraphComponent.this.canvas.getScale();
            try {
                mxGraphComponent.this.canvas.setScale(mxGraphComponent.this.graph.getView().getScale());
                mxGraphComponent.this.canvas.setDrawLabels(drawLabels);
                mxGraphComponent.this.canvas.setTranslate(0.0, 0.0);
                mxGraphComponent.this.canvas.setGraphics(g);
                this.drawFromRootCell();
            }
            finally {
                mxGraphComponent.this.canvas.setScale(previousScale);
                mxGraphComponent.this.canvas.setTranslate(previousTranslate.getX(), previousTranslate.getY());
                mxGraphComponent.this.canvas.setDrawLabels(previousDrawLabels);
                mxGraphComponent.this.canvas.setGraphics(previousGraphics);
            }
        }

        protected void drawFromRootCell() {
            this.drawCell(mxGraphComponent.this.canvas, mxGraphComponent.this.graph.getModel().getRoot());
        }

        protected boolean hitClip(mxGraphics2DCanvas canvas, mxCellState state) {
            Rectangle rect = this.getExtendedCellBounds(state);
            return rect == null || canvas.getGraphics().hitClip(rect.x, rect.y, rect.width, rect.height);
        }

        protected Rectangle getExtendedCellBounds(mxCellState state) {
            Rectangle rect = null;
            double rotation = mxUtils.getDouble(state.getStyle(), mxConstants.STYLE_ROTATION);
            mxRectangle tmp = mxUtils.getBoundingBox(new mxRectangle(state), rotation);
            int border = (int)Math.ceil(mxUtils.getDouble(state.getStyle(), mxConstants.STYLE_STROKEWIDTH) * mxGraphComponent.this.graph.getView().getScale()) + 1;
            tmp.grow(border);
            if (mxUtils.isTrue(state.getStyle(), mxConstants.STYLE_SHADOW)) {
                tmp.setWidth(tmp.getWidth() + (double)mxConstants.SHADOW_OFFSETX);
                tmp.setHeight(tmp.getHeight() + (double)mxConstants.SHADOW_OFFSETX);
            }
            if (state.getLabelBounds() != null) {
                tmp.add(state.getLabelBounds());
            }
            rect = tmp.getRectangle();
            return rect;
        }

        public void drawCell(mxICanvas canvas, Object cell) {
            mxCellState state = mxGraphComponent.this.graph.getView().getState(cell);
            if (state != null && this.isCellDisplayable(state.getCell()) && (!(canvas instanceof mxGraphics2DCanvas) || this.hitClip((mxGraphics2DCanvas)canvas, state))) {
                mxGraphComponent.this.graph.drawState(canvas, state, cell != mxGraphComponent.this.cellEditor.getEditingCell());
            }
            boolean edgesFirst = mxGraphComponent.this.graph.isKeepEdgesInBackground();
            boolean edgesLast = mxGraphComponent.this.graph.isKeepEdgesInForeground();
            if (edgesFirst) {
                this.drawChildren(cell, true, false);
            }
            this.drawChildren(cell, !edgesFirst && !edgesLast, true);
            if (edgesLast) {
                this.drawChildren(cell, true, false);
            }
            if (state != null) {
                this.cellDrawn(canvas, state);
            }
        }

        protected void drawChildren(Object cell, boolean edges, boolean others) {
            mxIGraphModel model = mxGraphComponent.this.graph.getModel();
            int childCount = model.getChildCount(cell);
            for (int i = 0; i < childCount; ++i) {
                Object child = model.getChildAt(cell, i);
                boolean isEdge = model.isEdge(child);
                if ((!others || isEdge) && (!edges || !isEdge)) continue;
                this.drawCell(mxGraphComponent.this.canvas, model.getChildAt(cell, i));
            }
        }

        protected void cellDrawn(mxICanvas canvas, mxCellState state) {
            if (mxGraphComponent.this.isFoldingEnabled() && canvas instanceof mxGraphics2DCanvas) {
                ImageIcon icon;
                mxIGraphModel model = mxGraphComponent.this.graph.getModel();
                mxGraphics2DCanvas g2c = (mxGraphics2DCanvas)canvas;
                Graphics2D g2 = g2c.getGraphics();
                boolean isEdge = model.isEdge(state.getCell());
                if (state.getCell() != mxGraphComponent.this.graph.getCurrentRoot() && (model.isVertex(state.getCell()) || isEdge) && (icon = mxGraphComponent.this.getFoldingIcon(state)) != null) {
                    Rectangle bounds = mxGraphComponent.this.getFoldingIconBounds(state, icon);
                    g2.drawImage(icon.getImage(), bounds.x, bounds.y, bounds.width, bounds.height, this);
                }
            }
        }

        protected boolean isCellDisplayable(Object cell) {
            return cell != mxGraphComponent.this.graph.getView().getCurrentRoot() && cell != mxGraphComponent.this.graph.getModel().getRoot();
        }
    }
}

