/*
 * Decompiled with CFR 0.152.
 */
package com.github.vivchar.rendererrecyclerviewadapter;

import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;
import com.github.vivchar.rendererrecyclerviewadapter.ViewFinder;
import com.github.vivchar.rendererrecyclerviewadapter.ViewFinderFactory;
import com.github.vivchar.rendererrecyclerviewadapter.ViewModel;
import com.github.vivchar.rendererrecyclerviewadapter.WrongViewFinderException;

public class ViewHolder<VF extends ViewFinder>
extends RecyclerView.ViewHolder {
    public static final int UNDEFINED = -1;
    private int mViewStateID = -1;
    private Class<? extends ViewModel> mType;
    @Nullable
    private VF mViewFinder;

    public ViewHolder(View itemView) {
        super(itemView);
    }

    @NonNull
    public VF getViewFinder() {
        if (this.mViewFinder == null) {
            try {
                this.mViewFinder = ViewFinderFactory.create(this.itemView);
            }
            catch (ClassCastException e) {
                throw new WrongViewFinderException(e);
            }
        }
        return this.mViewFinder;
    }

    void setViewStateID(int ID) {
        this.mViewStateID = ID;
    }

    int getViewStateID() {
        return this.mViewStateID;
    }

    void setType(@NonNull Class<? extends ViewModel> type) {
        this.mType = type;
    }

    Class<? extends ViewModel> getType() {
        return this.mType;
    }

    boolean isSupportViewState() {
        return this.mType != null && this.mViewStateID != -1;
    }
}

