/*
 * Decompiled with CFR 0.152.
 */
package com.github.vivchar.rendererrecyclerviewadapter;

import android.content.res.ColorStateList;
import android.graphics.Bitmap;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.util.SparseArray;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Adapter;
import android.widget.AdapterView;
import android.widget.Checkable;
import android.widget.CompoundButton;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RatingBar;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.DrawableRes;
import androidx.annotation.IdRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.StringRes;
import com.github.vivchar.rendererrecyclerviewadapter.OnCheckedChangeListener;
import com.github.vivchar.rendererrecyclerviewadapter.OnClickListener;
import com.github.vivchar.rendererrecyclerviewadapter.OnLongClickListener;
import com.github.vivchar.rendererrecyclerviewadapter.OnTouchListener;
import com.github.vivchar.rendererrecyclerviewadapter.ViewFinder;
import com.github.vivchar.rendererrecyclerviewadapter.ViewProvider;

public class ViewFinderImpl<T extends ViewFinder>
implements ViewFinder {
    @NonNull
    private final SparseArray<View> mCachedViews = new SparseArray();
    @NonNull
    private final View mItemView;

    public ViewFinderImpl(@NonNull View itemView) {
        this.mItemView = itemView;
    }

    @NonNull
    public <V extends View> T find(int ID, @NonNull ViewProvider<V> viewProvider) {
        viewProvider.provide(this.findViewById(ID));
        return (T)this;
    }

    @Override
    @NonNull
    public <V extends View> V find(int ID) {
        return (V)this.findViewById(ID);
    }

    @NonNull
    public <V extends View> T getRootView(@NonNull ViewProvider<V> viewProvider) {
        viewProvider.provide(this.mItemView);
        return (T)this;
    }

    @Override
    @NonNull
    public <V extends View> V getRootView() {
        return (V)this.mItemView;
    }

    @NonNull
    public T setOnViewClickListener(int ID, View.OnClickListener listener) {
        this.findViewById(ID).setOnClickListener(listener);
        return (T)this;
    }

    @NonNull
    public T setOnClickListener(int ID, final OnClickListener listener) {
        return this.setOnViewClickListener(ID, new View.OnClickListener(){

            public void onClick(View view) {
                listener.onClick();
            }
        });
    }

    @NonNull
    public T setOnViewTouchListener(int ID, View.OnTouchListener listener) {
        this.find(ID).setOnTouchListener(listener);
        return (T)this;
    }

    @NonNull
    public T setOnTouchListener(int ID, final OnTouchListener listener) {
        return this.setOnViewTouchListener(ID, new View.OnTouchListener(){

            public boolean onTouch(View view, MotionEvent motionEvent) {
                return listener.onTouch(motionEvent) && view.performClick();
            }
        });
    }

    @NonNull
    public T setOnViewLongClickListener(int ID, View.OnLongClickListener listener) {
        this.find(ID).setOnLongClickListener(listener);
        return (T)this;
    }

    @Override
    @NonNull
    public ViewFinder setOnLongClickListener(int ID, final OnLongClickListener listener) {
        return this.setOnViewLongClickListener(ID, new View.OnLongClickListener(){

            public boolean onLongClick(View view) {
                return listener.onLongClick();
            }
        });
    }

    @NonNull
    public T setOnViewClickListener(@NonNull View.OnClickListener listener) {
        this.getRootView().setOnClickListener(listener);
        return (T)this;
    }

    @Override
    @NonNull
    public ViewFinder setOnClickListener(final @NonNull OnClickListener listener) {
        return this.setOnViewClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                listener.onClick();
            }
        });
    }

    @NonNull
    public T setOnViewCheckedChangeListener(int ID, CompoundButton.OnCheckedChangeListener listener) {
        ((CompoundButton)this.find(ID)).setOnCheckedChangeListener(listener);
        return (T)this;
    }

    @Override
    @NonNull
    public ViewFinder setOnCheckedChangeListener(int ID, final OnCheckedChangeListener listener) {
        return this.setOnViewCheckedChangeListener(ID, new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton compoundButton, boolean b) {
                listener.onCheckedChanged(b);
            }
        });
    }

    @NonNull
    public T setClickable(int ID, boolean clickable) {
        this.find(ID).setClickable(clickable);
        return (T)this;
    }

    @NonNull
    public T setLongClickable(int ID, boolean clickable) {
        this.find(ID).setLongClickable(clickable);
        return (T)this;
    }

    @NonNull
    public T setText(int ID, CharSequence text) {
        ((TextView)this.find(ID)).setText(text);
        return (T)this;
    }

    @NonNull
    public T setText(int ID, @StringRes int textID) {
        ((TextView)this.find(ID)).setText(textID);
        return (T)this;
    }

    @NonNull
    public T setText(int ID, CharSequence text, TextView.BufferType type) {
        ((TextView)this.find(ID)).setText(text, type);
        return (T)this;
    }

    @NonNull
    public T setTextSize(int ID, float size) {
        ((TextView)this.find(ID)).setTextSize(size);
        return (T)this;
    }

    @NonNull
    public T setTypeface(int ID, Typeface typeface, int style) {
        ((TextView)this.find(ID)).setTypeface(typeface, style);
        return (T)this;
    }

    @NonNull
    public T setTypeface(int ID, Typeface typeface) {
        ((TextView)this.find(ID)).setTypeface(typeface);
        return (T)this;
    }

    @NonNull
    public T setError(int ID, CharSequence error) {
        ((TextView)this.find(ID)).setError(error);
        return (T)this;
    }

    @NonNull
    public T setError(int ID, CharSequence error, Drawable icon) {
        ((TextView)this.find(ID)).setError(error, icon);
        return (T)this;
    }

    @NonNull
    public T setTextColor(int ID, int color) {
        ((TextView)this.find(ID)).setTextColor(color);
        return (T)this;
    }

    @NonNull
    public T setTextColor(int ID, ColorStateList colors) {
        ((TextView)this.find(ID)).setTextColor(colors);
        return (T)this;
    }

    @NonNull
    public T setBackgroundColor(int ID, @ColorInt int color) {
        this.find(ID).setBackgroundColor(color);
        return (T)this;
    }

    @RequiresApi(api=23)
    @NonNull
    public T setForeground(int ID, Drawable background) {
        this.find(ID).setForeground(background);
        return (T)this;
    }

    @NonNull
    public T setBackground(int ID, Drawable background) {
        this.find(ID).setBackgroundDrawable(background);
        return (T)this;
    }

    @NonNull
    public T setBackgroundDrawable(int ID, Drawable background) {
        return this.setBackground(ID, background);
    }

    @NonNull
    public T setBackgroundResource(int ID, @DrawableRes int background) {
        this.find(ID).setBackgroundResource(background);
        return (T)this;
    }

    @NonNull
    public T setImageDrawable(int ID, @Nullable Drawable drawable) {
        ((ImageView)this.find(ID)).setImageDrawable(drawable);
        return (T)this;
    }

    @NonNull
    public T setImageResource(int ID, int resId) {
        ((ImageView)this.find(ID)).setImageResource(resId);
        return (T)this;
    }

    @NonNull
    public T setImageURI(int ID, @Nullable Uri uri) {
        ((ImageView)this.find(ID)).setImageURI(uri);
        return (T)this;
    }

    @NonNull
    public T setImageBitmap(int ID, Bitmap bm) {
        ((ImageView)this.find(ID)).setImageBitmap(bm);
        return (T)this;
    }

    @NonNull
    public T setColorFilter(int ID, ColorFilter cf) {
        ((ImageView)this.find(ID)).setColorFilter(cf);
        return (T)this;
    }

    @NonNull
    public T setColorFilter(int ID, int color, PorterDuff.Mode mode) {
        ((ImageView)this.find(ID)).setColorFilter(color, mode);
        return (T)this;
    }

    @NonNull
    public T clearColorFilter(int ID) {
        ((ImageView)this.find(ID)).clearColorFilter();
        return (T)this;
    }

    @NonNull
    public T setVisible(int ID, boolean visible) {
        this.find(ID).setVisibility(visible ? 0 : 4);
        return (T)this;
    }

    @NonNull
    public T setInvisible(int ID, boolean invisible) {
        this.find(ID).setVisibility(invisible ? 4 : 0);
        return (T)this;
    }

    @NonNull
    public T setGone(int ID, boolean gone) {
        this.find(ID).setVisibility(gone ? 8 : 0);
        return (T)this;
    }

    @NonNull
    public T setVisibility(int ID, int visibility) {
        this.find(ID).setVisibility(visibility);
        return (T)this;
    }

    @NonNull
    public T setAlpha(int ID, float alpha) {
        this.find(ID).setAlpha(alpha);
        return (T)this;
    }

    @NonNull
    public T addView(int ID, View child) {
        ((ViewGroup)this.find(ID)).addView(child);
        return (T)this;
    }

    @NonNull
    public T addView(int ID, View child, int index) {
        ((ViewGroup)this.find(ID)).addView(child, index);
        return (T)this;
    }

    @NonNull
    public T removeView(int ID, View view) {
        ((ViewGroup)this.find(ID)).removeView(view);
        return (T)this;
    }

    @NonNull
    public T removeViewAt(int ID, int index) {
        ((ViewGroup)this.find(ID)).removeViewAt(index);
        return (T)this;
    }

    @NonNull
    public T removeAllViews(int ID) {
        ((ViewGroup)this.find(ID)).removeAllViews();
        return (T)this;
    }

    @NonNull
    public T setEnabled(int ID, boolean enable) {
        this.find(ID).setEnabled(enable);
        return (T)this;
    }

    @NonNull
    public T setEnabled(int ID) {
        this.find(ID).setEnabled(true);
        return (T)this;
    }

    @NonNull
    public T setDisabled(int ID) {
        this.find(ID).setEnabled(false);
        return (T)this;
    }

    @NonNull
    public T setTag(int ID, Object tag) {
        this.find(ID).setTag(tag);
        return (T)this;
    }

    @NonNull
    public T setTag(int ID, int key, Object tag) {
        this.find(ID).setTag(key, tag);
        return (T)this;
    }

    @NonNull
    public T setChecked(int ID, boolean checked) {
        ((Checkable)this.find(ID)).setChecked(checked);
        return (T)this;
    }

    @NonNull
    public T setSelected(int ID, boolean selected) {
        this.find(ID).setSelected(selected);
        return (T)this;
    }

    @NonNull
    public T setPressed(int ID, boolean pressed) {
        this.find(ID).setPressed(pressed);
        return (T)this;
    }

    @NonNull
    public T setProgress(int ID, int progress) {
        ((ProgressBar)this.find(ID)).setProgress(progress);
        return (T)this;
    }

    @RequiresApi(api=24)
    @NonNull
    public T setProgress(int ID, int progress, boolean animate) {
        ((ProgressBar)this.find(ID)).setProgress(progress, animate);
        return (T)this;
    }

    @NonNull
    public T setMaxProgress(int ID, int max) {
        ((ProgressBar)this.find(ID)).setMax(max);
        return (T)this;
    }

    @RequiresApi(api=26)
    @NonNull
    public T setMinProgress(int ID, int min) {
        ((ProgressBar)this.find(ID)).setMin(min);
        return (T)this;
    }

    @NonNull
    public T setProgress(int ID, int progress, int max) {
        ProgressBar progressBar = (ProgressBar)this.find(ID);
        progressBar.setMax(max);
        progressBar.setProgress(progress);
        return (T)this;
    }

    @RequiresApi(api=26)
    @NonNull
    public T setProgress(int ID, int progress, int min, int max) {
        ProgressBar progressBar = (ProgressBar)this.find(ID);
        progressBar.setProgress(progress);
        progressBar.setMin(min);
        progressBar.setMax(max);
        return (T)this;
    }

    @NonNull
    public T setRating(int ID, float rating) {
        ((RatingBar)this.find(ID)).setRating(rating);
        return (T)this;
    }

    @NonNull
    public T setMaxRating(int ID, int max) {
        ((RatingBar)this.find(ID)).setMax(max);
        return (T)this;
    }

    @RequiresApi(api=26)
    @NonNull
    public T setMinRating(int ID, int min) {
        ((RatingBar)this.find(ID)).setMin(min);
        return (T)this;
    }

    @NonNull
    public T setRating(int ID, float rating, int max) {
        RatingBar ratingBar = (RatingBar)this.find(ID);
        ratingBar.setRating(rating);
        ratingBar.setMax(max);
        return (T)this;
    }

    @RequiresApi(api=26)
    @NonNull
    public T setRating(int ID, float rating, int min, int max) {
        RatingBar ratingBar = (RatingBar)this.find(ID);
        ratingBar.setRating(rating);
        ratingBar.setMin(min);
        ratingBar.setMax(max);
        return (T)this;
    }

    @NonNull
    public T setAdapter(int ID, Adapter adapter) {
        ((AdapterView)this.find(ID)).setAdapter(adapter);
        return (T)this;
    }

    @NonNull
    public T setOnItemClickListener(int ID, AdapterView.OnItemClickListener listener) {
        ((AdapterView)this.find(ID)).setOnItemClickListener(listener);
        return (T)this;
    }

    @NonNull
    public T setOnItemLongClickListener(int ID, AdapterView.OnItemLongClickListener listener) {
        ((AdapterView)this.find(ID)).setOnItemLongClickListener(listener);
        return (T)this;
    }

    @NonNull
    public T setOnItemSelectedListener(int ID, AdapterView.OnItemSelectedListener listener) {
        ((AdapterView)this.find(ID)).setOnItemSelectedListener(listener);
        return (T)this;
    }

    @NonNull
    private View findViewById(@IdRes int ID) {
        View cachedView = (View)this.mCachedViews.get(ID);
        if (cachedView != null) {
            return cachedView;
        }
        View view = this.mItemView.findViewById(ID);
        this.mCachedViews.put(ID, (Object)view);
        return view;
    }
}

