/*
 * Decompiled with CFR 0.152.
 */
package com.github.vivchar.rendererrecyclerviewadapter;

import android.view.View;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.github.vivchar.rendererrecyclerviewadapter.CompositeViewHolder;
import com.github.vivchar.rendererrecyclerviewadapter.ViewState;
import java.io.Serializable;
import java.util.HashMap;

public class CompositeViewState<VH extends CompositeViewHolder>
implements ViewState<VH>,
Serializable {
    @NonNull
    protected HashMap<Integer, ViewState> mViewStates;
    protected int mPosition;
    protected int mTopOffset;
    protected int mLeftOffset;

    @Override
    public void clear(@NonNull VH holder) {
        RecyclerView.LayoutManager layoutManager = ((CompositeViewHolder)((Object)holder)).getRecyclerView().getLayoutManager();
        if (layoutManager instanceof LinearLayoutManager) {
            LinearLayoutManager linearLayoutManager = (LinearLayoutManager)layoutManager;
            linearLayoutManager.scrollToPositionWithOffset(0, 0);
        }
    }

    @Override
    public void save(@NonNull VH holder) {
        this.mViewStates = ((CompositeViewHolder)((Object)holder)).getAdapter().getStates();
        RecyclerView.LayoutManager layoutManager = ((CompositeViewHolder)((Object)holder)).getRecyclerView().getLayoutManager();
        if (layoutManager instanceof LinearLayoutManager) {
            LinearLayoutManager linearLayoutManager = (LinearLayoutManager)layoutManager;
            this.mPosition = linearLayoutManager.findFirstVisibleItemPosition();
            View item = ((CompositeViewHolder)((Object)holder)).getRecyclerView().getChildAt(0);
            this.mTopOffset = item == null ? 0 : item.getTop() - ((CompositeViewHolder)((Object)holder)).getRecyclerView().getPaddingTop();
            this.mLeftOffset = item == null ? 0 : item.getLeft() - ((CompositeViewHolder)((Object)holder)).getRecyclerView().getPaddingLeft();
        } else {
            this.mPosition = 0;
            this.mTopOffset = 0;
        }
    }

    @Override
    public void restore(@NonNull VH holder) {
        ((CompositeViewHolder)((Object)holder)).getAdapter().setStates(this.mViewStates);
        RecyclerView.LayoutManager layoutManager = ((CompositeViewHolder)((Object)holder)).getRecyclerView().getLayoutManager();
        if (this.mPosition != -1 && layoutManager instanceof LinearLayoutManager) {
            LinearLayoutManager linearLayoutManager = (LinearLayoutManager)layoutManager;
            if (linearLayoutManager.canScrollHorizontally()) {
                linearLayoutManager.scrollToPositionWithOffset(this.mPosition, this.mLeftOffset);
            } else {
                linearLayoutManager.scrollToPositionWithOffset(this.mPosition, this.mTopOffset);
            }
        }
    }
}

