/*
 * Decompiled with CFR 0.152.
 */
package com.github.jfasttext;

import com.github.jfasttext.FastTextWrapper;
import java.util.ArrayList;
import java.util.List;
import org.bytedeco.javacpp.PointerPointer;

public class JFastText {
    private FastTextWrapper.FastTextApi fta = new FastTextWrapper.FastTextApi();

    public void runCmd(String[] args) {
        String[] cArgs = new String[args.length + 1];
        cArgs[0] = "fasttext";
        System.arraycopy(args, 0, cArgs, 1, args.length);
        this.fta.runCmd(cArgs.length, new PointerPointer(cArgs));
    }

    public void loadModel(String modelFile) {
        this.fta.loadModel(modelFile);
    }

    public void test(String testFile) {
        this.test(testFile, 1);
    }

    public void test(String testFile, int k) {
        if (k <= 0) {
            throw new IllegalArgumentException("k must be positive");
        }
        this.fta.test(testFile, k);
    }

    public String predict(String text) {
        return this.predict(text, 1).get(0);
    }

    public List<String> predict(String text, int k) {
        if (k <= 0) {
            throw new IllegalArgumentException("k must be positive");
        }
        FastTextWrapper.StringVector sv = this.fta.predict(text, k);
        ArrayList<String> predictions = new ArrayList<String>();
        int i = 0;
        while ((long)i < sv.size()) {
            predictions.add(sv.get(i).getString());
            ++i;
        }
        return predictions;
    }

    public ProbLabel predictProba(String text) {
        return this.predictProba(text, 1).get(0);
    }

    public List<ProbLabel> predictProba(String text, int k) {
        if (k <= 0) {
            throw new IllegalArgumentException("k must be positive");
        }
        FastTextWrapper.FloatStringPairVector fspv = this.fta.predictProba(text, k);
        ArrayList<ProbLabel> probaPredictions = new ArrayList<ProbLabel>();
        int i = 0;
        while ((long)i < fspv.size()) {
            float logProb = fspv.first(i);
            String label = fspv.second(i).getString();
            probaPredictions.add(new ProbLabel(logProb, label));
            ++i;
        }
        return probaPredictions;
    }

    public List<Float> getVector(String word) {
        FastTextWrapper.RealVector rv = this.fta.getVector(word);
        ArrayList<Float> wordVec = new ArrayList<Float>();
        int i = 0;
        while ((long)i < rv.size()) {
            wordVec.add(Float.valueOf(rv.get(i)));
            ++i;
        }
        return wordVec;
    }

    public int getNWords() {
        return this.fta.getNWords();
    }

    public List<String> getWords() {
        return JFastText.stringVec2Strings(this.fta.getWords());
    }

    public int getNLabels() {
        return this.fta.getNLabels();
    }

    public List<String> getLabels() {
        return JFastText.stringVec2Strings(this.fta.getWords());
    }

    public double getLr() {
        return this.fta.getLr();
    }

    public int getLrUpdateRate() {
        return this.fta.getLrUpdateRate();
    }

    public int getDim() {
        return this.fta.getDim();
    }

    public int getContextWindowSize() {
        return this.fta.getContextWindowSize();
    }

    public int getEpoch() {
        return this.fta.getEpoch();
    }

    public int getMinCount() {
        return this.fta.getMinCount();
    }

    public int getMinCountLabel() {
        return this.fta.getMinCountLabel();
    }

    public int getNSampledNegatives() {
        return this.fta.getNSampledNegatives();
    }

    public int getWordNgrams() {
        return this.fta.getWordNgrams();
    }

    public String getLossName() {
        return this.fta.getLossName().getString();
    }

    public String getModelName() {
        return this.fta.getModelName().getString();
    }

    public int getBucket() {
        return this.fta.getBucket();
    }

    public int getMinn() {
        return this.fta.getMinn();
    }

    public int getMaxn() {
        return this.fta.getMaxn();
    }

    public double getSamplingThreshold() {
        return this.fta.getSamplingThreshold();
    }

    public String getLabelPrefix() {
        return this.fta.getLabelPrefix().getString();
    }

    public String getPretrainedVectorsFileName() {
        return this.fta.getPretrainedVectorsFileName().getString();
    }

    private static List<String> stringVec2Strings(FastTextWrapper.StringVector sv) {
        ArrayList<String> strings = new ArrayList<String>();
        int i = 0;
        while ((long)i < sv.size()) {
            strings.add(sv.get(i).getString());
            ++i;
        }
        return strings;
    }

    public static void main(String[] args) {
        JFastText jft = new JFastText();
        jft.runCmd(args);
    }

    public static class ProbLabel {
        public float logProb;
        public String label;

        public ProbLabel(float logProb, String label) {
            this.logProb = logProb;
            this.label = label;
        }

        public String toString() {
            return String.format("logProb = %f, label = %s", Float.valueOf(this.logProb), this.label);
        }
    }
}

