/*
 * Decompiled with CFR 0.152.
 */
package com.github.vincentrussell.query.mongodb.sql.converter;

import com.github.vincentrussell.query.mongodb.sql.converter.FieldType;
import com.github.vincentrussell.query.mongodb.sql.converter.ParseException;
import com.github.vincentrussell.query.mongodb.sql.converter.util.DateFunction;
import com.github.vincentrussell.query.mongodb.sql.converter.util.RegexFunction;
import com.github.vincentrussell.query.mongodb.sql.converter.util.SqlUtils;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.NotExpression;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.expression.operators.relational.ComparisonOperator;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.GreaterThan;
import net.sf.jsqlparser.expression.operators.relational.GreaterThanEquals;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.expression.operators.relational.IsNullExpression;
import net.sf.jsqlparser.expression.operators.relational.LikeExpression;
import net.sf.jsqlparser.expression.operators.relational.MinorThan;
import net.sf.jsqlparser.expression.operators.relational.MinorThanEquals;
import net.sf.jsqlparser.expression.operators.relational.NotEqualsTo;
import net.sf.jsqlparser.schema.Column;
import org.bson.Document;

public class WhereCauseProcessor {
    private final FieldType defaultFieldType;
    private final Map<String, FieldType> fieldNameToFieldTypeMapping;

    public WhereCauseProcessor(FieldType defaultFieldType, Map<String, FieldType> fieldNameToFieldTypeMapping) {
        this.defaultFieldType = defaultFieldType;
        this.fieldNameToFieldTypeMapping = fieldNameToFieldTypeMapping;
    }

    public Object parseExpression(Document query, Expression incomingExpression, Expression otherSide) throws ParseException {
        if (ComparisonOperator.class.isInstance(incomingExpression)) {
            RegexFunction regexFunction = SqlUtils.isRegexFunction(incomingExpression);
            DateFunction dateFunction = SqlUtils.isDateFunction(incomingExpression);
            if (regexFunction != null) {
                Document regexDocument = new Document("$regex", (Object)regexFunction.getRegex());
                if (regexFunction.getOptions() != null) {
                    regexDocument.append("$options", (Object)regexFunction.getOptions());
                }
                query.put(regexFunction.getColumn(), (Object)regexDocument);
            } else if (dateFunction != null) {
                query.put(dateFunction.getColumn(), (Object)new Document(dateFunction.getComparisonExpression(), (Object)dateFunction.getDate()));
            } else if (EqualsTo.class.isInstance(incomingExpression)) {
                Expression leftExpression = ((EqualsTo)incomingExpression).getLeftExpression();
                Expression rightExpression = ((EqualsTo)incomingExpression).getRightExpression();
                query.put(this.parseExpression(new Document(), leftExpression, rightExpression).toString(), this.parseExpression(new Document(), rightExpression, leftExpression));
            } else if (NotEqualsTo.class.isInstance(incomingExpression)) {
                Expression leftExpression = ((NotEqualsTo)incomingExpression).getLeftExpression();
                Expression rightExpression = ((NotEqualsTo)incomingExpression).getRightExpression();
                query.put(SqlUtils.getStringValue(leftExpression), (Object)new Document("$ne", this.parseExpression(new Document(), rightExpression, leftExpression)));
            } else if (GreaterThan.class.isInstance(incomingExpression)) {
                Expression leftExpression = ((GreaterThan)incomingExpression).getLeftExpression();
                Expression rightExpression = ((GreaterThan)incomingExpression).getRightExpression();
                query.put(leftExpression.toString(), (Object)new Document("$gt", this.parseExpression(new Document(), rightExpression, leftExpression)));
            } else if (MinorThan.class.isInstance(incomingExpression)) {
                Expression leftExpression = ((MinorThan)incomingExpression).getLeftExpression();
                Expression rightExpression = ((MinorThan)incomingExpression).getRightExpression();
                query.put(leftExpression.toString(), (Object)new Document("$lt", this.parseExpression(new Document(), rightExpression, leftExpression)));
            } else if (GreaterThanEquals.class.isInstance(incomingExpression)) {
                Expression leftExpression = ((GreaterThanEquals)incomingExpression).getLeftExpression();
                Expression rightExpression = ((GreaterThanEquals)incomingExpression).getRightExpression();
                query.put(leftExpression.toString(), (Object)new Document("$gte", this.parseExpression(new Document(), rightExpression, leftExpression)));
            } else if (MinorThanEquals.class.isInstance(incomingExpression)) {
                Expression leftExpression = ((MinorThanEquals)incomingExpression).getLeftExpression();
                Expression rightExpression = ((MinorThanEquals)incomingExpression).getRightExpression();
                query.put(leftExpression.toString(), (Object)new Document("$lte", this.parseExpression(new Document(), rightExpression, leftExpression)));
            }
        } else if (LikeExpression.class.isInstance(incomingExpression) && Column.class.isInstance(((LikeExpression)incomingExpression).getLeftExpression()) && (StringValue.class.isInstance(((LikeExpression)incomingExpression).getRightExpression()) || Column.class.isInstance(((LikeExpression)incomingExpression).getRightExpression()))) {
            LikeExpression likeExpression = (LikeExpression)incomingExpression;
            String stringValueLeftSide = SqlUtils.getStringValue(likeExpression.getLeftExpression());
            String stringValueRightSide = SqlUtils.getStringValue(likeExpression.getRightExpression());
            Document document = new Document("$regex", (Object)("^" + SqlUtils.replaceRegexCharacters(stringValueRightSide) + "$"));
            if (likeExpression.isNot()) {
                document = new Document("$not", (Object)new Document(stringValueLeftSide, (Object)document));
                throw new ParseException("NOT LIKE queries not supported");
            }
            document = new Document(stringValueLeftSide, (Object)document);
            query.putAll((Map)document);
        } else if (IsNullExpression.class.isInstance(incomingExpression)) {
            IsNullExpression isNullExpression = (IsNullExpression)incomingExpression;
            query.put(isNullExpression.getLeftExpression().toString(), (Object)new Document("$exists", (Object)isNullExpression.isNot()));
        } else if (AndExpression.class.isInstance(incomingExpression)) {
            AndExpression andExpression = (AndExpression)incomingExpression;
            Expression leftExpression = andExpression.getLeftExpression();
            Expression rightExpression = andExpression.getRightExpression();
            query.put("$and", Arrays.asList(this.parseExpression(new Document(), leftExpression, rightExpression), this.parseExpression(new Document(), rightExpression, leftExpression)));
        } else if (InExpression.class.isInstance(incomingExpression)) {
            InExpression inExpression = (InExpression)incomingExpression;
            final Expression leftExpression = ((InExpression)incomingExpression).getLeftExpression();
            String leftExpressionAsString = SqlUtils.getStringValue(leftExpression);
            query.put(leftExpressionAsString, (Object)new Document(inExpression.isNot() ? "$nin" : "$in", (Object)Lists.transform((List)((ExpressionList)inExpression.getRightItemsList()).getExpressions(), (Function)new Function<Expression, Object>(){

                public Object apply(Expression expression) {
                    try {
                        return WhereCauseProcessor.this.parseExpression(new Document(), expression, leftExpression);
                    }
                    catch (ParseException e) {
                        throw new RuntimeException(e);
                    }
                }
            })));
        } else if (OrExpression.class.isInstance(incomingExpression)) {
            OrExpression orExpression = (OrExpression)incomingExpression;
            Expression leftExpression = orExpression.getLeftExpression();
            Expression rightExpression = orExpression.getRightExpression();
            query.put("$or", Arrays.asList(this.parseExpression(new Document(), leftExpression, rightExpression), this.parseExpression(new Document(), rightExpression, leftExpression)));
        } else {
            if (Parenthesis.class.isInstance(incomingExpression)) {
                Parenthesis parenthesis = (Parenthesis)incomingExpression;
                Object expression = this.parseExpression(new Document(), parenthesis.getExpression(), null);
                if (parenthesis.isNot()) {
                    return new Document("$nor", Arrays.asList(expression));
                }
                return expression;
            }
            if (NotExpression.class.isInstance(incomingExpression) && otherSide == null) {
                Expression expression = ((NotExpression)incomingExpression).getExpression();
                return new Document(SqlUtils.getStringValue(expression), (Object)new Document("$ne", (Object)true));
            }
            if (net.sf.jsqlparser.expression.Function.class.isInstance(incomingExpression) && !SqlUtils.isSpecialtyFunction(incomingExpression)) {
                net.sf.jsqlparser.expression.Function function = (net.sf.jsqlparser.expression.Function)incomingExpression;
                query.put("$" + function.getName(), SqlUtils.parseFunctionArguments(function.getParameters(), this.defaultFieldType, this.fieldNameToFieldTypeMapping));
            } else {
                if (otherSide == null) {
                    return new Document(SqlUtils.getStringValue(incomingExpression), (Object)true);
                }
                return SqlUtils.getValue(incomingExpression, otherSide, this.defaultFieldType, this.fieldNameToFieldTypeMapping);
            }
        }
        return query;
    }
}

