package com.vimeo.networking2

import com.squareup.moshi.Json
import com.squareup.moshi.JsonClass
import com.vimeo.networking2.common.Pageable

/**
 * Represents a pageable array/list of [TeamPermission].
 */
@JsonClass(generateAdapter = true)
data class TeamPermissionList(

    @Json(name = "total")
    override val total: Int? = null,

    @Json(name = "page")
    override val page: Int? = null,

    @Json(name = "per_page")
    override val perPage: Int? = null,

    @Json(name = "paging")
    override val paging: Paging? = null,

    @Json(name = "data")
    override val data: List<TeamPermission>? = null,

    @Json(name = "filtered_total")
    override val filteredTotal: Int? = null
) : Pageable<TeamPermission>
