/*
 * Decompiled with CFR 0.152.
 */
package com.vimeo.networking2.internal;

import com.vimeo.networking2.ApiError;
import com.vimeo.networking2.Authenticator;
import com.vimeo.networking2.GrantType;
import com.vimeo.networking2.InvalidParameter;
import com.vimeo.networking2.NoOpVimeoRequest;
import com.vimeo.networking2.Scopes;
import com.vimeo.networking2.VimeoAccount;
import com.vimeo.networking2.VimeoCallback;
import com.vimeo.networking2.VimeoRequest;
import com.vimeo.networking2.account.AccountStore;
import com.vimeo.networking2.account.CachingAccountStore;
import com.vimeo.networking2.internal.AccountStoringVimeoCallback;
import com.vimeo.networking2.internal.AuthParam;
import com.vimeo.networking2.internal.AuthService;
import com.vimeo.networking2.internal.AuthUtilsKt;
import com.vimeo.networking2.internal.VimeoCall;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u0012H\u0016J6\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u0012H\u0016J&\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u0012H\u0016J&\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u00052\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u0012H\u0016J.\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u0012H\u0016J.\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u0012H\u0016J\u0016\u0010\u001f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020 0\u0012H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\u0004\u0018\u00010\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/vimeo/networking2/internal/AuthenticatorImpl;", "Lcom/vimeo/networking2/Authenticator;", "authService", "Lcom/vimeo/networking2/internal/AuthService;", "basicAuthHeader", "", "scopes", "Lcom/vimeo/networking2/Scopes;", "accountStore", "Lcom/vimeo/networking2/account/CachingAccountStore;", "(Lcom/vimeo/networking2/internal/AuthService;Ljava/lang/String;Lcom/vimeo/networking2/Scopes;Lcom/vimeo/networking2/account/CachingAccountStore;)V", "currentAccount", "Lcom/vimeo/networking2/VimeoAccount;", "getCurrentAccount", "()Lcom/vimeo/networking2/VimeoAccount;", "clientCredentials", "Lcom/vimeo/networking2/VimeoRequest;", "callback", "Lcom/vimeo/networking2/VimeoCallback;", "emailJoin", "displayName", "email", "password", "marketingOptIn", "", "emailLogin", "exchangeOAuthOneToken", "token", "tokenSecret", "facebook", "google", "logOut", "", "auth"})
public final class AuthenticatorImpl
implements Authenticator {
    private final AuthService authService;
    private final String basicAuthHeader;
    private final Scopes scopes;
    private final CachingAccountStore accountStore;

    @Override
    @Nullable
    public VimeoAccount getCurrentAccount() {
        return this.accountStore.loadAccount();
    }

    @Override
    @NotNull
    public VimeoRequest clientCredentials(@NotNull VimeoCallback<VimeoAccount> callback) {
        VimeoRequest vimeoRequest;
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        List<InvalidParameter> invalidAuthParams = AuthUtilsKt.validate(MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)AuthParam.FIELD_GRANT_TYPE, (Object)GrantType.CLIENT_CREDENTIALS.getValue()), TuplesKt.to((Object)AuthParam.FIELD_SCOPES, (Object)this.scopes)}));
        VimeoCall<VimeoAccount> call = this.authService.authorizeWithClientCredentialsGrant(this.basicAuthHeader, GrantType.CLIENT_CREDENTIALS, this.scopes);
        Collection collection = invalidAuthParams;
        boolean bl = false;
        if (!collection.isEmpty()) {
            ApiError apiError = new ApiError("Client credentials authentication error.", null, null, null, invalidAuthParams, null, 46, null);
            vimeoRequest = call.enqueueError(apiError, callback);
        } else {
            vimeoRequest = call.enqueue((VimeoCallback)new AccountStoringVimeoCallback((AccountStore)this.accountStore, callback));
        }
        return vimeoRequest;
    }

    @Override
    @NotNull
    public VimeoRequest google(@NotNull String token, @NotNull String email, boolean marketingOptIn, @NotNull VimeoCallback<VimeoAccount> callback) {
        VimeoRequest vimeoRequest;
        Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
        Intrinsics.checkParameterIsNotNull((Object)email, (String)"email");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        List<InvalidParameter> invalidAuthParams = AuthUtilsKt.validate(MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)AuthParam.FIELD_ID_TOKEN, (Object)token), TuplesKt.to((Object)AuthParam.FIELD_EMAIL, (Object)email), TuplesKt.to((Object)AuthParam.FIELD_SCOPES, (Object)this.scopes)}));
        VimeoCall<VimeoAccount> call = this.authService.joinWithGoogle(this.basicAuthHeader, email, token, this.scopes, marketingOptIn);
        Collection collection = invalidAuthParams;
        boolean bl = false;
        if (!collection.isEmpty()) {
            ApiError apiError = new ApiError(null, null, "Google authentication failure", null, invalidAuthParams, null, 43, null);
            vimeoRequest = call.enqueueError(apiError, callback);
        } else {
            vimeoRequest = call.enqueue((VimeoCallback)new AccountStoringVimeoCallback((AccountStore)this.accountStore, callback));
        }
        return vimeoRequest;
    }

    @Override
    @NotNull
    public VimeoRequest facebook(@NotNull String token, @NotNull String email, boolean marketingOptIn, @NotNull VimeoCallback<VimeoAccount> callback) {
        VimeoRequest vimeoRequest;
        Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
        Intrinsics.checkParameterIsNotNull((Object)email, (String)"email");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        List<InvalidParameter> invalidAuthParams = AuthUtilsKt.validate(MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)AuthParam.FIELD_TOKEN, (Object)token), TuplesKt.to((Object)AuthParam.FIELD_EMAIL, (Object)email), TuplesKt.to((Object)AuthParam.FIELD_SCOPES, (Object)this.scopes)}));
        VimeoCall<VimeoAccount> call = this.authService.joinWithFacebook(this.basicAuthHeader, email, token, this.scopes, marketingOptIn);
        Collection collection = invalidAuthParams;
        boolean bl = false;
        if (!collection.isEmpty()) {
            ApiError apiError = new ApiError(null, null, "Facebook authentication failure", null, invalidAuthParams, null, 43, null);
            vimeoRequest = call.enqueueError(apiError, callback);
        } else {
            vimeoRequest = call.enqueue((VimeoCallback)new AccountStoringVimeoCallback((AccountStore)this.accountStore, callback));
        }
        return vimeoRequest;
    }

    @Override
    @NotNull
    public VimeoRequest emailJoin(@NotNull String displayName, @NotNull String email, @NotNull String password, boolean marketingOptIn, @NotNull VimeoCallback<VimeoAccount> callback) {
        VimeoRequest vimeoRequest;
        Intrinsics.checkParameterIsNotNull((Object)displayName, (String)"displayName");
        Intrinsics.checkParameterIsNotNull((Object)email, (String)"email");
        Intrinsics.checkParameterIsNotNull((Object)password, (String)"password");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        List<InvalidParameter> invalidAuthParams = AuthUtilsKt.validate(MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)AuthParam.FIELD_NAME, (Object)displayName), TuplesKt.to((Object)AuthParam.FIELD_EMAIL, (Object)email), TuplesKt.to((Object)AuthParam.FIELD_PASSWORD, (Object)password), TuplesKt.to((Object)AuthParam.FIELD_SCOPES, (Object)this.scopes)}));
        VimeoCall<VimeoAccount> call = this.authService.joinWithEmail(this.basicAuthHeader, displayName, email, password, this.scopes, marketingOptIn);
        Collection collection = invalidAuthParams;
        boolean bl = false;
        if (!collection.isEmpty()) {
            ApiError apiError = new ApiError("Email join error.", null, null, null, invalidAuthParams, null, 46, null);
            vimeoRequest = call.enqueueError(apiError, callback);
        } else {
            vimeoRequest = call.enqueue((VimeoCallback)new AccountStoringVimeoCallback((AccountStore)this.accountStore, callback));
        }
        return vimeoRequest;
    }

    @Override
    @NotNull
    public VimeoRequest emailLogin(@NotNull String email, @NotNull String password, @NotNull VimeoCallback<VimeoAccount> callback) {
        VimeoRequest vimeoRequest;
        Intrinsics.checkParameterIsNotNull((Object)email, (String)"email");
        Intrinsics.checkParameterIsNotNull((Object)password, (String)"password");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        List<InvalidParameter> invalidAuthParams = AuthUtilsKt.validate(MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)AuthParam.FIELD_USERNAME, (Object)email), TuplesKt.to((Object)AuthParam.FIELD_PASSWORD, (Object)password), TuplesKt.to((Object)AuthParam.FIELD_SCOPES, (Object)this.scopes)}));
        VimeoCall<VimeoAccount> call = this.authService.logInWithEmail(this.basicAuthHeader, email, password, GrantType.PASSWORD, this.scopes);
        Collection collection = invalidAuthParams;
        boolean bl = false;
        if (!collection.isEmpty()) {
            ApiError apiError = new ApiError("Email login error.", null, null, null, invalidAuthParams, null, 46, null);
            vimeoRequest = call.enqueueError(apiError, callback);
        } else {
            vimeoRequest = call.enqueue((VimeoCallback)new AccountStoringVimeoCallback((AccountStore)this.accountStore, callback));
        }
        return vimeoRequest;
    }

    @Override
    @NotNull
    public VimeoRequest exchangeOAuthOneToken(@NotNull String token, @NotNull String tokenSecret, @NotNull VimeoCallback<VimeoAccount> callback) {
        VimeoRequest vimeoRequest;
        Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
        Intrinsics.checkParameterIsNotNull((Object)tokenSecret, (String)"tokenSecret");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        List<InvalidParameter> invalidAuthParams = AuthUtilsKt.validate(MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)AuthParam.FIELD_TOKEN, (Object)token), TuplesKt.to((Object)AuthParam.FIELD_TOKEN_SECRET, (Object)tokenSecret), TuplesKt.to((Object)AuthParam.FIELD_SCOPES, (Object)this.scopes)}));
        VimeoCall<VimeoAccount> call = this.authService.exchangeOAuthOneToken(this.basicAuthHeader, GrantType.OAUTH_ONE, token, tokenSecret, this.scopes);
        Collection collection = invalidAuthParams;
        boolean bl = false;
        if (!collection.isEmpty()) {
            ApiError apiError = new ApiError("Auth token exchange error.", null, null, null, invalidAuthParams, null, 46, null);
            vimeoRequest = call.enqueueError(apiError, callback);
        } else {
            vimeoRequest = call.enqueue(callback);
        }
        return vimeoRequest;
    }

    @Override
    @NotNull
    public VimeoRequest logOut(@NotNull VimeoCallback<Unit> callback) {
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        VimeoAccount vimeoAccount = this.getCurrentAccount();
        String accessToken = vimeoAccount != null ? vimeoAccount.getAccessToken() : null;
        this.accountStore.removeAccount();
        if (accessToken == null) {
            return (VimeoRequest)NoOpVimeoRequest.INSTANCE;
        }
        return this.authService.logOut("Bearer " + accessToken).enqueue(callback);
    }

    public AuthenticatorImpl(@NotNull AuthService authService, @NotNull String basicAuthHeader, @NotNull Scopes scopes, @NotNull CachingAccountStore accountStore) {
        Intrinsics.checkParameterIsNotNull((Object)authService, (String)"authService");
        Intrinsics.checkParameterIsNotNull((Object)basicAuthHeader, (String)"basicAuthHeader");
        Intrinsics.checkParameterIsNotNull((Object)scopes, (String)"scopes");
        Intrinsics.checkParameterIsNotNull((Object)accountStore, (String)"accountStore");
        this.authService = authService;
        this.basicAuthHeader = basicAuthHeader;
        this.scopes = scopes;
        this.accountStore = accountStore;
    }
}

