/*
 * Decompiled with CFR 0.152.
 */
package com.vimeo.networking2.internal;

import com.vimeo.networking2.ApiError;
import com.vimeo.networking2.AuthenticatedAccessToken;
import com.vimeo.networking2.Authenticator;
import com.vimeo.networking2.BasicAccessToken;
import com.vimeo.networking2.GrantType;
import com.vimeo.networking2.InvalidParameter;
import com.vimeo.networking2.VimeoCallback;
import com.vimeo.networking2.VimeoRequest;
import com.vimeo.networking2.internal.AuthParam;
import com.vimeo.networking2.internal.AuthService;
import com.vimeo.networking2.internal.AuthUtilsKt;
import com.vimeo.networking2.internal.VimeoCall;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J6\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00130\u000bH\u0016J&\u0010\u0014\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00052\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00130\u000bH\u0016J.\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00130\u000bH\u0016J.\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00130\u000bH\u0016J>\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00052\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00130\u000bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/vimeo/networking2/internal/AuthenticatorImpl;", "Lcom/vimeo/networking2/Authenticator;", "authService", "Lcom/vimeo/networking2/internal/AuthService;", "authHeaders", "", "scopes", "(Lcom/vimeo/networking2/internal/AuthService;Ljava/lang/String;Ljava/lang/String;)V", "clientCredentials", "Lcom/vimeo/networking2/VimeoRequest;", "authCallback", "Lcom/vimeo/networking2/VimeoCallback;", "Lcom/vimeo/networking2/BasicAccessToken;", "emailJoin", "displayName", "email", "password", "marketingOptIn", "", "Lcom/vimeo/networking2/AuthenticatedAccessToken;", "emailLogin", "facebook", "token", "google", "socialAuthenticate", "tokenField", "Lcom/vimeo/networking2/internal/AuthParam;", "errorMessage", "auth"})
public final class AuthenticatorImpl
implements Authenticator {
    private final AuthService authService;
    private final String authHeaders;
    private final String scopes;

    @Override
    @NotNull
    public VimeoRequest clientCredentials(@NotNull VimeoCallback<BasicAccessToken> authCallback) {
        VimeoRequest vimeoRequest;
        Intrinsics.checkParameterIsNotNull(authCallback, (String)"authCallback");
        Map params = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)AuthParam.FIELD_GRANT_TYPE, (Object)GrantType.CLIENT_CREDENTIALS.getValue()), TuplesKt.to((Object)AuthParam.FIELD_SCOPES, (Object)this.scopes)});
        VimeoCall<BasicAccessToken> call = this.authService.authorizeWithClientCredentialsGrant(this.authHeaders, params);
        List<InvalidParameter> invalidAuthParams = AuthUtilsKt.validate(params);
        Collection collection = invalidAuthParams;
        if (!collection.isEmpty()) {
            ApiError apiError = new ApiError("Client credentials authentication error.", null, null, invalidAuthParams, null, 22, null);
            vimeoRequest = call.enqueueError(apiError, authCallback);
        } else {
            vimeoRequest = call.enqueue(authCallback);
        }
        return vimeoRequest;
    }

    @Override
    @NotNull
    public VimeoRequest google(@NotNull String token, @NotNull String email, boolean marketingOptIn, @NotNull VimeoCallback<AuthenticatedAccessToken> authCallback) {
        Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
        Intrinsics.checkParameterIsNotNull((Object)email, (String)"email");
        Intrinsics.checkParameterIsNotNull(authCallback, (String)"authCallback");
        return this.socialAuthenticate(token, email, marketingOptIn, AuthParam.FIELD_ID_TOKEN, "Google authentication error.", authCallback);
    }

    @Override
    @NotNull
    public VimeoRequest facebook(@NotNull String token, @NotNull String email, boolean marketingOptIn, @NotNull VimeoCallback<AuthenticatedAccessToken> authCallback) {
        Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
        Intrinsics.checkParameterIsNotNull((Object)email, (String)"email");
        Intrinsics.checkParameterIsNotNull(authCallback, (String)"authCallback");
        return this.socialAuthenticate(token, email, marketingOptIn, AuthParam.FIELD_TOKEN, "Facebook authentication error.", authCallback);
    }

    private final VimeoRequest socialAuthenticate(String token, String email, boolean marketingOptIn, AuthParam tokenField, String errorMessage, VimeoCallback<AuthenticatedAccessToken> authCallback) {
        VimeoRequest vimeoRequest;
        Map params = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)tokenField, (Object)token), TuplesKt.to((Object)AuthParam.FIELD_EMAIL, (Object)email), TuplesKt.to((Object)AuthParam.FIELD_MARKETING_OPT_IN, (Object)String.valueOf(marketingOptIn))});
        VimeoCall<AuthenticatedAccessToken> call = this.authService.join(this.authHeaders, params);
        List<InvalidParameter> invalidAuthParams = AuthUtilsKt.validate(params);
        Collection collection = invalidAuthParams;
        if (!collection.isEmpty()) {
            ApiError apiError = new ApiError(errorMessage, null, null, invalidAuthParams, null, 22, null);
            vimeoRequest = call.enqueueError(apiError, authCallback);
        } else {
            vimeoRequest = call.enqueue(authCallback);
        }
        return vimeoRequest;
    }

    @Override
    @NotNull
    public VimeoRequest emailJoin(@NotNull String displayName, @NotNull String email, @NotNull String password, boolean marketingOptIn, @NotNull VimeoCallback<AuthenticatedAccessToken> authCallback) {
        VimeoRequest vimeoRequest;
        Intrinsics.checkParameterIsNotNull((Object)displayName, (String)"displayName");
        Intrinsics.checkParameterIsNotNull((Object)email, (String)"email");
        Intrinsics.checkParameterIsNotNull((Object)password, (String)"password");
        Intrinsics.checkParameterIsNotNull(authCallback, (String)"authCallback");
        Map params = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)AuthParam.FIELD_NAME, (Object)displayName), TuplesKt.to((Object)AuthParam.FIELD_EMAIL, (Object)email), TuplesKt.to((Object)AuthParam.FIELD_PASSWORD, (Object)password), TuplesKt.to((Object)AuthParam.FIELD_MARKETING_OPT_IN, (Object)String.valueOf(marketingOptIn)), TuplesKt.to((Object)AuthParam.FIELD_SCOPES, (Object)this.scopes)});
        VimeoCall<AuthenticatedAccessToken> call = this.authService.join(this.authHeaders, params);
        List<InvalidParameter> invalidAuthParams = AuthUtilsKt.validate(params);
        Collection collection = invalidAuthParams;
        if (!collection.isEmpty()) {
            ApiError apiError = new ApiError("Email join error.", null, null, invalidAuthParams, null, 22, null);
            vimeoRequest = call.enqueueError(apiError, authCallback);
        } else {
            vimeoRequest = call.enqueue(authCallback);
        }
        return vimeoRequest;
    }

    @Override
    @NotNull
    public VimeoRequest emailLogin(@NotNull String email, @NotNull String password, @NotNull VimeoCallback<AuthenticatedAccessToken> authCallback) {
        VimeoRequest vimeoRequest;
        Intrinsics.checkParameterIsNotNull((Object)email, (String)"email");
        Intrinsics.checkParameterIsNotNull((Object)password, (String)"password");
        Intrinsics.checkParameterIsNotNull(authCallback, (String)"authCallback");
        Map params = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)AuthParam.FIELD_USERNAME, (Object)email), TuplesKt.to((Object)AuthParam.FIELD_PASSWORD, (Object)password), TuplesKt.to((Object)AuthParam.FIELD_GRANT_TYPE, (Object)GrantType.PASSWORD.getValue()), TuplesKt.to((Object)AuthParam.FIELD_SCOPES, (Object)this.scopes)});
        VimeoCall<AuthenticatedAccessToken> call = this.authService.logIn(this.authHeaders, params);
        List<InvalidParameter> invalidAuthParams = AuthUtilsKt.validate(params);
        Collection collection = invalidAuthParams;
        if (!collection.isEmpty()) {
            ApiError apiError = new ApiError("Email login error.", null, null, invalidAuthParams, null, 22, null);
            vimeoRequest = call.enqueueError(apiError, authCallback);
        } else {
            vimeoRequest = call.enqueue(authCallback);
        }
        return vimeoRequest;
    }

    public AuthenticatorImpl(@NotNull AuthService authService, @NotNull String authHeaders, @NotNull String scopes2) {
        Intrinsics.checkParameterIsNotNull((Object)authService, (String)"authService");
        Intrinsics.checkParameterIsNotNull((Object)authHeaders, (String)"authHeaders");
        Intrinsics.checkParameterIsNotNull((Object)scopes2, (String)"scopes");
        this.authService = authService;
        this.authHeaders = authHeaders;
        this.scopes = scopes2;
    }
}

