/*
 * Decompiled with CFR 0.152.
 */
package se.vidstige.jadb;

import java.io.IOException;
import java.net.InetSocketAddress;
import se.vidstige.jadb.ConnectionToRemoteDeviceException;
import se.vidstige.jadb.JadbException;
import se.vidstige.jadb.Transport;

public class HostDisconnectFromRemoteTcpDevice {
    private final Transport transport;
    private final ResponseValidator responseValidator;

    HostDisconnectFromRemoteTcpDevice(Transport transport) {
        this.transport = transport;
        this.responseValidator = new ResponseValidatorImp();
    }

    HostDisconnectFromRemoteTcpDevice(Transport transport, ResponseValidator responseValidator) {
        this.transport = transport;
        this.responseValidator = responseValidator;
    }

    InetSocketAddress disconnect(InetSocketAddress inetSocketAddress) throws IOException, JadbException, ConnectionToRemoteDeviceException {
        this.transport.send(String.format("host:disconnect:%s:%d", inetSocketAddress.getHostString(), inetSocketAddress.getPort()));
        this.verifyTransportLevel();
        this.verifyProtocolLevel();
        return inetSocketAddress;
    }

    private void verifyTransportLevel() throws IOException, JadbException {
        this.transport.verifyResponse();
    }

    private void verifyProtocolLevel() throws IOException, ConnectionToRemoteDeviceException {
        String status = this.transport.readString();
        this.responseValidator.validate(status);
    }

    static final class ResponseValidatorImp
    implements ResponseValidator {
        private static final String SUCCESSFULLY_DISCONNECTED = "disconnected";
        private static final String ALREADY_DISCONNECTED = "error: no such device";

        ResponseValidatorImp() {
        }

        @Override
        public void validate(String response) throws ConnectionToRemoteDeviceException {
            if (!this.checkIfConnectedSuccessfully(response) && !this.checkIfAlreadyConnected(response)) {
                throw new ConnectionToRemoteDeviceException(this.extractError(response));
            }
        }

        private boolean checkIfConnectedSuccessfully(String response) {
            return response.startsWith(SUCCESSFULLY_DISCONNECTED);
        }

        private boolean checkIfAlreadyConnected(String response) {
            return response.startsWith(ALREADY_DISCONNECTED);
        }

        private String extractError(String response) {
            int lastColon = response.lastIndexOf(":");
            if (lastColon != -1) {
                return response.substring(lastColon, response.length());
            }
            return response;
        }
    }

    static interface ResponseValidator {
        public void validate(String var1) throws ConnectionToRemoteDeviceException;
    }
}

