/*
 * Decompiled with CFR 0.152.
 */
package se.vidstige.jadb;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.nio.charset.Charset;
import se.vidstige.jadb.JadbException;
import se.vidstige.jadb.Stream;
import se.vidstige.jadb.SyncTransport;

class Transport {
    private final OutputStream outputStream;
    private final InputStream inputStream;

    private Transport(OutputStream outputStream, InputStream inputStream) {
        this.outputStream = outputStream;
        this.inputStream = inputStream;
    }

    public Transport(Socket socket) throws IOException {
        this(socket.getOutputStream(), socket.getInputStream());
    }

    public String readString() throws IOException {
        String encodedLength = this.readString(4);
        int length = Integer.parseInt(encodedLength, 16);
        return this.readString(length);
    }

    public void readResponseTo(OutputStream output) throws IOException {
        Stream.copy(this.inputStream, output);
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void verifyResponse() throws IOException, JadbException {
        String response = this.readString(4);
        if (!"OKAY".equals(response)) {
            String error = this.readString();
            throw new JadbException("command failed: " + error);
        }
    }

    public String readString(int length) throws IOException {
        DataInputStream reader = new DataInputStream(this.inputStream);
        byte[] responseBuffer = new byte[length];
        reader.readFully(responseBuffer);
        return new String(responseBuffer, Charset.forName("utf-8"));
    }

    public String getCommandLength(String command) {
        return String.format("%04x", command.length());
    }

    public void send(String command) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(this.outputStream);
        writer.write(this.getCommandLength(command));
        writer.write(command);
        writer.flush();
    }

    public SyncTransport startSync() throws IOException, JadbException {
        this.send("sync:");
        this.verifyResponse();
        return new SyncTransport(this.outputStream, this.inputStream);
    }

    public void close() throws IOException {
        this.inputStream.close();
        this.outputStream.close();
    }
}

