/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.plugin.maven;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.project.MavenProject;

public enum ClasspathType {
    PROJECT_ONLY,
    WITH_RUNTIME_DEPENDENCIES,
    WITH_COMPILE_DEPENDENCIES,
    WITH_ALL_DEPENDENCIES,
    WITH_ALL_DEPENDENCIES_AND_TESTS;


    public Collection<String> getClasspathElements(MavenProject project) {
        Collection<Object> classpathElements;
        try {
            switch (this) {
                case PROJECT_ONLY: {
                    classpathElements = Collections.singleton(project.getBuild().getOutputDirectory());
                    break;
                }
                case WITH_COMPILE_DEPENDENCIES: {
                    classpathElements = project.getCompileClasspathElements();
                    break;
                }
                case WITH_RUNTIME_DEPENDENCIES: {
                    classpathElements = project.getRuntimeClasspathElements();
                    break;
                }
                case WITH_ALL_DEPENDENCIES: {
                    classpathElements = new HashSet();
                    classpathElements.addAll(project.getRuntimeClasspathElements());
                    classpathElements.addAll(project.getCompileClasspathElements());
                    break;
                }
                case WITH_ALL_DEPENDENCIES_AND_TESTS: {
                    classpathElements = new HashSet();
                    classpathElements.addAll(project.getRuntimeClasspathElements());
                    classpathElements.addAll(project.getCompileClasspathElements());
                    classpathElements.addAll(project.getTestClasspathElements());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("ClasspathType " + this + " not supported");
                }
            }
        }
        catch (DependencyResolutionRequiredException e) {
            throw new IllegalStateException("Failed to resolve classpathType elements", e);
        }
        return classpathElements;
    }

    public List<URL> getUrls(MavenProject project) {
        Collection<String> classpathElements = this.getClasspathElements(project);
        ArrayList<URL> urls = new ArrayList<URL>(classpathElements.size());
        for (String element : classpathElements) {
            try {
                urls.add(new File(element).toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException("Failed to resolve classpath element", e);
            }
        }
        return urls;
    }
}

