/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.plugin.maven;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.victools.jsonschema.generator.Module;
import com.github.victools.jsonschema.generator.Option;
import com.github.victools.jsonschema.generator.OptionPreset;
import com.github.victools.jsonschema.generator.SchemaGenerator;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfig;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigBuilder;
import com.github.victools.jsonschema.generator.SchemaVersion;
import com.github.victools.jsonschema.module.jackson.JacksonModule;
import com.github.victools.jsonschema.module.jackson.JacksonOption;
import com.github.victools.jsonschema.module.javax.validation.JavaxValidationModule;
import com.github.victools.jsonschema.module.javax.validation.JavaxValidationOption;
import com.github.victools.jsonschema.module.swagger15.SwaggerModule;
import com.github.victools.jsonschema.module.swagger15.SwaggerOption;
import com.github.victools.jsonschema.plugin.maven.GeneratorModule;
import com.github.victools.jsonschema.plugin.maven.GeneratorOptions;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;

@Mojo(name="generate", defaultPhase=LifecyclePhase.COMPILE, requiresDependencyResolution=ResolutionScope.COMPILE, requiresDependencyCollection=ResolutionScope.COMPILE)
public class SchemaGeneratorMojo
extends AbstractMojo {
    @Parameter(property="classNames")
    private String[] classNames;
    @Parameter(property="packageNames")
    private String[] packageNames;
    @Parameter(property="schemaFilePath")
    private File schemaFilePath;
    @Parameter(property="schemaFileName", defaultValue="{0}-schema.json")
    private String schemaFileName;
    @Parameter(property="schemaVersion", defaultValue="DRAFT_7")
    private SchemaVersion schemaVersion;
    @Parameter
    private GeneratorOptions options;
    @Parameter
    private GeneratorModule[] modules;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    MavenProject project;
    private SchemaGenerator generator = null;
    private ClassLoader classLoader = null;

    public void execute() throws MojoExecutionException {
        this.getGenerator();
        if (this.classNames != null) {
            for (String className : this.classNames) {
                this.getLog().info((CharSequence)("Generating JSON Schema for class " + className));
                this.generateSchema(className);
            }
        }
        if (this.packageNames != null) {
            for (String packageName : this.packageNames) {
                this.getLog().info((CharSequence)("Generating JSON Schema for package " + packageName));
                this.generateSchemaForPackage(packageName);
            }
        }
    }

    private void generateSchema(String className) throws MojoExecutionException {
        Class<?> schemaClass = this.loadClass(className);
        this.generateSchema(schemaClass);
    }

    private void generateSchema(Class<?> schemaClass) throws MojoExecutionException {
        ObjectNode jsonSchema = this.getGenerator().generateSchema(schemaClass, new Type[0]);
        File file = this.getSchemaFile(schemaClass);
        this.getLog().info((CharSequence)("- Writing schema to file: " + file));
        this.writeToFile((JsonNode)jsonSchema, file);
    }

    private void generateSchemaForPackage(String packageName) throws MojoExecutionException {
        Reflections reflections = new Reflections(packageName, new Scanner[]{new SubTypesScanner(false)});
        Set subTypes = reflections.getSubTypesOf(Object.class);
        for (Class mainType : subTypes) {
            this.generateSchema(mainType);
        }
    }

    private File getSchemaFile(Class<?> mainType) {
        File directory;
        if (this.schemaFilePath == null) {
            directory = new File("src" + File.separator + "main" + File.separator + "resources");
            this.getLog().debug((CharSequence)("- No 'schemaFilePath' configured. Applying default: " + directory));
        } else {
            directory = this.schemaFilePath;
        }
        String fileName = MessageFormat.format(this.schemaFileName, mainType.getSimpleName(), mainType.getPackage().getName().replace('.', File.separatorChar));
        File schemaFile = new File(directory, fileName);
        try {
            Files.createDirectories(schemaFile.getParentFile().toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)("Failed to ensure existence of " + schemaFile.getParent()), (Throwable)e);
        }
        return schemaFile;
    }

    private SchemaGenerator getGenerator() throws MojoExecutionException {
        if (this.generator == null) {
            this.getLog().debug((CharSequence)"Initializing Schema Generator");
            SchemaGeneratorConfigBuilder configBuilder = new SchemaGeneratorConfigBuilder(this.schemaVersion, this.getOptionPreset());
            this.setOptions(configBuilder);
            this.setModules(configBuilder);
            SchemaGeneratorConfig config = configBuilder.build();
            this.generator = new SchemaGenerator(config);
        }
        return this.generator;
    }

    private OptionPreset getOptionPreset() {
        if (this.options != null && this.options.preset != null) {
            return this.options.preset.getPreset();
        }
        this.getLog().debug((CharSequence)"- No 'options/preset' configured. Applying default: PLAIN_JSON");
        return OptionPreset.PLAIN_JSON;
    }

    private void setOptions(SchemaGeneratorConfigBuilder configBuilder) {
        if (this.options == null) {
            return;
        }
        if (this.options.enabled != null) {
            for (Option option : this.options.enabled) {
                configBuilder.with(option, new Option[0]);
            }
        }
        if (this.options.disabled != null) {
            for (Option option : this.options.disabled) {
                configBuilder.without(option, new Option[0]);
            }
        }
    }

    private void setModules(SchemaGeneratorConfigBuilder configBuilder) throws MojoExecutionException {
        if (this.modules == null) {
            return;
        }
        block12: for (GeneratorModule module : this.modules) {
            if (module.className != null && !module.className.isEmpty()) {
                try {
                    this.getLog().debug((CharSequence)("- Adding custom Module " + module.className));
                    Class<?> moduleClass = this.loadClass(module.className);
                    Module moduleInstance = (Module)moduleClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                    configBuilder.with(moduleInstance);
                    continue;
                }
                catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new MojoExecutionException("Error: Can not instantiate custom module " + module.className, e);
                }
            }
            if (module.name == null) continue;
            switch (module.name) {
                case "Jackson": {
                    this.getLog().debug((CharSequence)"- Adding Jackson Module");
                    this.addJacksonModule(configBuilder, module);
                    continue block12;
                }
                case "JavaxValidation": {
                    this.getLog().debug((CharSequence)"- Adding Javax Validation Module");
                    this.addJavaxValidationModule(configBuilder, module);
                    continue block12;
                }
                case "Swagger15": {
                    this.getLog().debug((CharSequence)"- Adding Swagger 1.5 Module");
                    this.addSwagger15Module(configBuilder, module);
                    continue block12;
                }
                default: {
                    throw new MojoExecutionException("Error: Module does not have a name in ['Jackson', 'JavaxValidation', 'Swagger15'] or does not have a custom classname.");
                }
            }
        }
    }

    private ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            List runtimeClasspathElements = null;
            try {
                runtimeClasspathElements = this.project.getRuntimeClasspathElements();
            }
            catch (DependencyResolutionRequiredException e) {
                this.getLog().error((CharSequence)"Failed to resolve runtime classpath elements", (Throwable)e);
            }
            if (runtimeClasspathElements != null) {
                URL[] runtimeUrls = new URL[runtimeClasspathElements.size()];
                for (int i = 0; i < runtimeClasspathElements.size(); ++i) {
                    String element = (String)runtimeClasspathElements.get(i);
                    try {
                        runtimeUrls[i] = new File(element).toURI().toURL();
                        continue;
                    }
                    catch (MalformedURLException e) {
                        this.getLog().error((CharSequence)"Failed to resolve runtime classpath element", (Throwable)e);
                    }
                }
                this.classLoader = new URLClassLoader(runtimeUrls, Thread.currentThread().getContextClassLoader());
            }
        }
        return this.classLoader;
    }

    private Class<?> loadClass(String className) throws MojoExecutionException {
        try {
            return this.getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new MojoExecutionException("Error loading class " + className, (Exception)e);
        }
    }

    private void addSwagger15Module(SchemaGeneratorConfigBuilder configBuilder, GeneratorModule module) throws MojoExecutionException {
        if (module.options == null || module.options.length == 0) {
            configBuilder.with((Module)new SwaggerModule(new SwaggerOption[0]));
        } else {
            SwaggerOption[] swaggerOptions = new SwaggerOption[module.options.length];
            for (int i = 0; i < module.options.length; ++i) {
                try {
                    swaggerOptions[i] = SwaggerOption.valueOf((String)module.options[i]);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    throw new MojoExecutionException("Error: Unknown Swagger option " + module.options[i], (Exception)e);
                }
            }
            configBuilder.with((Module)new SwaggerModule(swaggerOptions));
        }
    }

    private void addJavaxValidationModule(SchemaGeneratorConfigBuilder configBuilder, GeneratorModule module) throws MojoExecutionException {
        if (module.options == null || module.options.length == 0) {
            configBuilder.with((Module)new JavaxValidationModule(new JavaxValidationOption[0]));
        } else {
            JavaxValidationOption[] javaxValidationOptions = new JavaxValidationOption[module.options.length];
            for (int i = 0; i < module.options.length; ++i) {
                try {
                    javaxValidationOptions[i] = JavaxValidationOption.valueOf((String)module.options[i]);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    throw new MojoExecutionException("Error: Unknown JavaxValidation option " + module.options[i], (Exception)e);
                }
            }
            configBuilder.with((Module)new JavaxValidationModule(javaxValidationOptions));
        }
    }

    private void addJacksonModule(SchemaGeneratorConfigBuilder configBuilder, GeneratorModule module) throws MojoExecutionException {
        if (module.options == null || module.options.length == 0) {
            configBuilder.with((Module)new JacksonModule());
        } else {
            JacksonOption[] jacksonOptions = new JacksonOption[module.options.length];
            for (int i = 0; i < module.options.length; ++i) {
                try {
                    jacksonOptions[i] = JacksonOption.valueOf((String)module.options[i]);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    throw new MojoExecutionException("Error: Unknown Jackson option " + module.options[i], (Exception)e);
                }
            }
            configBuilder.with((Module)new JacksonModule(jacksonOptions));
        }
    }

    private void writeToFile(JsonNode jsonSchema, File file) throws MojoExecutionException {
        try (FileOutputStream outputStream = new FileOutputStream(file);
             PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)outputStream, StandardCharsets.UTF_8));){
            writer.print(jsonSchema.toPrettyString());
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error: Can not write to file " + file, (Exception)e);
        }
    }
}

