/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.generator.impl;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.victools.jsonschema.generator.FieldScope;
import com.github.victools.jsonschema.generator.MethodScope;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfig;
import com.github.victools.jsonschema.generator.TypeScope;
import com.github.victools.jsonschema.generator.impl.SchemaGenerationContextImpl;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeCollector {
    private static final Logger logger = LoggerFactory.getLogger(AttributeCollector.class);
    private final ObjectMapper objectMapper;

    public AttributeCollector(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public static ObjectNode collectFieldAttributes(FieldScope field, SchemaGenerationContextImpl generationContext) {
        SchemaGeneratorConfig config = generationContext.getGeneratorConfig();
        ObjectNode node = config.createObjectNode();
        AttributeCollector collector = new AttributeCollector(config.getObjectMapper());
        collector.setTitle(node, config.resolveTitle(field));
        collector.setDescription(node, config.resolveDescription(field));
        collector.setDefault(node, config.resolveDefault(field));
        collector.setEnum(node, config.resolveEnum(field));
        collector.setAdditionalProperties(node, config.resolveAdditionalProperties(field), generationContext);
        collector.setPatternProperties(node, config.resolvePatternProperties(field), generationContext);
        collector.setStringMinLength(node, config.resolveStringMinLength(field));
        collector.setStringMaxLength(node, config.resolveStringMaxLength(field));
        collector.setStringFormat(node, config.resolveStringFormat(field));
        collector.setStringPattern(node, config.resolveStringPattern(field));
        collector.setNumberInclusiveMinimum(node, config.resolveNumberInclusiveMinimum(field));
        collector.setNumberExclusiveMinimum(node, config.resolveNumberExclusiveMinimum(field));
        collector.setNumberInclusiveMaximum(node, config.resolveNumberInclusiveMaximum(field));
        collector.setNumberExclusiveMaximum(node, config.resolveNumberExclusiveMaximum(field));
        collector.setNumberMultipleOf(node, config.resolveNumberMultipleOf(field));
        collector.setArrayMinItems(node, config.resolveArrayMinItems(field));
        collector.setArrayMaxItems(node, config.resolveArrayMaxItems(field));
        collector.setArrayUniqueItems(node, config.resolveArrayUniqueItems(field));
        config.getFieldAttributeOverrides().forEach(override -> override.overrideInstanceAttributes(node, field));
        return node;
    }

    public static ObjectNode collectMethodAttributes(MethodScope method, SchemaGenerationContextImpl generationContext) {
        SchemaGeneratorConfig config = generationContext.getGeneratorConfig();
        ObjectNode node = config.createObjectNode();
        AttributeCollector collector = new AttributeCollector(config.getObjectMapper());
        collector.setTitle(node, config.resolveTitle(method));
        collector.setDescription(node, config.resolveDescription(method));
        collector.setDefault(node, config.resolveDefault(method));
        collector.setEnum(node, config.resolveEnum(method));
        collector.setAdditionalProperties(node, config.resolveAdditionalProperties(method), generationContext);
        collector.setPatternProperties(node, config.resolvePatternProperties(method), generationContext);
        collector.setStringMinLength(node, config.resolveStringMinLength(method));
        collector.setStringMaxLength(node, config.resolveStringMaxLength(method));
        collector.setStringFormat(node, config.resolveStringFormat(method));
        collector.setStringPattern(node, config.resolveStringPattern(method));
        collector.setNumberInclusiveMinimum(node, config.resolveNumberInclusiveMinimum(method));
        collector.setNumberExclusiveMinimum(node, config.resolveNumberExclusiveMinimum(method));
        collector.setNumberInclusiveMaximum(node, config.resolveNumberInclusiveMaximum(method));
        collector.setNumberExclusiveMaximum(node, config.resolveNumberExclusiveMaximum(method));
        collector.setNumberMultipleOf(node, config.resolveNumberMultipleOf(method));
        collector.setArrayMinItems(node, config.resolveArrayMinItems(method));
        collector.setArrayMaxItems(node, config.resolveArrayMaxItems(method));
        collector.setArrayUniqueItems(node, config.resolveArrayUniqueItems(method));
        config.getMethodAttributeOverrides().forEach(override -> override.overrideInstanceAttributes(node, method));
        return node;
    }

    public static ObjectNode collectTypeAttributes(TypeScope scope, SchemaGenerationContextImpl generationContext, Set<String> allowedSchemaTypes) {
        SchemaGeneratorConfig config = generationContext.getGeneratorConfig();
        ObjectNode node = config.createObjectNode();
        AttributeCollector collector = new AttributeCollector(config.getObjectMapper());
        collector.setTitle(node, config.resolveTitleForType(scope));
        collector.setDescription(node, config.resolveDescriptionForType(scope));
        collector.setDefault(node, config.resolveDefaultForType(scope));
        collector.setEnum(node, config.resolveEnumForType(scope));
        if (allowedSchemaTypes.isEmpty() || allowedSchemaTypes.contains("object")) {
            collector.setAdditionalProperties(node, config.resolveAdditionalPropertiesForType(scope), generationContext);
            collector.setPatternProperties(node, config.resolvePatternPropertiesForType(scope), generationContext);
        }
        if (allowedSchemaTypes.isEmpty() || allowedSchemaTypes.contains("string")) {
            collector.setStringMinLength(node, config.resolveStringMinLengthForType(scope));
            collector.setStringMaxLength(node, config.resolveStringMaxLengthForType(scope));
            collector.setStringFormat(node, config.resolveStringFormatForType(scope));
            collector.setStringPattern(node, config.resolveStringPatternForType(scope));
        }
        if (allowedSchemaTypes.isEmpty() || allowedSchemaTypes.contains("integer") || allowedSchemaTypes.contains("number")) {
            collector.setNumberInclusiveMinimum(node, config.resolveNumberInclusiveMinimumForType(scope));
            collector.setNumberExclusiveMinimum(node, config.resolveNumberExclusiveMinimumForType(scope));
            collector.setNumberInclusiveMaximum(node, config.resolveNumberInclusiveMaximumForType(scope));
            collector.setNumberExclusiveMaximum(node, config.resolveNumberExclusiveMaximumForType(scope));
            collector.setNumberMultipleOf(node, config.resolveNumberMultipleOfForType(scope));
        }
        if (allowedSchemaTypes.isEmpty() || allowedSchemaTypes.contains("array")) {
            collector.setArrayMinItems(node, config.resolveArrayMinItemsForType(scope));
            collector.setArrayMaxItems(node, config.resolveArrayMaxItemsForType(scope));
            collector.setArrayUniqueItems(node, config.resolveArrayUniqueItemsForType(scope));
        }
        return node;
    }

    public AttributeCollector setTitle(ObjectNode node, String title) {
        if (title != null) {
            node.put("title", title);
        }
        return this;
    }

    public AttributeCollector setDescription(ObjectNode node, String description) {
        if (description != null) {
            node.put("description", description);
        }
        return this;
    }

    public AttributeCollector setDefault(ObjectNode node, Object defaultValue) {
        if (defaultValue != null) {
            if (defaultValue instanceof String) {
                node.put("default", (String)defaultValue);
            } else if (defaultValue instanceof BigDecimal) {
                node.put("default", (BigDecimal)defaultValue);
            } else if (defaultValue instanceof BigInteger) {
                node.put("default", (BigInteger)defaultValue);
            } else if (defaultValue instanceof Boolean) {
                node.put("default", (Boolean)defaultValue);
            } else if (defaultValue instanceof Double) {
                node.put("default", (Double)defaultValue);
            } else if (defaultValue instanceof Float) {
                node.put("default", (Float)defaultValue);
            } else if (defaultValue instanceof Integer) {
                node.put("default", (Integer)defaultValue);
            } else {
                node.putPOJO("default", defaultValue);
            }
        }
        return this;
    }

    public AttributeCollector setEnum(ObjectNode node, Collection<?> enumValues) {
        if (enumValues != null) {
            List values = enumValues.stream().filter(this::isSupportedEnumValue).filter(this::canBeConvertedToString).collect(Collectors.toList());
            if (values.size() == 1) {
                Object singleValue = values.get(0);
                if (singleValue instanceof String) {
                    node.put("const", (String)singleValue);
                } else {
                    node.putPOJO("const", singleValue);
                }
            } else if (!values.isEmpty()) {
                ArrayNode array = node.arrayNode();
                for (Object singleValue : values) {
                    if (singleValue instanceof String) {
                        array.add((String)singleValue);
                        continue;
                    }
                    array.addPOJO(singleValue);
                }
                node.set("enum", (JsonNode)array);
            }
        }
        return this;
    }

    private boolean isSupportedEnumValue(Object target) {
        if (target == null) {
            return true;
        }
        Class<?> targetType = target.getClass();
        return targetType.isPrimitive() || Number.class.isAssignableFrom(targetType) || CharSequence.class.isAssignableFrom(targetType) || Enum.class.isAssignableFrom(targetType);
    }

    private boolean canBeConvertedToString(Object target) {
        try {
            return target == null || this.objectMapper.writeValueAsString(target) != null;
        }
        catch (JsonProcessingException ex) {
            logger.warn("Failed to convert value to string via ObjectMapper: {}", target, (Object)ex);
            return false;
        }
    }

    public AttributeCollector setAdditionalProperties(ObjectNode node, Type additionalProperties, SchemaGenerationContextImpl generationContext) {
        ResolvedType targetType;
        if (additionalProperties == Void.class || additionalProperties == Void.TYPE) {
            node.put("additionalProperties", false);
        } else if (additionalProperties != null && (targetType = generationContext.getTypeContext().resolve(additionalProperties, new Type[0])).getErasedType() != Object.class) {
            ObjectNode additionalPropertiesSchema = this.objectMapper.createObjectNode();
            generationContext.traverseGenericType(targetType, additionalPropertiesSchema, false);
            node.set("additionalProperties", (JsonNode)additionalPropertiesSchema);
        }
        return this;
    }

    public AttributeCollector setPatternProperties(ObjectNode node, Map<String, Type> patternProperties, SchemaGenerationContextImpl generationContext) {
        if (patternProperties != null && !patternProperties.isEmpty()) {
            ObjectNode patternPropertiesNode = this.objectMapper.createObjectNode();
            for (Map.Entry<String, Type> entry : patternProperties.entrySet()) {
                ObjectNode singlePatternSchema = this.objectMapper.createObjectNode();
                ResolvedType targetType = generationContext.getTypeContext().resolve(entry.getValue(), new Type[0]);
                generationContext.traverseGenericType(targetType, singlePatternSchema, false);
                patternPropertiesNode.set(entry.getKey(), (JsonNode)singlePatternSchema);
            }
            node.set("patternProperties", (JsonNode)patternPropertiesNode);
        }
        return this;
    }

    public AttributeCollector setStringMinLength(ObjectNode node, Integer minLength) {
        if (minLength != null) {
            node.put("minLength", minLength);
        }
        return this;
    }

    public AttributeCollector setStringMaxLength(ObjectNode node, Integer maxLength) {
        if (maxLength != null) {
            node.put("maxLength", maxLength);
        }
        return this;
    }

    public AttributeCollector setStringFormat(ObjectNode node, String format) {
        if (format != null) {
            node.put("format", format);
        }
        return this;
    }

    public AttributeCollector setStringPattern(ObjectNode node, String pattern) {
        if (pattern != null) {
            node.put("pattern", pattern);
        }
        return this;
    }

    public AttributeCollector setNumberInclusiveMinimum(ObjectNode node, BigDecimal inclusiveMinimum) {
        if (inclusiveMinimum != null) {
            node.put("minimum", inclusiveMinimum);
        }
        return this;
    }

    public AttributeCollector setNumberExclusiveMinimum(ObjectNode node, BigDecimal exclusiveMinimum) {
        if (exclusiveMinimum != null) {
            node.put("exclusiveMinimum", exclusiveMinimum);
        }
        return this;
    }

    public AttributeCollector setNumberInclusiveMaximum(ObjectNode node, BigDecimal inclusiveMaximum) {
        if (inclusiveMaximum != null) {
            node.put("maximum", inclusiveMaximum);
        }
        return this;
    }

    public AttributeCollector setNumberExclusiveMaximum(ObjectNode node, BigDecimal exclusiveMaximum) {
        if (exclusiveMaximum != null) {
            node.put("exclusiveMaximum", exclusiveMaximum);
        }
        return this;
    }

    public AttributeCollector setNumberMultipleOf(ObjectNode node, BigDecimal multipleOf) {
        if (multipleOf != null) {
            node.put("multipleOf", multipleOf);
        }
        return this;
    }

    public AttributeCollector setArrayMinItems(ObjectNode node, Integer minItemCount) {
        if (minItemCount != null) {
            node.put("minItems", minItemCount);
        }
        return this;
    }

    public AttributeCollector setArrayMaxItems(ObjectNode node, Integer maxItemCount) {
        if (maxItemCount != null) {
            node.put("maxItems", maxItemCount);
        }
        return this;
    }

    public AttributeCollector setArrayUniqueItems(ObjectNode node, Boolean uniqueItems) {
        if (uniqueItems != null) {
            node.put("uniqueItems", uniqueItems);
        }
        return this;
    }
}

