/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.generator;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.ResolvedTypeWithMembers;
import com.fasterxml.classmate.members.ResolvedField;
import com.fasterxml.classmate.members.ResolvedMethod;
import com.github.victools.jsonschema.generator.FieldScope;
import com.github.victools.jsonschema.generator.MemberScope;
import com.github.victools.jsonschema.generator.TypeContext;
import com.github.victools.jsonschema.generator.impl.LazyValue;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Method;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class MethodScope
extends MemberScope<ResolvedMethod, Method> {
    private final LazyValue<FieldScope> getterField = new LazyValue<FieldScope>(this::doFindGetterField);

    protected MethodScope(ResolvedMethod method, ResolvedTypeWithMembers declaringTypeMembers, TypeContext context) {
        this(method, (ResolvedType)null, (String)null, declaringTypeMembers, false, context);
    }

    protected MethodScope(ResolvedMethod method, ResolvedType overriddenType, String overriddenName, ResolvedTypeWithMembers declaringTypeMembers, boolean fakeContainerItemScope, TypeContext context) {
        super(method, overriddenType, overriddenName, declaringTypeMembers, fakeContainerItemScope, context);
    }

    public MethodScope withOverriddenType(ResolvedType overriddenType) {
        return new MethodScope((ResolvedMethod)this.getMember(), overriddenType, this.getOverriddenName(), this.getDeclaringTypeMembers(), this.isFakeContainerItemScope(), this.getContext());
    }

    public MethodScope withOverriddenName(String overriddenName) {
        return new MethodScope((ResolvedMethod)this.getMember(), this.getOverriddenType(), overriddenName, this.getDeclaringTypeMembers(), this.isFakeContainerItemScope(), this.getContext());
    }

    public MethodScope asFakeContainerItemScope() {
        return (MethodScope)super.asFakeContainerItemScope();
    }

    public boolean isVoid() {
        return this.getType() == null;
    }

    public int getArgumentCount() {
        return ((ResolvedMethod)this.getMember()).getArgumentCount();
    }

    public List<ResolvedType> getArgumentTypes() {
        return IntStream.range(0, this.getArgumentCount()).mapToObj(arg_0 -> ((ResolvedMethod)((ResolvedMethod)this.getMember())).getArgumentType(arg_0)).collect(Collectors.toList());
    }

    public FieldScope findGetterField() {
        return this.getterField.get();
    }

    private FieldScope doFindGetterField() {
        if (this.getType() == null || !this.isPublic() || this.getArgumentCount() > 0) {
            return null;
        }
        String methodName = this.getName();
        String fieldName = methodName.startsWith("get") && methodName.length() > 3 && Character.isUpperCase(methodName.charAt(3)) ? methodName.substring(3, 4).toLowerCase() + methodName.substring(4) : (methodName.startsWith("is") && methodName.length() > 2 && Character.isUpperCase(methodName.charAt(2)) ? methodName.substring(2, 3).toLowerCase() + methodName.substring(3) : null);
        if (fieldName == null) {
            return null;
        }
        return Stream.of(this.getDeclaringTypeMembers().getMemberFields()).filter(memberField -> memberField.getName().equals(fieldName)).findFirst().map(field -> this.getContext().createFieldScope((ResolvedField)field, this.getDeclaringTypeMembers())).orElse(null);
    }

    public boolean isGetter() {
        return this.findGetterField() != null;
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
        A annotation = super.getAnnotation(annotationClass);
        if (annotation == null) {
            annotation = ((Method)this.getRawMember()).getAnnotatedReturnType().getAnnotation(annotationClass);
        }
        return annotation;
    }

    @Override
    public <A extends Annotation> A getContainerItemAnnotation(Class<A> annotationClass) {
        AnnotatedType[] typeArguments;
        AnnotatedType annotatedReturnType = ((Method)this.getRawMember()).getAnnotatedReturnType();
        if (annotatedReturnType instanceof AnnotatedParameterizedType && (typeArguments = ((AnnotatedParameterizedType)annotatedReturnType).getAnnotatedActualTypeArguments()).length == 1) {
            return typeArguments[0].getAnnotation(annotationClass);
        }
        return null;
    }

    @Override
    public <A extends Annotation> A getAnnotationConsideringFieldAndGetter(Class<A> annotationClass) {
        A annotation = this.getAnnotation(annotationClass);
        if (annotation == null) {
            FieldScope associatedField = this.findGetterField();
            annotation = associatedField == null ? null : associatedField.getAnnotation(annotationClass);
        }
        return annotation;
    }

    @Override
    public <A extends Annotation> A getContainerItemAnnotationConsideringFieldAndGetter(Class<A> annotationClass) {
        A annotation = this.getContainerItemAnnotation(annotationClass);
        if (annotation == null) {
            FieldScope associatedField = this.findGetterField();
            annotation = associatedField == null ? null : ((MemberScope)associatedField).getContainerItemAnnotation(annotationClass);
        }
        return annotation;
    }

    @Override
    protected String doGetSchemaPropertyName() {
        String result = this.getName();
        if (this.getContext().isDerivingFieldsFromArgumentFreeMethods() && this.getArgumentCount() == 0) {
            if (this.getOverriddenName() == null) {
                if (result.startsWith("get") && result.length() > 3) {
                    result = Character.toLowerCase(result.charAt(3)) + result.substring(4);
                } else if (result.startsWith("is") && result.length() > 2) {
                    result = Character.toLowerCase(result.charAt(2)) + result.substring(3);
                }
            }
        } else {
            result = result + this.getArgumentTypes().stream().map(this.getContext()::getMethodPropertyArgumentTypeDescription).collect(Collectors.joining(", ", "(", ")"));
        }
        return result;
    }
}

