/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.generator;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfig;
import com.github.victools.jsonschema.generator.SchemaKeyword;
import com.github.victools.jsonschema.generator.TypeContext;
import com.github.victools.jsonschema.generator.impl.AttributeCollector;
import com.github.victools.jsonschema.generator.impl.DefinitionKey;
import com.github.victools.jsonschema.generator.impl.SchemaCleanUpUtils;
import com.github.victools.jsonschema.generator.impl.SchemaGenerationContextImpl;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;

public class SchemaBuilder {
    private final SchemaGeneratorConfig config;
    private final TypeContext typeContext;
    private final SchemaGenerationContextImpl generationContext;
    private final List<ObjectNode> schemaNodes;
    private final Function<String, String> definitionKeyCleanup;

    static ObjectNode createSingleTypeSchema(SchemaGeneratorConfig config, TypeContext typeContext, Type mainTargetType, Type ... typeParameters) {
        SchemaBuilder instance = new SchemaBuilder(config, typeContext);
        return instance.createSchemaForSingleType(mainTargetType, typeParameters);
    }

    static SchemaBuilder forMultipleTypes(SchemaGeneratorConfig config, TypeContext typeContext) {
        return new SchemaBuilder(config, typeContext);
    }

    SchemaBuilder(SchemaGeneratorConfig config, TypeContext typeContext) {
        this.config = config;
        this.typeContext = typeContext;
        this.generationContext = new SchemaGenerationContextImpl(this.config, this.typeContext);
        this.schemaNodes = new ArrayList<ObjectNode>();
        SchemaCleanUpUtils cleanupUtils = new SchemaCleanUpUtils(config);
        this.definitionKeyCleanup = config.shouldUsePlainDefinitionKeys() ? cleanupUtils::ensureDefinitionKeyIsPlain : cleanupUtils::ensureDefinitionKeyIsUriCompatible;
    }

    private ObjectNode createSchemaForSingleType(Type mainTargetType, Type ... typeParameters) {
        String definitionsTagName;
        ObjectNode definitionsNode;
        boolean createDefinitionForMainSchema;
        ResolvedType mainType = this.typeContext.resolve(mainTargetType, typeParameters);
        DefinitionKey mainKey = this.generationContext.parseType(mainType);
        ObjectNode jsonSchemaResult = this.config.createObjectNode();
        if (this.config.shouldIncludeSchemaVersionIndicator()) {
            jsonSchemaResult.put(this.config.getKeyword(SchemaKeyword.TAG_SCHEMA), this.config.getKeyword(SchemaKeyword.TAG_SCHEMA_VALUE));
        }
        if (createDefinitionForMainSchema = this.config.shouldCreateDefinitionForMainSchema()) {
            this.generationContext.addReference(mainType, jsonSchemaResult, null, false);
        }
        if ((definitionsNode = this.buildDefinitionsAndResolveReferences(definitionsTagName = this.config.getKeyword(SchemaKeyword.TAG_DEFINITIONS), mainKey, this.generationContext)).size() > 0) {
            jsonSchemaResult.set(definitionsTagName, (JsonNode)definitionsNode);
        }
        if (!createDefinitionForMainSchema) {
            ObjectNode mainSchemaNode = this.generationContext.getDefinition(mainKey);
            jsonSchemaResult.setAll(mainSchemaNode);
            this.schemaNodes.add(jsonSchemaResult);
        }
        this.performCleanup();
        return jsonSchemaResult;
    }

    public ObjectNode createSchemaReference(Type targetType, Type ... typeParameters) {
        ResolvedType resolvedTargetType = this.typeContext.resolve(targetType, typeParameters);
        ObjectNode node = this.generationContext.createDefinitionReference(resolvedTargetType);
        this.schemaNodes.add(node);
        return node;
    }

    public ObjectNode collectDefinitions(String designatedDefinitionPath) {
        ObjectNode definitionsNode = this.buildDefinitionsAndResolveReferences(designatedDefinitionPath, null, this.generationContext);
        this.performCleanup();
        return definitionsNode;
    }

    private void performCleanup() {
        SchemaCleanUpUtils cleanUpUtils = new SchemaCleanUpUtils(this.config);
        if (this.config.shouldCleanupUnnecessaryAllOfElements()) {
            cleanUpUtils.reduceAllOfNodes(this.schemaNodes);
        }
        cleanUpUtils.reduceAnyOfNodes(this.schemaNodes);
    }

    private ObjectNode buildDefinitionsAndResolveReferences(String designatedDefinitionPath, DefinitionKey mainSchemaKey, SchemaGenerationContextImpl generationContext) {
        ObjectNode definitionsNode = this.config.createObjectNode();
        boolean createDefinitionsForAll = this.config.shouldCreateDefinitionsForAllObjects();
        boolean createDefinitionForMainSchema = this.config.shouldCreateDefinitionForMainSchema();
        boolean inlineAllSchemas = this.config.shouldInlineAllSchemas();
        for (Map.Entry<DefinitionKey, String> entry : this.getReferenceKeys(mainSchemaKey, generationContext).entrySet()) {
            String referenceKey;
            ObjectNode definition;
            boolean referenceInline;
            String definitionName = entry.getValue();
            DefinitionKey definitionKey = entry.getKey();
            List<ObjectNode> references = generationContext.getReferences(definitionKey);
            List<ObjectNode> nullableReferences = generationContext.getNullableReferences(definitionKey);
            boolean bl = referenceInline = inlineAllSchemas || (references.isEmpty() || !createDefinitionsForAll && references.size() + nullableReferences.size() < 2) && !definitionKey.equals(mainSchemaKey);
            if (referenceInline) {
                definition = generationContext.getDefinition(definitionKey);
                references.forEach(node -> AttributeCollector.mergeMissingAttributes(node, definition));
                referenceKey = null;
            } else {
                if (createDefinitionForMainSchema || !definitionKey.equals(mainSchemaKey)) {
                    definitionsNode.set(definitionName, (JsonNode)generationContext.getDefinition(definitionKey));
                    referenceKey = this.config.getKeyword(SchemaKeyword.TAG_REF_MAIN) + '/' + designatedDefinitionPath + '/' + definitionName;
                } else {
                    referenceKey = this.config.getKeyword(SchemaKeyword.TAG_REF_MAIN);
                }
                references.forEach(node -> node.put(this.config.getKeyword(SchemaKeyword.TAG_REF), referenceKey));
            }
            if (nullableReferences.isEmpty()) continue;
            definition = referenceInline ? generationContext.getDefinition(definitionKey) : this.config.createObjectNode().put(this.config.getKeyword(SchemaKeyword.TAG_REF), referenceKey);
            generationContext.makeNullable(definition);
            if (!inlineAllSchemas && (createDefinitionsForAll || nullableReferences.size() > 1)) {
                String nullableDefinitionName = definitionName + "-nullable";
                definitionsNode.set(nullableDefinitionName, (JsonNode)definition);
                nullableReferences.forEach(node -> node.put(this.config.getKeyword(SchemaKeyword.TAG_REF), this.config.getKeyword(SchemaKeyword.TAG_REF_MAIN) + '/' + designatedDefinitionPath + '/' + nullableDefinitionName));
                continue;
            }
            nullableReferences.forEach(node -> AttributeCollector.mergeMissingAttributes(node, definition));
        }
        definitionsNode.forEach(node -> this.schemaNodes.add((ObjectNode)node));
        return definitionsNode;
    }

    private Map<DefinitionKey, String> getReferenceKeys(DefinitionKey mainSchemaKey, SchemaGenerationContextImpl generationContext) {
        boolean createDefinitionForMainSchema = this.config.shouldCreateDefinitionForMainSchema();
        Map aliases = generationContext.getDefinedTypes().stream().collect(Collectors.groupingBy(this::getSchemaBaseDefinitionName, TreeMap::new, Collectors.toList()));
        LinkedHashMap<DefinitionKey, String> referenceKeys = new LinkedHashMap<DefinitionKey, String>();
        for (Map.Entry group : aliases.entrySet()) {
            List definitionKeys = (List)group.getValue();
            if (definitionKeys.size() == 1 || definitionKeys.size() == 2 && !createDefinitionForMainSchema && definitionKeys.contains(mainSchemaKey)) {
                definitionKeys.forEach(key -> {
                    String cfr_ignored_0 = (String)referenceKeys.put((DefinitionKey)key, (String)group.getKey());
                });
                continue;
            }
            AtomicInteger counter = new AtomicInteger(0);
            definitionKeys.forEach(key -> referenceKeys.put((DefinitionKey)key, (String)group.getKey() + "-" + counter.incrementAndGet()));
        }
        return referenceKeys;
    }

    private String getSchemaBaseDefinitionName(DefinitionKey key) {
        String schemaDefinitionName = this.typeContext.getSchemaDefinitionName(key.getType());
        return this.definitionKeyCleanup.apply(schemaDefinitionName);
    }
}

