/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.generator.impl.module;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.ResolvedTypeWithMembers;
import com.fasterxml.classmate.members.ResolvedMethod;
import com.github.victools.jsonschema.generator.Module;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigBuilder;
import com.github.victools.jsonschema.generator.impl.ReflectionGetterUtils;
import java.util.function.BiPredicate;

public class MethodExclusionModule
implements Module {
    private final BiPredicate<ResolvedMethod, ResolvedTypeWithMembers> shouldExcludeMethodsMatching;

    public static MethodExclusionModule forVoidMethods() {
        return new MethodExclusionModule((method, declaringType) -> MethodExclusionModule.isMethodVoid(method));
    }

    public static MethodExclusionModule forGetterMethods() {
        return new MethodExclusionModule(ReflectionGetterUtils::isGetter);
    }

    public static MethodExclusionModule forNonStaticNonVoidNonGetterMethods() {
        return new MethodExclusionModule((method, declaringType) -> !method.isStatic() && !MethodExclusionModule.isMethodVoid(method) && !ReflectionGetterUtils.isGetter(method, declaringType));
    }

    private static boolean isMethodVoid(ResolvedMethod method) {
        ResolvedType returnType = method.getReturnType();
        return returnType == null;
    }

    public MethodExclusionModule(BiPredicate<ResolvedMethod, ResolvedTypeWithMembers> shouldExcludeMethodsMatching) {
        this.shouldExcludeMethodsMatching = shouldExcludeMethodsMatching;
    }

    @Override
    public void applyToConfigBuilder(SchemaGeneratorConfigBuilder builder) {
        builder.forMethods().withIgnoreCheck(this.shouldExcludeMethodsMatching);
    }
}

