/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.generator;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.ResolvedTypeWithMembers;
import com.fasterxml.classmate.members.HierarchicType;
import com.fasterxml.classmate.members.ResolvedField;
import com.fasterxml.classmate.members.ResolvedMethod;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.github.victools.jsonschema.generator.CustomDefinition;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfig;
import com.github.victools.jsonschema.generator.impl.AttributeCollector;
import com.github.victools.jsonschema.generator.impl.ReflectionToStringUtils;
import com.github.victools.jsonschema.generator.impl.SchemaGenerationContext;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaGenerator {
    private static final Logger logger = LoggerFactory.getLogger(SchemaGenerator.class);
    private final SchemaGeneratorConfig config;

    public SchemaGenerator(SchemaGeneratorConfig config) {
        this.config = config;
    }

    public JsonNode generateSchema(Class<?> mainTargetType) {
        ObjectNode definitionsNode;
        SchemaGenerationContext generationContext = new SchemaGenerationContext(this.config);
        ResolvedType mainType = generationContext.resolve(mainTargetType);
        this.traverseGenericType(mainType, null, false, generationContext);
        ObjectNode jsonSchemaResult = this.config.createObjectNode();
        if (this.config.shouldIncludeSchemaVersionIndicator()) {
            jsonSchemaResult.put("$schema", "http://json-schema.org/draft-07/schema#");
        }
        if ((definitionsNode = this.buildDefinitionsAndResolveReferences(mainType, generationContext)).size() > 0) {
            jsonSchemaResult.set("definitions", (JsonNode)definitionsNode);
        }
        ObjectNode mainSchemaNode = generationContext.getDefinition(mainType);
        jsonSchemaResult.setAll(mainSchemaNode);
        return jsonSchemaResult;
    }

    private void traverseGenericType(ResolvedType targetType, ObjectNode targetNode, boolean isNullable, SchemaGenerationContext generationContext) {
        if (generationContext.containsDefinition(targetType)) {
            logger.debug("adding reference to existing definition of {}", (Object)targetType);
            generationContext.addReference(targetType, targetNode, isNullable);
            return;
        }
        ObjectNode definition = generationContext.isContainerType(targetType) ? this.traverseArrayType(targetType, targetNode, isNullable, generationContext) : this.traverseObjectType(targetType, targetNode, isNullable, generationContext);
        this.config.getTypeAttributeOverrides().forEach(override -> override.overrideTypeAttributes(definition, targetType, this.config));
    }

    private ObjectNode traverseArrayType(ResolvedType targetType, ObjectNode targetNode, boolean isNullable, SchemaGenerationContext generationContext) {
        ObjectNode definition;
        if (targetNode == null) {
            definition = this.config.createObjectNode();
            generationContext.putDefinition(targetType, definition);
        } else {
            definition = targetNode;
        }
        if (isNullable) {
            definition.set("type", (JsonNode)this.config.createArrayNode().add("array").add("null"));
        } else {
            definition.put("type", "array");
        }
        ObjectNode arrayItemTypeRef = this.config.createObjectNode();
        definition.set("items", (JsonNode)arrayItemTypeRef);
        ResolvedType itemType = generationContext.getContainerItemType(targetType);
        this.traverseGenericType(itemType, arrayItemTypeRef, false, generationContext);
        return definition;
    }

    private ObjectNode traverseObjectType(ResolvedType targetType, ObjectNode targetNode, boolean isNullable, SchemaGenerationContext generationContext) {
        ObjectNode definition;
        CustomDefinition customDefinition = this.config.getCustomDefinition(targetType);
        if (customDefinition != null && customDefinition.isMeantToBeInline()) {
            if (targetNode == null) {
                logger.debug("storing configured custom inline type for {} as definition (since it is the main schema \"#\")", (Object)targetType);
                definition = customDefinition.getValue();
                generationContext.putDefinition(targetType, definition);
            } else {
                logger.debug("directly applying configured custom inline type for {}", (Object)targetType);
                targetNode.setAll(customDefinition.getValue());
                definition = targetNode;
            }
        } else {
            definition = this.config.createObjectNode();
            generationContext.putDefinition(targetType, definition);
            if (targetNode != null) {
                generationContext.addReference(targetType, targetNode, isNullable);
            }
            if (customDefinition == null) {
                logger.debug("generating definition for {}", (Object)targetType);
                definition.put("type", "object");
                TreeMap<String, JsonNode> targetFields = new TreeMap<String, JsonNode>();
                TreeMap<String, JsonNode> targetMethods = new TreeMap<String, JsonNode>();
                this.collectObjectProperties(targetType, targetFields, targetMethods, generationContext);
                if (!targetFields.isEmpty() || !targetMethods.isEmpty()) {
                    ObjectNode propertiesNode = this.config.createObjectNode();
                    propertiesNode.setAll(targetFields);
                    propertiesNode.setAll(targetMethods);
                    definition.set("properties", (JsonNode)propertiesNode);
                }
            } else {
                logger.debug("applying configured custom definition for {}", (Object)targetType);
                definition.setAll(customDefinition.getValue());
            }
        }
        return definition;
    }

    private void collectObjectProperties(ResolvedType targetType, Map<String, JsonNode> targetFields, Map<String, JsonNode> targetMethods, SchemaGenerationContext generationContext) {
        logger.debug("iterating over declared fields from {}", (Object)targetType);
        ResolvedTypeWithMembers targetTypeWithMembers = generationContext.resolveWithMembers(targetType);
        Stream.of(targetTypeWithMembers.getMemberFields()).filter(field -> !this.config.shouldIgnore((ResolvedField)field, targetTypeWithMembers)).forEach(nonStaticField -> this.populateField((ResolvedField)nonStaticField, targetTypeWithMembers, targetFields, generationContext));
        logger.debug("iterating over declared public methods from {}", (Object)targetType);
        Stream.of(targetTypeWithMembers.getMemberMethods()).filter(method -> !this.config.shouldIgnore((ResolvedMethod)method, targetTypeWithMembers)).forEach(nonStaticMethod -> this.populateMethod((ResolvedMethod)nonStaticMethod, targetTypeWithMembers, targetMethods, generationContext));
        boolean includeStaticFields = this.config.shouldIncludeStaticFields();
        boolean includeStaticMethods = this.config.shouldIncludeStaticMethods();
        if (includeStaticFields || includeStaticMethods) {
            for (HierarchicType singleHierarchy : targetTypeWithMembers.allTypesAndOverrides()) {
                if (includeStaticFields) {
                    singleHierarchy.getType().getStaticFields().stream().map(generationContext::resolveMember).filter(staticField -> !this.config.shouldIgnore((ResolvedField)staticField, targetTypeWithMembers)).forEach(staticField -> this.populateField((ResolvedField)staticField, targetTypeWithMembers, targetFields, generationContext));
                }
                if (!includeStaticMethods) continue;
                singleHierarchy.getType().getStaticMethods().stream().map(generationContext::resolveMember).filter(staticMethod -> !this.config.shouldIgnore((ResolvedMethod)staticMethod, targetTypeWithMembers)).forEach(staticMethod -> this.populateMethod((ResolvedMethod)staticMethod, targetTypeWithMembers, targetMethods, generationContext));
            }
        }
    }

    private void populateField(ResolvedField field, ResolvedTypeWithMembers declaringType, Map<String, JsonNode> parentProperties, SchemaGenerationContext generationContext) {
        String defaultName = field.getName();
        String propertyName = Optional.ofNullable(this.config.resolvePropertyNameOverride(field, defaultName, declaringType)).orElse(defaultName);
        if (parentProperties.containsKey(propertyName)) {
            logger.debug("ignoring overridden {}.{}", (Object)field.getDeclaringType(), (Object)defaultName);
            return;
        }
        ObjectNode subSchema = this.config.createObjectNode();
        parentProperties.put(propertyName, (JsonNode)subSchema);
        ResolvedType fieldType = field.getType();
        fieldType = Optional.ofNullable(fieldType).map(typeOfField -> this.config.resolveTargetTypeOverride(field, (ResolvedType)typeOfField, declaringType)).orElse(fieldType);
        ObjectNode fieldAttributes = AttributeCollector.collectFieldAttributes(field, fieldType, declaringType, this.config);
        boolean isNullable = !((Field)field.getRawMember()).isEnumConstant() && this.config.isNullable(field, field.getType(), declaringType);
        this.populateSchema(fieldType, subSchema, isNullable, fieldAttributes, generationContext);
    }

    private void populateMethod(ResolvedMethod method, ResolvedTypeWithMembers declaringType, Map<String, JsonNode> parentProperties, SchemaGenerationContext generationContext) {
        String defaultName = ReflectionToStringUtils.createStringRepresentation(method);
        String propertyName = Optional.ofNullable(this.config.resolvePropertyNameOverride(method, defaultName, declaringType)).orElse(defaultName);
        if (parentProperties.containsKey(propertyName)) {
            logger.debug("ignoring overridden {}.{}", (Object)method.getDeclaringType(), (Object)defaultName);
            return;
        }
        ResolvedType returnValueType = method.getReturnType();
        if ((returnValueType = Optional.ofNullable(returnValueType).map(returnType -> this.config.resolveTargetTypeOverride(method, (ResolvedType)returnType, declaringType)).orElse(returnValueType)) == null) {
            parentProperties.put(propertyName, (JsonNode)BooleanNode.FALSE);
        } else {
            ObjectNode subSchema = this.config.createObjectNode();
            parentProperties.put(propertyName, (JsonNode)subSchema);
            ObjectNode methodAttributes = AttributeCollector.collectMethodAttributes(method, returnValueType, declaringType, this.config);
            boolean isNullable = this.config.isNullable(method, method.getReturnType(), declaringType);
            this.populateSchema(returnValueType, subSchema, isNullable, methodAttributes, generationContext);
        }
    }

    private void populateSchema(ResolvedType javaType, ObjectNode targetNode, boolean isNullable, ObjectNode collectedAttributes, SchemaGenerationContext generationContext) {
        ObjectNode referenceContainer;
        CustomDefinition customDefinition = this.config.getCustomDefinition(javaType);
        if (collectedAttributes == null || collectedAttributes.size() == 0 || customDefinition != null && customDefinition.isMeantToBeInline() || generationContext.isContainerType(javaType)) {
            referenceContainer = targetNode;
        } else {
            referenceContainer = this.config.createObjectNode();
            targetNode.set("allOf", (JsonNode)this.config.createArrayNode().add((JsonNode)referenceContainer).add((JsonNode)collectedAttributes));
        }
        if (customDefinition != null && customDefinition.isMeantToBeInline()) {
            referenceContainer.setAll(customDefinition.getValue());
            if (collectedAttributes != null && collectedAttributes.size() > 0) {
                referenceContainer.setAll(collectedAttributes);
            }
            if (isNullable) {
                this.makeNullable(referenceContainer);
            }
        } else {
            try {
                this.traverseGenericType(javaType, referenceContainer, isNullable, generationContext);
            }
            catch (UnsupportedOperationException ex) {
                logger.warn("Skipping type definition due to error", (Throwable)ex);
            }
        }
    }

    private void makeNullable(ObjectNode node) {
        if (node.has("$ref") || node.has("allOf") || node.has("anyOf") || node.has("oneOf")) {
            ObjectNode nullSchema = this.config.createObjectNode().put("type", "null");
            ArrayNode oneOf = this.config.createArrayNode().add((JsonNode)nullSchema).add(this.config.createObjectNode().setAll(node));
            node.removeAll();
            node.set("oneOf", (JsonNode)oneOf);
        } else {
            JsonNode fixedJsonSchemaType = node.get("type");
            if (fixedJsonSchemaType instanceof ArrayNode) {
                ArrayNode arrayOfTypes = (ArrayNode)fixedJsonSchemaType;
                boolean alreadyContainsNull = false;
                for (JsonNode arrayEntry : arrayOfTypes) {
                    alreadyContainsNull = alreadyContainsNull || "null".equals(arrayEntry.textValue());
                }
                if (!alreadyContainsNull) {
                    arrayOfTypes.add("null");
                }
            } else if (fixedJsonSchemaType instanceof TextNode && !"null".equals(fixedJsonSchemaType.textValue())) {
                node.replace("type", (JsonNode)this.config.createArrayNode().add(fixedJsonSchemaType).add("null"));
            }
        }
    }

    private ObjectNode buildDefinitionsAndResolveReferences(ResolvedType mainSchemaTarget, SchemaGenerationContext generationContext) {
        Map aliases = generationContext.getDefinedTypes().stream().collect(Collectors.groupingBy(ReflectionToStringUtils::createStringRepresentation, TreeMap::new, Collectors.toList()));
        ObjectNode definitionsNode = this.config.createObjectNode();
        boolean createDefinitionsForAll = this.config.shouldCreateDefinitionsForAllObjects();
        for (Map.Entry aliasEntry : aliases.entrySet()) {
            String referenceKey;
            boolean referenceInline;
            List types = (List)aliasEntry.getValue();
            List<ObjectNode> referencingNodes = types.stream().flatMap(type -> generationContext.getReferences((ResolvedType)type).stream()).collect(Collectors.toList());
            List<ObjectNode> nullableReferences = types.stream().flatMap(type -> generationContext.getNullableReferences((ResolvedType)type).stream()).collect(Collectors.toList());
            String alias = (String)aliasEntry.getKey();
            boolean bl = referenceInline = !types.contains(mainSchemaTarget) && (referencingNodes.isEmpty() || !createDefinitionsForAll && referencingNodes.size() + nullableReferences.size() < 2);
            if (referenceInline) {
                referencingNodes.forEach(referenceNode -> referenceNode.setAll(generationContext.getDefinition((ResolvedType)types.get(0))));
                referenceKey = null;
            } else {
                if (types.contains(mainSchemaTarget)) {
                    referenceKey = "#";
                } else {
                    definitionsNode.set(alias, (JsonNode)generationContext.getDefinition((ResolvedType)types.get(0)));
                    referenceKey = "#/definitions/" + alias;
                }
                referencingNodes.forEach(referenceNode -> referenceNode.put("$ref", referenceKey));
            }
            if (nullableReferences.isEmpty()) continue;
            ObjectNode definition = referenceInline ? generationContext.getDefinition((ResolvedType)types.get(0)) : this.config.createObjectNode().put("$ref", referenceKey);
            this.makeNullable(definition);
            if (createDefinitionsForAll || nullableReferences.size() > 1) {
                String nullableAlias = alias + " (nullable)";
                String nullableReferenceKey = "#/definitions/" + nullableAlias;
                definitionsNode.set(nullableAlias, (JsonNode)definition);
                nullableReferences.forEach(referenceNode -> referenceNode.put("$ref", nullableReferenceKey));
                continue;
            }
            nullableReferences.forEach(referenceNode -> referenceNode.setAll(definition));
        }
        return definitionsNode;
    }
}

