/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.generator;

import com.github.victools.jsonschema.generator.TypeVariableContext;
import com.github.victools.jsonschema.generator.impl.ReflectionTypeUtils;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class JavaType {
    private final Type declaredType;
    private volatile Type resolvedType;
    private final TypeVariableContext parentTypeVariables;

    public JavaType(Type declaredType, TypeVariableContext typeVariables) {
        this.declaredType = declaredType;
        this.resolvedType = null;
        this.parentTypeVariables = typeVariables;
    }

    Type getDeclaredType() {
        return this.declaredType;
    }

    public Type getResolvedType() {
        if (this.resolvedType == null) {
            this.resolvedType = this.parentTypeVariables.resolveGenericTypePlaceholder((Type)this.declaredType).declaredType;
        }
        return this.resolvedType;
    }

    public TypeVariableContext getParentTypeVariables() {
        return this.parentTypeVariables;
    }

    private String convertTypeToString(boolean fullClassNames) {
        String result;
        Type targetType = this.getResolvedType();
        Class<?> rawType = ReflectionTypeUtils.getRawType(targetType);
        if (rawType == null || fullClassNames) {
            result = this.declaredType.getTypeName();
        } else {
            result = rawType.getSimpleName();
            if (targetType instanceof ParameterizedType) {
                result = result + Stream.of(((ParameterizedType)targetType).getActualTypeArguments()).map(this.parentTypeVariables::resolveGenericTypePlaceholder).map(typeArgument -> typeArgument.convertTypeToString(fullClassNames)).collect(Collectors.joining(", ", "<", ">"));
            }
        }
        return result;
    }

    public String toString() {
        return this.convertTypeToString(false);
    }

    public int hashCode() {
        return this.getResolvedType().hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JavaType)) {
            return false;
        }
        JavaType otherJavaType = (JavaType)other;
        return this.convertTypeToString(true).equals(otherJavaType.convertTypeToString(true));
    }
}

