/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.generator.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.victools.jsonschema.generator.JavaType;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfig;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeCollector {
    private static final Logger logger = LoggerFactory.getLogger(AttributeCollector.class);
    private final ObjectMapper objectMapper;

    public AttributeCollector(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public static ObjectNode collectFieldAttributes(Field field, JavaType type, SchemaGeneratorConfig config) {
        ObjectNode node = config.createObjectNode();
        AttributeCollector collector = new AttributeCollector(config.getObjectMapper());
        collector.setTitle(node, config.resolveTitle(field, type));
        collector.setDescription(node, config.resolveDescription(field, type));
        collector.setEnum(node, config.resolveEnum(field, type));
        collector.setStringMinLength(node, config.resolveStringMinLength(field, type));
        collector.setStringMaxLength(node, config.resolveStringMaxLength(field, type));
        collector.setStringFormat(node, config.resolveStringFormat(field, type));
        collector.setNumberInclusiveMinimum(node, config.resolveNumberInclusiveMinimum(field, type));
        collector.setNumberExclusiveMinimum(node, config.resolveNumberExclusiveMinimum(field, type));
        collector.setNumberInclusiveMaximum(node, config.resolveNumberInclusiveMaximum(field, type));
        collector.setNumberExclusiveMaximum(node, config.resolveNumberExclusiveMaximum(field, type));
        collector.setNumberMultipleOf(node, config.resolveNumberMultipleOf(field, type));
        collector.setArrayMinItems(node, config.resolveArrayMinItems(field, type));
        collector.setArrayMaxItems(node, config.resolveArrayMaxItems(field, type));
        collector.setArrayUniqueItems(node, config.resolveArrayUniqueItems(field, type));
        config.getFieldAttributeOverrides().forEach(override -> override.overrideInstanceAttributes(node, field, type, config));
        return node;
    }

    public static ObjectNode collectMethodAttributes(Method method, JavaType returnType, SchemaGeneratorConfig config) {
        ObjectNode node = config.createObjectNode();
        AttributeCollector collector = new AttributeCollector(config.getObjectMapper());
        collector.setTitle(node, config.resolveTitle(method, returnType));
        collector.setDescription(node, config.resolveDescription(method, returnType));
        collector.setEnum(node, config.resolveEnum(method, returnType));
        collector.setStringMinLength(node, config.resolveStringMinLength(method, returnType));
        collector.setStringMaxLength(node, config.resolveStringMaxLength(method, returnType));
        collector.setStringFormat(node, config.resolveStringFormat(method, returnType));
        collector.setNumberInclusiveMinimum(node, config.resolveNumberInclusiveMinimum(method, returnType));
        collector.setNumberExclusiveMinimum(node, config.resolveNumberExclusiveMinimum(method, returnType));
        collector.setNumberInclusiveMaximum(node, config.resolveNumberInclusiveMaximum(method, returnType));
        collector.setNumberExclusiveMaximum(node, config.resolveNumberExclusiveMaximum(method, returnType));
        collector.setNumberMultipleOf(node, config.resolveNumberMultipleOf(method, returnType));
        collector.setArrayMinItems(node, config.resolveArrayMinItems(method, returnType));
        collector.setArrayMaxItems(node, config.resolveArrayMaxItems(method, returnType));
        collector.setArrayUniqueItems(node, config.resolveArrayUniqueItems(method, returnType));
        config.getMethodAttributeOverrides().forEach(override -> override.overrideInstanceAttributes(node, method, returnType, config));
        return node;
    }

    public AttributeCollector setTitle(ObjectNode node, String title) {
        if (title != null) {
            node.put("title", title);
        }
        return this;
    }

    public AttributeCollector setDescription(ObjectNode node, String description) {
        if (description != null) {
            node.put("description", description);
        }
        return this;
    }

    public AttributeCollector setEnum(ObjectNode node, Collection<?> enumValues) {
        if (enumValues != null && !enumValues.isEmpty()) {
            Stream<String> valueStream = enumValues.stream().map(this::convertObjectToString);
            if (enumValues.size() == 1) {
                String singleValue = valueStream.findFirst().get();
                node.putPOJO("const", (Object)singleValue);
            } else {
                ArrayNode array = node.arrayNode();
                valueStream.forEach(arg_0 -> ((ArrayNode)array).addPOJO(arg_0));
                node.set("enum", (JsonNode)array);
            }
        }
        return this;
    }

    private String convertObjectToString(Object target) {
        try {
            return this.objectMapper.writeValueAsString(target);
        }
        catch (JsonProcessingException ex) {
            logger.warn("Failed to convert value to string via ObjectMapper: {}", target, (Object)ex);
            return target == null ? null : '\"' + target.toString() + '\"';
        }
    }

    public AttributeCollector setStringMinLength(ObjectNode node, Integer minLength) {
        if (minLength != null) {
            node.put("minLength", minLength);
        }
        return this;
    }

    public AttributeCollector setStringMaxLength(ObjectNode node, Integer maxLength) {
        if (maxLength != null) {
            node.put("maxLength", maxLength);
        }
        return this;
    }

    public AttributeCollector setStringFormat(ObjectNode node, String format) {
        if (format != null) {
            node.put("format", format);
        }
        return this;
    }

    public AttributeCollector setNumberInclusiveMinimum(ObjectNode node, BigDecimal inclusiveMinimum) {
        if (inclusiveMinimum != null) {
            node.put("minimum", inclusiveMinimum);
        }
        return this;
    }

    public AttributeCollector setNumberExclusiveMinimum(ObjectNode node, BigDecimal exclusiveMinimum) {
        if (exclusiveMinimum != null) {
            node.put("exclusiveMinimum", exclusiveMinimum);
        }
        return this;
    }

    public AttributeCollector setNumberInclusiveMaximum(ObjectNode node, BigDecimal inclusiveMaximum) {
        if (inclusiveMaximum != null) {
            node.put("maximum", inclusiveMaximum);
        }
        return this;
    }

    public AttributeCollector setNumberExclusiveMaximum(ObjectNode node, BigDecimal exclusiveMaximum) {
        if (exclusiveMaximum != null) {
            node.put("exclusiveMaximum", exclusiveMaximum);
        }
        return this;
    }

    public AttributeCollector setNumberMultipleOf(ObjectNode node, BigDecimal multipleOf) {
        if (multipleOf != null) {
            node.put("multipleOf", multipleOf);
        }
        return this;
    }

    public AttributeCollector setArrayMinItems(ObjectNode node, Integer minItemCount) {
        if (minItemCount != null) {
            node.put("minItems", minItemCount);
        }
        return this;
    }

    public AttributeCollector setArrayMaxItems(ObjectNode node, Integer maxItemCount) {
        if (maxItemCount != null) {
            node.put("maxItems", maxItemCount);
        }
        return this;
    }

    public AttributeCollector setArrayUniqueItems(ObjectNode node, Boolean uniqueItems) {
        if (uniqueItems != null) {
            node.put("uniqueItems", uniqueItems);
        }
        return this;
    }
}

