/*
 * Decompiled with CFR 0.152.
 */
package org.vhwebrtc;

import android.support.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import org.vhwebrtc.H264Encoder;
import org.vhwebrtc.LibvpxVp8Encoder;
import org.vhwebrtc.LibvpxVp9Encoder;
import org.vhwebrtc.VideoCodecInfo;
import org.vhwebrtc.VideoEncoder;
import org.vhwebrtc.VideoEncoderFactory;

public class SoftwareVideoEncoderFactory
implements VideoEncoderFactory {
    @Override
    @Nullable
    public VideoEncoder createEncoder(VideoCodecInfo info) {
        if (info.name.equalsIgnoreCase("VP8")) {
            return new LibvpxVp8Encoder();
        }
        if (info.name.equalsIgnoreCase("VP9") && LibvpxVp9Encoder.nativeIsSupported()) {
            return new LibvpxVp9Encoder();
        }
        if (info.name.equalsIgnoreCase("H264")) {
            return new H264Encoder();
        }
        return null;
    }

    @Override
    public VideoCodecInfo[] getSupportedCodecs() {
        return SoftwareVideoEncoderFactory.supportedCodecs();
    }

    static VideoCodecInfo[] supportedCodecs() {
        ArrayList<VideoCodecInfo> codecs = new ArrayList<VideoCodecInfo>();
        codecs.add(new VideoCodecInfo("VP8", new HashMap<String, String>()));
        if (LibvpxVp9Encoder.nativeIsSupported()) {
            codecs.add(new VideoCodecInfo("VP9", new HashMap<String, String>()));
        }
        codecs.add(new VideoCodecInfo("H264", new HashMap<String, String>()));
        return codecs.toArray(new VideoCodecInfo[codecs.size()]);
    }
}

