/*
 * Decompiled with CFR 0.152.
 */
package org.vhwebrtc;

import android.support.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import org.vhwebrtc.H264Decoder;
import org.vhwebrtc.LibvpxVp8Decoder;
import org.vhwebrtc.LibvpxVp9Decoder;
import org.vhwebrtc.VideoCodecInfo;
import org.vhwebrtc.VideoDecoder;
import org.vhwebrtc.VideoDecoderFactory;

public class SoftwareVideoDecoderFactory
implements VideoDecoderFactory {
    @Override
    @Deprecated
    @Nullable
    public VideoDecoder createDecoder(String codecType) {
        return this.createDecoder(new VideoCodecInfo(codecType, new HashMap<String, String>()));
    }

    @Override
    @Nullable
    public VideoDecoder createDecoder(VideoCodecInfo codecType) {
        if (codecType.getName().equalsIgnoreCase("VP8")) {
            return new LibvpxVp8Decoder();
        }
        if (codecType.getName().equalsIgnoreCase("VP9") && LibvpxVp9Decoder.nativeIsSupported()) {
            return new LibvpxVp9Decoder();
        }
        if (codecType.getName().equalsIgnoreCase("H264")) {
            return new H264Decoder();
        }
        return null;
    }

    @Override
    public VideoCodecInfo[] getSupportedCodecs() {
        return SoftwareVideoDecoderFactory.supportedCodecs();
    }

    static VideoCodecInfo[] supportedCodecs() {
        ArrayList<VideoCodecInfo> codecs = new ArrayList<VideoCodecInfo>();
        codecs.add(new VideoCodecInfo("VP8", new HashMap<String, String>()));
        if (LibvpxVp9Decoder.nativeIsSupported()) {
            codecs.add(new VideoCodecInfo("VP9", new HashMap<String, String>()));
        }
        if (H264Decoder.nativeIsSupported()) {
            codecs.add(new VideoCodecInfo("H264", new HashMap<String, String>()));
        }
        return codecs.toArray(new VideoCodecInfo[codecs.size()]);
    }
}

